/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ObjectKey;
import java.io.Serializable;

public class ThumbnailTallyMark
implements Serializable,
Comparable,
ObjectKey {
    static final long serialVersionUID = 8597915791975305410L;
    public String sort;
    public String collectionID;
    public String institutionID;
    public String vcID;
    public long objectID;
    public long imageID;
    public boolean isMultiview;
    public boolean isMultipage;
    public int mediaType;

    public ThumbnailTallyMark(String string, ObjectKey objectKey) {
        this.sort = string;
        this.collectionID = objectKey.getCollectionID();
        this.institutionID = objectKey.getInstitutionID();
        this.vcID = objectKey.getVCID();
        this.objectID = objectKey.getObjectID();
        this.imageID = objectKey.getImageID();
        this.mediaType = objectKey.getMediaType();
        this.isMultiview = objectKey.isMultiview();
        this.isMultipage = objectKey.isMultipage();
    }

    public int compareTo(Object object) {
        ThumbnailTallyMark thumbnailTallyMark = (ThumbnailTallyMark)object;
        int n = InsightUtilities.compareStrings(this.sort, thumbnailTallyMark.sort);
        if (n == 0 && this.getObjectID() == thumbnailTallyMark.getObjectID() && this.getImageID() == thumbnailTallyMark.getImageID() && CollectionKeyDistributor.keysAgree(this, thumbnailTallyMark)) {
            n = InsightSmartClientResults.getMviMpdOrder(this.isMultiview(), this.isMultipage(), thumbnailTallyMark.isMultiview(), thumbnailTallyMark.isMultipage());
        }
        return n;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public long getImageID() {
        return this.imageID;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public boolean isMultiview() {
        return this.isMultiview;
    }

    public boolean isMultipage() {
        return this.isMultipage;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }
}

