/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.util.CSVLogger;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ObjectIndicatorFieldCriterion;
import com.luna.insight.server.ThumbnailQuery;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;

public class ThumbnailQueryLogger {
    public static int MAX_CRITERIA_COUNT = 3;
    public static final String LOG_FILE_EXTENSION = ".txt";
    public static final String LOG_TYPE = "query";
    public static final String SERVER_TYPE_JVA = "JVA";
    public static final String SERVER_TYPE_BROWSER = "Browser";

    public static void logSearchQuery(String string, String string2, ThumbnailQuery thumbnailQuery) {
        if (thumbnailQuery != null) {
            ThumbnailQueryLogger.logSearchQuery(string, string2, thumbnailQuery, thumbnailQuery.getCollectionName(), "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN");
        } else {
            ThumbnailQueryLogger.logSearchQuery(string, string2, thumbnailQuery, "", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN");
        }
    }

    public static void logSearchQuery(String string, String string2, ThumbnailQuery thumbnailQuery, String string3, String string4, String string5, String string6, String string7, String string8) {
        try {
            if (thumbnailQuery == null || thumbnailQuery.criteria == null || thumbnailQuery.criteria.length <= 0 || !(thumbnailQuery.criteria[0] instanceof ObjectIndicatorFieldCriterion)) {
                String string9 = InsightUtilities.appendDateToFilename(string, LOG_FILE_EXTENSION);
                FileWriter fileWriter = new FileWriter(string9, true);
                fileWriter.write(ThumbnailQueryLogger.getCsvSearchLogString(thumbnailQuery, string2, string3, string4, string5, string6, string7, string8));
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getSearchLogString(ThumbnailQuery thumbnailQuery, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("\n------------------------------");
        stringBuffer.append("\n" + new Date() + ":");
        if (string != null && string.length() > 0) {
            stringBuffer.append("\nCollection name: " + string);
        }
        stringBuffer.append("\nUser identity:");
        stringBuffer.append("\n[ext:" + string2 + "]-[int:" + string3 + "]-[UsrGrp:" + string4 + "]");
        try {
            stringBuffer.append("\n" + thumbnailQuery);
        }
        catch (Exception exception) {
            stringBuffer.append("\nException while constructing log string:\n" + InsightUtilities.getStackTrace(exception));
        }
        catch (Error error) {
            stringBuffer.append("\nError while constructing log string:\n" + InsightUtilities.getStackTrace(error));
        }
        return stringBuffer.toString();
    }

    public static String getCsvSearchLogString(ThumbnailQuery thumbnailQuery, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException {
        StringWriter stringWriter = new StringWriter();
        CSVLogger.writeEndOfRecord(stringWriter);
        CSVLogger.writeFirstRecord(stringWriter, new Date());
        CSVLogger.write(stringWriter, LOG_TYPE);
        CSVLogger.write(stringWriter, string);
        CSVLogger.write(stringWriter, string3);
        CSVLogger.write(stringWriter, string4);
        CSVLogger.write(stringWriter, string5);
        CSVLogger.write(stringWriter, string2);
        CSVLogger.write(stringWriter, string7);
        CSVLogger.write(stringWriter, string6);
        thumbnailQuery.toCsvString(stringWriter);
        return stringWriter.toString();
    }
}

