/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class SimpleDate
implements Comparable,
Serializable {
    static final long serialVersionUID = -8678335744685672126L;
    public static final String[] DAYS_OF_WEEK = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static final String[] DAYS_ABBREVIATED = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    public static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] MONTH_NAMES_ABBREVIATED = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final int[] MONTH_DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] PERMITTED_DATE_FORMATS = new String[]{"MM-dd-yyyy hh:mm:ss.SSS", "MM-dd-yyyy hh:mm:ss.SSS a", "MM-dd-yyyy hh:mm:ss.SSSa", "MM-dd-yyyy hh:mm:ss a", "MM-dd-yyyy hh:mm:ssa", "MM-dd-yyyy hh:mm a", "MM-dd-yyyy hh:mma", "MM-dd-yyyy", "MM/dd/yyyy hh:mm:ss.SSS", "MM/dd/yyyy hh:mm:ss.SSS a", "MM/dd/yyyy hh:mm:ss.SSSa", "MM/dd/yyyy hh:mm:ss a", "MM/dd/yyyy hh:mm:ssa", "MM/dd/yyyy hh:mm a", "MM/dd/yyyy hh:mma", "MM/dd/yyyy", "MMM d yyyy hh:mm:ss.SSS", "MMM d yyyy hh:mm:ss.SSS a", "MMM d yyyy hh:mm:ss.SSSa", "MMM d yyyy hh:mm:ss a", "MMM d yyyy hh:mm:ssa", "MMM d yyyy hh:mm a", "MMM d yyyy hh:mma", "MMM d yyyy", "MMM. d yyyy hh:mm:ss.SSS", "MMM. d yyyy hh:mm:ss.SSS a", "MMM. d yyyy hh:mm:ss.SSSa", "MMM. d yyyy hh:mm:ss a", "MMM. d yyyy hh:mm:ssa", "MMM. d yyyy hh:mm a", "MMM. d yyyy hh:mma", "MMM. d yyyy", "MMM. d, yyyy hh:mm:ss.SSS", "MMM. d, yyyy hh:mm:ss.SSS a", "MMM. d, yyyy hh:mm:ss.SSSa", "MMM. d, yyyy hh:mm:ss a", "MMM. d, yyyy hh:mm:ssa", "MMM. d, yyyy hh:mm a", "MMM. d, yyyy hh:mma", "MMM. d, yyyy", "MMM d, yyyy hh:mm:ss.SSS", "MMM d, yyyy hh:mm:ss.SSS a", "MMM d, yyyy hh:mm:ss.SSSa", "MMM d, yyyy hh:mm:ss a", "MMM d, yyyy hh:mm:ssa", "MMM d, yyyy hh:mm a", "MMM d, yyyy hh:mma", "MMM d, yyyy"};
    public Calendar calendar = Calendar.getInstance();

    public SimpleDate(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
    }

    public SimpleDate(java.sql.Date date) {
        Date date2 = new Date();
        if (date != null) {
            date2.setTime(date.getTime());
        }
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date2);
    }

    public SimpleDate(Calendar calendar) {
        this.calendar = calendar;
    }

    public SimpleDate(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public SimpleDate(int n, int n2, int n3, boolean bl) {
        this.adjust(1, n);
        if (bl) {
            this.adjust(2, n2 - 1);
        } else {
            this.adjust(2, n2);
        }
        this.adjust(5, n3);
    }

    public SimpleDate(String string) {
        this.set(string);
    }

    public SimpleDate(long l) {
        this.set(l);
    }

    public SimpleDate() {
    }

    public void set(String string) {
        if (string != null && string.length() == 14) {
            try {
                int n = Integer.parseInt(string.substring(0, 4));
                int n2 = Integer.parseInt(string.substring(4, 6));
                int n3 = Integer.parseInt(string.substring(6, 8));
                int n4 = Integer.parseInt(string.substring(8, 10));
                int n5 = Integer.parseInt(string.substring(10, 12));
                int n6 = Integer.parseInt(string.substring(12, 14));
                this.calendar.set(n, --n2, n3, n4, n5, n6);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void set(long l) {
        this.set("" + l);
    }

    public void add(int n, int n2) {
        this.calendar.add(n, n2);
    }

    public void adjust(int n, int n2) {
        this.calendar.set(n, n2);
    }

    public String get() {
        int n = this.calendar.get(1);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(5);
        int n4 = this.calendar.get(11);
        int n5 = this.calendar.get(12);
        int n6 = this.calendar.get(13);
        StringBuffer stringBuffer = new StringBuffer(14);
        stringBuffer.append(n);
        stringBuffer.append(this.zeroPad(2, ++n2));
        stringBuffer.append(this.zeroPad(2, n3));
        stringBuffer.append(this.zeroPad(2, n4));
        stringBuffer.append(this.zeroPad(2, n5));
        stringBuffer.append(this.zeroPad(2, n6));
        return stringBuffer.toString();
    }

    public long getAsLong() {
        try {
            return Long.parseLong(this.get());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public boolean equals(SimpleDate simpleDate) {
        return simpleDate.getAsLong() == this.getAsLong();
    }

    public String getClean() {
        int n = this.calendar.get(1);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(5);
        StringBuffer stringBuffer = new StringBuffer(11);
        stringBuffer.append(this.zeroPad(2, n3));
        stringBuffer.append(' ');
        stringBuffer.append(MONTH_NAMES_ABBREVIATED[n2]);
        stringBuffer.append(' ');
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public String getMedium() {
        int n = this.calendar.get(1);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(5);
        StringBuffer stringBuffer = new StringBuffer(12);
        stringBuffer.append(MONTH_NAMES_ABBREVIATED[n2]);
        stringBuffer.append(' ');
        stringBuffer.append(this.zeroPad(2, n3));
        stringBuffer.append(',');
        stringBuffer.append(' ');
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public String getShort() {
        int n = this.calendar.get(1);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(5);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.zeroPad(2, n2));
        stringBuffer.append('/');
        stringBuffer.append(this.zeroPad(2, n3));
        stringBuffer.append('/');
        stringBuffer.append(this.zeroPad(4, n));
        return stringBuffer.toString();
    }

    public String getFull() {
        int n = this.calendar.get(1);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(5);
        int n4 = this.calendar.get(7);
        int n5 = this.calendar.get(11);
        int n6 = this.calendar.get(12);
        int n7 = this.calendar.get(13);
        StringBuffer stringBuffer = new StringBuffer(24);
        stringBuffer.append(DAYS_ABBREVIATED[n4 - 1]);
        stringBuffer.append(' ');
        stringBuffer.append(this.zeroPad(2, n3));
        stringBuffer.append(' ');
        stringBuffer.append(MONTH_NAMES_ABBREVIATED[n2]);
        stringBuffer.append(' ');
        stringBuffer.append(n);
        stringBuffer.append(' ');
        stringBuffer.append(this.zeroPad(2, n5));
        stringBuffer.append(':');
        stringBuffer.append(this.zeroPad(2, n6));
        stringBuffer.append(':');
        stringBuffer.append(this.zeroPad(2, n7));
        return stringBuffer.toString();
    }

    protected String zeroPad(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(n2);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.get();
    }

    public String getYear() {
        return "" + this.calendar.get(1);
    }

    public String getMonth() {
        return "" + (this.calendar.get(2) + 1);
    }

    public String getDay() {
        return "" + this.calendar.get(5);
    }

    public String getHour() {
        return "" + this.calendar.get(10);
    }

    public String get24Hour() {
        return "" + this.calendar.get(11);
    }

    public String getMinute() {
        return "" + this.calendar.get(12);
    }

    public String getSecond() {
        return "" + this.calendar.get(13);
    }

    public String getAMPM() {
        return "" + this.calendar.get(9);
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public long getTimeInMillis() {
        if (this.calendar != null) {
            return this.calendar.getTime().getTime();
        }
        return 0L;
    }

    public long setTimeInMillis(long l) {
        if (this.calendar != null) {
            this.calendar.getTime().setTime(l);
        }
        return l;
    }

    public int compareTo(Object object) {
        SimpleDate simpleDate = (SimpleDate)object;
        long l = this.getTimeInMillis() - simpleDate.getTimeInMillis();
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }
}

