/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.Debug;
import com.luna.insight.server.DynamicThumbnailDistribution;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.QueryResultCollector;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.ThreadedGetter;
import com.luna.insight.server.ThumbnailDistribution;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.TrinityCollectionInfo;

public class QueryGetter
extends ThreadedGetter {
    protected ThumbnailQuery query;
    protected TrinityCollectionInfo tci;
    protected QueryResultCollector qrc;
    protected String username;
    protected String localAddress;

    public QueryGetter(ThumbnailQuery thumbnailQuery, TrinityCollectionInfo trinityCollectionInfo, CollectionConnection collectionConnection, String string, ResultsProgressListener resultsProgressListener, QueryResultCollector queryResultCollector, String string2) {
        this.query = thumbnailQuery;
        this.tci = trinityCollectionInfo;
        this.qrc = queryResultCollector;
        this.username = string2 != null ? string2 : "";
        this.cc = collectionConnection;
        this.rpl = resultsProgressListener;
        this.localAddress = string;
        this.qrc.addClient();
    }

    public void run() {
        this.setPriority(1);
        ThumbnailDistribution thumbnailDistribution = null;
        DynamicThumbnailDistribution dynamicThumbnailDistribution = null;
        try {
            this.debugOut("In doThumbnailQuery()");
            InsightRequest insightRequest = InsightRequest.newRequest(72, this.tci, this.localAddress);
            insightRequest.addObjectParam("THUMBNAIL_QUERY", this.query);
            insightRequest.addStringParam("USER_NAME", this.username);
            this.cc.oos.writeObject(insightRequest);
            this.cc.oos.flush();
            this.debugOut("doThumbnailQuery(): Waiting for data.");
            if (this.waitWhileKeepAlive(1) > 0) {
                Object object = this.cc.ois.readObject();
                if (object instanceof ThumbnailDistribution) {
                    thumbnailDistribution = (ThumbnailDistribution)object;
                    this.debugOut("doThumbnailQuery() results: " + thumbnailDistribution);
                } else if (object instanceof DynamicThumbnailDistribution) {
                    dynamicThumbnailDistribution = (DynamicThumbnailDistribution)object;
                    this.debugOut("doThumbnailQuery() results: " + dynamicThumbnailDistribution);
                }
            }
            this.debugOut("doThumbnailQuery(): After data retrieval.");
        }
        catch (Exception exception) {
            this.debugOut("Exception in doThumbnailQuery:\n" + InsightUtilities.getStackTrace(exception), 2);
            this.rpl.serverContacted(false);
            this.rpl.resultLoadFailed();
        }
        if (thumbnailDistribution != null && dynamicThumbnailDistribution == null) {
            dynamicThumbnailDistribution = DynamicThumbnailDistribution.getDynamicDistribution(thumbnailDistribution);
        }
        if (dynamicThumbnailDistribution != null) {
            this.cc.totalRecords = dynamicThumbnailDistribution.totalCount;
            this.rpl.getGroupInfo().setThumbnailDistribution(dynamicThumbnailDistribution);
            this.qrc.addResult(dynamicThumbnailDistribution);
        } else {
            this.rpl.serverContacted(false);
            this.rpl.resultLoadFailed();
        }
        this.qrc.removeClient();
    }

    public void debugOut(String string) {
        this.debugOut(string, 3);
    }

    public void debugOut(String string, int n) {
        Debug.debugOut("QG: " + string, n);
    }
}

