/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.ObjectKeyWrapper;
import java.util.Hashtable;
import java.util.Vector;

public class IscrMap
extends Hashtable {
    public static void debugOut(String string) {
        IscrMap.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IscrMap: " + string, n);
    }

    public static boolean doesIscrExist(Hashtable hashtable, InsightSmartClientResults insightSmartClientResults) {
        if (insightSmartClientResults != null && hashtable != null) {
            long l = insightSmartClientResults.getObjectID();
            long l2 = insightSmartClientResults.getImageID();
            boolean bl = insightSmartClientResults.isMultiview();
            boolean bl2 = insightSmartClientResults.isMultipage();
            Vector vector = (Vector)hashtable.get("" + l);
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    InsightSmartClientResults insightSmartClientResults2 = (InsightSmartClientResults)vector.elementAt(i);
                    if (l != insightSmartClientResults2.getObjectID() || l2 != insightSmartClientResults2.getImageID() || bl != insightSmartClientResults2.isMultiview() || bl2 != insightSmartClientResults2.isMultipage()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public IscrMap(int n) {
        super(n);
    }

    public boolean doesIscrExist(InsightSmartClientResults insightSmartClientResults) {
        return IscrMap.doesIscrExist(this, insightSmartClientResults);
    }

    public synchronized boolean addIscr(InsightSmartClientResults insightSmartClientResults) {
        if (insightSmartClientResults != null && !this.doesIscrExist(insightSmartClientResults)) {
            Vector<InsightSmartClientResults> vector = this.getIscrs(insightSmartClientResults.objectID);
            if (vector == null) {
                vector = new Vector<InsightSmartClientResults>(1);
                this.put(insightSmartClientResults.objectID + "", vector);
            }
            vector.addElement(insightSmartClientResults);
            return true;
        }
        return false;
    }

    public void removeIscrs(long l) {
        Vector vector = (Vector)this.get(l + "");
        if (vector != null) {
            vector.clear();
        }
    }

    public void removeIscr(ObjectKeyWrapper objectKeyWrapper) {
        Vector vector;
        if (objectKeyWrapper != null && (vector = this.getIscrs(objectKeyWrapper.getObjectID())) != null && vector.size() > 0) {
            int n = vector.indexOf(objectKeyWrapper);
            while (n > -1) {
                vector.removeElementAt(n);
                n = vector.indexOf(objectKeyWrapper);
            }
        }
    }

    public InsightSmartClientResults getIscr(long l, long l2, boolean bl, boolean bl2, int n) {
        Vector vector = this.getIscrs(l);
        if (vector != null) {
            InsightSmartClientResults insightSmartClientResults = null;
            InsightSmartClientResults insightSmartClientResults2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    InsightSmartClientResults insightSmartClientResults3 = (InsightSmartClientResults)vector.elementAt(i);
                    if (insightSmartClientResults3 == null || insightSmartClientResults3.getObjectID() != l || insightSmartClientResults3.getImageID() != l2) continue;
                    insightSmartClientResults2 = insightSmartClientResults3;
                    if (insightSmartClientResults3.isMultiview() != bl || insightSmartClientResults3.isMultipage() != bl2) continue;
                    insightSmartClientResults = insightSmartClientResults3;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (insightSmartClientResults == null && insightSmartClientResults2 != null) {
                insightSmartClientResults = new InsightSmartClientResults(insightSmartClientResults2);
                insightSmartClientResults.hasMviSeries = bl;
                insightSmartClientResults.hasMpdSeries = bl2;
                insightSmartClientResults.absoluteOrder = n;
            }
            return insightSmartClientResults;
        }
        return null;
    }

    public Vector getIscrs(long l) {
        return this.getIscrs(l + "");
    }

    public Vector getIscrs(String string) {
        if (string != null) {
            return (Vector)this.get(string);
        }
        return null;
    }
}

