/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.iface.ResourceLoader;
import com.luna.insight.core.util.BaseResourceBundle;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.InsightResourceBundle;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUserServicerCommands;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.MutableObject;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.security.InsightSecuritySettings;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class InsightUserClient
implements InsightUserServicerCommands,
ResourceLoader {
    public static final int DEBUG_LEVEL = 3;
    public static final String COMPONENT_CODE = "IUC";
    public static final int DEFAULT_PORT_NUMBER = 2840;
    protected static final long WAIT_LIMIT = 5000L;
    protected static final int WAIT_PAUSE = 200;
    public static boolean IS_3_1_USER_SERVER = false;
    public static final int TYPE_USER = 0;
    public static final int TYPE_USER_GROUP = 1;
    public static final int TYPE_SHARE = 2;
    protected static boolean usingPackageRemoverOutputSream = true;
    public static List USER_SHARES_STATIC = null;
    public String SERVER_ADDRESS = "127.0.0.1";
    protected int totalRecords = 0;
    protected int LISTEN_PORT_NUMBER = 2840;
    private InsightVersion serverVersion = null;
    protected Socket connectSocket;
    protected InputStream theInputStream;
    protected OutputStream theOutputStream;
    protected ObjectInputStream ois;
    protected ObjectOutputStream oos;

    public static void debugOut(String string) {
        InsightUserClient.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IUC: " + string, n);
    }

    public static void setUsingPackageRemoverOutputStream(boolean bl) {
        usingPackageRemoverOutputSream = bl;
    }

    public static boolean isUsingPackageRemoverOutputStream() {
        return usingPackageRemoverOutputSream;
    }

    public InsightUserClient(String string) {
        try {
            this.SERVER_ADDRESS = string;
            InsightUserClient.debugOut("Connecting to " + this.SERVER_ADDRESS + " on port " + this.LISTEN_PORT_NUMBER + ".");
            this.connectSocket = new Socket(this.SERVER_ADDRESS, this.LISTEN_PORT_NUMBER);
            if (!usingPackageRemoverOutputSream) {
                this.connectSocket.setTcpNoDelay(true);
            }
            InsightUserClient.debugOut("Creating streams.");
            this.theInputStream = this.connectSocket.getInputStream();
            this.theOutputStream = this.connectSocket.getOutputStream();
            InsightUserClient.debugOut("Creating output object stream.");
            this.oos = usingPackageRemoverOutputSream ? InsightPkgRemoverOutputStream.getInstance(this.theOutputStream) : new ObjectOutputStream(this.theOutputStream);
            InsightUserClient.debugOut("Creating input object stream.");
            this.ois = new InsightPkgSetterInputStream(this.theInputStream);
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in InsightUserClient constructor: " + exception);
        }
        if (!IS_3_1_USER_SERVER && this.isConnectionGood()) {
            this.serverVersion = this.getServerVersion();
            this.setClientVersion();
        }
    }

    public boolean isConnectionGood() {
        return this.oos != null && this.ois != null;
    }

    public InsightVersion getServerVersion() {
        InsightUserClient.debugOut("in getServerVersion().");
        InsightVersion insightVersion = null;
        try {
            this.oos.writeInt(23);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for data.");
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                insightVersion = (InsightVersion)this.ois.readObject();
                InsightUserClient.debugOut("Server version: " + insightVersion);
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getServerVersion():\n" + InsightUtilities.getStackTrace(exception));
        }
        return insightVersion;
    }

    public void setClientVersion() {
        InsightUserClient.debugOut("in setClientVersion().");
        try {
            this.oos.writeInt(24);
            this.oos.writeObject(new InsightVersion());
            this.oos.flush();
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in setClientVersion():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public String getLocalAddress() {
        InetAddress inetAddress = this.connectSocket.getLocalAddress();
        if (inetAddress != null) {
            return inetAddress.getHostAddress();
        }
        return "(none)";
    }

    public boolean authenticateUsernameAndPassword(String string, String string2) {
        boolean bl = false;
        try {
            InsightUserClient.debugOut("in authenticateUsernameAndPassword()");
            this.oos.writeInt(45);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for data.");
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in authenticateUsernameAndPassword():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public InsightUser getInsightUser(String string) {
        InsightUser insightUser = null;
        try {
            InsightUserClient.debugOut("Getting insight user.");
            this.oos.writeInt(20);
            this.oos.writeObject(string);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for data.");
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                insightUser = (InsightUser)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getInsightUser():\n" + InsightUtilities.getStackTrace(exception));
        }
        return insightUser;
    }

    public Vector getAvailableCollections(String string, String string2) {
        Vector vector = new Vector();
        try {
            InsightUserClient.debugOut("Getting collections vector.");
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 0, 8), 7)) {
                this.oos.writeInt(28);
            } else {
                this.oos.writeInt(14);
            }
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for available collections data.");
            if (this.waitForInput(1, 15000L) > 0) {
                InsightUserClient.debugOut("Receiving data.");
                vector = (Vector)this.ois.readObject();
                boolean bl = InsightSmartClient.ASSUME_SYNCHRONIZED_FIELD_STANDARDS = this.ois.readBoolean();
            }
            if (vector != null) {
                InsightUserClient.debugOut("Received " + vector.size() + " collections.");
            } else {
                InsightUserClient.debugOut("Received no collections.");
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getAvailableCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
        return vector;
    }

    public Vector getMedeCollectionsByUserGroups(String string, String string2) {
        return this.getCollectionsByUserGroups(string, string2, true);
    }

    public Vector getCollectionsByUserGroups(String string, String string2) {
        return this.getCollectionsByUserGroups(string, string2, false);
    }

    public Vector getCollectionsByUserGroups(String string, String string2, boolean bl) {
        Vector vector = new Vector();
        try {
            InsightUserClient.debugOut("Getting collections by user groups.");
            this.oos.writeInt(21);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.writeBoolean(bl);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for available collections data.");
            if (this.waitForInput(1, 15000L) > 0) {
                InsightUserClient.debugOut("Receiving data.");
                vector = (Vector)this.ois.readObject();
                InsightSmartClient.ASSUME_SYNCHRONIZED_FIELD_STANDARDS = this.ois.readBoolean();
                if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 13), 7)) {
                    USER_SHARES_STATIC = (List)this.ois.readObject();
                }
            }
            if (vector != null) {
                InsightUserClient.debugOut("Received " + vector.size() + " collections.");
            } else {
                InsightUserClient.debugOut("Received no collections.");
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getCollectionsByUserGroups():\n" + InsightUtilities.getStackTrace(exception));
        }
        return vector;
    }

    public Vector getAvailableMedeCollections(String string, String string2) {
        Vector vector = new Vector();
        try {
            InsightUserClient.debugOut("Getting MEDE collections vector.");
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 0, 8), 7)) {
                this.oos.writeInt(29);
            } else {
                this.oos.writeInt(19);
            }
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for available collections data.");
            if (this.waitForInput(1, 15000L) > 0) {
                InsightUserClient.debugOut("Receiving data.");
                vector = (Vector)this.ois.readObject();
                boolean bl = InsightSmartClient.ASSUME_SYNCHRONIZED_FIELD_STANDARDS = this.ois.readBoolean();
            }
            if (vector != null) {
                InsightUserClient.debugOut("Received " + vector.size() + " collections.");
            } else {
                InsightUserClient.debugOut("Received no collections.");
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getAvailableCollections().");
        }
        return vector;
    }

    public Vector getAvailableCollectionsLanguages() {
        Vector vector = new Vector();
        try {
            InsightUserClient.debugOut("in getAvailableCollectionsLanguages().");
            this.oos.writeInt(15);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for available collection languages data.");
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                vector = (Vector)this.ois.readObject();
            }
            if (vector != null) {
                InsightUserClient.debugOut("Received " + vector.size() + " collection languages.");
            } else {
                InsightUserClient.debugOut("Received no collection languages.");
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getAvailableCollectionsLanguages():\n" + InsightUtilities.getStackTrace(exception));
        }
        return vector;
    }

    public InsightResourceBundle getInsightResourceBundle(String string, String string2, int n) {
        InsightResourceBundle insightResourceBundle = null;
        InsightUserClient.debugOut("in getInsightResourceBundle().");
        try {
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                this.oos.writeInt(16);
                this.oos.writeObject(string);
                this.oos.writeObject(string2);
                this.oos.writeInt(n);
                this.oos.flush();
                if (this.waitForInput() > 0) {
                    boolean bl = this.ois.readBoolean();
                    if (bl) {
                        Object object = this.ois.readObject();
                        if (object != null && object instanceof InsightResourceBundle) {
                            insightResourceBundle = (InsightResourceBundle)object;
                        }
                    } else {
                        insightResourceBundle = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getInsightResourceBundle(): " + exception);
        }
        return insightResourceBundle;
    }

    public BaseResourceBundle getBaseResourceBundle(String string, String string2, String string3, int n) {
        BaseResourceBundle baseResourceBundle = null;
        InsightUserClient.debugOut("in getBaseResourceBundle().");
        try {
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                this.oos.writeInt(27);
                this.oos.writeObject(string);
                this.oos.writeObject(string2);
                this.oos.writeObject(string3);
                this.oos.writeInt(n);
                this.oos.flush();
                if (this.waitForInput() > 0) {
                    boolean bl = this.ois.readBoolean();
                    if (bl) {
                        Object object = this.ois.readObject();
                        if (object instanceof BaseResourceBundle) {
                            baseResourceBundle = (BaseResourceBundle)object;
                        }
                    } else {
                        baseResourceBundle = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return baseResourceBundle;
    }

    public InputStream getLocaleBundle(String string, String string2, String string3, int n) {
        InsightUserClient.debugOut("in getLocaleBundle()");
        InputStream inputStream = null;
        try {
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                this.oos.writeInt(44);
                this.oos.writeObject(string);
                this.oos.writeObject(string2);
                this.oos.writeObject(string3);
                this.oos.flush();
                if (this.waitForInput() > 0 && this.ois.readBoolean()) {
                    int n2;
                    int n3 = this.ois.readInt();
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    while ((n2 = this.ois.read(byArray, n4, byArray.length - n4)) > 0) {
                        n4 += n2;
                    }
                    if (n4 < byArray.length) {
                        InsightUserClient.debugOut("Bad read detected in getLocaleBundle");
                    } else {
                        inputStream = CoreUtilities.getByteArrayAsInputStream(byArray);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return inputStream;
    }

    public Hashtable getDefaultBGURL() {
        InsightUserClient.debugOut("In InsightUserClient.getDefaultBGURL()");
        Hashtable hashtable = new Hashtable();
        try {
            Object object;
            this.oos.writeInt(17);
            this.oos.flush();
            if (this.waitForInput() > 0 && (object = this.ois.readObject()) != null) {
                hashtable = (Hashtable)object;
            }
        }
        catch (IOException iOException) {
            InsightUserClient.debugOut("Caught IOException in GetDefaultBGURL");
            hashtable = new Hashtable();
            hashtable.put("DefaultBGURL", "collection-images/back.gif");
            hashtable.put("DefaultColor", new Color(0, 41, 74));
        }
        catch (ClassNotFoundException classNotFoundException) {
            InsightUserClient.debugOut("Caught ClassNotFoundException in GetDefaultBGURL");
            hashtable = new Hashtable();
            hashtable.put("DefaultBGURL", "collection-images/back.gif");
            hashtable.put("DefaultColor", new Color(0, 41, 74));
        }
        return hashtable;
    }

    public Vector getLegacyUserGroupList(int n) {
        Vector vector = new Vector();
        try {
            InsightUserClient.debugOut("Getting user group list.");
            this.oos.writeInt(11);
            this.oos.writeInt(n);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for a response.");
            if (this.waitForInput() > 0 && (vector = (Vector)this.ois.readObject()) == null) {
                vector = new Vector();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getUserGroupList(): " + exception);
        }
        return vector;
    }

    public List getUserKeyListByGroup(String string) {
        List list = new ArrayList();
        try {
            InsightUserClient.debugOut("Getting user keys list.");
            this.oos.writeInt(34);
            this.oos.writeObject(string);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getUserKeyListByGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list == null ? new ArrayList() : list;
    }

    public List getUserKeyListByShare(String string) {
        List list = new ArrayList();
        try {
            InsightUserClient.debugOut("Getting user keys list.");
            this.oos.writeInt(35);
            this.oos.writeObject(string);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getUserKeyListByShare():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list == null ? new ArrayList() : list;
    }

    public List getUserKeyList() {
        List list = new ArrayList();
        try {
            InsightUserClient.debugOut("Getting user keys list.");
            this.oos.writeInt(32);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getUserKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list == null ? new ArrayList() : list;
    }

    public List getShareKeyList() {
        List list = new ArrayList();
        try {
            InsightUserClient.debugOut("Getting user share list.");
            this.oos.writeInt(31);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getShareList():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list == null ? new ArrayList() : list;
    }

    public List getShareTree(String string, String string2) {
        if (!InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
            return this.getImageGroupFileList(string, string2, 0, null);
        }
        List list = new ArrayList();
        try {
            InsightUserClient.debugOut("Getting user share tree");
            this.oos.writeInt(53);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getShareTree():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public int getShareGroupCount(String string, String string2) {
        if (!InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
            return this.getImageGroupFileList(string, string2, 0, null).size();
        }
        int n = 0;
        try {
            InsightUserClient.debugOut("Getting user share group count");
            this.oos.writeInt(54);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data...");
                n = this.ois.readInt();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getShareGroupCount():\n" + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    public List getShareSubfolderList(String string, int n) {
        List list = new ArrayList();
        if (!InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
            return list;
        }
        try {
            InsightUserClient.debugOut("Getting user share subfolder list.");
            this.oos.writeInt(50);
            this.oos.writeObject(string);
            this.oos.writeInt(n);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput(1, 100000L) > 0) {
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getShareSubfolderList():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list == null ? new ArrayList() : list;
    }

    public Boolean createShareSubfolder(String string, String string2, int n, String string3, boolean bl) {
        if (!InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
            return Boolean.FALSE;
        }
        boolean bl2 = false;
        try {
            InsightUserClient.debugOut("Creating user share subfolder");
            this.oos.writeInt(51);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.writeInt(n);
            this.oos.writeObject(string3);
            this.oos.writeInt(bl ? 1 : 0);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                bl2 = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in createShareSubfolder():\n" + InsightUtilities.getStackTrace(exception));
        }
        return new Boolean(bl2);
    }

    public Boolean deleteShareSubfolder(String string, int n, boolean bl) {
        if (!InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
            return Boolean.FALSE;
        }
        boolean bl2 = true;
        try {
            InsightUserClient.debugOut("Deleting user share subfolder");
            this.oos.writeInt(52);
            this.oos.writeObject(string);
            this.oos.writeInt(n);
            this.oos.writeBoolean(bl);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for response.");
            if (this.waitForInput() > 0) {
                bl2 = this.ois.readBoolean();
                InsightUserClient.debugOut("delete folder response: " + bl2);
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in deleteShareSubfolder():\n" + InsightUtilities.getStackTrace(exception));
        }
        return new Boolean(bl2);
    }

    public List getUserGroupKeyList() {
        List list = null;
        try {
            InsightUserClient.debugOut("Getting user group key list.");
            this.oos.writeInt(30);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for a response.");
            if (this.waitForInput() > 0) {
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getUserGroupKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list == null ? new ArrayList() : list;
    }

    public List getUserGroupsAndSharesForUser(String string) {
        ArrayList<List> arrayList = null;
        try {
            InsightUserClient.debugOut("Getting user groups and shares lists for " + string + ".");
            this.oos.writeInt(33);
            this.oos.writeObject(string);
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for a response.");
            if (this.waitForInput() > 0) {
                List list = (List)this.ois.readObject();
                List list2 = (List)this.ois.readObject();
                if (list != null && list2 != null) {
                    arrayList = new ArrayList<List>();
                    arrayList.add(list);
                    arrayList.add(list2);
                }
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getUserGroupsAndSharesForUser(" + string + "):\n" + InsightUtilities.getStackTrace(exception));
        }
        return arrayList;
    }

    public boolean doesImageGroupFileExist(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            this.oos.writeInt(13);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.writeObject(string3);
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
                this.oos.writeInt(n);
            }
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in doesImageGroupFileExist(): " + exception);
        }
        return bl;
    }

    public Vector getImageGroupFileList(String string, String string2, int n, MutableObject mutableObject) {
        Vector vector = new Vector();
        try {
            this.oos.writeInt(6);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
                this.oos.writeInt(n);
            }
            this.oos.flush();
            InsightUserClient.debugOut("Waiting for file list.");
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                vector = (Vector)this.ois.readObject();
                if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(4, 0, 1), 7)) {
                    Map map = (Map)this.ois.readObject();
                    if (mutableObject != null) {
                        mutableObject.setValue(map);
                    }
                }
            }
            if (vector == null) {
                vector = new Vector();
            }
            InsightUserClient.debugOut("Received " + vector.size() + " image group files.");
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getImageGroupFileList(): " + exception);
        }
        return vector;
    }

    public ImageGroupFile getImageGroupFile(String string, String string2, int n, String string3) {
        ImageGroupFile imageGroupFile = null;
        try {
            this.oos.writeInt(7);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
                this.oos.writeInt(n);
            }
            this.oos.writeObject(string3);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                imageGroupFile = (ImageGroupFile)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getImageGroupFile(): " + exception);
        }
        return imageGroupFile;
    }

    public boolean saveImageGroupFile(String string, String string2, int n, ImageGroupFile imageGroupFile, boolean bl) {
        boolean bl2 = false;
        try {
            imageGroupFile.trimToSize();
            this.oos.writeInt(8);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
                this.oos.writeInt(n);
            }
            this.oos.writeObject(imageGroupFile);
            this.oos.writeBoolean(bl);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl2 = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in saveImageGroupFile(): " + exception);
        }
        return bl2;
    }

    public boolean deleteImageGroupFile(String string, String string2, String string3, String string4, int n, String string5, boolean bl) {
        boolean bl2 = false;
        try {
            this.oos.writeInt(9);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.writeObject(string3);
            this.oos.writeObject(string4);
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
                this.oos.writeInt(n);
            }
            this.oos.writeObject(string5);
            this.oos.writeBoolean(bl);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl2 = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in deleteImageGroupFile(): " + exception);
        }
        return bl2;
    }

    public List getPresentationNames(String string, String string2, int n, String string3) {
        InsightUserClient.debugOut("in getPresentationNames().");
        List list = null;
        try {
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(4, 0, 1), 7)) {
                this.oos.writeInt(25);
                this.oos.writeObject(string);
                this.oos.writeObject(string2);
                if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
                    this.oos.writeInt(n);
                }
                this.oos.writeObject(string3);
                this.oos.flush();
                if (this.waitForInput() > 0) {
                    InsightUserClient.debugOut("Receiving data.");
                    list = (List)this.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getPresentationNames():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        if (list == null) {
            list = new Vector(0);
        }
        return list;
    }

    public ImageSeries getPresentation(String string, String string2, int n, String string3, String string4) {
        InsightUserClient.debugOut("in getPresentation().");
        ImageSeries imageSeries = null;
        try {
            if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(4, 0, 1), 7)) {
                this.oos.writeInt(26);
                this.oos.writeObject(string);
                this.oos.writeObject(string2);
                if (InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 0), 7)) {
                    this.oos.writeInt(n);
                }
                this.oos.writeObject(string3);
                this.oos.writeObject(string4);
                this.oos.flush();
                if (this.waitForInput() > 0) {
                    InsightUserClient.debugOut("Receiving data.");
                    imageSeries = (ImageSeries)this.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getPresentation():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        return imageSeries;
    }

    public String getDefaultFuzzyHelpMessage() {
        String string = "No help available.";
        try {
            this.oos.writeInt(18);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                string = (String)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getDefaultFuzzyHelpMessage(): " + exception);
        }
        return string;
    }

    public InsightSecuritySettings getInsightSecuritySettings() {
        InsightUserClient.debugOut("in getInsightSecuritySettings().");
        InsightSecuritySettings insightSecuritySettings = new InsightSecuritySettings();
        try {
            if (!IS_3_1_USER_SERVER) {
                this.oos.writeInt(22);
                this.oos.flush();
                if (this.waitForInput() > 0) {
                    insightSecuritySettings = (InsightSecuritySettings)this.ois.readObject();
                }
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getInsightSecuritySettings():\n" + InsightUtilities.getStackTrace(exception));
        }
        return insightSecuritySettings;
    }

    public boolean addUserToShare(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        InsightUserClient.debugOut("In addUserToShare.");
        boolean bl4 = false;
        try {
            this.oos.writeInt(38);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.writeBoolean(bl);
            this.oos.writeBoolean(bl2);
            this.oos.writeBoolean(bl3);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl4 = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in addUserToShare():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl4;
    }

    public boolean setUserShareRights(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        InsightUserClient.debugOut("In setUserShareRights.");
        boolean bl4 = false;
        try {
            this.oos.writeInt(36);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.writeBoolean(bl);
            this.oos.writeBoolean(bl2);
            this.oos.writeBoolean(bl3);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl4 = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in setUserSHareRights():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl4;
    }

    public boolean addCollection(TrinityCollectionInfo trinityCollectionInfo) {
        InsightUserClient.debugOut("In addCollection.");
        boolean bl = false;
        try {
            this.oos.writeInt(46);
            this.oos.writeObject(trinityCollectionInfo);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
                if (bl && InsightVersion.compareVersions(this.serverVersion, new InsightVersion(5, 10, 14), 7)) {
                    trinityCollectionInfo.setServerID(this.ois.readInt());
                }
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in addCollection():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean deleteCollection(TrinityCollectionInfo trinityCollectionInfo) {
        InsightUserClient.debugOut("In deleteCollection.");
        boolean bl = false;
        try {
            this.oos.writeInt(55);
            this.oos.writeObject(trinityCollectionInfo);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in deleteCollection():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean addCollectionToGroup(CollectionKey collectionKey, String string, int n, String string2) {
        InsightUserClient.debugOut("In addCollectionToGroup.");
        boolean bl = false;
        try {
            this.oos.writeInt(47);
            this.oos.writeObject(collectionKey);
            this.oos.writeObject(string);
            this.oos.writeInt(n);
            this.oos.writeObject(string2);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in addUserToGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean addUserToGroup(String string, String string2) {
        InsightUserClient.debugOut("In addUserToGroup.");
        boolean bl = false;
        try {
            this.oos.writeInt(37);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in addUserToGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean removeUserFromGroup(String string, String string2) {
        InsightUserClient.debugOut("In removeUserFromGroup.");
        boolean bl = false;
        try {
            this.oos.writeInt(39);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in removeUserFromGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean removeUserFromShare(String string, String string2) {
        InsightUserClient.debugOut("In removeUserFromShare.");
        boolean bl = false;
        try {
            this.oos.writeInt(40);
            this.oos.writeObject(string);
            this.oos.writeObject(string2);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in removeUserFromShare():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public List getAuthorizationEntityInfo(int n, String string) {
        InsightUserClient.debugOut("In getAuthorizationEntityInfo.");
        List list = null;
        try {
            this.oos.writeInt(48);
            this.oos.writeInt(n);
            this.oos.writeObject(string);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in getAuthorizationEntityInfo():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public boolean addAuthorizationEntity(int n, Object object) {
        InsightUserClient.debugOut("In addAuthorizationEntity.");
        boolean bl = false;
        try {
            this.oos.writeInt(41);
            this.oos.writeInt(n);
            this.oos.writeObject(object);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in addAuthorizationEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean saveAuthorizationEntity(int n, Object object) {
        InsightUserClient.debugOut("In saveAuthorizationEntity");
        boolean bl = false;
        try {
            this.oos.writeInt(49);
            this.oos.writeInt(n);
            this.oos.writeObject(object);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in removeAuthorizationEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public boolean removeAuthorizationEntity(int n, Object object) {
        InsightUserClient.debugOut("In removeAuthorizationEntity.");
        boolean bl = false;
        try {
            this.oos.writeInt(42);
            this.oos.writeInt(n);
            this.oos.writeObject(object);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                bl = this.ois.readBoolean();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in removeAuthorizationEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
        return bl;
    }

    public List getMasterServerList(InsightUser insightUser) {
        InsightUserClient.debugOut("In getMasterServerList()");
        List list = null;
        try {
            this.oos.writeInt(43);
            this.oos.writeObject(insightUser);
            this.oos.flush();
            if (this.waitForInput() > 0) {
                InsightUserClient.debugOut("Receiving data.");
                list = (List)this.ois.readObject();
            }
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in removeAuthorizationEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
        return list;
    }

    public void closeConnection() {
        InsightUserClient.debugOut("Requesting close connection.");
        try {
            for (int i = 0; i < 5; ++i) {
                this.oos.writeInt(0);
            }
            this.oos.flush();
            InsightUserClient.debugOut("Closing socket.");
            this.connectSocket.close();
        }
        catch (Exception exception) {
            InsightUserClient.debugOut("Exception in closeConnection().");
        }
    }

    public void close() {
        this.closeConnection();
    }

    public static void main(String[] stringArray) {
        InsightUserClient insightUserClient = new InsightUserClient("127.0.0.1");
    }

    protected int waitForInput() {
        return this.waitForInput(1, 5000L);
    }

    protected int waitForInput(int n) {
        return this.waitForInput(n, 5000L);
    }

    protected int waitForInput(int n, long l) {
        int n2;
        block5: {
            n2 = 0;
            try {
                if (this.theInputStream == null) break block5;
                int n3 = 0;
                while (this.theInputStream.available() < n) {
                    n3 += 200;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((long)n3 < l) continue;
                }
                n2 = this.theInputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2;
    }
}

