/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.license.InsightLicenseManager;
import com.luna.insight.core.license.InsightLicenseNamedUsers;
import com.luna.insight.core.util.DefaultTheme;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.ConnectionKeeper;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.Debug;
import com.luna.insight.server.DynamicThumbnailDistribution;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldListResult;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldStandardMismatches;
import com.luna.insight.server.FieldStandardsManager;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.GroupInformation;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.ImageToProcess;
import com.luna.insight.server.InsightJtipImage;
import com.luna.insight.server.InsightJtipTile;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightServicerCommands;
import com.luna.insight.server.InsightSmartClientResults;
import com.luna.insight.server.InsightSmartServer;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.IscrMap;
import com.luna.insight.server.MediaMetaData;
import com.luna.insight.server.MutableInteger;
import com.luna.insight.server.MutableLong;
import com.luna.insight.server.ObjectDataRecord;
import com.luna.insight.server.ObjectDimension;
import com.luna.insight.server.ObjectKeyWrapper;
import com.luna.insight.server.RequestContext;
import com.luna.insight.server.ThumbnailDistribution;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.ThumbnailQueryCache;
import com.luna.insight.server.ThumbnailResultCache;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.XMLExportLogger;
import com.luna.insight.server.backend.InsightBackendConnector;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.collectionmanagement.CollectionBuildingObject;
import com.luna.insight.server.collectionmanagement.CollectionBuildingTemplate;
import com.luna.insight.server.extensions.ServiceComponent;
import com.luna.insight.server.hierarchy.HierarchyAncillaryData;
import com.luna.insight.server.hierarchy.HierarchyNodeData;
import com.luna.insight.server.indexer.TrinityIndexer;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityChangeList;
import com.luna.insight.server.inscribe.EntityEquivalenceQuery;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyWrapper;
import com.luna.insight.server.inscribe.EntityLock;
import com.luna.insight.server.inscribe.EntityRelationship;
import com.luna.insight.server.inscribe.EntitySearchQuery;
import com.luna.insight.server.inscribe.EntitySearchResult;
import com.luna.insight.server.inscribe.MedeConnector;
import com.luna.insight.server.inscribe.MedePrivileges;
import com.luna.insight.server.inscribe.MedeSmartClient;
import com.luna.insight.server.inscribe.MedeTermProcessor;
import com.luna.insight.server.inscribe.MediaSearchQuery;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.links.LinkCodeGenerator;
import com.luna.insight.server.links.LinkData;
import com.luna.insight.server.links.LinkFieldCriterion;
import com.luna.insight.server.links.LinkFieldMapping;
import com.luna.insight.server.links.LinkFileManager;
import com.luna.insight.server.mediacreation.IMediaBatch;
import com.luna.insight.server.mediacreation.ImportMediaResult;
import com.luna.insight.server.mpd.MpdSearchResults;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import com.luna.insight.server.mvi.MultiviewImageFileManager;
import com.luna.insight.server.mvi.MultiviewImageSeries;
import com.luna.insight.server.mvi.MultiviewImageSlide;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.presentation.ImageSeriesSlide;
import com.luna.insight.server.presentation.PresentationFileManager;
import com.luna.insight.server.ucb.FuzzyDateJulianRange;
import com.luna.insight.server.ucb.UcbFuzzyDateMachine;
import com.luna.insight.server.ucb.UcbHierarchyNodeData;
import com.luna.insight.server.ucb.UcbSupportConnector;
import com.luna.insight.server.usergroup.CollectionUserGroupKey;
import com.luna.insight.server.usergroup.UserGroup;
import com.luna.insight.server.usergroup.UserGroupConnection;
import com.luna.insight.server.usergroup.UserGroupSessionResults;
import com.luna.insight.server.usergroup.UserGroupShell;
import java.awt.Rectangle;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class InsightSmartServicer
implements Runnable,
InsightServicerCommands {
    public static final int RESOLUTIONS = 8;
    public static final String COMPONENT_CODE = "Servicer";
    public static final int DEBUG_LEVEL = 2;
    public static final int MAXIMUM_THUMBNAIL_FIELD_LENGTH = InsightSmartServer.MAXIMUM_THUMBNAIL_FIELD_LENGTH;
    public static final int MAXIMUM_SORT_FIELD_LENGTH = 30;
    protected static final int WAIT_LIMIT = 100000;
    protected static final int WAIT_PAUSE = 200;
    protected InsightSmartServer serverParent;
    protected Socket theSocket;
    protected String clientIP;
    protected String hostIP;
    protected boolean isClientLocal = false;
    protected ObjectInputStream ois;
    protected ObjectOutputStream oos;
    protected InsightRequest request;

    public InsightSmartServicer(Socket socket, InsightSmartServer insightSmartServer) {
        this.theSocket = socket;
        this.serverParent = insightSmartServer;
        if (this.theSocket != null) {
            InetAddress inetAddress = this.theSocket.getInetAddress();
            InetAddress inetAddress2 = this.theSocket.getLocalAddress();
            this.clientIP = inetAddress.getHostAddress();
            this.hostIP = inetAddress2.getHostAddress();
            if (inetAddress.equals(inetAddress2)) {
                this.serverParent.debugOut("Client is the local host.");
                this.isClientLocal = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block222: {
            int n = 1;
            boolean bl = false;
            int n2 = 0;
            boolean bl2 = true;
            InputStream inputStream = this.theSocket.getInputStream();
            OutputStream outputStream = this.theSocket.getOutputStream();
            this.debugOut("waiting for input");
            if (InsightUtilities.waitForInput(inputStream, 200, 100000L) > 0) {
                this.oos = InsightPkgRemoverOutputStream.getInstance(outputStream);
                this.ois = new InsightPkgSetterInputStream(inputStream);
            } else {
                this.debugOut("no data found on input stream");
                bl2 = false;
            }
            while (bl2) {
                this.debugOut("asking for request #" + n + ".");
                if (InsightUtilities.waitForInput(inputStream, 200, 100000L) > 0) {
                    try {
                        this.request = (InsightRequest)this.ois.readObject();
                        n2 = this.request.getRequestCmd();
                        this.debugOut("run(): requestCmd: " + n2);
                    }
                    catch (Exception exception) {
                        if (!(exception instanceof OptionalDataException)) {
                            this.debugOut("Exception in readObject():\n " + exception + "\n" + InsightUtilities.getStackTrace(exception));
                        }
                        n2 = this.ois.readInt();
                    }
                    try {
                        Thread.currentThread().setName("InsightSmartServicer cmd=" + n2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.request != null && n2 >= 1001) {
                        RequestContext requestContext = new RequestContext(this, this.request, this.oos, this.serverParent, this.clientIP, this.hostIP, this.isClientLocal);
                        boolean bl3 = false;
                        Iterator iterator = InsightSmartServer.SERVICE_LIST.iterator();
                        while (iterator.hasNext()) {
                            ServiceComponent serviceComponent = (ServiceComponent)iterator.next();
                            bl3 = serviceComponent.servesRequest(requestContext);
                            if (!bl3) continue;
                            this.debugOut("Handing request to Service Component " + serviceComponent.getCommonName());
                            serviceComponent.handleRequest(requestContext);
                            break;
                        }
                        if (!bl3) {
                            this.debugOut("No Service Component for request " + n2);
                        }
                    } else {
                        switch (n2) {
                            case 21: {
                                this.legacyVerifyVersion();
                                break;
                            }
                            case 54: {
                                this.legacyStartSession();
                                break;
                            }
                            case 55: {
                                this.legacyEndSession();
                                break;
                            }
                            case 56: {
                                this.legacyKeepAlive();
                                break;
                            }
                            case 118: {
                                this.verifyVersion();
                                break;
                            }
                            case 119: {
                                this.startSession();
                                break;
                            }
                            case 120: {
                                this.endSession();
                                break;
                            }
                            case 121: {
                                this.keepAlive();
                                break;
                            }
                            case 4: {
                                this.getSingleURL();
                                break;
                            }
                            case 3: {
                                this.getFullInformation();
                                break;
                            }
                            case 0: {
                                bl2 = false;
                                break;
                            }
                            case 1: {
                                this.getThumbnails();
                                break;
                            }
                            case 2: {
                                this.getURLs();
                                break;
                            }
                            case 5: {
                                this.addImage();
                                break;
                            }
                            case 79: {
                                this.addImages();
                                break;
                            }
                            case 6: {
                                this.removeImage();
                                break;
                            }
                            case 78: {
                                this.removeImages();
                                break;
                            }
                            case 7: {
                                this.newGroup();
                                break;
                            }
                            case 8: {
                                this.saveAs();
                                break;
                            }
                            case 40: {
                                this.deleteGroup();
                                break;
                            }
                            case 9: {
                                this.closeGroup();
                                break;
                            }
                            case 10: {
                                this.getGroupId();
                                break;
                            }
                            case 11: {
                                this.openGroup();
                                break;
                            }
                            case 12: {
                                this.getGroupList();
                                break;
                            }
                            case 13: {
                                this.getCollectionList();
                                break;
                            }
                            case 14: {
                                this.getUniqueList();
                                break;
                            }
                            case 15: {
                                this.getFieldList();
                                break;
                            }
                            case 94: {
                                this.getV2FieldList();
                                break;
                            }
                            case 16: {
                                this.getArtistStory();
                                break;
                            }
                            case 17: {
                                this.getURLsWithType();
                                break;
                            }
                            case 18: {
                                this.getPrivs();
                                break;
                            }
                            case 19: {
                                this.shutdown();
                                bl2 = false;
                                break;
                            }
                            case 20: {
                                this.getServerProps();
                                break;
                            }
                            case 22: {
                                this.getMatchingIDs();
                                break;
                            }
                            case 23: {
                                this.getObjectData();
                                break;
                            }
                            case 24: {
                                this.editObject();
                                break;
                            }
                            case 25: {
                                this.addObject();
                                break;
                            }
                            case 26: {
                                this.getVocabulary();
                                break;
                            }
                            case 27: {
                                this.addVocabulary();
                                break;
                            }
                            case 28: {
                                this.removeVocabulary();
                                break;
                            }
                            case 149: {
                                this.getPresentationNames();
                                break;
                            }
                            case 29: {
                                this.getImageSeriesList();
                                break;
                            }
                            case 30: {
                                this.getImageSeries();
                                break;
                            }
                            case 31: {
                                this.saveImageSeries();
                                break;
                            }
                            case 32: {
                                this.openClientSideGroup();
                                break;
                            }
                            case 33: {
                                this.getImagesInGroup();
                                break;
                            }
                            case 34: {
                                this.getImageFiles();
                                break;
                            }
                            case 35: {
                                this.getImageFile();
                                break;
                            }
                            case 36: {
                                this.getConfigurationInfo();
                                break;
                            }
                            case 37: {
                                this.getVirtualCollectionInfo();
                                break;
                            }
                            case 38: {
                                this.getGroupInformation();
                                break;
                            }
                            case 39: {
                                this.removeImageSeries();
                                break;
                            }
                            case 41: {
                                this.getDescriptionData();
                                break;
                            }
                            case 42: {
                                this.getFuzzyDateConversion();
                                break;
                            }
                            case 43: {
                                this.getThesaurusList();
                                break;
                            }
                            case 44: {
                                this.getTopLevelNodes();
                                break;
                            }
                            case 45: {
                                this.doTermSearch();
                                break;
                            }
                            case 46: {
                                this.doTreePathSearch();
                                break;
                            }
                            case 47: {
                                this.doTreeChildSearch();
                                break;
                            }
                            case 48: {
                                this.doAncillarySearch();
                                break;
                            }
                            case 49: {
                                this.getJtipImage();
                                break;
                            }
                            case 50: {
                                this.getJtipImages();
                                break;
                            }
                            case 51: {
                                this.getJtipLevelCount();
                                break;
                            }
                            case 52: {
                                this.getJtipImageData();
                                break;
                            }
                            case 53: {
                                this.getUcbThumbnails();
                                break;
                            }
                            case 58: {
                                this.openImageGroupFile();
                                break;
                            }
                            case 59: {
                                this.getMultiviewImage();
                                break;
                            }
                            case 74: {
                                this.getMultiviewImages();
                                break;
                            }
                            case 60: {
                                this.saveMultiviewImage();
                                break;
                            }
                            case 61: {
                                this.removeMultiviewImage();
                                break;
                            }
                            case 62: {
                                this.getSelectedImagesInGroup();
                                break;
                            }
                            case 63: {
                                this.groupHasMultiviewImages();
                                break;
                            }
                            case 86: {
                                this.groupHasMultipageDocuments();
                                break;
                            }
                            case 85: {
                                this.getMultipageDocument();
                                break;
                            }
                            case 81: {
                                this.groupContainsMediaType();
                                break;
                            }
                            case 64: {
                                this.getLinks();
                                break;
                            }
                            case 65: {
                                this.saveLink();
                                break;
                            }
                            case 66: {
                                this.removeLink();
                                break;
                            }
                            case 67: {
                                this.getObjectDimension();
                                break;
                            }
                            case 68: {
                                this.doesGroupExist();
                                break;
                            }
                            case 69: {
                                this.getImageCount();
                                break;
                            }
                            case 70: {
                                this.getStandardPreferences();
                                break;
                            }
                            case 82: {
                                this.getStandardDescription();
                                break;
                            }
                            case 71: {
                                this.getMismatchedFields();
                                break;
                            }
                            case 72: {
                                this.doThumbnailQuery();
                                break;
                            }
                            case 73: {
                                this.getTallyMarks();
                                break;
                            }
                            case 75: {
                                this.getCollectionInfoUpdate();
                                break;
                            }
                            case 76: {
                                this.setMultiviewImage();
                                break;
                            }
                            case 77: {
                                this.saveGroup();
                                break;
                            }
                            case 80: {
                                this.removeThumbnailCache();
                                break;
                            }
                            case 84: {
                                this.setServerFSMAndThumbCache();
                                break;
                            }
                            case 126: {
                                this.rebuildFsmAndThumbCache();
                                break;
                            }
                            case 87: {
                                this.getClientIP();
                                break;
                            }
                            case 88: {
                                this.hasLinkCode();
                                break;
                            }
                            case 89: {
                                this.publishLinks();
                                break;
                            }
                            case 90: {
                                this.unpublishLinks();
                                break;
                            }
                            case 91: {
                                this.saveMultipageDocumentSeries();
                                break;
                            }
                            case 92: {
                                this.searchMultipageDocument();
                                break;
                            }
                            case 93: {
                                this.isMedeEnabled();
                                break;
                            }
                            case 95: {
                                this.getMedePrivileges();
                                break;
                            }
                            case 177: {
                                this.getMedeCommitLevels();
                                break;
                            }
                            case 96: {
                                this.getEntityTypes();
                                break;
                            }
                            case 148: {
                                this.getEntityTypeRelationships();
                                break;
                            }
                            case 97: {
                                this.getEntities();
                                break;
                            }
                            case 98: {
                                this.getEntity();
                                break;
                            }
                            case 99: {
                                this.getEntityByFieldValue();
                                break;
                            }
                            case 131: {
                                this.getEntitiesByFieldValue();
                                break;
                            }
                            case 103: {
                                this.getEntityUniqueList();
                                break;
                            }
                            case 175: {
                                this.getEntityEquivalenceSearchResults();
                                break;
                            }
                            case 176: {
                                this.doEntityMerge();
                                break;
                            }
                            case 104: {
                                this.getEntitySearchResults();
                                break;
                            }
                            case 110: {
                                this.getMediaSearchResults();
                                break;
                            }
                            case 105: {
                                this.getEntityLock();
                                break;
                            }
                            case 106: {
                                this.unlockEntity();
                                break;
                            }
                            case 101: {
                                this.saveEntity();
                                break;
                            }
                            case 113: {
                                this.saveEntityChanges();
                                break;
                            }
                            case 102: {
                                this.deleteEntity();
                                break;
                            }
                            case 107: {
                                this.getEntityChangeUsers();
                                break;
                            }
                            case 108: {
                                this.getEntityChangeLists();
                                break;
                            }
                            case 109: {
                                this.approveEntityChanges();
                                break;
                            }
                            case 181: {
                                this.getApprovalExtraItems();
                                break;
                            }
                            case 127: {
                                this.cancelEntityChanges();
                                break;
                            }
                            case 128: {
                                this.removeRejectedEntityChanges();
                                break;
                            }
                            case 111: {
                                this.importEntities();
                                break;
                            }
                            case 112: {
                                this.isValueInValueList();
                                break;
                            }
                            case 115: {
                                this.getFullObjectData();
                                break;
                            }
                            case 116: {
                                this.getFullMediaData();
                                break;
                            }
                            case 117: {
                                this.logXMLExport();
                                break;
                            }
                            case 124: {
                                this.getAllEntityKeys();
                                break;
                            }
                            case 125: {
                                this.getEntitySearchResult();
                                break;
                            }
                            case 129: {
                                this.getKeysOfDuplicateEntities();
                                break;
                            }
                            case 114: {
                                this.getEntityTypeFields();
                                break;
                            }
                            case 123: {
                                this.getMediaTicket();
                                break;
                            }
                            case 130: {
                                this.getReferencedEntityCount();
                                break;
                            }
                            case 150: {
                                this.saveInscribeImportedMediaFiles();
                                break;
                            }
                            case 151: {
                                this.getLpsID();
                                break;
                            }
                            case 152: {
                                this.getSpsRecords();
                                break;
                            }
                            case 153: {
                                this.addNewSpsRecords();
                                break;
                            }
                            case 132: {
                                this.addLocalNodePath();
                                break;
                            }
                            case 133: {
                                this.getTermsInHierarchy();
                                break;
                            }
                            case 134: {
                                this.isTermInHierarchy();
                                break;
                            }
                            case 164: {
                                this.getHierarchyNames();
                                break;
                            }
                            case 147: {
                                this.isFieldStandardNameUnique();
                                break;
                            }
                            case 135: {
                                this.getFieldStandard();
                                break;
                            }
                            case 155: {
                                this.getFieldStandardTemplate();
                                break;
                            }
                            case 158: {
                                this.isCatalogTemplateNameUnique();
                                break;
                            }
                            case 157: {
                                this.getCatalogTemplates();
                                break;
                            }
                            case 156: {
                                this.saveCatalogTemplate();
                                break;
                            }
                            case 185: {
                                this.updateCatalogTemplate();
                                break;
                            }
                            case 154: {
                                this.getCollectionBuildingTemplate();
                                break;
                            }
                            case 137: {
                                this.saveCollectionBuildingObject();
                                break;
                            }
                            case 138: {
                                this.getPersonalCollections();
                                break;
                            }
                            case 159: {
                                this.canCreatePersonalCollections();
                                break;
                            }
                            case 160: {
                                this.isLicensedPersonalCollectionServer();
                                break;
                            }
                            case 140: {
                                this.saveObjectDataRecord();
                                break;
                            }
                            case 142: {
                                this.getMediaSecurityServletBaseUrl();
                                break;
                            }
                            case 144: {
                                this.deleteCollection();
                                break;
                            }
                            case 161: {
                                this.authenticateStudioUser();
                                break;
                            }
                            case 180: {
                                this.getCollectionServerPrivs();
                                break;
                            }
                            case 162: {
                                this.saveThemeFile();
                                break;
                            }
                            case 163: {
                                this.getThemeFileIfNecessary();
                                break;
                            }
                            case 187: {
                                this.getMediaSecurityKey();
                                break;
                            }
                            case 165: {
                                this.getMediaBatches();
                                break;
                            }
                            case 172: {
                                this.getMediaBatchElements();
                                break;
                            }
                            case 173: {
                                this.deleteMediaBatch();
                                break;
                            }
                            case 166: {
                                this.saveMediaBatch();
                                break;
                            }
                            case 179: {
                                this.deleteMediaRecords();
                                break;
                            }
                            case 139: {
                                this.importMediaFiles();
                                break;
                            }
                            case 167: {
                                this.publishMediaFiles(true);
                                break;
                            }
                            case 168: {
                                this.publishMediaFiles(false);
                                break;
                            }
                            case 169: {
                                this.saveCollectionUserGroupKey();
                                break;
                            }
                            case 170: {
                                this.getCollectionProfileKeyList();
                                break;
                            }
                            case 171: {
                                this.getCollectionUserGroupKeyList();
                                break;
                            }
                            case 174: {
                                this.reorderGroupImages();
                                break;
                            }
                            case 178: {
                                this.getStandardNames();
                                break;
                            }
                            case 183: {
                                this.getDependentCollections();
                                break;
                            }
                            case 184: {
                                this.deleteCatalogTemplate();
                                break;
                            }
                            case 186: {
                                this.getEntityCount();
                                break;
                            }
                            case 188: {
                                this.startTermProcessing();
                                break;
                            }
                            case 189: {
                                this.getMediaURL();
                            }
                        }
                    }
                    ++n;
                    continue;
                }
                bl2 = false;
            }
            Object var12_14 = null;
            this.debugOut("disconnecting at " + new Date() + ".", 1);
            try {
                if (this.theSocket != null) {
                    this.theSocket.close();
                }
            }
            catch (IOException iOException) {
                this.debugOut("IOException on theSocket.close().");
            }
            try {
                if (this.ois != null) {
                    this.ois.close();
                }
            }
            catch (IOException iOException) {
                this.debugOut("IOException on ois.close().");
            }
            try {
                if (this.oos != null) {
                    this.oos.close();
                }
                break block222;
            }
            catch (IOException iOException) {
                this.debugOut("IOException on oos.close().");
            }
            break block222;
            {
                catch (Exception exception) {
                    this.debugOut("Exception during communication:\n" + InsightUtilities.convertStackTraceToString(exception));
                    Object var12_15 = null;
                    this.debugOut("disconnecting at " + new Date() + ".", 1);
                    try {
                        if (this.theSocket != null) {
                            this.theSocket.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException on theSocket.close().");
                    }
                    try {
                        if (this.ois != null) {
                            this.ois.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException on ois.close().");
                    }
                    try {
                        if (this.oos != null) {
                            this.oos.close();
                        }
                        break block222;
                    }
                    catch (IOException iOException) {
                        this.debugOut("IOException on oos.close().");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.debugOut("disconnecting at " + new Date() + ".", 1);
                try {
                    if (this.theSocket != null) {
                        this.theSocket.close();
                    }
                }
                catch (IOException iOException) {
                    this.debugOut("IOException on theSocket.close().");
                }
                try {
                    if (this.ois != null) {
                        this.ois.close();
                    }
                }
                catch (IOException iOException) {
                    this.debugOut("IOException on ois.close().");
                }
                try {
                    if (this.oos != null) {
                        this.oos.close();
                    }
                }
                catch (IOException iOException) {
                    this.debugOut("IOException on oos.close().");
                }
                throw throwable;
            }
        }
    }

    protected void getClientIP() {
        this.debugOut("in getClientIP()");
        try {
            this.oos.writeObject(this.clientIP);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getClientIP():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected InsightBackendConnector getBackendConnector() {
        return this.serverParent.getBackendConnector();
    }

    protected UcbSupportConnector getUcbSupportConnector() {
        return new UcbSupportConnector(this.serverParent.BACKEND_PARAMETERS, this.serverParent.MIP_PROPS, this.serverParent.UCB_TABLE_NAMES);
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.serverParent.getDebugPrefix() + "/" + this.clientIP + ": " + string, 2);
    }

    protected void debugOutStay(String string) {
        Debug.debugOutStay(this.serverParent.getDebugPrefix() + "/" + this.clientIP + ": " + string, 2);
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut(this.serverParent.getDebugPrefix() + "/" + this.clientIP + ": " + string, n);
    }

    protected void newLine() {
        Debug.debugOut("", 2);
    }

    protected void startSession() {
        this.debugOut("in startSession().");
        try {
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            String string5 = "";
            String string6 = "";
            String string7 = "";
            if (collectionKey != null) {
                string5 = collectionKey.getCollectionID();
                string6 = collectionKey.getInstitutionID();
                string7 = collectionKey.getVCID();
            }
            UserGroupSessionResults userGroupSessionResults = this.serverParent.startSession(string, string2, this.clientIP, string3, string4, string5, string6, string7);
            this.oos.writeObject(userGroupSessionResults);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in startSession():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void legacyStartSession() {
        this.debugOut("in legacyStartSession().");
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            UserGroupSessionResults userGroupSessionResults = this.serverParent.startSession(string, string2, this.clientIP, string3);
            this.oos.writeObject(userGroupSessionResults);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in legacyStartSession():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void endSession() {
        this.debugOut("In endSession().");
        try {
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            String string5 = "";
            String string6 = "";
            String string7 = "";
            if (collectionKey != null) {
                string5 = collectionKey.getCollectionID();
                string6 = collectionKey.getInstitutionID();
                string7 = collectionKey.getVCID();
            }
            boolean bl = this.serverParent.endSession(string, string2, this.clientIP, string3, string4, string5, string6, string7);
        }
        catch (Exception exception) {
            this.debugOut("Exception in endSession():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void legacyEndSession() {
        this.debugOut("In legacyEndSession().");
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            boolean bl = this.serverParent.endSession(string, string2, this.clientIP, string3);
        }
        catch (Exception exception) {
            this.debugOut("Exception in legacyEndSession():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void keepAlive() {
        this.debugOut("In keepAlive().");
        try {
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            this.serverParent.keepSessionAlive(string, string2, this.clientIP, string3);
        }
        catch (Exception exception) {
            this.debugOut("Exception in keepAlive():\n" + InsightUtilities.getStackTrace(exception));
        }
        this.debugOut("Done with keepAlive().");
    }

    protected void legacyKeepAlive() {
        this.debugOut("In legacyKeepAlive().");
        try {
            String string = (String)this.ois.readObject();
            String string2 = (String)this.ois.readObject();
            String string3 = (String)this.ois.readObject();
            this.serverParent.keepSessionAlive(string, string2, this.clientIP, string3);
        }
        catch (Exception exception) {
            this.debugOut("Exception in legacyKeepAlive():\n" + InsightUtilities.getStackTrace(exception));
        }
        this.debugOut("Done with legacyKeepAlive().");
    }

    public String pluralize(int n) {
        if (n == 1) {
            return "";
        }
        return "s";
    }

    protected void getMatchingIDs() {
        this.debugOut("in getMatchingIDs().");
    }

    protected void getObjectData() {
        this.debugOut("in getObjectData().");
        try {
            long l = this.request.getLongParam("OBJECT_ID");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Object[] objectArray = insightBackendConnector.getObjectData(l);
            this.oos.writeObject(objectArray);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectData():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    private void getEntityCount() {
        this.debugOut("in getEntityCount()");
        try {
            Integer n = this.getRequestUniqueCollectionID();
            int n2 = this.request.getIntegerParam("ENTITY_TYPE_ID");
            TrinityConnector trinityConnector = (TrinityConnector)this.getBackendConnector();
            this.oos.writeLong(trinityConnector.getEntityCount(n, n2));
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityCount():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void editObject() {
        this.debugOut("in editObject().");
        try {
            long l = this.request.getLongParam("OBJECT_ID");
            Field[] fieldArray = ((Vector)this.request.getObjectParam("FIELDS")).toArray(new Field[0]);
            String[] stringArray = ((Vector)this.request.getObjectParam("VALUES")).toArray(new String[0]);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl = false;
            try {
                bl = insightBackendConnector.editObject(l, fieldArray, stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.debugOut("writing success.");
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in editObject().\n" + exception);
        }
    }

    protected void addObject() {
        this.debugOut("in addObject().");
        try {
            String string = this.request.getStringParam("COLLECTION_NAME");
            String string2 = this.request.getStringParam("VCID");
            Field[] fieldArray = ((Vector)this.request.getObjectParam("FIELDS")).toArray(new Field[0]);
            String[] stringArray = ((Vector)this.request.getObjectParam("VALUES")).toArray(new String[0]);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl = false;
            try {
                bl = insightBackendConnector.addObject(fieldArray, stringArray, string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in addObject().");
        }
    }

    protected void addVocabulary() {
        this.debugOut("in addVocabulary().");
        try {
            String string = this.request.getStringParam("TABLE_NAME");
            String string2 = this.request.getStringParam("FIELD_NAME");
            String string3 = this.request.getStringParam("VALUE");
            string = this.serverParent.getPrimaryObjectTable();
            this.debugOut("adding (vocab) " + string3 + " to " + string + "." + string2);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            insightBackendConnector.addVocabulary(string, string2, string3);
        }
        catch (Exception exception) {
            this.debugOut("exception in addVocabulary().");
        }
    }

    protected void removeVocabulary() {
        this.debugOut("in removeVocabulary().");
        try {
            String string = this.request.getStringParam("TABLE_NAME");
            String string2 = this.request.getStringParam("FIELD_NAME");
            String string3 = this.request.getStringParam("VALUE");
            string = this.serverParent.getPrimaryObjectTable();
            this.debugOut("removing (vocab) " + string3 + " from " + string + "." + string2);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            insightBackendConnector.removeVocabulary(string, string2, string3);
        }
        catch (Exception exception) {
            this.debugOut("exception in removeVocabulary().");
        }
    }

    protected void getVocabulary() {
        this.debugOut("in getVocabulary().");
        try {
            String string = this.request.getStringParam("TABLE_NAME");
            String string2 = this.request.getStringParam("FIELD_NAME");
            string = this.serverParent.getPrimaryObjectTable();
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = insightBackendConnector.getVocabulary(string, string2);
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getVocabulary().");
        }
    }

    protected void getSelectedImagesInGroup() {
        this.debugOut("In getSelectedImagesInGroup().");
        ConnectionKeeper connectionKeeper = null;
        try {
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            String string = this.request.getStringParam("INSTITUTION_ID", "UNAVAILABLE");
            String string2 = this.request.getStringParam("VCID", "UNAVAILABLE");
            Vector vector = (Vector)this.request.getObjectParam("OBJECT_IDS");
            Vector vector2 = (Vector)this.request.getObjectParam("MEDIA_IDS");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n = -1;
                n2 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector<ImageInGroup> vector3 = new Vector<ImageInGroup>();
            if (InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(3, 50, 0), 7)) {
                connectionKeeper = new ConnectionKeeper(this.oos);
                connectionKeeper.start();
            }
            boolean bl2 = false;
            if (InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 50, 7), 8) && !string2.equalsIgnoreCase("NA") && InsightSmartServer.DISABLE_EXPORT_FOR_VC) {
                this.debugOut("getSelectedImagesInGroup not supported for Virtual Collections.");
                bl2 = true;
            }
            if (InsightUtilities.isNonEmpty(vector) && InsightUtilities.isNonEmpty(vector2) && !bl2) {
                boolean bl3 = InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 0, 0), 7);
                Vector vector4 = insightBackendConnector.getImageFiles(vector2, n, n2, bl3);
                for (int i = 0; i < vector2.size(); ++i) {
                    long l = (Long)vector.elementAt(i);
                    long l2 = (Long)vector2.elementAt(i);
                    Vector vector5 = null;
                    for (int j = 0; !(j >= vector4.size() || InsightUtilities.isNonEmpty(vector5 = (Vector)vector4.get(j)) && ((ImageFile)vector5.get(0)).getImageID() == l2); ++j) {
                        vector5 = null;
                    }
                    if (vector5 == null) continue;
                    for (int j = 0; vector5 != null && j < vector5.size(); ++j) {
                        ImageFile imageFile = (ImageFile)vector5.get(j);
                        if (imageFile.getMediaType() != 1) continue;
                        imageFile.setUrl(InsightSmartServer.addExtendedURLParams(this.request, imageFile.getResolution(), imageFile.getUrl(), n, n2, string, string2));
                    }
                    vector3.addElement(new ImageInGroup(l, l2, false, collectionKey, vector5));
                }
            }
            if (connectionKeeper != null) {
                connectionKeeper.sendSuccess();
            }
            this.oos.writeObject(vector3);
            this.oos.flush();
        }
        catch (Exception exception) {
            if (connectionKeeper != null) {
                connectionKeeper.sendFailure();
            }
            this.debugOut("Exception in getSelectedImagesInGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getImagesInGroup() {
        this.debugOut("In getImagesInGroup().");
        try {
            Comparable comparable;
            int n;
            Object object;
            Object object2;
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            int n2 = this.request.getIntegerParam("GROUP_ID");
            int n3 = this.request.getIntegerParam("PROFILE_ID");
            int n4 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            Vector<FieldMapping> vector = (Vector<FieldMapping>)this.request.getObjectParam("SORT_FIELDS");
            if (vector != null) {
                object2 = vector.toArray(new FieldMapping[0]);
                vector = new Vector<FieldMapping>();
                object = this.getRequestUniqueCollectionID();
                for (n = 0; n < ((FieldMapping[])object2).length; ++n) {
                    comparable = this.serverParent.getFSM((Integer)object).getFieldMapping(object2[n]);
                    if (comparable == null || comparable.getFinalField() == null) continue;
                    vector.add((FieldMapping)comparable);
                }
            }
            if (bl) {
                n3 = -1;
                n4 = -1;
            }
            this.debugOut("group: " + n2 + "; profile: " + n3 + "; collection: " + n4);
            object = this.getBackendConnector();
            object2 = ((InsightBackendConnector)object).getImagesInGroup(n2, n3, n4, collectionKey, vector);
            this.debugOut("Images in group: " + ((Vector)object2).size());
            n = 0;
            this.oos.writeInt(((Vector)object2).size());
            comparable = null;
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                comparable = (ImageInGroup)((Vector)object2).elementAt(i);
                this.oos.writeObject(comparable);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImagesInGroup():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getImageFiles() {
        this.debugOut("In getImageFiles().");
        try {
            long l = this.request.getLongParam("MEDIA_ID");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            String string = this.request.getStringParam("INSTITUTION_ID", "UNAVAILABLE");
            String string2 = this.request.getStringParam("VCID", "UNAVAILABLE");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n = -1;
                n2 = -1;
            }
            this.debugOut("image: " + l + "; profile: " + n + "; userCollection: " + n2);
            boolean bl2 = InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 0, 0), 7);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = insightBackendConnector.getImageFiles(l, n, n2, bl2);
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                ImageFile imageFile = (ImageFile)vector.get(i);
                if (imageFile.mediaType != 1) continue;
                imageFile.URL = InsightSmartServer.addExtendedURLParams(this.request, imageFile.resolution, imageFile.URL, n, n2, string, string2);
            }
            this.debugOut("Image " + l + " has " + vector.size() + " resolutions.");
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getImageFiles().");
        }
    }

    protected void getImageFile() {
        this.debugOut("In getImageFile().");
        try {
            long l = this.request.getLongParam("MEDIA_ID");
            int n = this.request.getIntegerParam("RESOLUTION");
            int n2 = this.request.getIntegerParam("PROFILE_ID");
            int n3 = this.request.getIntegerParam("USER_COLLECTION");
            String string = this.request.getStringParam("INSTITUTION_ID", "UNAVAILABLE");
            String string2 = this.request.getStringParam("VCID", "UNAVAILABLE");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n2 = -1;
                n3 = -1;
            }
            this.debugOut("image: " + l + "; profile: " + n2 + "; userCollection: " + n3);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            ImageFile imageFile = insightBackendConnector.getImageFile(l, n, n2, n3);
            if (imageFile != null && imageFile.mediaType == 1) {
                imageFile.URL = InsightSmartServer.addExtendedURLParams(this.request, n, imageFile.URL, n2, n3, string, string2);
            }
            this.oos.writeObject(imageFile);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageFile():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getImageGroupFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImageGroupFile() {
        this.debugOut("in openImageGroupFile().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            connectionKeeper.start();
            String string = this.request.getStringParam("VCID");
            Integer n = this.getRequestUniqueCollectionID(true);
            Vector vector = (Vector)this.request.getObjectParam("IMAGES");
            Vector vector2 = (Vector)this.request.getObjectParam("MVI_IDS");
            int n2 = this.request.getIntegerParam("PROFILE_ID");
            int n3 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n2 = -1;
                n3 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            GroupInformation groupInformation = insightBackendConnector.openGroup(n, vector, string);
            if (vector2 != null) {
                MultiviewImageFileManager multiviewImageFileManager = this.serverParent.getMviFileManager();
                synchronized (multiviewImageFileManager) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        long l = (Long)vector2.elementAt(i);
                        insightBackendConnector.setMviSeries(groupInformation.getGroupID(), l, true);
                    }
                }
            }
            groupInformation.setContainsAudio(insightBackendConnector.groupContainsMediaType(2, groupInformation.getGroupID(), n2, n3));
            groupInformation.setContainsVideo(insightBackendConnector.groupContainsMediaType(3, groupInformation.getGroupID(), n2, n3));
            groupInformation.setContainsQtvr(insightBackendConnector.groupContainsMediaType(4, groupInformation.getGroupID(), n2, n3));
            groupInformation.setContainsMisc(insightBackendConnector.groupContainsMediaType(5, groupInformation.getGroupID(), n2, n3));
            groupInformation.setContainsMultiviews(insightBackendConnector.groupHasMultiviewImages(groupInformation.getGroupID(), n2, n3));
            groupInformation.setContainsMultipages(insightBackendConnector.groupHasMultipageDocuments(groupInformation.getGroupID(), n2, n3));
            groupInformation.setAbsoluteOrdering(insightBackendConnector.groupIsAbsoluteOrdered(groupInformation.getGroupID(), n2, n3));
            connectionKeeper.sendSuccess();
            this.oos.writeObject(groupInformation);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in openImageGroupFile(): " + exception);
        }
    }

    protected void openClientSideGroup() {
        this.debugOut("in openClientSideGroup().");
        try {
            String string = this.request.getStringParam("GROUP_NAME");
            String string2 = this.request.getStringParam("VCID");
            Integer n = this.getRequestUniqueCollectionID(true);
            Vector vector = (Vector)this.request.getObjectParam("IMAGES_IN_GROUP");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            int n2 = insightBackendConnector.openClientSideGroup(n, string, string2, vector);
            this.oos.writeInt(n2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in openClientSideGroup().");
        }
    }

    protected void reorderGroupImages() {
        this.debugOut("in reorderGroupImages().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            boolean bl = this.request.getBooleanParam("ABSOLUTE_ORDERING");
            Vector vector = (Vector)this.request.getObjectParam("IMAGES_IN_GROUP");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl2 = insightBackendConnector.reorderImagesInGroup(n, bl, vector);
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in openClientSideGroup().");
        }
    }

    protected void getServerProps() {
        this.debugOut("in getServerProps().");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        InsightBackendConnector insightBackendConnector = this.getBackendConnector();
        hashtable.put("Implementation", insightBackendConnector.getImplementationName());
        hashtable.put("Version", insightBackendConnector.getVersionId());
        hashtable.put("Language", this.serverParent.COLLECTION_LOCALE);
        if (this.serverParent.LEXICON_TREES) {
            hashtable.put("LexiconTree", new Boolean(true));
        }
        if (this.serverParent.FUZZY_DATES && InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(3, 50, 0), 7)) {
            hashtable.put("FuzzyDate", new Boolean(true));
            hashtable.put("FuzzyDateHelpText", this.serverParent.FUZZY_DATE_HELP_TEXT);
        }
        if (this.serverParent.JTIPS) {
            hashtable.put("JTIP", new Boolean(true));
        }
        if (this.serverParent.UCB_DB) {
            hashtable.put("UCB_DB", new Boolean(true));
        }
        if (this.serverParent.OBJECTS_EDITABLE) {
            hashtable.put("ObjectsEditable", new Boolean(true));
        }
        hashtable.put("CollectionConfiguration", new Boolean(true));
        hashtable.put("AllowCollectionSortMax", new Integer(this.serverParent.ALLOW_COLLECTION_SORT_MAX));
        try {
            this.oos.writeObject(hashtable);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getServerProps(), exc: " + exception);
        }
    }

    protected void verifyVersion() {
        this.debugOut("in verifyVersion().");
        try {
            InsightVersion insightVersion = this.request.getVersion();
            int n = insightVersion.getMajorVersion();
            int n2 = insightVersion.getMinorVersion();
            int n3 = insightVersion.getMicroVersion();
            this.debugOut("Client version: " + InsightVersion.version(n, n2, n3) + ".");
            if (n == 6 && n2 == 32 && n3 == 0) {
                this.oos.writeBoolean(true);
            } else {
                boolean bl = InsightVersion.requiresZipUpdate(n, n2, n3);
                this.debugOut("client is out of date.");
                this.oos.writeBoolean(false);
                this.oos.writeBoolean(bl);
                if (bl) {
                    this.debugOut("zip file update is required.");
                    this.oos.writeObject(this.serverParent.suitableClientURL);
                    this.oos.writeObject(this.serverParent.outdatedMessage);
                } else {
                    this.oos.writeObject(this.serverParent.suitableJARFileURL);
                    this.oos.writeObject(InsightVersion.version());
                }
            }
            if (n > 3 || n >= 3 && n2 >= 1) {
                this.oos.writeObject(new InsightVersion("09Dec2010"));
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in verifyVersion():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void legacyVerifyVersion() {
        this.debugOut("in legacyVerifyVersion().");
        try {
            int n = this.ois.readInt();
            int n2 = this.ois.readInt();
            int n3 = this.ois.readInt();
            this.debugOut("client version is " + InsightVersion.version(n, n2, n3) + ".");
            if (n == 6 && n2 == 32 && n3 == 0) {
                this.oos.writeBoolean(true);
            } else {
                boolean bl = InsightVersion.requiresZipUpdate(n, n2, n3);
                this.debugOut("client is out of date.");
                this.oos.writeBoolean(false);
                this.oos.writeBoolean(bl);
                if (bl) {
                    this.debugOut("zip file update is required.");
                    this.oos.writeObject(this.serverParent.suitableClientURL);
                    this.oos.writeObject(this.serverParent.outdatedMessage);
                } else {
                    this.oos.writeObject(this.serverParent.suitableJARFileURL);
                    this.oos.writeObject(InsightVersion.version());
                }
            }
            if (n > 3 || n >= 3 && n2 >= 1) {
                this.oos.writeObject(new InsightVersion("09Dec2010"));
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in legacyVerifyVersion():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void shutdown() {
        if (this.isClientLocal) {
            this.debugOut("server shutdown requested.");
        }
    }

    protected void getArtistStory() {
        this.debugOut("in getArtistStory().");
        try {
            String string = this.request.getStringParam("ARTIST_NAME");
            this.debugOut("getting artist story for " + string);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            String string2 = insightBackendConnector.getArtistInformation(string);
            this.oos.writeObject(string2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getArtistStory().");
        }
    }

    protected void getV2FieldList() {
        this.debugOut("in getV2FieldList().");
        try {
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = new Vector(0);
            if (insightBackendConnector instanceof TrinityConnector) {
                vector = InsightUtilities.toVector(((TrinityConnector)insightBackendConnector).getFieldList(null, true));
            }
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getV2FieldList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getFieldList() {
        this.debugOut("in getFieldList().");
        try {
            String string = this.request.getStringParam("STANDARD_NAME");
            boolean bl = this.request.getBooleanParam("INCLUDE_STANDARD_LIST");
            Integer n = this.getRequestUniqueCollectionID(true);
            this.debugOut("Standard name: " + string);
            this.debugOut("Include standard list: " + bl);
            FieldStandardsManager fieldStandardsManager = this.serverParent.getFSM(n);
            Vector vector = new Vector();
            Vector vector2 = null;
            FieldListResult fieldListResult = null;
            FieldListResult fieldListResult2 = null;
            FieldListResult fieldListResult3 = null;
            FieldListResult fieldListResult4 = null;
            if (bl) {
                vector2 = fieldStandardsManager.getFieldList(string);
                fieldListResult = new FieldListResult(string, vector2);
                vector2 = fieldStandardsManager.getLinkStandard().getFieldMappings();
                fieldListResult2 = new FieldListResult(fieldStandardsManager.getLinkStandard().getStandardName(), vector2);
            } else {
                fieldListResult4 = new FieldListResult(string, fieldStandardsManager.getHierarchyFieldMappings(string));
            }
            vector2 = fieldStandardsManager.getNonMatchedFields(string);
            fieldListResult3 = new FieldListResult(fieldStandardsManager.getCollectionStandard().getStandardName(), vector2);
            if (bl) {
                this.oos.writeObject(fieldListResult);
                if (InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(3, 50, 0), 7)) {
                    this.oos.writeObject(fieldListResult2);
                }
            } else {
                this.oos.writeObject(fieldListResult4);
            }
            this.oos.writeObject(fieldListResult3);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFieldList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getStandardPreferences() {
        this.debugOut("in getStandardPreferences().");
        try {
            Object object;
            Object object2;
            Integer n = this.getRequestUniqueCollectionID(false);
            if (n == null) {
                object2 = this.request.getCollectionKeyParam();
                object = this.getBackendConnector();
                n = ((InsightBackendConnector)object).getUniqueCollectionID((CollectionKey)object2);
            }
            if (n == null) {
                this.oos.writeInt(0);
                this.oos.flush();
            } else {
                object2 = this.serverParent.getFSM(n).getStandardPreferences();
                this.oos.writeInt(object2.size());
                object = object2.iterator();
                while (object.hasNext()) {
                    this.oos.writeObject(object.next());
                }
                this.oos.flush();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getStandardPreferences():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getStandardDescription() {
        this.debugOut("in getStandardDescription().");
        try {
            String string = this.request.getStringParam("STANDARD_NAME");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            String string2 = insightBackendConnector.getStandardDescription(string);
            this.oos.writeObject(string2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getStandardDescription():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void isFieldStandardNameUnique() {
        this.debugOut("in isFieldStandardNameUnique().");
        try {
            String string = this.request.getStringParam("FIELD_STANDARD_NAME");
            boolean bl = false;
            InsightBackendConnector insightBackendConnector = this.serverParent.getBackendConnector();
            if (insightBackendConnector instanceof TrinityConnector) {
                TrinityConnector trinityConnector = (TrinityConnector)insightBackendConnector;
                bl = trinityConnector.isFieldStandardNameUnique(string);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isFieldStandardNameUnique():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getFieldStandard() {
        this.debugOut("in getFieldStandard().");
        try {
            String string = this.request.getStringParam("STANDARD_NAME");
            Integer n = this.getRequestUniqueCollectionID(true);
            this.debugOut("Getting field standard: " + string);
            FieldStandard fieldStandard = this.serverParent.getFSM(n).getFieldStandard(string);
            this.debugOut("Retrieved field standard: " + fieldStandard);
            this.oos.writeObject(fieldStandard);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFieldStandard():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getFieldStandardTemplate() {
        this.debugOut("in getFieldStandardTemplate().");
        try {
            String string = this.request.getStringParam("STANDARD_NAME");
            FieldStandard fieldStandard = this.serverParent.getFieldStandardTemplate(string);
            this.oos.writeObject(fieldStandard);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFieldStandardTemplates():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMismatchedFields() {
        this.debugOut("in getMismatchedFields().");
        try {
            Integer n = this.getRequestUniqueCollectionID(true);
            FieldStandardsManager fieldStandardsManager = this.serverParent.getFSM(n);
            Vector vector = fieldStandardsManager.getMismatchedFields();
            this.oos.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                this.oos.writeObject((FieldStandardMismatches)vector.elementAt(i));
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMismatchedFields():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getPresentationNames() {
        this.debugOut("in getPresentationNames().");
        try {
            Object object;
            Vector vector;
            int n = this.request.getIntegerParam("GROUP_ID", -1);
            Integer n2 = this.getRequestUniqueCollectionID(true);
            if (n < 0) {
                vector = this.request.getStringParam("GROUP_NAME", null);
                object = this.request.getStringParam("VCID");
                if (InsightUtilities.isNonEmpty((String)((Object)vector))) {
                    InsightBackendConnector insightBackendConnector = this.getBackendConnector();
                    n = insightBackendConnector.getGroupID(n2, (String)((Object)vector), (String)object);
                }
            }
            vector = null;
            object = this.serverParent.getPresFileManager();
            synchronized (object) {
                vector = this.serverParent.getPresFileManager().getPresentationNames(n);
            }
            if (vector == null) {
                vector = new Vector(0);
            }
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPresentationNames():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getImageSeriesList() {
        this.debugOut("in getImageSeriesList().");
        try {
            Object object;
            Object object2;
            int n = this.request.getIntegerParam("GROUP_ID", -1);
            Integer n2 = this.getRequestUniqueCollectionID(true);
            if (n < 0) {
                object2 = this.request.getStringParam("GROUP_NAME", null);
                object = this.request.getStringParam("VCID");
                if (InsightUtilities.isNonEmpty((String)object2)) {
                    InsightBackendConnector insightBackendConnector = this.getBackendConnector();
                    n = insightBackendConnector.getGroupID(n2, (String)object2, (String)object);
                }
            }
            object2 = new Vector(0);
            object = this.serverParent.getPresFileManager();
            synchronized (object) {
                object2 = this.serverParent.getPresFileManager().getPresentations(n);
            }
            this.oos.writeInt(((Vector)object2).size());
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                this.oos.writeObject(((Vector)object2).elementAt(i));
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageSeriesList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getImageSeries() {
        this.debugOut("in getImageSeries().");
        try {
            Object object;
            Object object2;
            int n = this.request.getIntegerParam("GROUP_ID", -1);
            String string = this.request.getStringParam("SERIES_NAME");
            Integer n2 = this.getRequestUniqueCollectionID(true);
            if (n < 0) {
                object2 = this.request.getStringParam("GROUP_NAME", null);
                object = this.request.getStringParam("VCID");
                if (InsightUtilities.isNonEmpty((String)object2)) {
                    InsightBackendConnector insightBackendConnector = this.getBackendConnector();
                    n = insightBackendConnector.getGroupID(n2, (String)object2, (String)object);
                }
            }
            object = this.serverParent.getPresFileManager();
            synchronized (object) {
                object2 = this.serverParent.getPresFileManager().getPresentation(n, string);
            }
            this.oos.writeObject(object2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageSeries():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImageSeries() {
        this.debugOut("in saveImageSeries().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            ImageSeries imageSeries = (ImageSeries)this.request.getObjectParam("IMAGE_SERIES");
            this.debugOut("group ID: " + n);
            this.debugOut("series name: " + imageSeries.getSeriesName());
            boolean bl = false;
            PresentationFileManager presentationFileManager = this.serverParent.getPresFileManager();
            synchronized (presentationFileManager) {
                imageSeries.setGroupID(n);
                bl = this.serverParent.getPresFileManager().savePresentation(imageSeries);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveImageSeries():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeImageSeries() {
        this.debugOut("in removeImageSeries().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            String string = this.request.getStringParam("SERIES_NAME");
            PresentationFileManager presentationFileManager = this.serverParent.getPresFileManager();
            synchronized (presentationFileManager) {
                this.serverParent.getPresFileManager().deletePresentation(n, string);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeImageSeries():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMultiviewImage() {
        this.debugOut("In getMultiviewImage().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            long l = this.request.getLongParam("MEDIA_ID");
            int n2 = 0;
            MultiviewImageSeries multiviewImageSeries = null;
            MultiviewImageFileManager multiviewImageFileManager = this.serverParent.getMviFileManager();
            synchronized (multiviewImageFileManager) {
                multiviewImageSeries = this.serverParent.getMviFileManager().getMultiviewImage(n, l, n2);
            }
            this.oos.writeObject(multiviewImageSeries);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMultiviewImage():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMultiviewImages() {
        this.debugOut("In getMultiviewImages().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            Vector vector = new Vector(0);
            MultiviewImageFileManager multiviewImageFileManager = this.serverParent.getMviFileManager();
            synchronized (multiviewImageFileManager) {
                vector = this.serverParent.getMviFileManager().getMviSerieses(n);
            }
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMultiviewImages():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMultiviewImage() {
        this.debugOut("In saveMultiviewImage().");
        try {
            Object object;
            MultiviewImageSeries multiviewImageSeries = (MultiviewImageSeries)this.request.getObjectParam("MVI_SERIES");
            boolean bl = false;
            Object object2 = this.serverParent.getMviFileManager();
            synchronized (object2) {
                bl = this.serverParent.getMviFileManager().saveMultiviewImage(multiviewImageSeries);
                if (bl) {
                    object = this.getBackendConnector();
                    ((InsightBackendConnector)object).setMviSeries(multiviewImageSeries.getGroupID(), multiviewImageSeries.getImageID(), true);
                }
            }
            if (bl) {
                object2 = this.serverParent.getThumbnailQueryCache();
                synchronized (object2) {
                    object = this.serverParent.getThumbnailQueryCache().getThumbnailQueries(multiviewImageSeries.getGroupID());
                    ThumbnailQuery thumbnailQuery = null;
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        thumbnailQuery = (ThumbnailQuery)((Vector)object).elementAt(i);
                        thumbnailQuery.getThumbnailResultCache().addMultiviewThumbnail(multiviewImageSeries.getObjectID(), multiviewImageSeries.getImageID(), multiviewImageSeries);
                    }
                }
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveMultiviewImage():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMultiviewImage() {
        this.debugOut("In setMultiviewImage().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            long l = this.request.getLongParam("OBJECT_ID");
            long l2 = this.request.getLongParam("MEDIA_ID");
            boolean bl = this.request.getBooleanParam("HAS_MVI");
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            insightBackendConnector.setMviSeries(n, l2, bl);
            ThumbnailQueryCache thumbnailQueryCache = this.serverParent.getThumbnailQueryCache();
            synchronized (thumbnailQueryCache) {
                Vector vector = this.serverParent.getThumbnailQueryCache().getThumbnailQueries(n);
                ThumbnailQuery thumbnailQuery = null;
                for (int i = 0; i < vector.size(); ++i) {
                    thumbnailQuery = (ThumbnailQuery)vector.elementAt(i);
                    if (bl) {
                        thumbnailQuery.getThumbnailResultCache().addMultiviewThumbnail(l, l2, collectionKey);
                        continue;
                    }
                    thumbnailQuery.getThumbnailResultCache().removeMultiviewThumbnail(l, l2, collectionKey);
                }
            }
            this.oos.writeBoolean(true);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in setMultiviewImage():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMultiviewImage() {
        this.debugOut("In removeMultiviewImage().");
        try {
            Object object;
            int n = this.request.getIntegerParam("GROUP_ID");
            long l = this.request.getLongParam("OBJECT_ID");
            long l2 = this.request.getLongParam("MEDIA_ID");
            int n2 = 0;
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            boolean bl = false;
            Object object2 = this.serverParent.getMviFileManager();
            synchronized (object2) {
                bl = this.serverParent.getMviFileManager().deleteMultiviewImage(n, l2, n2);
                object = this.getBackendConnector();
                ((InsightBackendConnector)object).setMviSeries(n, l2, false);
            }
            object2 = this.serverParent.getThumbnailQueryCache();
            synchronized (object2) {
                object = this.serverParent.getThumbnailQueryCache().getThumbnailQueries(n);
                ThumbnailQuery thumbnailQuery = null;
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    thumbnailQuery = (ThumbnailQuery)((Vector)object).elementAt(i);
                    thumbnailQuery.getThumbnailResultCache().removeMultiviewThumbnail(l, l2, collectionKey);
                }
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeMultiviewImage():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void groupHasMultiviewImages() {
        this.debugOut("in groupHasMultiviewImages().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            int n2 = this.request.getIntegerParam("PROFILE_ID");
            int n3 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n2 = -1;
                n3 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl2 = insightBackendConnector.groupHasMultiviewImages(n, n2, n3);
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in groupHasMultiviewImages():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void groupHasMultipageDocuments() {
        this.debugOut("in groupHasMultipageDocuments(().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            int n2 = this.request.getIntegerParam("PROFILE_ID");
            int n3 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n2 = -1;
                n3 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl2 = insightBackendConnector.groupHasMultipageDocuments(n, n2, n3);
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in groupHasMultipageDocuments():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void groupContainsMediaType() {
        this.debugOut("in groupContainsMediaType().");
        try {
            int n = this.request.getIntegerParam("MEDIA_TYPE");
            int n2 = this.request.getIntegerParam("GROUP_ID");
            int n3 = this.request.getIntegerParam("PROFILE_ID");
            int n4 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n3 = -1;
                n4 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl2 = insightBackendConnector.groupContainsMediaType(n, n2, n3, n4);
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in groupContainsMediaType():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getLinks() {
        this.debugOut("in getLinks()");
        try {
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            Vector vector = (Vector)this.request.getObjectParam("USER_GROUP_SHELLS");
            long l = this.request.getLongParam("MEDIA_ID");
            Vector vector2 = new Vector(0);
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                vector2 = this.serverParent.getLinkFileManager().getLinks(collectionKey, l);
                for (int i = 0; i < vector2.size(); ++i) {
                    ((LinkData)vector2.elementAt(i)).setSaveLocation(0);
                }
                if (vector != null) {
                    UserGroupShell userGroupShell = null;
                    Vector vector3 = null;
                    LinkData linkData = null;
                    for (int i = 0; i < vector.size(); ++i) {
                        userGroupShell = (UserGroupShell)vector.elementAt(i);
                        vector3 = this.serverParent.getLinkFileManager().getLinks(collectionKey, userGroupShell.getName(), userGroupShell.getCodeKey(), l);
                        if (vector3 == null) continue;
                        for (int j = 0; j < vector3.size(); ++j) {
                            linkData = (LinkData)vector3.elementAt(j);
                            linkData.setSaveLocation(1);
                            linkData.setGroupName(userGroupShell.getName());
                            linkData.setGroupCodeKey(userGroupShell.getCodeKey());
                            vector2.addElement(linkData);
                        }
                    }
                }
            }
            this.oos.writeObject(vector2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getLinks():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveLink() {
        this.debugOut("in saveLink()");
        try {
            LinkData linkData = (LinkData)this.request.getObjectParam("LINK_DATA");
            Integer n = this.getRequestUniqueCollectionID(true);
            boolean bl = false;
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                if (linkData.getSaveLocation() == 0) {
                    bl = this.serverParent.getLinkFileManager().saveLink(linkData);
                    String string = LinkCodeGenerator.getLinkCode(linkData);
                    if (bl && this.serverParent.getLinkInventory().isInInventory(string)) {
                        this.serverParent.publishLink(linkData, string, n);
                    }
                } else if (linkData.getSaveLocation() == 1) {
                    bl = this.serverParent.getLinkFileManager().saveLink(linkData, linkData.getGroupName(), linkData.getGroupCodeKey());
                    String string = LinkCodeGenerator.getLinkCode(linkData);
                    if (bl && this.serverParent.getLinkInventory().isInInventory(string)) {
                        this.serverParent.publishLink(linkData, string, n);
                    }
                }
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveLink():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLink() {
        this.debugOut("in removeLink()");
        try {
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            String string = this.request.getStringParam("LINK_GROUP_NAME");
            String string2 = this.request.getStringParam("LINK_GROUP_CODE_KEY");
            long l = this.request.getLongParam("LINK_MEDIA_ID");
            Rectangle rectangle = (Rectangle)this.request.getObjectParam("LINK_REGION");
            int n = this.request.getIntegerParam("LINK_SAVE_LOCATION");
            boolean bl = false;
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                if (n == 0) {
                    bl = this.serverParent.getLinkFileManager().deleteLink(collectionKey, l, rectangle);
                    String string3 = LinkCodeGenerator.getCollectionLinkCode(collectionKey);
                    if (bl && this.serverParent.getLinkInventory().isInInventory(string3)) {
                        this.serverParent.unpublishLink(string3, rectangle, l);
                    }
                } else if (n == 1) {
                    bl = this.serverParent.getLinkFileManager().deleteLink(collectionKey, string, string2, l, rectangle);
                    String string4 = LinkCodeGenerator.getGroupLinkCode(collectionKey, string, string2);
                    if (bl && this.serverParent.getLinkInventory().isInInventory(string4)) {
                        this.serverParent.unpublishLink(string4, rectangle, l);
                    }
                }
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeLink():\n" + InsightUtilities.convertStackTraceToString(exception));
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hasLinkCode() {
        this.debugOut("in hasLinkCode()");
        try {
            String string = this.request.getStringParam("LINK_CODE");
            boolean bl = false;
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                bl = this.serverParent.getLinkInventory().isInInventory(string);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in hasLinkCode():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishLinks() {
        this.debugOut("in publishLinks()");
        try {
            Integer n = this.getRequestUniqueCollectionID(true);
            Vector vector = (Vector)this.request.getObjectParam("LINKS");
            String string = this.request.getStringParam("LINK_CODE");
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                this.serverParent.publishLinks(vector, string, n);
            }
            this.oos.writeBoolean(true);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in publishLinks():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unpublishLinks() {
        this.debugOut("in unpublishLinks()");
        try {
            Vector vector = (Vector)this.request.getObjectParam("LINKS");
            String string = this.request.getStringParam("LINK_CODE");
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                this.serverParent.unpublishLinks(vector, string);
            }
            this.oos.writeBoolean(true);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in unpublishLinks():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void saveThemeFile() {
        this.debugOut("in saveThemeFile()");
        try {
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            DefaultTheme defaultTheme = (DefaultTheme)this.request.getObjectParam("COLLECTION_THEME");
            byte[] byArray = (byte[])this.request.getObjectParam("COLLECTION_THEME_ZIP");
            if (defaultTheme == null || collectionKey == null) {
                this.oos.writeBoolean(false);
            } else {
                this.oos.writeBoolean(this.serverParent.getThemeFileManager().saveThemeFile(this.getRequestUniqueCollectionID(), (TrinityConnector)this.getBackendConnector(), collectionKey, defaultTheme, byArray));
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveThemeFile():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    protected void getThemeFileIfNecessary() {
        this.debugOut("in getThemeFile()");
        try {
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            long l = this.request.getLongParam("COLLECTION_THEME_CRC");
            byte[] byArray = null;
            if (collectionKey != null) {
                byArray = this.serverParent.getThemeFileManager().getThemeFile(collectionKey, l);
            }
            if (byArray == null || byArray.length == 0) {
                this.oos.writeBoolean(false);
            } else {
                this.oos.writeBoolean(true);
                this.oos.writeObject(byArray);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getThemeFile():\n" + InsightUtilities.convertStackTraceToString(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getUniqueList() {
        this.debugOut("in getUniqueList().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            Object object;
            Object object2;
            CriterionValue[] criterionValueArray;
            Integer n = this.getRequestUniqueCollectionID(true);
            FieldMapping fieldMapping = (FieldMapping)this.request.getObjectParam("FIELD_MAPPING");
            int n2 = this.request.getIntegerParam("GROUP_ID");
            int n3 = this.request.getIntegerParam("RELATIONSHIP");
            String string = null;
            if (n3 != 0) {
                string = this.request.getStringParam("COMPARATOR");
            }
            int n4 = this.request.getIntegerParam("THRESHOLD");
            boolean bl = this.request.getBooleanParam("USE_CACHE");
            Vector vector = new Vector();
            boolean bl2 = false;
            CollectionKeyWrapper collectionKeyWrapper = null;
            Vector vector2 = null;
            if (fieldMapping instanceof LinkFieldMapping) {
                criterionValueArray = this.request.getCollectionKeyParam().getInstitutionID();
                object2 = this.request.getCollectionKeyParam().getCollectionID();
                object = this.request.getCollectionKeyParam().getVCID();
                String string2 = this.request.getStringParam("CLIENT_LOCAL_IP");
                vector2 = (Vector)this.request.getObjectParam("USER_GROUP_SHELLS");
                this.debugOut("Just recieved all of these items from InsightSmartClient.");
                this.debugOut("localIPAddress: " + string2);
                this.debugOut("userGroupShells: " + vector2);
                collectionKeyWrapper = new CollectionKeyWrapper((String)criterionValueArray, (String)object2, (String)object);
                this.debugOut("collectionKey value is: " + collectionKeyWrapper);
                vector = LinkCodeGenerator.getLinkCodes(collectionKeyWrapper, this.clientIP, string2, vector2);
                this.debugOut("linkCodes is as follows: " + vector);
                bl2 = true;
            }
            connectionKeeper.start();
            if (bl2) {
                criterionValueArray = this.serverParent.getLinkFileManager();
                synchronized (criterionValueArray) {
                    this.serverParent.publishLinks(collectionKeyWrapper, vector2, n);
                }
            }
            this.debugOut("Unique list, field mapping: [" + fieldMapping.fieldStandardName + ", " + fieldMapping.fieldID + "], groupID: " + n2 + ", threshold: " + n4);
            criterionValueArray = null;
            object2 = this.serverParent.getFSM(n).getFieldMapping(fieldMapping);
            this.debugOut("mapping is: " + object2);
            if (object2 != null) {
                object = this.getBackendConnector();
                criterionValueArray = ((InsightBackendConnector)object).getUniqueList((FieldMapping)object2, n2, n3, string, n4, bl, vector);
            } else {
                this.debugOut("Unable to translate field mapping: " + fieldMapping);
                criterionValueArray = new CriterionValue[]{};
            }
            if (criterionValueArray != null) {
                this.debugOut("" + criterionValueArray.length + " elements found.");
                connectionKeeper.sendSuccess();
                this.oos.writeBoolean(true);
                this.oos.writeInt(criterionValueArray.length);
                for (int i = 0; i < criterionValueArray.length; ++i) {
                    this.oos.writeObject(criterionValueArray[i]);
                }
            } else {
                connectionKeeper.sendSuccess();
                this.oos.writeBoolean(false);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getUniqueList() [Time: " + System.currentTimeMillis() + "]: " + exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getGroupList() {
        this.debugOut("in getGroupList().");
        try {
            String string = this.request.getStringParam("VCID");
            boolean bl = this.request.getBooleanParam("VC_GROUPS_ONLY", false);
            Integer n = this.getRequestUniqueCollectionID(true);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            List list = bl ? insightBackendConnector.getVirtualCollectionList(n) : insightBackendConnector.getGroupList(n, string);
            GroupInformation groupInformation = null;
            Hashtable<String, List> hashtable = new Hashtable<String, List>(0);
            if (!bl) {
                PresentationFileManager presentationFileManager = this.serverParent.getPresFileManager();
                synchronized (presentationFileManager) {
                    for (int i = 0; list != null && i < list.size(); ++i) {
                        groupInformation = (GroupInformation)list.get(i);
                        hashtable.put(groupInformation.getGroupName(), this.serverParent.getPresFileManager().getPresentationNames(groupInformation.getGroupID()));
                    }
                }
                this.oos.writeInt(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    groupInformation = (GroupInformation)list.get(i);
                    this.oos.writeObject(groupInformation.getGroupName());
                }
                if (InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(4, 0, 1), 7) && !bl) {
                    this.oos.writeObject(hashtable);
                }
            } else {
                this.oos.writeObject(list);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getGroupList().");
        }
    }

    protected void getImageCount() {
        try {
            this.debugOut("in getImageCount().");
            GroupInformation groupInformation = (GroupInformation)this.request.getObjectParam("GROUP_INFORMATION");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            int n = insightBackendConnector.getImageCountOfGroup(groupInformation.getGroupID());
            this.oos.writeInt(n);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getImageCount().");
        }
    }

    protected void getCollectionList() {
        this.debugOut("in getCollectionList().");
        try {
            TrinityConnector trinityConnector = (TrinityConnector)this.getBackendConnector();
            List list = trinityConnector.getCollectionNames();
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getCollectionList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void doesGroupExist() {
        this.debugOut("in doesGroupExist().");
        try {
            String string = this.request.getStringParam("GROUP_NAME");
            String string2 = this.request.getStringParam("VCID");
            Integer n = this.getRequestUniqueCollectionID(true);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl = insightBackendConnector.doesGroupExist(n, string, string2);
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in doesGroupExist().");
        }
    }

    protected void getGroupId() {
        this.debugOut("in getGroupId().");
        try {
            String string = this.request.getStringParam("GROUP_NAME");
            String string2 = this.request.getStringParam("VCID");
            Integer n = this.getRequestUniqueCollectionID(true);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            int n2 = insightBackendConnector.getGroupID(n, string, string2);
            this.debugOut("Got group ID " + n2);
            this.oos.writeInt(n2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getGroupId():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getGroupInformation() {
        this.debugOut("in getGroupInformation().");
        try {
            String string = this.request.getStringParam("GROUP_NAME");
            String string2 = this.request.getStringParam("VCID");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            Integer n3 = this.getRequestUniqueCollectionID(true);
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n = -1;
                n2 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            GroupInformation groupInformation = insightBackendConnector.getGroupInformation(n3, string, string2, n, n2);
            this.debugOut("Group ID for group " + string + ": " + (groupInformation == null ? "NOT FOUND" : groupInformation.getGroupID() + ""));
            this.oos.writeObject(groupInformation);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getGroupInformation():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void addImage() {
        this.debugOut("in addImage().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            long l = this.request.getLongParam("MEDIA_ID");
            boolean bl = this.request.getBooleanParam("HAS_MVI");
            boolean bl2 = this.request.getBooleanParam("HAS_MULTI_PAGE");
            int n2 = this.request.getIntegerParam("ABSOLUTE_ORDER");
            this.debugOut("adding image " + l + " to group " + n + ".");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl3 = insightBackendConnector.addImage(n, l, bl, bl2, n2);
            this.oos.writeBoolean(bl3);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in addImage().");
        }
    }

    protected void addImages() {
        this.debugOut("in addImages().");
        try {
            InsightBackendConnector insightBackendConnector;
            long l = System.currentTimeMillis();
            Vector vector = (Vector)this.request.getObjectParam("IMAGES");
            Vector<Object> vector2 = new Vector<Object>(vector != null ? vector.size() : 0);
            if (vector != null) {
                insightBackendConnector = this.getBackendConnector();
                long l2 = System.currentTimeMillis();
                long l3 = 0L;
                ImageToProcess imageToProcess = null;
                insightBackendConnector.addBatchImages(vector);
                for (int i = 0; i < vector.size(); ++i) {
                    imageToProcess = (ImageToProcess)vector.elementAt(i);
                    if (!imageToProcess.success) continue;
                    vector2.addElement(imageToProcess);
                }
                this.debugOut("Total time to add images: " + (System.currentTimeMillis() - l2));
            }
            if (vector2 != null && vector2.size() > 1) {
                insightBackendConnector = vector2.firstElement();
                vector2.removeAllElements();
                vector2.addElement(insightBackendConnector);
            }
            this.oos.writeObject(vector2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in addImages().");
        }
    }

    protected void removeImage() {
        this.debugOut("in removeImage().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            long l = this.request.getLongParam("MEDIA_ID");
            this.debugOut("removing image " + l + " from group " + n + ".");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            insightBackendConnector.removeImage(n, l);
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeImage(): " + exception);
        }
    }

    protected void removeImages() {
        this.debugOut("in removeImages().");
        try {
            int n = this.request.getIntegerParam("GROUP_ID");
            Vector vector = (Vector)this.request.getObjectParam("MEDIA_IDS");
            this.debugOut("Images to remove: " + vector.size());
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            for (int i = 0; i < vector.size(); ++i) {
                long l = (Long)vector.elementAt(i);
                this.debugOut("removing image " + l + " from group " + n + ".");
                insightBackendConnector.removeImage(n, l);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeImages(): " + exception);
        }
    }

    protected void newGroup() {
        this.debugOut("in newGroup().");
        try {
            String string = this.request.getStringParam("VCID");
            Integer n = this.getRequestUniqueCollectionID(true);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            insightBackendConnector.newGroup(n, string);
            int n2 = insightBackendConnector.getGroupID();
            this.oos.writeInt(n2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in newGroup(): " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openGroup() {
        this.debugOut("in openGroup().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            Vector vector;
            Object object;
            connectionKeeper.start();
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            String string = this.request.getStringParam("GROUP_NAME");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("THUMBNAIL_SIZE");
            Integer n4 = this.getRequestUniqueCollectionID();
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n = -1;
                n2 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            GroupInformation groupInformation = insightBackendConnector.openGroupWithInfo(n4, string, collectionKey.getVCID(), false);
            ImageGroupFile imageGroupFile = new ImageGroupFile(string);
            int n5 = insightBackendConnector.getGroupID();
            int n6 = insightBackendConnector.getGroupID(n4, string, collectionKey.getVCID());
            if (n6 >= 0) {
                CollectionKey collectionKey2;
                int n7;
                Vector vector2;
                imageGroupFile = insightBackendConnector.getImageGroupFile(n5, n, n2, collectionKey, n3, false);
                imageGroupFile.imagesInGroup = null;
                object = this.serverParent.getPresFileManager();
                synchronized (object) {
                    this.serverParent.getPresFileManager().deleteAllPresentations(n5);
                    vector2 = this.serverParent.getPresFileManager().getPresentations(n6);
                    if (vector2 != null) {
                        for (n7 = 0; n7 < vector2.size(); ++n7) {
                            collectionKey2 = (ImageSeries)vector2.elementAt(n7);
                            ((ImageSeries)collectionKey2).setGroupID(n5);
                        }
                    }
                    imageGroupFile.setImageSerieses(vector2);
                }
                object = this.serverParent.getMviFileManager();
                synchronized (object) {
                    this.serverParent.getMviFileManager().deleteAllMultiviewImages(n5);
                    vector2 = this.serverParent.getMviFileManager().getMviSerieses(n6);
                    if (vector2 != null) {
                        for (n7 = 0; n7 < vector2.size(); ++n7) {
                            collectionKey2 = (MultiviewImageSeries)vector2.elementAt(n7);
                            ((MultiviewImageSeries)collectionKey2).setGroupID(n5);
                            insightBackendConnector.setMviSeries(n5, ((MultiviewImageSeries)collectionKey2).getImageID(), true);
                        }
                    }
                    imageGroupFile.setMviSerieses(vector2);
                }
                groupInformation.setContainsAudio(insightBackendConnector.groupContainsMediaType(2, n5, n, n2));
                groupInformation.setContainsVideo(insightBackendConnector.groupContainsMediaType(3, n5, n, n2));
                groupInformation.setContainsQtvr(insightBackendConnector.groupContainsMediaType(4, n5, n, n2));
                groupInformation.setContainsMultiviews(insightBackendConnector.groupHasMultiviewImages(n5, n, n2));
                groupInformation.setContainsMultipages(insightBackendConnector.groupHasMultipageDocuments(n5, n, n2));
                groupInformation.setAbsoluteOrdering(insightBackendConnector.groupIsAbsoluteOrdered(n5, n, n2));
            }
            if ((object = imageGroupFile.getMviSerieses()) != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    MultiviewImageSeries multiviewImageSeries = (MultiviewImageSeries)((Vector)object).elementAt(i);
                    if (multiviewImageSeries.getSlides() == null) continue;
                    for (int j = 0; j < multiviewImageSeries.getSlides().size(); ++j) {
                        MultiviewImageSlide multiviewImageSlide = (MultiviewImageSlide)multiviewImageSeries.getSlides().elementAt(j);
                        if (multiviewImageSlide.getInstitutionID() != null) continue;
                        multiviewImageSlide.setInstitutionID(collectionKey.getInstitutionID());
                        multiviewImageSlide.setCollectionID(collectionKey.getCollectionID());
                        multiviewImageSlide.setVCID(collectionKey.getVCID());
                    }
                }
            }
            if ((vector = imageGroupFile.getImageSerieses()) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ImageSeries imageSeries = (ImageSeries)vector.elementAt(i);
                    if (imageSeries.getSlides() == null) continue;
                    for (int j = 0; j < imageSeries.getSlides().size(); ++j) {
                        ImageSeriesSlide imageSeriesSlide = (ImageSeriesSlide)imageSeries.getSlides().elementAt(j);
                        if (imageSeriesSlide.getInstitutionID() != null) continue;
                        imageSeriesSlide.setInstitutionID(collectionKey.getInstitutionID());
                        imageSeriesSlide.setCollectionID(collectionKey.getCollectionID());
                        imageSeriesSlide.setVCID(collectionKey.getVCID());
                    }
                }
            }
            this.debugOut("Sending " + groupInformation);
            connectionKeeper.sendSuccess();
            this.oos.writeObject(imageGroupFile);
            if (groupInformation.getGroupID() == -1) {
                this.oos.writeObject(groupInformation);
            } else {
                this.oos.writeObject(null);
            }
            this.oos.writeInt(n5);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("exception in openGroup(): " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveGroup() {
        block17: {
            this.debugOut("in saveGroup().");
            ConnectionKeeper connectionKeeper = null;
            try {
                ImageGroupFile imageGroupFile = (ImageGroupFile)this.request.getObjectParam("IMAGE_GROUP_FILE");
                int n = this.request.getIntegerParam("GROUP_ID");
                String string = this.request.getStringParam("VCID");
                final Integer n2 = this.getRequestUniqueCollectionID();
                boolean bl = this.request.getBooleanParam("WAIT_FOR_SERVER");
                if (bl) {
                    connectionKeeper = new ConnectionKeeper(this.oos);
                    connectionKeeper.start();
                }
                InsightBackendConnector insightBackendConnector = this.getBackendConnector();
                final ArrayList arrayList = new ArrayList();
                int n3 = insightBackendConnector.saveAs(n2, n, imageGroupFile.getGroupName(), string, arrayList);
                boolean bl2 = false;
                if (n3 == -1) {
                    CollectionKey collectionKey;
                    int n4;
                    Vector vector;
                    Object object;
                    bl2 = true;
                    int n5 = insightBackendConnector.getBaseGroupID();
                    if (arrayList.size() != 0) {
                        object = new Runnable(){

                            public void run() {
                                InsightSmartServicer.this.serverParent.updateServerThumbnailCaches(n2, arrayList);
                            }
                        };
                        new Thread((Runnable)object).start();
                    }
                    if (bl2) {
                        object = this.serverParent.getPresFileManager();
                        synchronized (object) {
                            this.serverParent.getPresFileManager().deleteAllPresentations(n5);
                            vector = imageGroupFile.getImageSerieses();
                            for (n4 = 0; n4 < vector.size(); ++n4) {
                                collectionKey = (ImageSeries)vector.elementAt(n4);
                                ((ImageSeries)collectionKey).setGroupID(n5);
                                bl2 = this.serverParent.getPresFileManager().savePresentation((ImageSeries)collectionKey);
                                if (!bl2) break;
                                ((ImageSeries)collectionKey).setGroupID(n);
                            }
                        }
                    }
                    if (bl2) {
                        object = this.serverParent.getMviFileManager();
                        synchronized (object) {
                            this.serverParent.getMviFileManager().deleteAllMultiviewImages(n5);
                            vector = imageGroupFile.getMviSerieses();
                            for (n4 = 0; n4 < vector.size(); ++n4) {
                                collectionKey = (MultiviewImageSeries)vector.elementAt(n4);
                                ((MultiviewImageSeries)collectionKey).setGroupID(n5);
                                bl2 = this.serverParent.getMviFileManager().saveMultiviewImage((MultiviewImageSeries)collectionKey);
                                if (!bl2) break;
                                if (bl2) {
                                    insightBackendConnector.setMviSeries(((MultiviewImageSeries)collectionKey).getGroupID(), ((MultiviewImageSeries)collectionKey).getImageID(), true);
                                }
                                ((MultiviewImageSeries)collectionKey).setGroupID(n);
                            }
                        }
                    }
                }
                if (connectionKeeper != null) {
                    connectionKeeper.sendSuccess();
                }
                this.oos.writeBoolean(bl2);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("Exception in saveGroup(): " + exception);
                if (connectionKeeper == null) break block17;
                connectionKeeper.sendFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAs() {
        block11: {
            this.debugOut("in saveAs().");
            ConnectionKeeper connectionKeeper = null;
            try {
                int n = this.request.getIntegerParam("GROUP_ID");
                String string = this.request.getStringParam("GROUP_NAME");
                String string2 = this.request.getStringParam("VCID");
                final Integer n2 = this.getRequestUniqueCollectionID();
                boolean bl = this.request.getBooleanParam("WAIT_FOR_SERVER");
                if (bl) {
                    connectionKeeper = new ConnectionKeeper(this.oos);
                    connectionKeeper.start();
                }
                InsightBackendConnector insightBackendConnector = this.getBackendConnector();
                final ArrayList arrayList = new ArrayList();
                insightBackendConnector.saveAs(n2, n, string, string2, arrayList);
                if (arrayList.size() != 0) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            InsightSmartServicer.this.serverParent.updateServerThumbnailCaches(n2, arrayList);
                        }
                    };
                    new Thread(runnable).start();
                }
                int n3 = insightBackendConnector.getBaseGroupID();
                FilenameFilter filenameFilter = this.serverParent.getPresFileManager();
                synchronized (filenameFilter) {
                    this.serverParent.getPresFileManager().deleteAllPresentations(n3);
                    this.serverParent.getPresFileManager().copyPresentations(n, n3);
                }
                filenameFilter = this.serverParent.getMviFileManager();
                synchronized (filenameFilter) {
                    this.serverParent.getMviFileManager().deleteAllMultiviewImages(n3);
                    this.serverParent.getMviFileManager().copyMultiviewImages(n, n3);
                }
                if (connectionKeeper != null) {
                    connectionKeeper.sendSuccess();
                }
                this.oos.writeBoolean(true);
                this.oos.flush();
            }
            catch (Exception exception) {
                this.debugOut("exception in saveAs(): " + exception);
                if (connectionKeeper == null) break block11;
                connectionKeeper.sendFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteGroup() {
        this.debugOut("in deleteGroup().");
        try {
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            int n = this.request.getIntegerParam("GROUP_ID");
            String string4 = this.request.getStringParam("USER_NAME");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            int n2 = insightBackendConnector.deleteGroup(n);
            Object object = this.serverParent.getPresFileManager();
            synchronized (object) {
                this.serverParent.getPresFileManager().deleteAllPresentations(n);
                this.serverParent.getPresFileManager().deleteAllPresentations(insightBackendConnector.getBaseGroupID());
            }
            object = this.serverParent.getMviFileManager();
            synchronized (object) {
                this.serverParent.getMviFileManager().deleteAllMultiviewImages(n);
                this.serverParent.getMviFileManager().deleteAllMultiviewImages(insightBackendConnector.getBaseGroupID());
            }
            object = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, null, null);
            if (object != null) {
                ((UserGroupConnection)object).getThumbnailQueryCache().removeThumbnailQuery(n);
            }
            if (n2 == -1) {
                this.debugOut("Group " + n + " successfully deleted.");
            } else {
                this.debugOut("Group " + n + " not deleted.");
            }
        }
        catch (Exception exception) {
            this.debugOut("exception in deleteGroup(): " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void closeGroup() {
        this.debugOut("in closeGroup().");
        try {
            Object object;
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            int n = this.request.getIntegerParam("GROUP_ID");
            String string4 = this.request.getStringParam("USER_NAME");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            int n2 = insightBackendConnector.closeGroup(n);
            if (n2 == -1) {
                object = this.serverParent.getPresFileManager();
                synchronized (object) {
                    this.serverParent.getPresFileManager().deleteAllPresentations(n);
                }
                object = this.serverParent.getMviFileManager();
                synchronized (object) {
                    this.serverParent.getMviFileManager().deleteAllMultiviewImages(n);
                }
            }
            if ((object = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, null, null)) != null) {
                ((UserGroupConnection)object).getThumbnailQueryCache().removeThumbnailQuery(n);
            }
            if (n2 != -4) return;
        }
        catch (Exception exception) {
            this.debugOut("exception in closeGroup(): " + exception);
        }
    }

    protected void getObjectDimension() {
        this.debugOut("in getObjectDimension().");
        try {
            long l = this.request.getLongParam("MEDIA_ID");
            Integer n = this.getRequestUniqueCollectionID();
            this.debugOut("Image ID: " + l + ".");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            ObjectDimension objectDimension = insightBackendConnector.getObjectDimension(n, l);
            this.oos.writeObject(objectDimension);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectDimension(): " + exception);
        }
    }

    protected void getFullInformation() {
        this.debugOut("in getFullInformation().");
        try {
            int n;
            Integer n2 = this.getRequestUniqueCollectionID();
            long l = this.request.getLongParam("OBJECT_ID");
            boolean bl = this.request.getBooleanParam("USING_STANDARD_NAME");
            String string = this.request.getStringParam("STANDARD_NAME");
            this.debugOut("Object ID: " + l + ", standard name: " + string + ", usingStandardName: " + bl);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            FieldValue[] fieldValueArray = insightBackendConnector.getFullInformation(l);
            this.debugOut("full-information gathered; " + fieldValueArray.length + " elements.");
            Vector<FieldValue> vector = new Vector<FieldValue>(fieldValueArray.length);
            Field field = null;
            if (fieldValueArray.length > 0) {
                for (n = 0; n < fieldValueArray.length; ++n) {
                    if (fieldValueArray[n] == null || fieldValueArray[n].value == null || fieldValueArray[n].value.length() <= 0) continue;
                    field = null;
                    if (fieldValueArray[n].isFieldGroupName) {
                        field = new Field();
                        field.fieldDisplayName = fieldValueArray[n].displayName;
                        field.stringType = 2;
                        field.descriptionURL = null;
                    } else {
                        field = bl && string != null ? this.serverParent.getFSM(n2).getFieldInStandardByID(string, fieldValueArray[n].getFieldID()) : this.serverParent.getFSM(n2).getFieldByID(fieldValueArray[n].getFieldID());
                        if (field == null && vector.size() > 0 && ((FieldValue)vector.lastElement()).isFieldGroupName && ((FieldValue)vector.lastElement()).getValue() == null) {
                            vector.removeElementAt(vector.size() - 1);
                        }
                    }
                    if (field == null) continue;
                    fieldValueArray[n].field = field;
                    vector.addElement(fieldValueArray[n]);
                }
            }
            n = 0;
            while (n < vector.size()) {
                boolean bl2 = false;
                FieldValue fieldValue = (FieldValue)vector.elementAt(n);
                if (fieldValue.isFieldGroupName && fieldValue.getValue() == null && (n + 1 == vector.size() || ((FieldValue)vector.elementAt((int)(n + 1))).isFieldGroupName || ((FieldValue)vector.elementAt((int)(n + 1))).field.fieldGroupID == 0)) {
                    vector.removeElementAt(n);
                    bl2 = true;
                }
                if (bl2) continue;
                ++n;
            }
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFullInformation():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getFullObjectData() {
        this.debugOut("in getFullObjectData().");
        try {
            Integer n = this.getRequestUniqueCollectionID();
            long l = this.request.getLongParam("OBJECT_ID");
            boolean bl = this.request.getBooleanParam("USING_STANDARD_NAME");
            String string = this.request.getStringParam("STANDARD_NAME");
            this.debugOut("object reference: " + l + ".");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            ObjectDataRecord objectDataRecord = insightBackendConnector.getFullObjectData(l, this.serverParent.getFSM(n), string);
            this.oos.writeObject(objectDataRecord);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFullObjectData():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getFullMediaData() {
        this.debugOut("in getFullMediaData().");
        try {
            long l = this.request.getLongParam("MEDIA_ID");
            int n = this.request.getIntegerParam("RESOLUTION");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            MediaMetaData mediaMetaData = insightBackendConnector.getFullMediaData(l, n);
            this.oos.writeObject(mediaMetaData);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFullMediaData():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void removeThumbnailCache() {
        this.debugOut("in removeThumbnailCache().");
        try {
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            int n = this.request.getIntegerParam("GROUP_ID");
            String string4 = this.request.getStringParam("USER_NAME");
            UserGroupConnection userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, null, null);
            if (userGroupConnection != null) {
                userGroupConnection.getThumbnailQueryCache().removeThumbnailQuery(n);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeThumbnailCache(): " + exception);
        }
    }

    protected void doThumbnailQuery() {
        this.debugOut("in doThumbnailQuery() 1.");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            Integer n = this.getRequestUniqueCollectionID();
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            ThumbnailQuery thumbnailQuery = (ThumbnailQuery)this.request.getObjectParam("THUMBNAIL_QUERY");
            String string4 = this.request.getStringParam("USER_NAME");
            boolean bl = InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(3, 10, 9), 7);
            connectionKeeper.start();
            UserGroupConnection userGroupConnection = null;
            boolean bl2 = false;
            userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, true, this.hostIP, string4, thumbnailQuery != null ? thumbnailQuery.getInstitutionID() : null, thumbnailQuery != null ? thumbnailQuery.getCollectionID() : null, thumbnailQuery != null ? thumbnailQuery.getVCID() : null);
            boolean bl3 = bl2 = userGroupConnection != null;
            if (bl2) {
                long l = System.currentTimeMillis();
                thumbnailQuery = this.doThumbnailQuery(thumbnailQuery, userGroupConnection, n);
                this.debugOut("Time for call to doThumbnailQuery(): " + (System.currentTimeMillis() - l));
                userGroupConnection.getThumbnailQueryCache().addThumbnailQuery(thumbnailQuery, true);
                ThumbnailDistribution thumbnailDistribution = thumbnailQuery.getThumbnailResultCache().getDistribution();
                DynamicThumbnailDistribution dynamicThumbnailDistribution = thumbnailQuery.getThumbnailResultCache().getDynamicDistribution();
                this.serverParent.logSearchQuery(thumbnailQuery, thumbnailQuery.collectionName, this.hostIP, this.clientIP, string3, string, string4);
                connectionKeeper.sendSuccess();
                this.debugOut("dynamicDistribution: " + bl);
                if (bl) {
                    this.debugOut("Sending dtd: " + dynamicThumbnailDistribution.totalCount);
                    this.oos.writeObject(dynamicThumbnailDistribution);
                } else {
                    this.oos.writeObject(thumbnailDistribution);
                }
            } else {
                connectionKeeper.sendFailure();
                this.oos.writeObject(null);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in doThumbnailQuery(): " + exception);
        }
    }

    public ThumbnailQuery doThumbnailQuery(ThumbnailQuery thumbnailQuery, Integer n) {
        this.debugOut("in doThumbnailQuery() 2.");
        return this.doThumbnailQuery(thumbnailQuery, null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThumbnailQuery doThumbnailQuery(ThumbnailQuery thumbnailQuery, UserGroupConnection userGroupConnection, Integer n) {
        Serializable serializable;
        Serializable serializable2;
        int n2;
        int n3;
        this.debugOut("in doThumbnailQuery() 3.");
        FieldStandardsManager fieldStandardsManager = this.serverParent.getFSM(n);
        ThumbnailQuery thumbnailQuery2 = thumbnailQuery;
        boolean bl = false;
        Vector vector = null;
        for (n3 = 0; thumbnailQuery != null && thumbnailQuery.criteria != null && n3 < thumbnailQuery.criteria.length; ++n3) {
            if (thumbnailQuery.criteria[n3] instanceof FieldCriterion) {
                FieldCriterion fieldCriterion = (FieldCriterion)thumbnailQuery.criteria[n3];
                fieldCriterion.fieldMapping = fieldStandardsManager.getFieldMapping(fieldCriterion.fieldMapping);
                this.debugOut("Criterion[" + n3 + "]: " + fieldCriterion);
                if (!(fieldCriterion instanceof LinkFieldCriterion)) continue;
                bl = true;
                ((LinkFieldCriterion)fieldCriterion).setCollectionKey(thumbnailQuery2);
                ((LinkFieldCriterion)fieldCriterion).setClientIP(this.clientIP);
                if (userGroupConnection != null) {
                    ((LinkFieldCriterion)fieldCriterion).setLocalClientIP(userGroupConnection.getLocalIPAddress());
                }
                vector = ((LinkFieldCriterion)fieldCriterion).getUserGroupShells();
                continue;
            }
            this.debugOut("Free text[" + n3 + "]: " + thumbnailQuery.criteria[n3]);
        }
        int n4 = n3 = thumbnailQuery != null && (thumbnailQuery.criteria == null || thumbnailQuery.criteria.length == 0) ? 1 : 0;
        if (!(thumbnailQuery == null || this.serverParent.ALLOW_COLLECTION_SORT_MAX <= 0 || n3 == 0 && this.request != null && InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(3, 10, 11), 7) || (n2 = this.serverParent.getGroupRecordCount(thumbnailQuery.getGroupID())) <= this.serverParent.ALLOW_COLLECTION_SORT_MAX)) {
            serializable2 = null;
            if (thumbnailQuery.captionFields != null && thumbnailQuery.captionFields.length > 0 && thumbnailQuery.captionFields[0] != null) {
                serializable2 = fieldStandardsManager.getFieldStandard(thumbnailQuery.captionFields[0].fieldStandardName);
            }
            if (serializable2 == null && thumbnailQuery.sortFields != null && thumbnailQuery.sortFields.length > 0 && thumbnailQuery.sortFields[0] != null) {
                serializable2 = fieldStandardsManager.getFieldStandard(thumbnailQuery.sortFields[0].fieldStandardName);
            }
            if (serializable2 == null) {
                this.debugOut("WARNING: Using default caption\\sort fields of the COLLECTION std.");
                serializable2 = fieldStandardsManager.getCollectionStandard();
            }
            if (serializable2 != null) {
                this.debugOut("Setting caption\\sort fields back to defaults for field std " + ((FieldStandard)serializable2).getStandardName() + ".");
                if (thumbnailQuery.captionFields != null && thumbnailQuery.captionFields.length > 0) {
                    thumbnailQuery.captionFields = ((FieldStandard)serializable2).getStartThumbFields();
                }
                if (thumbnailQuery.sortFields != null && thumbnailQuery.sortFields.length > 0) {
                    thumbnailQuery.sortFields = ((FieldStandard)serializable2).getStartSortFields();
                }
            } else {
                this.debugOut("ERROR: Default caption\\sort fields not found (field std missing)!");
            }
        }
        for (n2 = 0; thumbnailQuery != null && thumbnailQuery.captionFields != null && n2 < thumbnailQuery.captionFields.length; ++n2) {
            if (thumbnailQuery.captionFields[n2].fieldID == 0) continue;
            thumbnailQuery.captionFields[n2] = fieldStandardsManager.getFieldMapping(thumbnailQuery.captionFields[n2]);
        }
        for (n2 = 0; thumbnailQuery != null && thumbnailQuery.sortFields != null && n2 < thumbnailQuery.sortFields.length; ++n2) {
            thumbnailQuery.sortFields[n2] = fieldStandardsManager.getFieldMapping(thumbnailQuery.sortFields[n2]);
        }
        if (bl) {
            LinkFileManager linkFileManager = this.serverParent.getLinkFileManager();
            synchronized (linkFileManager) {
                this.serverParent.publishLinks(thumbnailQuery2, vector, n);
            }
        }
        ThumbnailQuery thumbnailQuery3 = null;
        serializable2 = null;
        Object object = this.serverParent.getThumbnailQueryCache();
        synchronized (object) {
            this.debugOut("Searching for thumbnail query in server default thumbnail cache.");
            thumbnailQuery3 = this.serverParent.getThumbnailQueryCache().getThumbnailQuery(thumbnailQuery);
            if (thumbnailQuery3 == null && (serializable = this.serverParent.getThumbnailQueryCache().getMatchingFieldsThumbnailQuery(thumbnailQuery)) != null && ((ThumbnailQuery)serializable).getThumbnailResultCache() != null) {
                serializable2 = ((ThumbnailQuery)serializable).getThumbnailResultCache().getIscrMap();
            }
        }
        if (thumbnailQuery3 == null && userGroupConnection != null) {
            this.debugOut("Searching for thumbnail query in user group connection in [" + userGroupConnection.getGroupName() + ", " + userGroupConnection.getIPAddress() + "].");
            thumbnailQuery3 = userGroupConnection.getThumbnailQueryCache().getThumbnailQuery(thumbnailQuery);
        }
        if (thumbnailQuery3 == null) {
            thumbnailQuery3 = thumbnailQuery;
            object = this.getBackendConnector();
            serializable = new Vector(0);
            int n5 = 0;
            long l = System.currentTimeMillis();
            if (serializable2 == null) {
                serializable2 = new IscrMap(thumbnailQuery3.length);
            }
            serializable = ((InsightBackendConnector)object).performThumbnailQuery(thumbnailQuery3.getGroupID(), thumbnailQuery3.getCaptionFields(), thumbnailQuery3.getSortFields(), thumbnailQuery3.getCriteria(), thumbnailQuery3.isFreeTextSearch(), thumbnailQuery3.getThumbnailSize(), thumbnailQuery3.getProfileID(), thumbnailQuery3.getUserCollection(), false, thumbnailQuery3.getStart(), thumbnailQuery3.getLength(), (IscrMap)serializable2, false);
            this.debugOut("Version " + (object instanceof TrinityConnector ? "3" : "2") + " time for query: " + (System.currentTimeMillis() - l));
            n5 = ((Vector)serializable).size();
            this.debugOut("Results size: " + ((Vector)serializable).size());
            l = System.currentTimeMillis();
            ThumbnailResultCache thumbnailResultCache = new ThumbnailResultCache(n, thumbnailQuery3);
            thumbnailResultCache.setResults((Vector)serializable, this.serverParent.getDynamicDistributionBucketSize());
            this.debugOut("ISCR map size: " + (serializable2 == null ? 0 : ((Hashtable)serializable2).size()));
            if (serializable2 != null && ((Hashtable)serializable2).size() > 0) {
                thumbnailResultCache.setIscrMap((IscrMap)serializable2);
            }
            this.debugOut("Time for creating and setting TD and TRC: " + (System.currentTimeMillis() - l));
            l = System.currentTimeMillis();
            thumbnailQuery3.setThumbnailResultCache(thumbnailResultCache);
            thumbnailQuery3.resultCount = thumbnailResultCache.getTotalCount();
            if (n3 != 0) {
                this.serverParent.setGroupRecordCount(thumbnailQuery3.getGroupID(), thumbnailQuery3.resultCount);
            }
        }
        return thumbnailQuery3;
    }

    protected void getTallyMarks() {
        this.debugOut("in getTallyMarks().");
        try {
            Serializable serializable;
            Integer n = this.getRequestUniqueCollectionID();
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            ThumbnailQuery thumbnailQuery = (ThumbnailQuery)this.request.getObjectParam("THUMBNAIL_QUERY");
            int n2 = this.request.getIntegerParam("TALLY_INDEX");
            int n3 = this.request.getIntegerParam("LENGTH");
            boolean bl = InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(3, 10, 9), 7);
            ThumbnailDistribution thumbnailDistribution = null;
            DynamicThumbnailDistribution dynamicThumbnailDistribution = null;
            UserGroupConnection userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, true, this.hostIP, string4, thumbnailQuery != null ? thumbnailQuery.getInstitutionID() : null, thumbnailQuery != null ? thumbnailQuery.getCollectionID() : null, thumbnailQuery != null ? thumbnailQuery.getVCID() : null);
            if (userGroupConnection != null) {
                serializable = userGroupConnection.getThumbnailQueryCache().getThumbnailQuery(thumbnailQuery.getGroupID());
                if (serializable == null) {
                    long l = System.currentTimeMillis();
                    serializable = this.doThumbnailQuery(thumbnailQuery, userGroupConnection, n);
                    this.debugOut("Time for call to doThumbnailQuery(): " + (System.currentTimeMillis() - l));
                    userGroupConnection.getThumbnailQueryCache().addThumbnailQuery((ThumbnailQuery)serializable, true);
                }
                if (serializable != null) {
                    ThumbnailResultCache thumbnailResultCache = ((ThumbnailQuery)serializable).getThumbnailResultCache();
                    if (thumbnailResultCache != null) {
                        thumbnailDistribution = thumbnailResultCache.getDistribution();
                        dynamicThumbnailDistribution = thumbnailResultCache.getDynamicDistribution();
                    } else {
                        this.debugOut("Thumbnail result cache not found for group " + thumbnailQuery.getGroupID() + ".");
                    }
                } else {
                    this.debugOut("Thumbnail query not found for group " + thumbnailQuery.getGroupID() + ".");
                }
            }
            if (thumbnailDistribution == null && dynamicThumbnailDistribution == null) {
                this.oos.writeObject(null);
            } else {
                serializable = null;
                this.debugOut("dynamicDistribution: " + bl);
                serializable = bl ? dynamicThumbnailDistribution.getTallyMarks(n2, n3) : thumbnailDistribution.getTallyMarks(n2, n3);
                this.debugOut("Sending " + ((Vector)serializable).size() + " tally mark(s).");
                this.oos.writeObject(serializable);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getTallyMarks():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getThumbnails() {
        this.debugOut("in getThumbnails().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            Serializable serializable;
            Integer n = this.getRequestUniqueCollectionID();
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            Vector vector = (Vector)this.request.getObjectParam("TALLY_MARKS");
            ThumbnailQuery thumbnailQuery = (ThumbnailQuery)this.request.getObjectParam("THUMBNAIL_QUERY");
            connectionKeeper.start();
            ThumbnailResultCache thumbnailResultCache = null;
            UserGroupConnection userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, true, this.hostIP, string4, thumbnailQuery != null ? thumbnailQuery.getInstitutionID() : null, thumbnailQuery != null ? thumbnailQuery.getCollectionID() : null, thumbnailQuery != null ? thumbnailQuery.getVCID() : null);
            if (userGroupConnection != null) {
                serializable = userGroupConnection.getThumbnailQueryCache().getThumbnailQuery(thumbnailQuery.getGroupID());
                if (serializable == null) {
                    long l = System.currentTimeMillis();
                    serializable = this.doThumbnailQuery(thumbnailQuery, userGroupConnection, n);
                    this.debugOut("Time for call to doThumbnailQuery(): " + (System.currentTimeMillis() - l));
                    userGroupConnection.getThumbnailQueryCache().addThumbnailQuery((ThumbnailQuery)serializable, true);
                }
                if (serializable != null) {
                    thumbnailResultCache = ((ThumbnailQuery)serializable).getThumbnailResultCache();
                    if (thumbnailResultCache == null) {
                        this.debugOut("Thumbnail result cache not found for group " + thumbnailQuery.getGroupID() + ".");
                    }
                } else {
                    this.debugOut("Thumbnail query not found for group " + thumbnailQuery.getGroupID() + ".");
                }
            }
            if (thumbnailResultCache == null) {
                connectionKeeper.sendSuccess();
                this.oos.writeInt(0);
            } else {
                this.debugOut("Requesting " + vector.size() + " thumbnail(s).");
                serializable = thumbnailResultCache.getThumbnails(vector);
                this.debugOut("Sending " + ((Vector)serializable).size() + " thumbnail(s).");
                connectionKeeper.sendSuccess();
                this.oos.writeInt(((Vector)serializable).size());
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    this.oos.writeObject(((Vector)serializable).elementAt(i));
                }
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getThumbnails():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getSingleURL() {
        this.debugOut("in getSingleURL().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("IS_OBJECT_ID");
            long l = this.request.getLongParam("MEDIA_ID");
            int n3 = this.request.getIntegerParam("RESOLUTION");
            String string = this.request.getStringParam("INSTITUTION_ID", "UNAVAILABLE");
            String string2 = this.request.getStringParam("VCID", "UNAVAILABLE");
            boolean bl2 = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl2) {
                n = -1;
                n2 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            String string3 = null;
            if (bl) {
                this.debugOut("getting URL for object ID " + l);
                string3 = insightBackendConnector.getImageFromObjectID("" + l, n3, n, n2);
            } else {
                this.debugOut("getting URL for image ref. " + l);
                string3 = insightBackendConnector.getImage(l, n3, n, n2);
                string3 = InsightSmartServer.addExtendedURLParams(this.request, n3, string3, n, n2, string, string2);
            }
            this.debugOut("URL for " + l + " / " + n3 + ": " + string3);
            this.oos.writeObject(string3);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getSingleURL.");
        }
    }

    protected void getURLs() {
        this.debugOut("in getURLs().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            long l = this.request.getLongParam("MEDIA_ID");
            String string = this.request.getStringParam("INSTITUTION_ID", "UNAVAILABLE");
            String string2 = this.request.getStringParam("VCID", "UNAVAILABLE");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n = -1;
                n2 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            this.debugOut("gathering URLs.");
            String[] stringArray = insightBackendConnector.getURLs(l, n, n2);
            this.debugOut("finished gathering " + stringArray.length / 3 + " URLs:");
            this.oos.writeInt(stringArray.length / 3);
            int n3 = 0;
            for (int i = 0; i < stringArray.length; i += 3) {
                if (stringArray[i] != null) {
                    this.debugOut("" + i + ": " + stringArray[i]);
                    stringArray[i] = InsightSmartServer.addExtendedURLParams(this.request, n3++, stringArray[i], n, n2, string, string2);
                }
                this.oos.writeObject(stringArray[i]);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getURLs(): " + exception);
        }
    }

    protected void getURLsWithType() {
        this.debugOut("in getURLsWithType().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            long l = this.request.getLongParam("MEDIA_ID");
            String string = this.request.getStringParam("INSTITUTION_ID", "UNAVAILABLE");
            String string2 = this.request.getStringParam("VCID", "UNAVAILABLE");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n = -1;
                n2 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            this.debugOut("gathering URLs with image type.");
            Object[] objectArray = insightBackendConnector.getURLsAndDimensions(l, n, n2);
            this.debugOut("finished gathering URLs:");
            this.oos.writeInt(objectArray.length);
            int n3 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) {
                    if (i % 3 == 2) {
                        this.debugOut(objectArray[i - 1] + "; " + objectArray[i]);
                    } else if (i % 3 == 0) {
                        this.debugOut("" + objectArray[i]);
                        objectArray[i] = InsightSmartServer.addExtendedURLParams(this.request, n3++, (String)objectArray[i], n, n2, string, string2);
                    }
                }
                this.oos.writeObject(objectArray[i]);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getURLsWithType(): " + exception);
        }
    }

    protected void getDescriptionData() {
        this.debugOut("in getDescriptionData().");
        try {
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = insightBackendConnector.getDescriptionData(collectionKey.getInstitutionID(), collectionKey.getCollectionID(), collectionKey.getVCID());
            if (vector == null || vector.size() != 2) {
                this.debugOut("Invalid data.");
                this.oos.writeBoolean(false);
            } else {
                this.oos.writeBoolean(true);
                this.oos.writeObject(vector);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getDescriptionData, e: " + exception);
        }
    }

    protected void getConfigurationInfo() {
        this.debugOut("in getConfigurationInfo().");
        try {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.request.getObjectParam("COLLECTION_INFO");
            String string = this.request.getStringParam("STANDARD_NAME");
            this.debugOut("standardName: " + string, 3);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            insightBackendConnector.getConfigurationInfo(trinityCollectionInfo);
            Integer n = trinityCollectionInfo.getUniqueCollectionID();
            if (n != null && this.serverParent.getFSM(n).supportsLinkSearching()) {
                trinityCollectionInfo.supportsLinkSearching = true;
            }
            this.debugOut("supportsLinkSearching: " + trinityCollectionInfo.supportsLinkSearching);
            trinityCollectionInfo.supportsKeywordsFieldSearching = true;
            if (trinityCollectionInfo.isInfoComplete()) {
                FieldMapping[] fieldMappingArray = this.serverParent.getFSM(trinityCollectionInfo.getUniqueCollectionID()).getStartThumbFields(string);
                trinityCollectionInfo.dataFieldMappings = new Vector(fieldMappingArray.length);
                for (int i = 0; i < fieldMappingArray.length; ++i) {
                    trinityCollectionInfo.dataFieldMappings.addElement(fieldMappingArray[i]);
                }
                FieldMapping[] fieldMappingArray2 = this.serverParent.getFSM(trinityCollectionInfo.getUniqueCollectionID()).getStartSortFields(string);
                trinityCollectionInfo.sortFieldMappings = new Vector(fieldMappingArray2.length);
                for (int i = 0; i < fieldMappingArray2.length; ++i) {
                    trinityCollectionInfo.sortFieldMappings.addElement(fieldMappingArray2[i]);
                }
                if (trinityCollectionInfo.getSearchCriteria() != null) {
                    Object[] objectArray = new FieldCriterion[trinityCollectionInfo.getSearchCriteria().size()];
                    trinityCollectionInfo.getSearchCriteria().copyInto(objectArray);
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object = objectArray[i];
                        ((FieldCriterion)object).fieldMapping = this.serverParent.getFSM(trinityCollectionInfo.getUniqueCollectionID()).getFieldMappingInStandard(string, ((FieldCriterion)object).field.fieldName);
                        ((FieldCriterion)object).field = null;
                        if (((FieldCriterion)object).fieldMapping != null) continue;
                        trinityCollectionInfo.getSearchCriteria().removeElement(object);
                    }
                }
            } else {
                this.debugOut("Configuration info not properly set.");
            }
            trinityCollectionInfo.setServerVersion(new InsightVersion("09Dec2010"));
            trinityCollectionInfo.setServerSerializedClasses(this.serverParent.getServerSerializedClasses());
            trinityCollectionInfo.setMediaSecurityTicketlessMode(this.serverParent.isMediaSecurityTicketlessMode());
            if (!trinityCollectionInfo.getMediaSecurityTicketlessMode() || InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 0, 0), 7)) {
                trinityCollectionInfo.setMediaSecurityEnabled(this.serverParent.isMediaSecurityEnabled());
            }
            trinityCollectionInfo.setHelpFileNames(this.serverParent.getHelpFileNames());
            this.oos.writeObject(trinityCollectionInfo);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getConfigurationInfo(): " + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getCollectionInfoUpdate() {
        this.debugOut("in getCollectionInfoUpdate().");
        try {
            Integer n = this.getRequestUniqueCollectionID();
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            String string = this.request.getStringParam("STANDARD_NAME");
            this.debugOut("standardName: " + string, 3);
            FieldMapping[] fieldMappingArray = this.serverParent.getFSM(n).getStartThumbFields(string);
            Vector<FieldMapping> vector = new Vector<FieldMapping>(fieldMappingArray.length);
            for (int i = 0; i < fieldMappingArray.length; ++i) {
                vector.addElement(fieldMappingArray[i]);
            }
            FieldMapping[] fieldMappingArray2 = this.serverParent.getFSM(n).getStartSortFields(string);
            Vector<FieldMapping> vector2 = new Vector<FieldMapping>(fieldMappingArray2.length);
            for (int i = 0; i < fieldMappingArray2.length; ++i) {
                vector2.addElement(fieldMappingArray2[i]);
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector3 = insightBackendConnector.getInitialSearchCriteria(collectionKey.getInstitutionID(), collectionKey.getCollectionID(), collectionKey.getVCID());
            if (vector3 != null) {
                Object[] objectArray = new FieldCriterion[vector3.size()];
                vector3.copyInto(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    ((FieldCriterion)object).fieldMapping = this.serverParent.getFSM(n).getFieldMappingInStandard(string, ((FieldCriterion)object).field.fieldName);
                    ((FieldCriterion)object).field = null;
                    if (((FieldCriterion)object).fieldMapping != null) continue;
                    vector3.removeElement(object);
                }
            }
            this.oos.writeObject(vector);
            this.oos.writeObject(vector2);
            this.oos.writeObject(vector3);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionInfoUpdate(): " + exception + InsightUtilities.getStackTrace());
        }
    }

    protected void getVirtualCollectionInfo() {
    }

    protected void getPrivs() {
        this.debugOut("in getPrivs().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            MedeConnector medeConnector = this.serverParent.getMedeConnector();
            int[] nArray = medeConnector.getPrivs(n, n2);
            this.debugOut("privs gathered.");
            this.oos.writeObject(nArray);
            if (InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 50, 0), 7)) {
                this.oos.writeInt(medeConnector.getMedePermissions(n, n2));
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPrivs():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void rebuildFsmAndThumbCache() {
        block16: {
            this.debugOut("in rebuildFsmAndThumbCache().");
            ConnectionKeeper connectionKeeper = null;
            try {
                Integer n = this.getRequestUniqueCollectionID();
                boolean bl = this.request.getBooleanParam("WAIT_FOR_SERVER");
                if (bl) {
                    connectionKeeper = new ConnectionKeeper(this.oos);
                    connectionKeeper.start();
                }
                boolean bl2 = this.serverParent.getServerRebuildLock();
                boolean bl3 = false;
                if (!bl) {
                    this.oos.writeBoolean(bl2);
                    this.oos.writeBoolean(bl3);
                    this.oos.flush();
                }
                if (bl2) {
                    try {
                        bl2 = true;
                        InsightBackendConnector insightBackendConnector = this.getBackendConnector();
                        this.newLine();
                        this.debugOut("Rebuilding field standards manager.");
                        this.newLine();
                        FieldStandardsManager fieldStandardsManager = ((TrinityConnector)insightBackendConnector).assembleFSM(n, true);
                        this.newLine();
                        this.debugOut("Rebuilding thumbnail query cache.");
                        this.newLine();
                        ThumbnailQueryCache thumbnailQueryCache = InsightSmartServer.generateThumbnailQueryCache(fieldStandardsManager, this.serverParent.getBackendParameters());
                        if (thumbnailQueryCache != null && thumbnailQueryCache.queryCache != null) {
                            this.debugOut("Thumbnail query cache size: " + thumbnailQueryCache.queryCache.size());
                            for (int i = 0; i < thumbnailQueryCache.queryCache.size(); ++i) {
                                ThumbnailQuery thumbnailQuery = (ThumbnailQuery)thumbnailQueryCache.queryCache.elementAt(i);
                                this.debugOut("Cache " + (i + 1) + " result count: " + thumbnailQuery.getThumbnailResultCache().results.size());
                                this.debugOut("TD tally count " + (i + 1) + ": " + thumbnailQuery.getThumbnailResultCache().getDistribution().totalCount);
                            }
                            this.newLine();
                            this.debugOut("Setting field standards manager.");
                            this.serverParent.setFSM(n, fieldStandardsManager);
                            this.newLine();
                            this.debugOut("Setting thumbnail query cache.");
                            this.serverParent.setThumbnailQueryCache(thumbnailQueryCache);
                            TrinityConnector.clearuniqueListCache();
                            TrinityIndexer.clearBrowserFieldsCache();
                            if (this.serverParent.getMedePublisher() != null) {
                                this.serverParent.getMedePublisher().clearEntityInfo();
                            }
                            bl3 = true;
                        }
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception while rebuilding():\n" + InsightUtilities.getStackTrace(exception));
                    }
                    catch (Error error) {
                        this.debugOut("Error while rebuilding():\n" + InsightUtilities.getStackTrace(error));
                    }
                    this.serverParent.releaseServerRebuildLock();
                } else {
                    this.debugOut("Server currently rebuilding field standards manager and thumbail query cache.");
                }
                if (bl) {
                    if (connectionKeeper != null) {
                        connectionKeeper.sendSuccess();
                    }
                    this.oos.writeBoolean(bl2);
                    this.oos.writeBoolean(bl3);
                    this.oos.flush();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in rebuildFsmAndThumbCache():\n" + InsightUtilities.getStackTrace(exception));
                if (connectionKeeper != null) {
                    connectionKeeper.sendFailure();
                }
            }
            catch (Error error) {
                this.debugOut("Error in rebuildFsmAndThumbCache():\n" + InsightUtilities.getStackTrace(error));
                if (connectionKeeper == null) break block16;
                connectionKeeper.sendFailure();
            }
        }
    }

    protected void setServerFSMAndThumbCache() {
        this.debugOut("in setServerFSMAndThumbCache(). DEPRECATED");
    }

    protected void getMultipageDocument() {
        this.debugOut("in getMultipageDocument().");
        try {
            long l = this.request.getLongParam("OBJECT_ID");
            long l2 = this.request.getLongParam("MEDIA_ID");
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            ObjectKeyWrapper objectKeyWrapper = new ObjectKeyWrapper(l, l2, false, true, collectionKey);
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            MultipageDocumentSeries multipageDocumentSeries = insightBackendConnector.getMultipageDocument(objectKeyWrapper);
            this.oos.writeObject(multipageDocumentSeries);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMultipageDocument.");
        }
    }

    protected void saveMultipageDocumentSeries() {
        boolean bl = true;
        this.debugOut("in saveMultipageDocumentSeries()");
        try {
            MultipageDocumentSeries multipageDocumentSeries = (MultipageDocumentSeries)this.request.getObjectParam("MPD_SERIES");
            this.debugOut("Just read in the mpdSeries");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            bl = insightBackendConnector.saveMultipageDocumentSeries(multipageDocumentSeries);
            this.debugOut("Just returned from saveMultipageDocumentSeries");
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in saving multipage document");
        }
    }

    protected void searchMultipageDocument() {
        this.debugOut("in searchMultipageDocument()");
        try {
            String string = this.request.getStringParam("MPD_DOCUMENT_ID");
            String string2 = this.request.getStringParam("MPD_DOCUMENT_SEARCH");
            this.debugOut("Received document ID: " + string + " and search value: '" + string2 + "'");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            MpdSearchResults mpdSearchResults = insightBackendConnector.searchMultipageDocument(string, string2);
            this.oos.writeObject(mpdSearchResults);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in searchMultipageDocument():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMediaSecurityKey() {
        this.debugOut("in getMediaSecurityKey().");
        try {
            String string = null;
            string = this.serverParent.getMediaSecurityKey();
            this.oos.writeObject(string);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaSecurityKey():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMediaTicket() {
        this.debugOut("in getMediaTicket().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            String string = null;
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            int[] nArray = insightBackendConnector.getPrivs(n, n2);
            if (nArray != null && nArray.length >= 5) {
                int n3 = nArray[4];
                this.debugOut("Retrieved max resolution: " + n3);
                string = this.serverParent.getMediaSecurityTicket(n3, this.clientIP);
                this.debugOut("Registered ticket: " + string);
            } else {
                this.debugOut("Failed to get max resolution, returning ticket: " + string);
            }
            this.oos.writeObject(string);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaTicket():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void logXMLExport() {
        this.debugOut("in logXMLExport()");
        try {
            String string = this.request.getStringParam("COLLECTION_NAME");
            String string2 = this.request.getStringParam("USER_NAME");
            String string3 = this.request.getStringParam("SESSION_GROUP_NAME");
            int n = this.request.getIntegerParam("PROFILE_ID");
            long l = this.request.getLongParam("EXPORT_MEDIA_ID");
            int n2 = this.request.getIntegerParam("EXPORT_RESOLUTION");
            String string4 = this.request.getStringParam("EXPORT_IMAGE_URL");
            String string5 = this.request.getStringParam("CLIENT_LOCAL_IP");
            CollectionKey collectionKey = this.request.getCollectionKeyParam();
            if (this.serverParent.xmlExportLogFilename != null && this.serverParent.xmlExportLogFilename.length() > 0) {
                XMLExportLogger.logXMLExport(this.serverParent.xmlExportLogFilename, string, this.hostIP, this.clientIP, string5, string2, string3, collectionKey.getInstitutionID(), collectionKey.getCollectionID(), collectionKey.getVCID(), n, l, n2, string4);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in logXMLExport():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getFuzzyDateConversion() {
        this.debugOut("in getFuzzyDateConversion().");
        try {
            String string = this.request.getStringParam("FUZZY_DATE");
            FuzzyDateJulianRange fuzzyDateJulianRange = UcbFuzzyDateMachine.getFuzzyDateJulianRange(string);
            this.oos.writeObject(fuzzyDateJulianRange);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getFuzzyDateConversion():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getTopLevelNodes() {
        this.debugOut("in getTopLevelNodes().");
        try {
            String string = this.request.getStringParam("HIERARCHY_NAME");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = insightBackendConnector instanceof UcbSupportConnector ? ((UcbSupportConnector)insightBackendConnector).getTopLevelNodes(string) : (insightBackendConnector instanceof TrinityConnector ? ((TrinityConnector)insightBackendConnector).getTopLevelNodes(string) : new Vector(0));
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getTopLevelNodes():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void doTreeChildSearch() {
        this.debugOut("in doTreeChildSearch().");
        try {
            HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)this.request.getObjectParam("NODE_DATA");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = new Vector(0);
            if (insightBackendConnector instanceof UcbSupportConnector) {
                if (hierarchyNodeData instanceof UcbHierarchyNodeData) {
                    vector = ((UcbSupportConnector)insightBackendConnector).doTreeChildSearch((UcbHierarchyNodeData)hierarchyNodeData);
                }
            } else if (insightBackendConnector instanceof TrinityConnector) {
                vector = ((TrinityConnector)insightBackendConnector).doTreeChildSearch(hierarchyNodeData);
            }
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doTreeChildSearch():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getThesaurusList() {
        this.debugOut("in getThesaurusList().");
        try {
            if (this.serverParent.LEXICON_TREES) {
                UcbSupportConnector ucbSupportConnector = this.getUcbSupportConnector();
                String[] stringArray = ucbSupportConnector.getThesaurusList();
                this.oos.writeInt(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.oos.writeObject(stringArray[i]);
                }
            } else {
                this.oos.writeInt(0);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getThesaurusList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void doTermSearch() {
        this.debugOut("in doTermSearch().");
        try {
            String string = this.request.getStringParam("THESAURUS_NAME");
            String string2 = this.request.getStringParam("TERM");
            int n = this.request.getIntegerParam("START");
            int n2 = this.request.getIntegerParam("LENGTH");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = null;
            MutableInteger mutableInteger = new MutableInteger();
            if (insightBackendConnector instanceof UcbSupportConnector) {
                vector = ((UcbSupportConnector)insightBackendConnector).doTermSearch(string, string2);
            } else if (insightBackendConnector instanceof TrinityConnector) {
                vector = ((TrinityConnector)insightBackendConnector).doTermSearch(string, string2, n, n2, mutableInteger);
            }
            this.oos.writeInt(mutableInteger.getValue());
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doTermSearch():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void doTreePathSearch() {
        this.debugOut("in doTreePathSearch().");
        try {
            HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)this.request.getObjectParam("NODE_DATA");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = null;
            if (!(insightBackendConnector instanceof UcbSupportConnector) && insightBackendConnector instanceof TrinityConnector) {
                vector = ((TrinityConnector)insightBackendConnector).doTreePathSearch(hierarchyNodeData);
            }
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doTreePathSearch():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void doAncillarySearch() {
        this.debugOut("in doAncillarySearch().");
        try {
            HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)this.request.getObjectParam("NODE_DATA");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            HierarchyAncillaryData hierarchyAncillaryData = null;
            if (!(insightBackendConnector instanceof UcbSupportConnector) && insightBackendConnector instanceof TrinityConnector) {
                hierarchyAncillaryData = ((TrinityConnector)insightBackendConnector).doAncillarySearch(hierarchyNodeData);
            }
            this.oos.writeObject(hierarchyAncillaryData);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doAncillarySearch():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void addLocalNodePath() {
        this.debugOut("in addLocalNodePath().");
        try {
            String string = this.request.getStringParam("HIERARCHY_NAME");
            String string2 = this.request.getStringParam("LOCAL_VOCABULARY_ROOT_NAME");
            Field field = (Field)this.request.getObjectParam("FIELD");
            String string3 = this.request.getStringParam("TERM");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl = false;
            if (insightBackendConnector instanceof TrinityConnector) {
                bl = ((TrinityConnector)insightBackendConnector).addLocalNodePath(string, string2, field, string3);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in addLocalNodePath():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void getTermsInHierarchy() {
        this.debugOut("in getTermsInHierarchy().");
        try {
            String string = this.request.getStringParam("HIERARCHY_NAME");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = new Vector(0);
            if (insightBackendConnector instanceof TrinityConnector) {
                vector = ((TrinityConnector)insightBackendConnector).getTermsInHierarchy(string);
            }
            this.oos.writeObject(vector);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getTermsInHierarchy():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void getHierarchyNames() {
        this.debugOut("in getHierarchyNames().");
        try {
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            List list = null;
            if (insightBackendConnector instanceof TrinityConnector) {
                list = ((TrinityConnector)insightBackendConnector).getHierarchyNames();
            }
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getHierarchyNames():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void isTermInHierarchy() {
        this.debugOut("in isTermInHierarchy().");
        try {
            String string = this.request.getStringParam("HIERARCHY_NAME");
            String string2 = this.request.getStringParam("TERM");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            boolean bl = false;
            if (insightBackendConnector instanceof TrinityConnector) {
                bl = ((TrinityConnector)insightBackendConnector).isTermInHierarchy(string, string2);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isTermInHierarchy():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getJtipLevelCount() {
        this.debugOut("in getJtipLevelCount().");
        try {
            String string = this.request.getStringParam("MEDIA_ID");
            if (this.serverParent.JTIPS) {
                UcbSupportConnector ucbSupportConnector = this.getUcbSupportConnector();
                int n = ucbSupportConnector.getJtipLevelCount(string);
                this.oos.writeInt(n);
            } else {
                this.oos.writeInt(0);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getJtipLevelCount(): " + exception + ".");
        }
    }

    protected void getJtipImage() {
        this.debugOut("in getJtipImage().");
        try {
            long l = this.request.getLongParam("MEDIA_ID");
            int n = this.request.getIntegerParam("RESOLUTION");
            if (this.serverParent.JTIPS) {
                this.debugOut("Retrieving Jtip image '" + l + "' at resolution " + n + ".");
                UcbSupportConnector ucbSupportConnector = this.getUcbSupportConnector();
                InsightJtipImage insightJtipImage = ucbSupportConnector.getJtipImage(l, n);
                this.debugOut("InsightJtipImage '" + l + "' received: " + insightJtipImage);
                this.oos.writeObject(insightJtipImage);
            } else {
                this.oos.writeObject(null);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getJtipImage(): " + exception + ".");
        }
    }

    protected void getJtipImages() {
        this.debugOut("in getJtipImages().");
        try {
            long l = this.request.getLongParam("MEDIA_ID");
            if (this.serverParent.JTIPS) {
                UcbSupportConnector ucbSupportConnector = this.getUcbSupportConnector();
                Vector vector = ucbSupportConnector.getJtipImages(l);
                this.oos.writeObject(vector);
            } else {
                this.oos.writeObject(null);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getJtipImages(): " + exception + ".");
        }
    }

    protected void getJtipImageData() {
        this.debugOut("in getJtipImageData().");
        try {
            Vector vector = (Vector)this.request.getObjectParam("TILES");
            if (this.serverParent.JTIPS) {
                UcbSupportConnector ucbSupportConnector = this.getUcbSupportConnector();
                Vector vector2 = ucbSupportConnector.getJtipImageData(vector);
                Object[] objectArray = new InsightJtipTile[vector2.size()];
                vector2.copyInto(objectArray);
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null || ((InsightJtipTile)objectArray[i]).getJpegData() == null) continue;
                    n += ((InsightJtipTile)objectArray[i]).getJpegData().length;
                    ++n2;
                }
                this.oos.writeInt(n2);
                this.oos.writeInt(n);
                this.oos.flush();
                this.debugOut("Sending " + n + " bytes, for " + n2 + " tiles.");
                if (n > 0) {
                    OutputStream outputStream = this.theSocket.getOutputStream();
                    int n3 = 4096;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null || ((InsightJtipTile)objectArray[i]).getJpegData() == null) continue;
                        byte[] byArray = ((InsightJtipTile)objectArray[i]).getJpegData();
                        this.oos.writeObject(objectArray[i]);
                        this.oos.writeInt(byArray.length);
                        this.oos.flush();
                        int n4 = 0;
                        for (int j = 0; j < byArray.length; j += n4) {
                            n4 = byArray.length - j >= n3 ? n3 : byArray.length - j;
                            outputStream.write(byArray, j, n4);
                            outputStream.flush();
                        }
                    }
                }
            } else {
                this.oos.writeInt(0);
                this.oos.writeInt(0);
                this.oos.flush();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getJtipImageData(): " + exception + ".");
        }
    }

    protected void getUcbThumbnails() {
        this.debugOut("in getUcbThumbnails().");
        try {
            Serializable serializable;
            int n;
            Integer n2 = this.getRequestUniqueCollectionID();
            int n3 = this.request.getIntegerParam("GROUP_ID");
            int n4 = this.request.getIntegerParam("START");
            int n5 = this.request.getIntegerParam("LENGTH");
            FieldMapping[] fieldMappingArray = ((Vector)this.request.getObjectParam("CAPTION_FIELDS")).toArray(new FieldMapping[0]);
            FieldMapping[] fieldMappingArray2 = ((Vector)this.request.getObjectParam("SORT_FIELDS")).toArray(new FieldMapping[0]);
            boolean bl = this.request.getBooleanParam("IS_KEYWORD_SEARCH");
            Vector vector = (Vector)this.request.getObjectParam("SEARCH_CRITERIA");
            FieldCriterion[] fieldCriterionArray = new FieldCriterion[]{};
            String[] stringArray = new String[]{};
            int n6 = 0;
            if (bl) {
                if (vector != null) {
                    stringArray = vector.toArray(stringArray);
                    n6 = stringArray.length;
                }
            } else if (vector != null) {
                fieldCriterionArray = vector.toArray(fieldCriterionArray);
            }
            String[] stringArray2 = new String[fieldMappingArray.length];
            for (int i = 0; i < fieldMappingArray.length; ++i) {
                FieldMapping fieldMapping = this.serverParent.getFSM(n2).getFieldMapping(fieldMappingArray[i]);
                if (fieldMapping == null || fieldMapping.getFinalField() == null) continue;
                stringArray2[i] = fieldMapping.getFinalField().fieldName;
            }
            String[] stringArray3 = new String[fieldMappingArray2.length];
            for (n = 0; n < fieldMappingArray2.length; ++n) {
                serializable = this.serverParent.getFSM(n2).getFieldMapping(fieldMappingArray2[n]);
                if (serializable == null || ((FieldMapping)serializable).getFinalField() == null) continue;
                stringArray3[n] = ((FieldMapping)serializable).getFinalField().fieldName;
            }
            for (n = 0; n < fieldCriterionArray.length; ++n) {
                serializable = this.serverParent.getFSM(n2).getFieldMapping(fieldCriterionArray[n].fieldMapping);
                if (serializable == null) continue;
                fieldCriterionArray[n].field = ((FieldMapping)serializable).getFinalField();
            }
            UcbSupportConnector ucbSupportConnector = this.getUcbSupportConnector();
            serializable = n6 > 0 ? ucbSupportConnector.doFreeTextThumbnailQuery(n3, stringArray2, stringArray, stringArray3, n4, n5) : ucbSupportConnector.doThumbnailQuery(n3, stringArray2, fieldCriterionArray, stringArray3, n4, n5);
            int n7 = ucbSupportConnector.getTotalRecords();
            this.oos.writeInt(n7);
            int n8 = ((Vector)serializable).size();
            this.oos.writeInt(n8);
            if (n8 > 0) {
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)((Vector)serializable).elementAt(i);
                    this.oos.writeObject(insightSmartClientResults);
                }
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUcbThumbnails(): " + exception + ".");
        }
    }

    protected void isMedeEnabled() {
        this.debugOut("in isMedeEnabled().");
        try {
            this.oos.writeBoolean(this.serverParent.MEDE_ENABLED);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isMedeEnabled():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMedeCommitLevels() {
        this.debugOut("in getMedeCommitLevels().");
        try {
            Integer n = this.getRequestUniqueCollectionID();
            MedePrivileges medePrivileges = (MedePrivileges)this.request.getObjectParam("MEDE_PRIVS");
            MedeConnector medeConnector = this.serverParent.getMedeConnector();
            medePrivileges.setInvertedCommitLevel(medeConnector.getInvertedCommitApprovalLevel(n));
            medePrivileges.setSourceCommitLevel(medeConnector.getSourceCommitApprovalLevel(n));
            this.oos.writeObject(medePrivileges);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMedeCommitLevels():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMedePrivileges() {
        this.debugOut("in getMedePrivileges().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            InsightUser insightUser = (InsightUser)this.request.getObjectParam("USER");
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                n3 = medeConnector.getApprovalLevel(n, n2);
                n4 = medeConnector.getInsightUserID(insightUser);
                n5 = medeConnector.getMedePermissions(n, n2);
            }
            this.oos.writeInt(n3);
            this.oos.writeInt(n4);
            this.oos.writeInt(n5);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMedePrivileges():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityTypes() {
        this.debugOut("in getEntityTypes().");
        try {
            List list = new Vector(0);
            Integer n = this.getRequestUniqueCollectionID();
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list = medeConnector.getEntityTypes(n);
            }
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityTypes():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityTypeRelationships() {
        this.debugOut("in getEntityTypeRelationships().");
        try {
            List<EntityRelationship> list = new Vector(0);
            if (this.serverParent.MEDE_ENABLED) {
                Integer n = this.getRequestUniqueCollectionID();
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list = medeConnector.getEntityTypeRelationships(n);
                if (InsightUtilities.isEmpty(list) && InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(3, 50, 20), 8)) {
                    if (list == null) {
                        list = new Vector(1);
                    }
                    list.add(new EntityRelationship(-1000, -1001, -1, -1));
                }
            }
            this.debugOut("Sending relationships: " + list);
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityTypeRelationships():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntities() {
        this.debugOut("in getEntities().");
        try {
            List list = (List)this.request.getObjectParam("ENTITIES");
            Integer n = this.getRequestUniqueCollectionID();
            List list2 = new Vector(0);
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list2 = medeConnector.getEntities(n, list, true, false);
            }
            this.oos.writeObject(list2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntities():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntity() {
        this.debugOut("in getEntity().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            Integer n2 = this.getRequestUniqueCollectionID();
            Entity entity = null;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                entity = medeConnector.getEntity(n2, n, l);
            }
            this.oos.writeObject(entity);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityByFieldValue() {
        this.debugOut("in getEntityByFieldValue().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            int n2 = this.request.getIntegerParam("FIELD_ID");
            String string = this.request.getStringParam("VALUE");
            Integer n3 = this.getRequestUniqueCollectionID();
            Entity entity = null;
            MutableInteger mutableInteger = new MutableInteger();
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                entity = medeConnector.getEntityByFieldValue(n3, n, n2, string, mutableInteger);
            }
            this.oos.writeInt(mutableInteger.getValue());
            this.oos.writeObject(entity);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityByFieldValue():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntitiesByFieldValue() {
        this.debugOut("in getEntitiesByFieldValue().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            int n2 = this.request.getIntegerParam("FIELD_ID");
            String string = this.request.getStringParam("VALUE");
            int n3 = this.request.getIntegerParam("START");
            int n4 = this.request.getIntegerParam("LENGTH");
            Integer n5 = this.getRequestUniqueCollectionID();
            List list = null;
            MutableInteger mutableInteger = new MutableInteger();
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list = medeConnector.getEntitiesByFieldValue(n5, n, n2, string, n3, n4, mutableInteger);
            }
            this.oos.writeInt(mutableInteger.getValue());
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntitiesByFieldValue():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getReferencedEntityCount() {
        this.debugOut("in getReferencedEntityCount().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            int n2 = 0;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                n2 = medeConnector.getReferencedEntityCount(n, l);
            }
            this.debugOut("Received referenced entity count: " + n2);
            this.oos.writeInt(n2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getReferencedEntityCount():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void saveInscribeImportedMediaFiles() {
        this.debugOut("in saveInscribeImportedMediaFiles().");
        try {
            InsightBackendConnector insightBackendConnector;
            Vector vector = (Vector)this.request.getObjectParam("MEDIA_FILE_LIST");
            String string = this.request.getStringParam("VCID");
            String string2 = this.request.getStringParam("INITIAL_GROUP_OPEN");
            int n = this.request.getIntegerParam("LPS_ID");
            long l = this.request.getLongParam("MEDIA_ID");
            Integer n2 = this.getRequestUniqueCollectionID();
            MutableLong mutableLong = new MutableLong(-1L);
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED && (insightBackendConnector = this.serverParent.getBackendConnector()) instanceof TrinityConnector) {
                TrinityConnector trinityConnector = (TrinityConnector)insightBackendConnector;
                bl = trinityConnector.saveInscribeImportedMediaFiles(n2, vector, string, string2, n, l, mutableLong);
            }
            this.oos.writeBoolean(bl);
            this.oos.writeLong(mutableLong.getValue());
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveInscribeImportedMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getLpsID() {
        this.debugOut("in getLpsID().");
        try {
            InsightBackendConnector insightBackendConnector;
            String string = this.request.getStringParam("LPS_PATH");
            boolean bl = this.request.getBooleanParam("ADD_IF_NEEDED_FLAG");
            int n = -1;
            if (this.serverParent.MEDE_ENABLED && (insightBackendConnector = this.serverParent.getBackendConnector()) instanceof TrinityConnector) {
                TrinityConnector trinityConnector = (TrinityConnector)insightBackendConnector;
                n = trinityConnector.getLpsID(string, bl);
            }
            this.oos.writeInt(n);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getLpsID():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getSpsRecords() {
        this.debugOut("in getSpsRecords().");
        try {
            TrinityConnector trinityConnector;
            List list = new Vector();
            InsightBackendConnector insightBackendConnector = this.serverParent.getBackendConnector();
            if (insightBackendConnector instanceof TrinityConnector && (list = (trinityConnector = (TrinityConnector)insightBackendConnector).getSpsRecords()) == null) {
                list = new Vector();
            }
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getSpsRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void addNewSpsRecords() {
        this.debugOut("in addNewSpsRecords().");
        try {
            InsightBackendConnector insightBackendConnector;
            List list = (List)this.request.getObjectParam("SPS_RECORDS");
            int n = -1;
            if (this.serverParent.MEDE_ENABLED && (insightBackendConnector = this.serverParent.getBackendConnector()) instanceof TrinityConnector) {
                TrinityConnector trinityConnector = (TrinityConnector)insightBackendConnector;
                n = trinityConnector.addNewSpsRecords(list);
            }
            this.oos.writeInt(n);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in addNewSpsRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityLock() {
        this.debugOut("in getEntityLock().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            int n2 = this.request.getIntegerParam("USER_ID");
            EntityLock entityLock = null;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                entityLock = medeConnector.getEntityLock(n, l, n2);
            }
            this.oos.writeObject(entityLock);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityLock():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void unlockEntity() {
        this.debugOut("in unlockEntity().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            int n2 = this.request.getIntegerParam("USER_ID");
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                bl = medeConnector.unlockEntity(n, l, n2, true);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in unlockEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void saveEntity() {
        this.debugOut("in saveEntity().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MedeConnector medeConnector;
            EntityChangeList entityChangeList = (EntityChangeList)this.request.getObjectParam("ENTITY_CHANGE_LIST");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            Integer n3 = this.getRequestUniqueCollectionID();
            connectionKeeper.start();
            boolean bl = false;
            Hashtable hashtable = new Hashtable();
            if (this.serverParent.MEDE_ENABLED && (bl = (medeConnector = this.serverParent.getMedeConnector()).saveEntityChanges(n3, entityChangeList, n, n2, hashtable)) && this.serverParent.doingImmediateMedePublishing()) {
                this.serverParent.publishImmediately(n3, true);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl);
            this.oos.writeObject(hashtable);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in saveEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void saveEntityChanges() {
        this.debugOut("in saveEntityChanges().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MedeConnector medeConnector;
            List list = (List)this.request.getObjectParam("ENTITY_CHANGE_LIST");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("USER_ID");
            boolean bl = this.request.getBooleanParam("ENTITY_LOCK_FLAG");
            Integer n4 = this.getRequestUniqueCollectionID();
            connectionKeeper.start();
            boolean bl2 = false;
            if (this.serverParent.MEDE_ENABLED && (bl2 = (medeConnector = this.serverParent.getMedeConnector()).saveEntityChanges(n4, list, n, n2, n3, bl)) && this.serverParent.doingImmediateMedePublishing()) {
                this.serverParent.publishImmediately(n4, true);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in saveEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void deleteEntity() {
        this.debugOut("in deleteEntity().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MedeConnector medeConnector;
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            int n2 = this.request.getIntegerParam("USER_ID");
            int n3 = this.request.getIntegerParam("PROFILE_ID");
            int n4 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("DELETE_FLAG");
            Integer n5 = this.getRequestUniqueCollectionID();
            connectionKeeper.start();
            boolean bl2 = false;
            if (this.serverParent.MEDE_ENABLED && (bl2 = (medeConnector = this.serverParent.getMedeConnector()).deleteEntity(n5, n, l, n2, n3, n4, bl, false)) && this.serverParent.doingImmediateMedePublishing()) {
                this.serverParent.publishImmediately(n5, true);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in deleteEntity():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void importEntities() {
        this.debugOut("in importEntities().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MedeConnector medeConnector;
            connectionKeeper.start();
            int n = this.request.getIntegerParam("USER_ID");
            int n2 = this.request.getIntegerParam("PROFILE_ID");
            int n3 = this.request.getIntegerParam("USER_COLLECTION");
            Collection collection = (Collection)this.request.getObjectParam("ENTITIES");
            Integer n4 = this.getRequestUniqueCollectionID();
            boolean bl = this.request.getBooleanParam("PUBLISH_IMMEDIATELY", false);
            boolean bl2 = false;
            List list = null;
            if (this.serverParent.MEDE_ENABLED && (list = (medeConnector = this.serverParent.getMedeConnector()).importEntities(n4, n, n2, n3, collection)) != null && bl) {
                this.serverParent.publishImmediately(n4, true);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in importEntities():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityChangeUsers() {
        this.debugOut("in getEntityChangeUsers().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("CHANGE_STATUS");
            List list = (List)this.request.getObjectParam("CHANGE_CATEGORIES");
            int n4 = this.request.getIntegerParam("EDITOR_ID");
            int n5 = this.request.getIntegerParam("APPROVAL_LEVEL_MODE");
            Integer n6 = this.getRequestUniqueCollectionID();
            List list2 = new Vector(0);
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list2 = medeConnector.getEntityChangeUsers(n6, n, n2, n3, list, n4, n5);
            }
            this.oos.writeObject(list2);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityChangeUsers():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityChangeLists() {
        this.debugOut("in getEntityChangeLists().");
        ConnectionKeeper connectionKeeper = null;
        try {
            if (InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 10, 18), 7)) {
                connectionKeeper = new ConnectionKeeper(this.oos);
                connectionKeeper.start();
            }
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            int n2 = this.request.getIntegerParam("USER_ID");
            int n3 = this.request.getIntegerParam("PROFILE_ID");
            int n4 = this.request.getIntegerParam("USER_COLLECTION");
            int n5 = this.request.getIntegerParam("CHANGE_STATUS");
            List list = (List)this.request.getObjectParam("CHANGE_CATEGORIES");
            int n6 = this.request.getIntegerParam("EDITOR_ID");
            int n7 = this.request.getIntegerParam("APPROVAL_LEVEL_MODE");
            Integer n8 = this.getRequestUniqueCollectionID();
            List list2 = new Vector(0);
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list2 = medeConnector.getEntityChangeLists(n8, n, n2, n3, n4, n5, list, n6, n7);
            }
            if (connectionKeeper != null) {
                connectionKeeper.sendSuccess();
            }
            this.oos.writeObject(list2);
            this.oos.flush();
        }
        catch (Exception exception) {
            if (connectionKeeper != null) {
                connectionKeeper.sendFailure();
            }
            this.debugOut("Exception in getEntityChangeLists():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void approveEntityChanges() {
        this.debugOut("in approveEntityChanges().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MedeConnector medeConnector;
            boolean bl = this.request.getBooleanParam("APPROVE_FLAG");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            int n4 = this.request.getIntegerParam("USER_ID");
            List list = (List)this.request.getObjectParam("CHANGE_CATEGORIES");
            List list2 = (List)this.request.getObjectParam("CHANGE_IDS");
            int n5 = this.request.getIntegerParam("EDITOR_ID");
            Integer n6 = this.getRequestUniqueCollectionID();
            connectionKeeper.start();
            boolean bl2 = false;
            if (this.serverParent.MEDE_ENABLED && (bl2 = (medeConnector = this.serverParent.getMedeConnector()).approveEntityChanges(n6, bl, n, n2, n3, l, n4, list, list2, n5)) && this.serverParent.doingImmediateMedePublishing()) {
                this.serverParent.publishImmediately(n6, true);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in approveEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getApprovalExtraItems() {
        this.debugOut("in getApprovalExtraItems.");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            long l = this.request.getLongParam("ENTITY_ID");
            List list = (List)this.request.getObjectParam("CHANGE_CATEGORIES");
            Integer n = this.getRequestUniqueCollectionID();
            connectionKeeper.start();
            List list2 = null;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list2 = medeConnector.getApprovalExtraItems(n, l, list);
                connectionKeeper.sendSuccess();
                this.oos.writeObject(list2);
                this.oos.flush();
            }
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getApprovalExtraItems():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void cancelEntityChanges() {
        this.debugOut("in cancelEntityChanges().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MedeConnector medeConnector;
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            List list = (List)this.request.getObjectParam("CHANGE_IDS");
            int n4 = this.request.getIntegerParam("EDITOR_ID");
            Integer n5 = this.getRequestUniqueCollectionID();
            connectionKeeper.start();
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED && (bl = (medeConnector = this.serverParent.getMedeConnector()).cancelEntityChanges(n5, n, n2, n3, l, list, n4)) && this.serverParent.doingImmediateMedePublishing()) {
                this.serverParent.publishImmediately(n5, false);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in cancelEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void removeRejectedEntityChanges() {
        this.debugOut("in removeRejectedEntityChanges().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MedeConnector medeConnector;
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("ENTITY_TYPE_ID");
            long l = this.request.getLongParam("ENTITY_ID");
            int n4 = this.request.getIntegerParam("USER_ID");
            List list = (List)this.request.getObjectParam("CHANGE_CATEGORIES");
            List list2 = (List)this.request.getObjectParam("CHANGE_IDS");
            int n5 = this.request.getIntegerParam("EDITOR_ID");
            Integer n6 = this.getRequestUniqueCollectionID();
            connectionKeeper.start();
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED && (bl = (medeConnector = this.serverParent.getMedeConnector()).cancelRejectedEntityChanges(n6, n, n2, n3, l, n4, list, list2, n5)) && this.serverParent.doingImmediateMedePublishing()) {
                this.serverParent.publishImmediately(n6, false);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in removeRejectedEntityChanges():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityUniqueList() {
        this.debugOut("in getEntityUniqueList().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            Field field = (Field)this.request.getObjectParam("FIELD");
            int n2 = this.request.getIntegerParam("RELATIONSHIP");
            Integer n3 = this.getRequestUniqueCollectionID();
            String string = null;
            if (n2 != 0) {
                string = this.request.getStringParam("COMPARATOR");
            }
            int n4 = this.request.getIntegerParam("THRESHOLD");
            connectionKeeper.start();
            this.debugOut("Unique list, field [" + field.fieldDisplayName + ", " + field.fieldID + "], threshold: " + n4);
            CriterionValue[] criterionValueArray = null;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                criterionValueArray = medeConnector.getUniqueList(n3, n, field, n2, string, n4);
                if (criterionValueArray == null) {
                    connectionKeeper.sendSuccess();
                    this.oos.writeBoolean(false);
                } else {
                    this.debugOut("" + criterionValueArray.length + " elements found.");
                    connectionKeeper.sendSuccess();
                    this.oos.writeBoolean(true);
                    this.oos.writeInt(criterionValueArray.length);
                    for (int i = 0; i < criterionValueArray.length; ++i) {
                        this.oos.writeObject(criterionValueArray[i]);
                    }
                }
                this.oos.flush();
            } else {
                connectionKeeper.sendFailure();
            }
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getUniqueList() [Time: " + System.currentTimeMillis() + "]:\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void doEntityMerge() {
        this.debugOut("in getEntityEquivalenceSearchResults().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            Iterator iterator;
            Integer n = this.getRequestUniqueCollectionID();
            int n2 = this.request.getIntegerParam("START");
            EntityEquivalenceQuery entityEquivalenceQuery = (EntityEquivalenceQuery)this.request.getObjectParam("ENTITY_EQUIVALENCE_QUERY");
            Collection collection = (Collection)this.request.getObjectParam("ENTITY_CHANGE_LIST");
            Collection collection2 = (Collection)this.request.getObjectParam("MERGE_CHILD_ENTITIES");
            int n3 = this.request.getIntegerParam("USER_COLLECTION");
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            int n4 = this.request.getIntegerParam("PROFILE_ID");
            int n5 = this.request.getIntegerParam("USER_ID");
            EntityEquivalenceQuery entityEquivalenceQuery2 = null;
            UserGroupConnection userGroupConnection = null;
            connectionKeeper.start();
            if (entityEquivalenceQuery != null && (userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, n3 + "", null)) != null) {
                this.debugOut("Searching for ESQ in user group connection in [" + userGroupConnection.getGroupName() + ", " + userGroupConnection.getIPAddress() + "].");
                entityEquivalenceQuery2 = userGroupConnection.getThumbnailQueryCache().getEntityEquivalenceQuery();
                if (entityEquivalenceQuery2 != null && !entityEquivalenceQuery2.equals(entityEquivalenceQuery)) {
                    entityEquivalenceQuery2 = null;
                }
            }
            MedeConnector medeConnector = this.serverParent.getMedeConnector();
            Object var17_18 = null;
            ArrayList arrayList = new ArrayList(collection);
            boolean bl = false;
            if (arrayList.size() == 0) {
                bl = true;
            } else {
                iterator = arrayList.iterator();
                while (iterator.hasNext() && (bl = medeConnector.saveEntityChanges(n, ((EntityChangeList)iterator.next()).getEntityChanges(), n4, n3, n5, false))) {
                }
            }
            iterator = collection2.iterator();
            while (bl && iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                bl = bl && medeConnector.deleteEntity(n, entity.getEntityTypeID(), entity.getEntityID(), n5, n4, n3, true, true);
            }
            if (bl) {
                this.serverParent.publishImmediately(n, true);
            }
            connectionKeeper.sendSuccess();
            this.oos.writeObject(var17_18);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getEntityEquivalenceSearchResults():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityEquivalenceSearchResults() {
        this.debugOut("in getEntityEquivalenceSearchResults().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            EntityEquivalenceQuery entityEquivalenceQuery = null;
            Integer n = this.getRequestUniqueCollectionID();
            int n2 = this.request.getIntegerParam("START");
            int n3 = this.request.getIntegerParam("LENGTH");
            EntityEquivalenceQuery entityEquivalenceQuery2 = (EntityEquivalenceQuery)this.request.getObjectParam("ENTITY_EQUIVALENCE_QUERY");
            int n4 = this.request.getIntegerParam("USER_COLLECTION");
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            connectionKeeper.start();
            if (entityEquivalenceQuery2 != null) {
                List list;
                UserGroupConnection userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, n4 + "", null);
                if (userGroupConnection != null) {
                    this.debugOut("Searching for ESQ in user group connection in [" + userGroupConnection.getGroupName() + ", " + userGroupConnection.getIPAddress() + "].");
                    entityEquivalenceQuery = userGroupConnection.getThumbnailQueryCache().getEntityEquivalenceQuery();
                    if (entityEquivalenceQuery != null && !entityEquivalenceQuery.equals(entityEquivalenceQuery2)) {
                        entityEquivalenceQuery = null;
                    }
                }
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                if (entityEquivalenceQuery == null) {
                    list = medeConnector.doEntityEquivalenceSearch(n, entityEquivalenceQuery2);
                    entityEquivalenceQuery2.setResults(list);
                    if (userGroupConnection != null) {
                        userGroupConnection.getThumbnailQueryCache().setEntityEquivalenceQuery(entityEquivalenceQuery2);
                    }
                    entityEquivalenceQuery = entityEquivalenceQuery2;
                }
                if ((list = entityEquivalenceQuery.getResults(n2, n3, entityEquivalenceQuery2.getPagingSortType())) != null) {
                    medeConnector.populateEntityEquivalenceClassData(n, list);
                }
                connectionKeeper.sendSuccess();
                this.oos.writeInt(entityEquivalenceQuery.getResults().size());
                this.oos.writeObject(list);
                this.oos.flush();
            }
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getEntityEquivalenceSearchResults():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntitySearchResults() {
        this.debugOut("in getEntitySearchResults().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            EntitySearchQuery entitySearchQuery = (EntitySearchQuery)this.request.getObjectParam("ENTITY_SEARCH_QUERY");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("START");
            int n4 = this.request.getIntegerParam("LENGTH");
            boolean bl = this.request.getBooleanParam("INCLUDE_MEDIA_FILES_FLAG");
            boolean bl2 = this.request.getBooleanParam("ENTITY_IDS_ONLY_FLAG");
            boolean bl3 = this.request.getBooleanParam("EXCLUDE_SPS");
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            Integer n5 = this.getRequestUniqueCollectionID();
            this.debugOut("ProfileID: " + n + ", UserCollection: " + n2);
            this.debugOut("Start: " + n3 + ", Length: " + n4);
            connectionKeeper.start();
            if (this.serverParent.MEDE_ENABLED) {
                long l = System.currentTimeMillis();
                List list = new Vector(0);
                if (entitySearchQuery != null) {
                    Vector<EntitySearchResult> vector;
                    long l2 = System.currentTimeMillis();
                    MedeConnector medeConnector = this.serverParent.getMedeConnector();
                    EntitySearchQuery entitySearchQuery2 = null;
                    UserGroupConnection userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, n2 + "", null);
                    if (userGroupConnection != null) {
                        this.debugOut("Searching for ESQ in user group connection in [" + userGroupConnection.getGroupName() + ", " + userGroupConnection.getIPAddress() + "].");
                        entitySearchQuery2 = userGroupConnection.getThumbnailQueryCache().getEntitySearchQuery(entitySearchQuery);
                    }
                    if (entitySearchQuery2 == null) {
                        vector = medeConnector.doEntitySearch(n5, entitySearchQuery, null, bl2);
                        entitySearchQuery.setResults(vector);
                        entitySearchQuery.setResultCount(medeConnector.getTotalRecords());
                        if (userGroupConnection != null) {
                            userGroupConnection.getThumbnailQueryCache().clearEntitySearchQueries();
                            userGroupConnection.getThumbnailQueryCache().addEntitySearchQuery(entitySearchQuery);
                        }
                        entitySearchQuery2 = entitySearchQuery;
                    } else {
                        entitySearchQuery = entitySearchQuery2;
                    }
                    this.debugOut("Do entity search time: " + (System.currentTimeMillis() - l2));
                    l2 = System.currentTimeMillis();
                    if (n3 > -1 && n4 > -1) {
                        vector = entitySearchQuery.getResults();
                        list = new Vector(n4);
                        for (int i = n3; i < vector.size() && list.size() < n4; ++i) {
                            list.add(vector.get(i));
                        }
                    } else {
                        list = entitySearchQuery.getResults();
                    }
                    this.debugOut("Fetch requested page (" + n3 + ", " + n4 + ") time: " + (System.currentTimeMillis() - l2));
                    if (bl) {
                        l2 = System.currentTimeMillis();
                        vector = new Vector<EntitySearchResult>(list != null ? list.size() : 0);
                        for (int i = 0; list != null && i < list.size(); ++i) {
                            EntitySearchResult entitySearchResult = (EntitySearchResult)list.get(i);
                            if (entitySearchResult.getThumbnailFiles() != null && entitySearchResult.getThumbnailFiles().size() != 0) continue;
                            vector.add(entitySearchResult);
                        }
                        medeConnector.getEsrMediaFiles(vector, 0, n, n2, bl3);
                        this.debugOut("Get ESR media files time: " + (System.currentTimeMillis() - l2));
                    }
                }
                this.debugOut("Total entity search time: " + (System.currentTimeMillis() - l));
                connectionKeeper.sendSuccess();
                this.debugOut("Total results size: " + entitySearchQuery.getResultCount());
                this.oos.writeInt(entitySearchQuery.getResultCount());
                this.debugOut("Page count size: " + (list == null ? 0 : list.size()));
                this.oos.writeInt(list == null ? 0 : list.size());
                for (int i = 0; list != null && i < list.size(); ++i) {
                    this.oos.writeObject(list.get(i));
                }
                this.oos.flush();
            } else {
                connectionKeeper.sendFailure();
            }
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getEntitySearchResults():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getAllEntityKeys() {
        this.debugOut("in getAllEntityKeys().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            EntitySearchQuery entitySearchQuery = (EntitySearchQuery)this.request.getObjectParam("ENTITY_SEARCH_QUERY");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            boolean bl = this.request.getBooleanParam("ENTITY_IDS_ONLY_FLAG");
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            Integer n3 = this.getRequestUniqueCollectionID();
            this.debugOut("ProfileID: " + n + ", UserCollection: " + n2);
            connectionKeeper.start();
            if (this.serverParent.MEDE_ENABLED) {
                Serializable serializable;
                Object object;
                long l = System.currentTimeMillis();
                List list = new Vector(0);
                if (entitySearchQuery != null) {
                    long l2 = System.currentTimeMillis();
                    object = this.serverParent.getMedeConnector();
                    serializable = null;
                    UserGroupConnection userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, n2 + "", null);
                    if (userGroupConnection != null) {
                        this.debugOut("Searching for ESQ in user group connection in [" + userGroupConnection.getGroupName() + ", " + userGroupConnection.getIPAddress() + "].");
                        serializable = userGroupConnection.getThumbnailQueryCache().getEntitySearchQuery(entitySearchQuery);
                    }
                    if (serializable == null) {
                        List list2 = ((MedeConnector)object).doEntitySearch(n3, entitySearchQuery, null, bl);
                        entitySearchQuery.setResults(list2);
                        entitySearchQuery.setResultCount(((InsightBackendConnector)object).getTotalRecords());
                        if (userGroupConnection != null) {
                            userGroupConnection.getThumbnailQueryCache().clearEntitySearchQueries();
                            userGroupConnection.getThumbnailQueryCache().addEntitySearchQuery(entitySearchQuery);
                        }
                        serializable = entitySearchQuery;
                    } else {
                        entitySearchQuery = serializable;
                    }
                    this.debugOut("Do entity search time: " + (System.currentTimeMillis() - l2));
                    l2 = System.currentTimeMillis();
                    list = entitySearchQuery.getResults();
                }
                this.debugOut("Total entity search time: " + (System.currentTimeMillis() - l));
                connectionKeeper.sendSuccess();
                this.debugOut("Total results size: " + entitySearchQuery.getResultCount());
                this.oos.writeInt(entitySearchQuery.getResultCount());
                Vector vector = new Vector();
                this.debugOut("start packing up keys");
                for (int i = 0; list != null && i < list.size(); ++i) {
                    object = (EntitySearchResult)list.get(i);
                    serializable = new EntityKeyWrapper(((EntitySearchResult)object).getEntityTypeID(), ((EntitySearchResult)object).getEntityID());
                    this.oos.writeObject(serializable);
                }
                this.oos.flush();
            } else {
                connectionKeeper.sendFailure();
            }
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getAllEntityKeys():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntitySearchResult() {
        this.debugOut("in getEntitySearchResult().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            EntityKey entityKey = (EntityKey)this.request.getObjectParam("ENTITY_KEY");
            EntitySearchQuery entitySearchQuery = (EntitySearchQuery)this.request.getObjectParam("ENTITY_SEARCH_QUERY");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("CLIENT_LOCAL_IP");
            String string4 = this.request.getStringParam("USER_NAME");
            Integer n3 = this.getRequestUniqueCollectionID();
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            EntitySearchResult entitySearchResult = null;
            this.debugOut("Get: EntityTypeID: " + entityKey.getEntityTypeID() + ", EntityID: " + entityKey.getEntityID() + ", ProfileID: " + n + ", UserCollection: " + n2);
            connectionKeeper.start();
            if (this.serverParent.MEDE_ENABLED) {
                long l = System.currentTimeMillis();
                if (entitySearchQuery != null) {
                    Vector<EntitySearchResult> vector;
                    long l2 = System.currentTimeMillis();
                    MedeConnector medeConnector = this.serverParent.getMedeConnector();
                    EntitySearchQuery entitySearchQuery2 = null;
                    UserGroupConnection userGroupConnection = this.serverParent.getUserGroupConnection(string, string2, this.clientIP, string3, false, this.hostIP, string4, null, n2 + "", null);
                    if (userGroupConnection != null) {
                        this.debugOut("Searching for ESQ in user group connection in [" + userGroupConnection.getGroupName() + ", " + userGroupConnection.getIPAddress() + "].");
                        entitySearchQuery2 = userGroupConnection.getThumbnailQueryCache().getEntitySearchQuery(entitySearchQuery);
                    }
                    if (entitySearchQuery2 != null) {
                        entitySearchQuery = entitySearchQuery2;
                        ((EntityKeyWrapper)entityKey).setIgnoreCollectionKey(true);
                        int n4 = ((Vector)entitySearchQuery.getResults()).indexOf(entityKey);
                        if (n4 > -1) {
                            entitySearchResult = (EntitySearchResult)((Vector)entitySearchQuery.getResults()).get(n4);
                            this.debugOut("Found the ESR in the cache.");
                            if (entitySearchResult.getThumbnailFiles() == null || entitySearchResult.getThumbnailFiles().size() == 0) {
                                this.debugOut("No thumbnails defined for the ESR.");
                                vector = new Vector<EntitySearchResult>(1);
                                vector.add(entitySearchResult);
                                medeConnector.getEsrMediaFiles(vector, 0, n, n2, bl);
                                this.debugOut("Get ESR media files time: " + (System.currentTimeMillis() - l2));
                            }
                        }
                    }
                    if (entitySearchResult == null) {
                        this.debugOut("ESR not found, reconstructing.");
                        Vector<EntityKey> vector2 = new Vector<EntityKey>(1);
                        vector2.add(entityKey);
                        vector = medeConnector.getEntitySearchResults(n3, entitySearchQuery, n, n2, -1, -1, vector2, true, false, bl);
                        if (vector != null && vector.size() > 0) {
                            entitySearchResult = (EntitySearchResult)((Vector)vector).firstElement();
                        }
                    }
                    this.debugOut("Do entity search time: " + (System.currentTimeMillis() - l2));
                    l2 = System.currentTimeMillis();
                }
                this.debugOut("Total entity search time: " + (System.currentTimeMillis() - l));
                connectionKeeper.sendSuccess();
                this.oos.writeObject(entitySearchResult);
                this.oos.flush();
            } else {
                connectionKeeper.sendFailure();
            }
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getEntitySearchResult():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMediaSearchResults() {
        this.debugOut("in getMediaSearchResults().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            MediaSearchQuery mediaSearchQuery = (MediaSearchQuery)this.request.getObjectParam("MEDIA_SEARCH_QUERY");
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            int n3 = this.request.getIntegerParam("START");
            int n4 = this.request.getIntegerParam("LENGTH");
            EntitySearchQuery entitySearchQuery = (EntitySearchQuery)this.request.getObjectParam("ENTITY_SEARCH_QUERY");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            Integer n5 = this.getRequestUniqueCollectionID();
            this.debugOut("ProfileID: " + n + ", UserCollection: " + n2);
            this.debugOut("Start: " + n3 + ", Length: " + n4);
            connectionKeeper.start();
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                long l = System.currentTimeMillis();
                List list = medeConnector.getMediaSearchResults(n5, mediaSearchQuery, n, n2, n3, n4, entitySearchQuery, bl);
                this.debugOut("Total media search time: " + (System.currentTimeMillis() - l));
                connectionKeeper.sendSuccess();
                this.debugOut("Total results size: " + medeConnector.getTotalRecords());
                this.oos.writeInt(medeConnector.getTotalRecords());
                this.debugOut("Page count size: " + (list == null ? 0 : list.size()));
                this.oos.writeInt(list == null ? 0 : list.size());
                for (int i = 0; list != null && i < list.size(); ++i) {
                    this.oos.writeObject(list.get(i));
                }
                this.oos.flush();
            } else {
                connectionKeeper.sendFailure();
            }
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in getMediaSearchResults():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void isValueInValueList() {
        this.debugOut("in isValueInValueList().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            int n2 = this.request.getIntegerParam("FIELD_ID");
            String string = this.request.getStringParam("VALUE");
            Integer n3 = this.getRequestUniqueCollectionID();
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                bl = medeConnector.isValueInValueList(n3, string, n2, n);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isValueInValueList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getEntityTypeFields() {
        this.debugOut("in getEntityTypeFields().");
        try {
            int n = this.request.getIntegerParam("ENTITY_TYPE_ID");
            List list = new Vector();
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list = medeConnector.getEntityTypeFields(n);
            }
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getEntityTypeFields():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getKeysOfDuplicateEntities() {
        this.debugOut("in getKeysOfDuplicateEntities().");
        try {
            Entity entity = (Entity)this.request.getObjectParam("ENTITY");
            Integer n = this.getRequestUniqueCollectionID();
            long l = System.currentTimeMillis();
            List list = new Vector(0);
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list = medeConnector.getKeysOfDuplicateEntities(n, entity);
            }
            this.debugOut("Get duplicate entity keys time: " + (System.currentTimeMillis() - l));
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getKeysOfDuplicateEntities():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void isCatalogTemplateNameUnique() {
        this.debugOut("in isCatalogTemplateNameUnique()");
        try {
            Set set = null;
            boolean bl = true;
            if (this.serverParent.MEDE_ENABLED) {
                set = this.serverParent.getMedeConnector().getCatalogTemplates();
                if (set != null) {
                    String string = this.request.getStringParam("CATALOG_TEMPLATE_NAME");
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        BaseTemplate baseTemplate = (BaseTemplate)iterator.next();
                        if (!baseTemplate.getTemplateName().equals(string)) continue;
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isCatalogTemplateNameUnique():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getCatalogTemplates() {
        this.debugOut("in getCatalogTemplates()");
        try {
            Set set = null;
            if (this.serverParent.MEDE_ENABLED) {
                set = this.serverParent.getMedeConnector().getCatalogTemplates();
            }
            this.oos.writeObject(set);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCatalogTemplates():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCatalogTemplate() {
        this.debugOut("in saveCatalogTemplate()");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            connectionKeeper.start();
            BaseTemplate baseTemplate = (BaseTemplate)this.request.getObjectParam("CATALOG_TEMPLATE");
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED) {
                Object object = FieldStandardsManager.FIELD_POOL_LOCK;
                synchronized (object) {
                    final MedeConnector medeConnector = this.serverParent.getMedeConnector();
                    bl = medeConnector.saveCatalogTemplate(baseTemplate);
                    baseTemplate = medeConnector.getCatalogTemplate(baseTemplate.getTemplateID());
                    Runnable runnable = new Runnable(){

                        public void run() {
                            FieldStandardsManager.setFieldPoolUpToDate(false);
                            MedeConnector.rebuildFieldPool(medeConnector);
                        }
                    };
                    runnable.run();
                }
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl);
            this.oos.writeObject(baseTemplate);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in saveCatalogTemplate():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCatalogTemplate() {
        this.debugOut("in updateCatalogTemplate()");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            connectionKeeper.start();
            BaseTemplate baseTemplate = (BaseTemplate)this.request.getObjectParam("CATALOG_TEMPLATE");
            BaseTemplate baseTemplate2 = (BaseTemplate)this.request.getObjectParam("CATALOG_TEMPLATE_ORIG");
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED) {
                Object object = FieldStandardsManager.FIELD_POOL_LOCK;
                synchronized (object) {
                    final MedeConnector medeConnector = this.serverParent.getMedeConnector();
                    bl = medeConnector.updateCatalogTemplate(baseTemplate, baseTemplate2);
                    baseTemplate = medeConnector.getCatalogTemplate(baseTemplate.getTemplateID());
                    Runnable runnable = new Runnable(){

                        public void run() {
                            FieldStandardsManager.setFieldPoolUpToDate(false);
                            MedeConnector.rebuildFieldPool(medeConnector);
                        }
                    };
                    runnable.run();
                }
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl);
            this.oos.writeObject(baseTemplate);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in updateCatalogTemplate():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCatalogTemplate() {
        this.debugOut("in deleteCatalogTemplate().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            connectionKeeper.start();
            BaseTemplate baseTemplate = (BaseTemplate)this.request.getObjectParam("CATALOG_TEMPLATE");
            boolean bl = false;
            if (this.serverParent.MEDE_ENABLED) {
                Object object = FieldStandardsManager.FIELD_POOL_LOCK;
                synchronized (object) {
                    final MedeConnector medeConnector = this.serverParent.getMedeConnector();
                    bl = medeConnector.deleteCatalogTemplate(baseTemplate);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            FieldStandardsManager.setFieldPoolUpToDate(false);
                            MedeConnector.rebuildFieldPool(medeConnector);
                        }
                    };
                    runnable.run();
                }
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("exception in openClientSideGroup().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getStandardNames() {
        this.debugOut("in getStandardNames()");
        try {
            Set set = null;
            Object object = FieldStandardsManager.FIELD_POOL_LOCK;
            synchronized (object) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                set = medeConnector.getAllStandardNames();
            }
            this.oos.writeObject(set);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getStandardNames():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getDependentCollections() {
        this.debugOut("in getDependentCollections()");
        try {
            int n = this.request.getIntegerParam("CATALOG_TEMPLATE_ID");
            List list = new Vector();
            if (this.serverParent.MEDE_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                list = medeConnector.getDependentCollections(n);
            }
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getDependentCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getCollectionBuildingTemplate() {
        this.debugOut("in getCollectionBuildingTemplate");
        CollectionBuildingTemplate collectionBuildingTemplate = this.serverParent.getCollectionBuildingTemplate();
        try {
            this.oos.writeObject(collectionBuildingTemplate);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionBuildingTemplate():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCollectionBuildingObject() {
        this.debugOut("in saveCollectionBuildingObject().");
        ConnectionKeeper connectionKeeper = new ConnectionKeeper(this.oos);
        try {
            connectionKeeper.start();
            CollectionBuildingObject collectionBuildingObject = (CollectionBuildingObject)this.request.getObjectParam("PERSONAL_COLLECTION");
            boolean bl = collectionBuildingObject.isTemporary();
            boolean bl2 = collectionBuildingObject.getCollectionType().equals(CollectionBuildingObject.VIRTUAL_TYPE);
            boolean bl3 = false;
            if (!collectionBuildingObject.isPersonalCollection() || this.serverParent.PERSONAL_COLLECTIONS_ENABLED) {
                MedeConnector medeConnector = this.serverParent.getMedeConnector();
                if (collectionBuildingObject != null && collectionBuildingObject.getTCI() != null) {
                    boolean bl4 = true;
                    Class<?> clazz = collectionBuildingObject.getClass();
                    synchronized (clazz) {
                        if (bl || collectionBuildingObject.isCollectionNameModified()) {
                            if (collectionBuildingObject.getCollectionType().equals(CollectionBuildingObject.MASTER_TYPE)) {
                                bl4 = !medeConnector.isCollectionNameInUse(collectionBuildingObject.getCollectionName()) && !medeConnector.getAllStandardNames().contains(collectionBuildingObject.getCollectionName());
                            } else {
                                boolean bl5 = bl4 = !medeConnector.isCollectionNameInUse(collectionBuildingObject.getCollectionName());
                            }
                        }
                        if (bl4) {
                            int n = -1;
                            UserGroup userGroup = this.serverParent.getUserGroup(collectionBuildingObject.getTCI().getPcOwnerSessionGroupName(), collectionBuildingObject.getTCI().getPcOwnerSessionCodeKey());
                            if (userGroup != null) {
                                n = userGroup.getGroupID();
                            }
                            bl3 = medeConnector.saveCollectionBuildingObject(collectionBuildingObject, this.serverParent.getThemeFileManager(), n);
                        }
                    }
                    if (bl3 && !bl2 && (bl || collectionBuildingObject.isFieldStandardModified() || collectionBuildingObject.isMappingStandardsModified())) {
                        this.serverParent.updateUniqueCollection(collectionBuildingObject.getUniqueCollectionID());
                    }
                }
            }
            connectionKeeper.sendSuccess();
            this.oos.writeBoolean(bl3);
            this.oos.writeObject(collectionBuildingObject.getCollectionID());
            this.oos.writeObject(collectionBuildingObject.getUniqueCollectionID());
            if (!collectionBuildingObject.isPersonalCollection()) {
                this.oos.writeObject(collectionBuildingObject.getCollectionUserGroupName());
                this.oos.writeObject(collectionBuildingObject.getCollectionUserGroupCodeKey());
                if (bl2) {
                    this.oos.writeObject(collectionBuildingObject.getVCID());
                }
                if (bl) {
                    this.serverParent.updateUserGroupsAndPools(true);
                }
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            connectionKeeper.sendFailure();
            this.debugOut("Exception in saveCollectionBuildingObject():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void isLicensedPersonalCollectionServer() {
        this.debugOut("in isLicensedPersonalCollectionServer().");
        try {
            boolean bl = false;
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            if (this.serverParent.LICENSED_PERSONAL_COLLECTION_MANAGER) {
                this.oos.writeBoolean(true);
            } else {
                this.oos.writeBoolean(false);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isLicensedPersonalCollectionServer():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void canCreatePersonalCollections() {
        this.debugOut("in canEditPersonalCollections().");
        try {
            Object object;
            Object object2;
            boolean bl = false;
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            String string3 = this.request.getStringParam("INSIGHT_USER");
            if (this.serverParent.LICENSED_PERSONAL_COLLECTION_MANAGER && (object2 = this.serverParent.getBackendConnector()) instanceof TrinityConnector) {
                object = (TrinityConnector)object2;
                UserGroup userGroup = this.serverParent.getUserGroup(string, string2);
                if (userGroup != null) {
                    bl = ((TrinityConnector)object).canCreatePersonalCollections(userGroup);
                }
            }
            if (this.serverParent.LICENSED_NAMED_USER_MODE && bl) {
                object2 = this.serverParent.getInsightLicenseManager();
                object = ((InsightLicenseManager)object2).getLicenseNamedUserList();
                bl = ((InsightLicenseNamedUsers)object).isLicensedPCNamedUser(string3);
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPersonalCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getPersonalCollections() {
        this.debugOut("in getPersonalCollections().");
        try {
            InsightBackendConnector insightBackendConnector;
            InsightUser insightUser = (InsightUser)this.request.getObjectParam("INSIGHT_USER");
            String string = this.request.getStringParam("SESSION_GROUP_NAME");
            String string2 = this.request.getStringParam("SESSION_GROUP_CODE_KEY");
            List list = null;
            if (this.serverParent.PERSONAL_COLLECTIONS_ENABLED && (insightBackendConnector = this.serverParent.getBackendConnector()) instanceof TrinityConnector) {
                TrinityConnector trinityConnector = (TrinityConnector)insightBackendConnector;
                int n = -1;
                UserGroup userGroup = this.serverParent.getUserGroup(string, string2);
                if (userGroup != null) {
                    n = userGroup.getGroupID();
                }
                list = trinityConnector.getPersonalCollections(this.serverParent.getInsightLicenseManager().getLicenseNamedUserList(), insightUser, n);
            }
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getPersonalCollections():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void publishMediaFiles(boolean bl) {
        this.debugOut(" in publishMediaFiles()");
        ConnectionKeeper connectionKeeper = null;
        try {
            List list;
            TrinityConnector trinityConnector;
            int n;
            boolean bl2 = false;
            List list2 = (List)this.request.getObjectParam("MEDIA_IDS");
            String string = this.request.getStringParam("GROUP_NAME");
            String string2 = this.request.getStringParam("VCID");
            final Integer n2 = this.getRequestUniqueCollectionID();
            if (this.request.getBooleanParam("WAIT_FOR_SERVER")) {
                connectionKeeper = new ConnectionKeeper(this.oos);
                connectionKeeper.start();
            }
            if ((n = (trinityConnector = (TrinityConnector)this.getBackendConnector()).getGroupID(n2, string, string2)) != -4 && n != -3 && (list = trinityConnector.publishMediaFiles(n2, n, list2, bl)) != null) {
                bl2 = true;
                if (list.size() > 0) {
                    this.serverParent.clearEntityCaches();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            InsightSmartServicer.this.serverParent.updateServerThumbnailCaches(n2, list);
                        }
                    };
                    new Thread(runnable).start();
                }
            }
            if (connectionKeeper != null) {
                connectionKeeper.sendSuccess();
            }
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            if (connectionKeeper != null) {
                connectionKeeper.sendFailure();
            }
            this.debugOut("Exception in publishMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void importMediaFiles() {
        this.debugOut("in savePersonalCollectionMediaFiles().");
        try {
            List list = (List)this.request.getObjectParam("MEDIA_FILE_LIST");
            String string = this.request.getStringParam("VCID");
            String string2 = this.request.getStringParam("INITIAL_GROUP_OPEN");
            Integer n = this.getRequestUniqueCollectionID();
            Entity entity = (Entity)this.request.getObjectParam("ENTITY");
            int n2 = this.request.getIntegerParam("LPS_ID");
            long l = -1L;
            ImportMediaResult importMediaResult = null;
            boolean bl = false;
            InsightBackendConnector insightBackendConnector = this.serverParent.getBackendConnector();
            if (insightBackendConnector instanceof TrinityConnector) {
                bl = InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 10, 12), 8);
                int n3 = ((TrinityConnector)insightBackendConnector).getCollectionMediaCount();
                if (this.serverParent.MAX_COLLECTION_MEDIA_COUNT_SOFT > 0 && n3 >= this.serverParent.MAX_COLLECTION_MEDIA_COUNT_SOFT) {
                    if (!bl) {
                        importMediaResult = new ImportMediaResult(3);
                    }
                } else {
                    boolean bl2 = this.serverParent.shouldWarnAboutMediaCount(n3);
                    if (this.serverParent.PERSONAL_COLLECTIONS_ENABLED && entity != null) {
                        l = ((TrinityConnector)insightBackendConnector).savePersonalCollectionMediaFiles(n, list, string, string2, entity, n2);
                    } else if (entity == null) {
                        l = ((TrinityConnector)insightBackendConnector).importMediaFiles(n, list, n2);
                    }
                    if (!bl) {
                        importMediaResult = new ImportMediaResult(l, bl2 ? 2 : 0);
                    }
                }
            }
            if (bl) {
                this.oos.writeLong(l);
            } else {
                this.oos.writeObject(importMediaResult);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in savePersonalCollectionMediaFiles():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void saveObjectDataRecord() {
        this.debugOut("in saveObjectDataRecord().");
        try {
            TrinityConnector trinityConnector;
            InsightBackendConnector insightBackendConnector;
            Integer n = this.getRequestUniqueCollectionID();
            ObjectDataRecord objectDataRecord = (ObjectDataRecord)this.request.getObjectParam("OBJECT_DATA_RECORD");
            boolean bl = false;
            long l = objectDataRecord.getObjectID();
            if (this.serverParent.PERSONAL_COLLECTIONS_ENABLED && (insightBackendConnector = this.serverParent.getBackendConnector()) instanceof TrinityConnector && (bl = (trinityConnector = (TrinityConnector)insightBackendConnector).saveObjectDataRecord(n, objectDataRecord, this.serverParent.getFSM(n)))) {
                l = objectDataRecord.getObjectID();
            }
            this.oos.writeBoolean(bl);
            this.oos.writeLong(l);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveObjectDataRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void saveCollectionUserGroupKey() {
        this.debugOut("in saveCollectionUserGroupKey().");
        try {
            CollectionUserGroupKey collectionUserGroupKey = (CollectionUserGroupKey)this.request.getObjectParam("COLLECTION_USER_GROUP_KEY");
            TrinityConnector trinityConnector = (TrinityConnector)this.serverParent.getBackendConnector();
            int n = trinityConnector.saveCollectionUserGroupKey(collectionUserGroupKey);
            if (n == 0) {
                this.oos.writeObject(collectionUserGroupKey);
            } else {
                this.oos.writeObject(null);
                this.oos.writeInt(n);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveCollectionUserGroupKey():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getCollectionProfileKeyList() {
        this.debugOut("in getCollectionProfileKeyList().");
        try {
            int n = this.request.getIntegerParam("USER_COLLECTION");
            TrinityConnector trinityConnector = (TrinityConnector)this.serverParent.getBackendConnector();
            this.oos.writeObject(trinityConnector.getCollectionProfileKeyList(n));
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionProfileKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getCollectionUserGroupKeyList() {
        this.debugOut("in getCollectionProfileKeyList().");
        try {
            Integer n = this.getRequestUniqueCollectionID();
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            TrinityConnector trinityConnector = (TrinityConnector)this.serverParent.getBackendConnector();
            this.oos.writeObject(trinityConnector.getCollectionUserGroupKeyList(n, n2));
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionUserGroupKeyList():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCollection() {
        this.debugOut("in deleteCollection().");
        ConnectionKeeper connectionKeeper = null;
        boolean bl = InsightVersion.compareVersions(this.request.getVersion(), new InsightVersion(5, 10, 15), 7);
        try {
            boolean bl2;
            block9: {
                TrinityConnector trinityConnector;
                CollectionKey collectionKey;
                Integer n;
                block10: {
                    InsightBackendConnector insightBackendConnector;
                    n = this.getRequestUniqueCollectionID();
                    collectionKey = this.request.getCollectionKeyParam();
                    bl2 = false;
                    if (bl) {
                        connectionKeeper = new ConnectionKeeper(this.oos);
                        connectionKeeper.start();
                    }
                    if (!((insightBackendConnector = this.serverParent.getBackendConnector()) instanceof TrinityConnector)) break block9;
                    trinityConnector = (TrinityConnector)insightBackendConnector;
                    if (collectionKey != null && !collectionKey.getVCID().equals("NA")) break block10;
                    bl2 = trinityConnector.deleteCollection(n);
                    TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.request.getObjectParam("COLLECTION_INFO");
                    if (trinityCollectionInfo == null) break block9;
                    MedeSmartClient medeSmartClient = this.getMedeSmartClient(trinityCollectionInfo);
                    try {
                        medeSmartClient.deleteCollectionMedia(trinityCollectionInfo);
                        Object var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        if (medeSmartClient != null && medeSmartClient.isConnectionGood(trinityCollectionInfo)) {
                            medeSmartClient.closeConnections();
                        }
                        throw throwable;
                    }
                    if (medeSmartClient != null && medeSmartClient.isConnectionGood(trinityCollectionInfo)) {
                        medeSmartClient.closeConnections();
                    }
                    break block9;
                }
                bl2 = trinityConnector.deleteVirtualCollection(n, collectionKey);
            }
            if (bl) {
                connectionKeeper.sendSuccess();
            }
            this.oos.writeBoolean(bl2);
            this.oos.flush();
        }
        catch (Exception exception) {
            if (bl && connectionKeeper != null) {
                connectionKeeper.sendFailure();
            }
            this.debugOut("Exception in deletePersonalCollection():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public MedeSmartClient getMedeSmartClient(TrinityCollectionInfo trinityCollectionInfo) {
        MedeSmartClient medeSmartClient = new MedeSmartClient(trinityCollectionInfo);
        if (medeSmartClient != null && medeSmartClient.areConnectionsGood()) {
            return medeSmartClient;
        }
        return null;
    }

    protected void getMediaSecurityServletBaseUrl() {
        this.debugOut("in getMediaSecurityServletBaseUrl().");
        try {
            String string = null;
            string = this.serverParent.getMediaSecurityServletBaseUrl();
            this.oos.writeObject(string);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaSecurityServletBaseUrl():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void authenticateStudioUser() {
        this.debugOut("in authenticateStudioUser");
        try {
            String string = this.request.getStringParam("USER_NAME");
            boolean bl = ((TrinityConnector)this.getBackendConnector()).authenticateStudioUser(string);
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in authenticateStudioUser():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getCollectionServerPrivs() {
        this.debugOut("in getCollectionServerPrivs");
        try {
            String string = this.request.getStringParam("USER_NAME");
            int n = ((TrinityConnector)this.getBackendConnector()).getCollectionServerPrivs(string);
            this.oos.writeInt(n);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionServerPrivs():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMediaBatches() {
        this.debugOut("in getMediaBatches()");
        try {
            List list = new ArrayList();
            Integer n = this.getRequestUniqueCollectionID();
            list = ((TrinityConnector)this.getBackendConnector()).getMediaBatches(n);
            this.oos.writeObject(list);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaBatches():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void getMediaBatchElements() {
        this.debugOut("in getMediaBatchElements()");
        try {
            int n = this.request.getIntegerParam("MEDIA_BATCH_ID");
            this.oos.writeObject(((TrinityConnector)this.getBackendConnector()).getMediaBatchElements(n));
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMediaBatchElements():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void deleteMediaBatch() {
        this.debugOut("in deleteMediaBatch()");
        try {
            int n = this.request.getIntegerParam("MEDIA_BATCH_ID");
            final Integer n2 = this.getRequestUniqueCollectionID();
            final HashSet hashSet = new HashSet();
            boolean bl = ((TrinityConnector)this.getBackendConnector()).deleteMediaBatch(n, hashSet);
            if (bl && hashSet.size() > 0) {
                this.serverParent.clearEntityCaches();
                Runnable runnable = new Runnable(){

                    public void run() {
                        InsightSmartServicer.this.serverParent.updateServerThumbnailCaches(n2, new ArrayList(hashSet));
                    }
                };
                new Thread(runnable).start();
            }
            this.oos.writeBoolean(bl);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteMediaBatch():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    protected void deleteMediaRecords() {
        this.debugOut("in deleteMediaRecords");
        ConnectionKeeper connectionKeeper = null;
        try {
            Set set = (Set)this.request.getObjectParam("MEDIA_IDS");
            final Integer n = this.getRequestUniqueCollectionID();
            connectionKeeper = new ConnectionKeeper(this.oos);
            connectionKeeper.start();
            TrinityConnector trinityConnector = (TrinityConnector)this.getBackendConnector();
            final Set set2 = trinityConnector.getLongIDSet(null, "IRENTITYMEDIAMAP", "EntityID", "MediaID", set);
            ((TrinityConnector)this.getBackendConnector()).deleteMediaRecords(set);
            if (set2 != null && set2.size() > 0) {
                this.serverParent.clearEntityCaches();
                Runnable runnable = new Runnable(){

                    public void run() {
                        InsightSmartServicer.this.serverParent.updateServerThumbnailCaches(n, new ArrayList(set2));
                    }
                };
                new Thread(runnable).start();
            }
            connectionKeeper.sendSuccess();
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in deleteMediaRecords");
            connectionKeeper.sendFailure();
        }
    }

    protected void saveMediaBatch() {
        this.debugOut("in saveMediaBatch()");
        ConnectionKeeper connectionKeeper = null;
        try {
            List list;
            final IMediaBatch iMediaBatch = (IMediaBatch)this.request.getObjectParam("MEDIA_BATCH");
            if (this.request.getBooleanParam("WAIT_FOR_SERVER")) {
                connectionKeeper = new ConnectionKeeper(this.oos);
                connectionKeeper.start();
            }
            if ((list = ((TrinityConnector)this.getBackendConnector()).saveMediaBatch(iMediaBatch)) != null) {
                if (list.size() > 0) {
                    this.serverParent.clearEntityCaches();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            InsightSmartServicer.this.serverParent.updateServerThumbnailCaches(iMediaBatch.getUniqueCollectionID(), list);
                        }
                    };
                    new Thread(runnable).start();
                }
                if (connectionKeeper != null) {
                    connectionKeeper.sendSuccess();
                }
                this.oos.writeObject(iMediaBatch);
            } else {
                if (connectionKeeper != null) {
                    connectionKeeper.sendSuccess();
                }
                this.oos.writeObject(null);
            }
            this.oos.flush();
        }
        catch (Exception exception) {
            if (connectionKeeper != null) {
                connectionKeeper.sendFailure();
            }
            this.debugOut("Exception in saveMediaBatch():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    Integer getRequestUniqueCollectionID() {
        return this.getRequestUniqueCollectionID(true);
    }

    protected Integer getRequestUniqueCollectionID(boolean bl) {
        Integer n = new Integer(this.request.getIntegerParam("UNIQUE_COLLECTION_ID"));
        if (n == 0) {
            if (bl) {
                String string;
                String string2 = this.request.getStringParam("SESSION_GROUP_NAME");
                UserGroup userGroup = this.serverParent.getUserGroup(string2, string = this.request.getStringParam("SESSION_GROUP_CODE_KEY"));
                if (userGroup == null) {
                    this.debugOut("No UserGroup for '" + string2 + "', code key '" + string + "'.'");
                    return null;
                }
                return userGroup.getUniqueCollectionID();
            }
            return null;
        }
        return n;
    }

    protected void startTermProcessing() {
        this.debugOut("in startTermProcessing().");
        MedeTermProcessor.startTermProcessing();
    }

    protected void getMediaURL() {
        this.debugOut("in getMediaURL().");
        try {
            int n = this.request.getIntegerParam("PROFILE_ID");
            int n2 = this.request.getIntegerParam("USER_COLLECTION");
            long l = this.request.getLongParam("MEDIA_ID");
            int n3 = this.request.getIntegerParam("RESOLUTION");
            String string = this.request.getStringParam("INSTITUTION_ID", "UNAVAILABLE");
            String string2 = this.request.getStringParam("VCID", "UNAVAILABLE");
            boolean bl = this.request.getBooleanParam("EXCLUDE_SPS");
            if (bl) {
                n = -1;
                n2 = -1;
            }
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Object[] objectArray = insightBackendConnector.getMediaURL(l, n, n2, n3);
            int n4 = -1;
            if (objectArray != null && objectArray[2] != null) {
                try {
                    Integer n5 = (Integer)objectArray[2];
                    n4 = n5;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (objectArray[0] != null) {
                objectArray[0] = InsightSmartServer.addExtendedURLParams(this.request, n4, (String)objectArray[0], n, n2, string, string2);
            }
            this.debugOut("Source URL: " + objectArray[0]);
            this.debugOut("Source File Name: " + objectArray[1]);
            this.debugOut("Resolution Size: " + objectArray[2]);
            this.oos.writeObject(objectArray[0]);
            this.oos.writeObject(objectArray[1]);
            this.oos.writeObject(objectArray[2]);
            this.oos.flush();
        }
        catch (Exception exception) {
            this.debugOut("exception in getURLsWithType(): " + exception);
        }
    }
}

