/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ObjectKey;
import com.luna.insight.server.ObjectKeyComparer;
import com.luna.insight.server.ThumbnailTallyMark;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Locale;

public class InsightSmartClientResults
implements Serializable,
Comparable,
ObjectKey,
Cloneable {
    static final long serialVersionUID = 6006324459166310976L;
    public static final int MAXIMUM_THUMBNAIL_FIELD_LENGTH = 25;
    protected static final int[][] MVI_MPD_ORDER = new int[][]{{0, -1, -1, -1}, {1, 0, 1, 1}, {1, -1, 0, -1}, {1, -1, 1, 0}};
    public String institutionID;
    public String collectionID;
    public String vcID;
    public long imageID = -1L;
    public long objectID;
    public int mediaType = 1;
    public boolean hasMviSeries = false;
    public boolean hasMpdSeries = false;
    public int absoluteOrder;
    public String[] fieldData;
    public String thumbnailURL;
    public transient byte[] thumbImageData = null;
    public Dimension thumbDimension;
    public String sortString = null;
    public Locale iscrLocale = Locale.getDefault();
    public transient String[] sortData = null;

    public static void debugOut(String string) {
        Debug.debugOut("ISCR: " + string);
    }

    public static int getMviMpdOrder(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        int n2 = 0;
        if (!bl && !bl2) {
            n = 0;
        } else if (!bl && bl2) {
            n = 1;
        } else if (bl && !bl2) {
            n = 2;
        } else if (bl && bl2) {
            n = 3;
        }
        if (!bl3 && !bl4) {
            n2 = 0;
        } else if (!bl3 && bl4) {
            n2 = 1;
        } else if (bl3 && !bl4) {
            n2 = 2;
        } else if (bl3 && bl4) {
            n2 = 3;
        }
        return MVI_MPD_ORDER[n][n2];
    }

    public InsightSmartClientResults() {
    }

    public InsightSmartClientResults(InsightSmartClientResults insightSmartClientResults) {
        if (insightSmartClientResults != null) {
            this.institutionID = insightSmartClientResults.getInstitutionID();
            this.collectionID = insightSmartClientResults.getCollectionID();
            this.vcID = insightSmartClientResults.getVCID();
            this.imageID = insightSmartClientResults.getImageID();
            this.objectID = insightSmartClientResults.getObjectID();
            this.mediaType = insightSmartClientResults.getMediaType();
            this.hasMviSeries = insightSmartClientResults.isMultiview();
            this.hasMpdSeries = insightSmartClientResults.isMultipage();
            this.absoluteOrder = insightSmartClientResults.absoluteOrder;
            this.fieldData = insightSmartClientResults.fieldData;
            this.thumbnailURL = insightSmartClientResults.thumbnailURL;
            this.thumbImageData = insightSmartClientResults.thumbImageData;
            this.thumbDimension = insightSmartClientResults.thumbDimension;
            this.sortString = insightSmartClientResults.sortString;
            this.iscrLocale = insightSmartClientResults.iscrLocale;
            this.sortData = insightSmartClientResults.sortData;
        }
    }

    public void setMultiview(boolean bl) {
        this.hasMviSeries = bl;
    }

    public void setMultipage(boolean bl) {
        this.hasMpdSeries = bl;
    }

    public void setAbsoluteOrder(int n) {
        this.absoluteOrder = n;
    }

    public String getSortString() {
        return this.sortString;
    }

    public String getThumbnailUrl() {
        return this.thumbnailURL;
    }

    public Object clone() {
        return InsightUtilities.deepCopy(this);
    }

    public boolean equals(Object object) {
        if (object instanceof ThumbnailTallyMark) {
            ThumbnailTallyMark thumbnailTallyMark = (ThumbnailTallyMark)object;
            return this.getImageID() == thumbnailTallyMark.imageID && this.objectID == thumbnailTallyMark.objectID && this.collectionID.equalsIgnoreCase(thumbnailTallyMark.collectionID) && this.institutionID.equalsIgnoreCase(thumbnailTallyMark.institutionID);
        }
        if (object instanceof InsightSmartClientResults) {
            InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)object;
            return ObjectKeyComparer.keysAgree(this, insightSmartClientResults);
        }
        return super.equals(object);
    }

    public int compareTo(Object object) {
        InsightSmartClientResults insightSmartClientResults = (InsightSmartClientResults)object;
        int n = InsightUtilities.compareStrings(this.getSortString(), insightSmartClientResults.getSortString());
        if (n == 0 && this.getObjectID() == insightSmartClientResults.getObjectID() && this.getImageID() == insightSmartClientResults.getImageID() && CollectionKeyDistributor.keysAgree(this, insightSmartClientResults)) {
            n = InsightSmartClientResults.getMviMpdOrder(this.isMultiview(), this.isMultipage(), insightSmartClientResults.isMultiview(), insightSmartClientResults.isMultipage());
        }
        return n;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public long getImageID() {
        return this.imageID;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public int getAbsoluteOrder() {
        return this.absoluteOrder;
    }

    public boolean isMultiview() {
        return this.hasMviSeries;
    }

    public boolean isMultipage() {
        return this.hasMpdSeries;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        if (collectionKey != null) {
            this.institutionID = collectionKey.getInstitutionID();
            this.collectionID = collectionKey.getCollectionID();
            this.vcID = collectionKey.getVCID();
        }
    }

    public void setFieldData(String[] stringArray) {
        this.fieldData = stringArray;
    }
}

