/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.KeywordsFieldCriterion;
import com.luna.insight.server.ObjectKey;
import com.luna.insight.server.TrinityCollectionInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;

public class InsightLaunchParams
extends EnhancedProperties {
    public static final String INITIAL_ACTIVITY = "iia";
    public static final String COLLECTION_UNIQUE_ID = "cid";
    public static final String INITIAL_GROUP = "ig";
    public static final String INITIAL_GW_ACTIVITY = "gwia";
    public static final String INITIAL_SEARCH_PARAMS = "gwisp";
    public static final String OBJECT_ID = "id";
    public static final String MEDIA_ID = "ir";
    public static final String MEDIA_X = "iwx";
    public static final String MEDIA_Y = "iwy";
    public static final String MEDIA_RESOLUTION = "iwas";
    public static final String USER_SERVER = "u";
    public static final String COLLECTION_KEY = "COLLECTION_KEY";
    public static final String INITIAL_GROUP_ATTRIBS = "INITIAL_GROUP_ATTRIBS";
    public static final String MEDIA_TO_LAUNCH = "MEDIA_TO_LAUNCH";
    public static final String SEARCH_CRITERIA = "SEARCH_CRITERIA";
    public static final String REMOTE_LAUNCH_BASEURL = "REMOTE_LAUNCH_BASEURL";
    public static final String USER_SERVER_ADDRESS = "USER_SERVER_ADDRESS";
    public static final int OPEN_GROUP_WORKSPACE = 0;
    public static final int OPEN_MEDIA_WORKSPACE = 1;
    public static final int OPEN_BOTH = 2;
    public static final int DO_NOTHING = 0;
    public static final int SHOW_SEARCH_MENU = 1;
    public static final int CUSTOM_SEARCH = 3;
    public static final String INTER_TUPLE_DELIMS = ";,-";
    public static final String INTRA_TUPLE_DELIMS = ":";
    public static final String PIPE = "|";
    public static final String COLON = ":";
    public static final String SEARCH_CRITERIA_DELIMS = "|~";
    public static final String OBJECT_INDICATOR_TAG = "ImageID";

    public static void debugOut(String string) {
        InsightLaunchParams.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightLaunchParams: " + string, n);
    }

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(3);
        InsightLaunchParams.debugOut(URLDecoder.decode("http://insight.techempower.com:8080/servlet/deploy/InsightJVA/launch?cid=1&iia=2&gwia=3&ig=Johnson+Museum+of+Art&gwisp=0%7CImageID%7CImageID%7C1%7C3154%3A80450034%7C00%7CImageID%7CImageID%7C1%7C2007%3A80540022%7C00%7CImageID%7CImageID%7C1%7C1483%3A80200032%7C00%7CImageID%7CImageID%7C1%7C1753%3A80450026%7C0&id=3154+2007+1483+1753&ir=80450034+80540022+80200032+80450026&iwas=2"));
    }

    public static String generateLaunchUrl(InsightLaunchParams insightLaunchParams, int n) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (insightLaunchParams != null) {
            try {
                object = (TrinityCollectionInfo)insightLaunchParams.getCollectionKey();
                String string = insightLaunchParams.getRemoteLaunchBaseUrl();
                if (string == null) {
                    string = ((TrinityCollectionInfo)object).getRemoteLaunchBaseUrl();
                }
                if (object != null && InsightUtilities.isNonEmpty(string)) {
                    Object object2;
                    stringBuffer.append(string);
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != '?') {
                        if (stringBuffer.toString().indexOf(63) != -1) {
                            stringBuffer.append("&");
                        } else {
                            stringBuffer.append("?");
                        }
                    }
                    stringBuffer.append("cid=" + URLEncoder.encode(((TrinityCollectionInfo)object).getTriplet(), "UTF-8"));
                    stringBuffer.append("&iia=" + insightLaunchParams.getInitialActivity());
                    stringBuffer.append("&gwia=" + insightLaunchParams.getInitialGwActivity());
                    if (InsightUtilities.isNonEmpty(insightLaunchParams.getInitialGroup())) {
                        stringBuffer.append("&ig=" + URLEncoder.encode(insightLaunchParams.getInitialGroup(), "UTF-8"));
                    }
                    if (InsightUtilities.isNonEmpty(insightLaunchParams.getUserServerAddress())) {
                        stringBuffer.append("&u=" + URLEncoder.encode(insightLaunchParams.getUserServerAddress(), "UTF-8"));
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (InsightUtilities.isNonEmpty(insightLaunchParams.getSearchCriteria())) {
                        object2 = insightLaunchParams.getSearchCriteria();
                        for (int i = 0; object2 != null && i < object2.size(); ++i) {
                            FieldCriterion fieldCriterion;
                            if (object2.get(i) instanceof KeywordsFieldCriterion) {
                                fieldCriterion = (KeywordsFieldCriterion)object2.get(i);
                                if (fieldCriterion.getEquivalence() == null || !InsightUtilities.isNonEmpty(fieldCriterion.getEquivalence().getSearchValue())) continue;
                                stringBuffer2.append(fieldCriterion.getBooleanOperator() + PIPE + "KEYWORDS" + PIPE + "KEYWORDS" + PIPE + 1 + PIPE + fieldCriterion.getEquivalence().getSearchValue() + PIPE + fieldCriterion.getRelationship() + PIPE);
                                continue;
                            }
                            if (object2.get(i) instanceof FieldCriterion) {
                                fieldCriterion = (FieldCriterion)object2.get(i);
                                if (fieldCriterion.getType() != 0 || fieldCriterion.getFieldMapping() == null || fieldCriterion.getEquivalence() == null || !InsightUtilities.isNonEmpty(fieldCriterion.getEquivalence().getSearchValue())) continue;
                                stringBuffer2.append(fieldCriterion.getBooleanOperator() + PIPE + fieldCriterion.getFieldMapping().getFieldName() + PIPE + fieldCriterion.getFieldMapping().getDisplayName() + PIPE + fieldCriterion.getFieldMapping().getFieldType() + PIPE + fieldCriterion.getEquivalence().getSearchValue() + PIPE + fieldCriterion.getRelationship() + PIPE);
                                continue;
                            }
                            if (!(object2.get(i) instanceof String)) continue;
                            stringBuffer2.append("1|KEYWORDS|KEYWORDS|1|" + (String)object2.get(i) + PIPE + 0 + PIPE);
                        }
                    }
                    if (insightLaunchParams.toGroupWorkspace() && InsightUtilities.isNonEmpty(insightLaunchParams.getMediaToLaunch())) {
                        object2 = insightLaunchParams.getMediaToLaunch();
                        for (int i = 0; object2 != null && i < object2.size(); ++i) {
                            if (!(object2.get(i) instanceof ObjectKey)) continue;
                            ObjectKey objectKey = (ObjectKey)object2.get(i);
                            stringBuffer2.append("0|ImageID|ImageID|1|" + objectKey.getObjectID() + ":" + objectKey.getImageID() + PIPE + 0 + PIPE);
                        }
                    }
                    if (stringBuffer2.length() > 0) {
                        stringBuffer.append("&gwisp=" + URLEncoder.encode(stringBuffer2.toString(), "UTF-8"));
                    }
                    if (insightLaunchParams.toMediaWorkspace() && InsightUtilities.isNonEmpty(insightLaunchParams.getMediaToLaunch())) {
                        object2 = new StringBuffer();
                        StringBuffer stringBuffer3 = new StringBuffer();
                        List list = insightLaunchParams.getMediaToLaunch();
                        for (int i = 0; list != null && i < list.size(); ++i) {
                            if (!(list.get(i) instanceof ObjectKey)) continue;
                            ObjectKey objectKey = (ObjectKey)list.get(i);
                            if (((StringBuffer)object2).length() > 0) {
                                ((StringBuffer)object2).append("+");
                            }
                            ((StringBuffer)object2).append(objectKey.getObjectID());
                            if (stringBuffer3.length() > 0) {
                                stringBuffer3.append("+");
                            }
                            stringBuffer3.append(objectKey.getImageID());
                        }
                        stringBuffer.append("&id=" + ((StringBuffer)object2).toString());
                        stringBuffer.append("&ir=" + stringBuffer3.toString());
                        stringBuffer.append("&iwas=" + n);
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        object = stringBuffer.toString();
        InsightLaunchParams.debugOut("launchUrlStr: " + (String)object);
        return stringBuffer.toString();
    }

    public InsightLaunchParams() {
        super(true);
    }

    public int getInitialActivity() {
        return this.getIntegerProperty(INITIAL_ACTIVITY, 0);
    }

    public String getInitialGroup() {
        return this.getProperty(INITIAL_GROUP, null);
    }

    public int getInitialGwActivity() {
        return this.getIntegerProperty(INITIAL_GW_ACTIVITY, 0);
    }

    public CollectionKey getCollectionKey() {
        if (this.get(COLLECTION_KEY) instanceof CollectionKey) {
            return (CollectionKey)this.get(COLLECTION_KEY);
        }
        return null;
    }

    public List getSearchCriteria() {
        if (this.get(SEARCH_CRITERIA) instanceof List) {
            return (List)this.get(SEARCH_CRITERIA);
        }
        return null;
    }

    public List getMediaToLaunch() {
        if (this.get(MEDIA_TO_LAUNCH) instanceof List) {
            return (List)this.get(MEDIA_TO_LAUNCH);
        }
        return null;
    }

    public String getRemoteLaunchBaseUrl() {
        if (this.get(REMOTE_LAUNCH_BASEURL) instanceof String) {
            return (String)this.get(REMOTE_LAUNCH_BASEURL);
        }
        return null;
    }

    public String getUserServerAddress() {
        if (this.get(USER_SERVER_ADDRESS) instanceof String) {
            return (String)this.get(USER_SERVER_ADDRESS);
        }
        return null;
    }

    public boolean toGroupWorkspace() {
        return this.getInitialActivity() == 2 || this.getInitialActivity() == 0;
    }

    public boolean toMediaWorkspace() {
        return this.getInitialActivity() == 2 || this.getInitialActivity() == 1;
    }

    public boolean showSearchMenu() {
        return this.getInitialGwActivity() == 1 || this.getInitialGwActivity() == 3;
    }

    public void setInitialActivity(int n) {
        this.setProperty(INITIAL_ACTIVITY, n + "");
    }

    public void setInitialGroup(String string) {
        this.setProperty(INITIAL_GROUP, string);
    }

    public void setInitialGwActivity(int n) {
        this.setProperty(INITIAL_GW_ACTIVITY, n + "");
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        this.put(COLLECTION_KEY, collectionKey);
    }

    public void setSearchCriteria(List list) {
        this.put(SEARCH_CRITERIA, list);
    }

    public void setMediaToLaunch(List list) {
        this.put(MEDIA_TO_LAUNCH, list);
    }

    public void setRemoteLaunchBaseUrl(String string) {
        this.put(REMOTE_LAUNCH_BASEURL, string);
    }

    public void setUserServerAddress(String string) {
        this.put(USER_SERVER_ADDRESS, string);
    }
}

