/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class ImageInGroup
implements Serializable,
Comparable,
CollectionKey {
    static final long serialVersionUID = 8877255169767232847L;
    public Vector imageFiles = null;
    protected long objectIDLong;
    protected long imageIDV3;
    protected String institutionIDV3;
    protected String collectionIDV3;
    protected String vcID;
    protected boolean hasMultipage = false;
    private int objectIDV3 = 0;
    private String imageID = null;
    private String collectionID = null;
    public String[] sortData = CoreUtilities.NULL_STRING_ARRAY;
    private transient String compareKey = null;
    protected int absoluteOrder = 0;

    public ImageInGroup(long l, long l2, boolean bl, CollectionKey collectionKey, Vector vector) {
        this(l, l2, bl, 0, collectionKey, vector);
    }

    public ImageInGroup(long l, long l2, boolean bl, int n, CollectionKey collectionKey, Vector vector) {
        this.objectIDLong = l;
        this.imageIDV3 = l2;
        this.hasMultipage = bl;
        this.absoluteOrder = n;
        this.institutionIDV3 = collectionKey.getInstitutionID();
        this.collectionIDV3 = collectionKey.getCollectionID();
        this.vcID = collectionKey.getVCID();
        this.imageFiles = vector;
    }

    public void trimToSize() {
        this.imageFiles = null;
    }

    public void setObjectID(long l) {
        this.objectIDLong = l;
    }

    public void setImageID(long l) {
        this.imageIDV3 = l;
    }

    public void setInstitutionID(String string) {
        this.institutionIDV3 = string;
    }

    public void setCollectionID(String string) {
        this.collectionIDV3 = string;
    }

    public void setMultipage(boolean bl) {
        this.hasMultipage = bl;
    }

    public void setAbsoluteOrder(int n) {
        this.absoluteOrder = n;
    }

    public long getObjectID() {
        return this.objectIDLong;
    }

    public long getImageID() {
        return this.imageIDV3;
    }

    public boolean isMultipage() {
        return this.hasMultipage;
    }

    public int getAbsoluteOrder() {
        return this.absoluteOrder;
    }

    public int getMediaType() {
        if (this.imageFiles != null && this.imageFiles.size() > 0) {
            return ((ImageFile)this.imageFiles.firstElement()).mediaType;
        }
        return 1;
    }

    public String toString() {
        if (this.imageFiles != null) {
            return "ImageInGroup [i=" + this.institutionIDV3 + "; c=" + this.collectionIDV3 + "; i=" + this.imageIDV3 + "; " + this.imageFiles.size() + " sizes]";
        }
        return "ImageInGroup [i=" + this.institutionIDV3 + "; c=" + this.collectionIDV3 + "; i=" + this.imageIDV3 + "; no sizes]";
    }

    public String getInstitutionID() {
        return this.institutionIDV3;
    }

    public String getCollectionID() {
        return this.collectionIDV3;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.objectIDLong == 0L) {
            this.objectIDLong = this.objectIDV3;
        }
        if (this.imageIDV3 == 0L) {
            try {
                this.imageIDV3 = Long.parseLong(this.imageID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.collectionIDV3 == null) {
            try {
                this.collectionIDV3 = this.collectionID;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        this.imageID = null;
        this.collectionID = null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImageInGroup)) {
            return false;
        }
        ImageInGroup imageInGroup = (ImageInGroup)object;
        return this.imageIDV3 == imageInGroup.getImageID() && this.objectIDLong == imageInGroup.getObjectID() && this.collectionIDV3.equals(imageInGroup.getCollectionID()) && this.institutionIDV3.equals(imageInGroup.getInstitutionID());
    }

    public void setSortKeys(String[] stringArray) {
        this.sortData = stringArray == null ? CoreUtilities.NULL_STRING_ARRAY : stringArray;
    }

    public String getCompareKey() {
        if (this.compareKey == null || this.compareKey.trim().equals("")) {
            boolean bl = false;
            this.compareKey = "";
            if (this.sortData != null) {
                for (int i = 0; i < this.sortData.length; ++i) {
                    this.compareKey = this.compareKey + (this.sortData[i] != null ? this.sortData[i] : "");
                    bl = true;
                }
            }
            if (!bl && this.absoluteOrder > 0) {
                this.compareKey = InsightUtilities.zeroPad(this.absoluteOrder, 20);
            }
        }
        return this.compareKey;
    }

    public int compareTo(Object object) {
        if (!(object instanceof ImageInGroup)) {
            return 0;
        }
        return this.getCompareKey().compareTo(((ImageInGroup)object).getCompareKey());
    }
}

