/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageInGroup;
import com.luna.insight.server.mpd.MultipageDocumentSeries;
import com.luna.insight.server.mvi.MultiviewImageSeries;
import com.luna.insight.server.presentation.ImageSeries;
import com.luna.insight.server.presentation.ImageSeriesSlide;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ImageGroupFile
implements Serializable {
    static final long serialVersionUID = -6288218131363794470L;
    protected String creatorName = null;
    protected String creatorPassword = null;
    protected String groupName = null;
    protected Vector imagesInGroup = null;
    protected Vector imageSerieses = null;
    protected Vector mviSerieses = null;
    protected transient Vector mpdSerieses = null;
    protected List links = null;
    protected boolean isAbsoluteOrder;
    protected int folderID = 0;
    private static final Dimension[] s_dimensions = new Dimension[]{new Dimension(96, 96), new Dimension(192, 192), new Dimension(384, 384), new Dimension(768, 768), new Dimension(1536, 1536), new Dimension(3072, 3072), new Dimension(6144, 6144), new Dimension(12288, 12288), new Dimension(24576, 24576)};

    public static void debugOut(String string) {
        ImageGroupFile.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IGF: " + string, n);
    }

    public ImageGroupFile() {
    }

    public ImageGroupFile(String string) {
        this(string, null, (Vector)null);
    }

    public ImageGroupFile(String string, Vector vector) {
        this(string, vector, (Vector)null);
    }

    public ImageGroupFile(String string, Vector vector, Vector vector2) {
        this.groupName = string;
        this.imagesInGroup = vector;
        this.imageSerieses = vector2;
    }

    public ImageGroupFile(String string, Vector vector, ImageSeries imageSeries) {
        this(string, vector, ImageGroupFile.createSeriesVector(imageSeries));
    }

    private static Vector createSeriesVector(ImageSeries imageSeries) {
        Vector<ImageSeries> vector = new Vector<ImageSeries>();
        vector.addElement(imageSeries);
        return vector;
    }

    public void trimToSize() {
        int n;
        if (this.imagesInGroup != null) {
            for (n = 0; n < this.imagesInGroup.size(); ++n) {
                ((ImageInGroup)this.imagesInGroup.elementAt(n)).trimToSize();
            }
            this.imagesInGroup.trimToSize();
        }
        if (this.imageSerieses != null) {
            for (n = 0; n < this.imageSerieses.size(); ++n) {
                ((ImageSeries)this.imageSerieses.elementAt(n)).trimToSize();
            }
            this.imageSerieses.trimToSize();
        }
    }

    public void setCreator(String string, String string2) {
        this.creatorName = string;
        this.creatorPassword = string2;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public String getCreatorPassword() {
        return this.creatorPassword;
    }

    public boolean hasSameCreator(ImageGroupFile imageGroupFile) {
        return imageGroupFile != null && this.hasSameCreator(imageGroupFile.getCreatorName(), imageGroupFile.getCreatorPassword());
    }

    public boolean hasSameCreator(String string, String string2) {
        return this.creatorName != null && string != null && this.creatorName.equals(string);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setImagesInGroup(Vector vector) {
        this.imagesInGroup = vector;
    }

    public Vector getImagesInGroup() {
        if (this.imagesInGroup == null) {
            this.imagesInGroup = new Vector();
        }
        return this.imagesInGroup;
    }

    public void addImage(ImageInGroup imageInGroup) {
        if (this.imagesInGroup == null) {
            this.imagesInGroup = new Vector();
        }
        this.imagesInGroup.addElement(imageInGroup);
    }

    public void setImageSerieses(Vector vector) {
        this.imageSerieses = vector;
    }

    public Vector getImageSerieses() {
        if (this.imageSerieses == null) {
            this.imageSerieses = new Vector();
        }
        return this.imageSerieses;
    }

    public ImageSeries getImageSeries(String string) {
        if (this.imageSerieses != null) {
            for (int i = 0; i < this.imageSerieses.size(); ++i) {
                ImageSeries imageSeries = (ImageSeries)this.imageSerieses.elementAt(i);
                if (!imageSeries.getSeriesName().equalsIgnoreCase(string)) continue;
                return imageSeries;
            }
        }
        return null;
    }

    public boolean addImageSeries(ImageSeries imageSeries) {
        ImageSeries imageSeries2;
        int n;
        if (this.imageSerieses == null) {
            this.imageSerieses = new Vector();
        }
        boolean bl = false;
        for (n = 0; n < this.imageSerieses.size(); ++n) {
            imageSeries2 = (ImageSeries)this.imageSerieses.elementAt(n);
            if (!imageSeries.getSeriesName().equalsIgnoreCase(imageSeries2.getSeriesName())) continue;
            bl = true;
            break;
        }
        imageSeries2 = (ImageSeries)imageSeries.clone();
        imageSeries2.setChanges(false);
        if (bl) {
            this.imageSerieses.setElementAt(imageSeries2, n);
        } else {
            this.imageSerieses.addElement(imageSeries2);
        }
        return !bl;
    }

    public void removeImageSeries(String string) {
        if (this.imageSerieses != null) {
            for (int i = 0; i < this.imageSerieses.size(); ++i) {
                ImageSeries imageSeries = (ImageSeries)this.imageSerieses.elementAt(i);
                if (!imageSeries.getSeriesName().equalsIgnoreCase(string)) continue;
                this.imageSerieses.removeElementAt(i);
                break;
            }
        }
    }

    public String getUniqueImageSeriesName() {
        String string = "Untitled";
        int n = 1;
        String string2 = string + n;
        while (this.getImageSeries(string2) != null) {
            string2 = string + ++n;
        }
        return string2;
    }

    public Vector getMviSerieses() {
        if (this.mviSerieses == null) {
            this.mviSerieses = new Vector();
        }
        return this.mviSerieses;
    }

    public void setMviSerieses(Vector vector) {
        this.mviSerieses = vector;
    }

    public MultiviewImageSeries getMultiviewImage(int n, long l, long l2, CollectionKey collectionKey) {
        if (this.mviSerieses != null) {
            for (int i = 0; i < this.mviSerieses.size(); ++i) {
                MultiviewImageSeries multiviewImageSeries = (MultiviewImageSeries)this.mviSerieses.elementAt(i);
                if (multiviewImageSeries.getGroupID() != n || multiviewImageSeries.getImageID() != l2 || !CollectionKeyDistributor.keysAgree(multiviewImageSeries, collectionKey)) continue;
                return multiviewImageSeries;
            }
        }
        return null;
    }

    public void addMultiviewImage(MultiviewImageSeries multiviewImageSeries) {
        int n;
        if (this.mviSerieses == null) {
            this.mviSerieses = new Vector();
        }
        boolean bl = false;
        for (n = 0; n < this.mviSerieses.size(); ++n) {
            MultiviewImageSeries multiviewImageSeries2 = (MultiviewImageSeries)this.mviSerieses.elementAt(n);
            if (multiviewImageSeries.getGroupID() != multiviewImageSeries2.getGroupID() || multiviewImageSeries.getObjectID() != multiviewImageSeries2.getObjectID() || multiviewImageSeries.getImageID() != multiviewImageSeries2.getImageID() || !CollectionKeyDistributor.keysAgree(multiviewImageSeries, multiviewImageSeries2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.mviSerieses.setElementAt(multiviewImageSeries, n);
        } else {
            this.mviSerieses.addElement(multiviewImageSeries);
        }
    }

    public boolean removeMultiviewImage(int n, long l, long l2, CollectionKey collectionKey) {
        if (this.mviSerieses != null) {
            for (int i = 0; i < this.mviSerieses.size(); ++i) {
                MultiviewImageSeries multiviewImageSeries = (MultiviewImageSeries)this.mviSerieses.elementAt(i);
                if (multiviewImageSeries.getGroupID() != n || multiviewImageSeries.getObjectID() != l || multiviewImageSeries.getImageID() != l2 || !CollectionKeyDistributor.keysAgree(multiviewImageSeries, collectionKey)) continue;
                this.mviSerieses.removeElementAt(i);
                return true;
            }
        }
        return false;
    }

    public Vector getMpdSerieses() {
        if (this.mpdSerieses == null) {
            this.mpdSerieses = new Vector();
        }
        return this.mpdSerieses;
    }

    public void setMpdSerieses(Vector vector) {
        this.mpdSerieses = vector;
    }

    public MultipageDocumentSeries getMultipageDocument(long l, long l2, CollectionKey collectionKey) {
        if (this.mpdSerieses != null) {
            for (int i = 0; i < this.mpdSerieses.size(); ++i) {
                MultipageDocumentSeries multipageDocumentSeries = (MultipageDocumentSeries)this.mpdSerieses.elementAt(i);
                if (multipageDocumentSeries.getImageID() != l2 || !CollectionKeyDistributor.keysAgree(multipageDocumentSeries, collectionKey)) continue;
                return multipageDocumentSeries;
            }
        }
        return null;
    }

    public void addMultipageDocument(MultipageDocumentSeries multipageDocumentSeries) {
        int n;
        if (this.mpdSerieses == null) {
            this.mpdSerieses = new Vector();
        }
        boolean bl = false;
        for (n = 0; n < this.mpdSerieses.size(); ++n) {
            MultipageDocumentSeries multipageDocumentSeries2 = (MultipageDocumentSeries)this.mpdSerieses.elementAt(n);
            if (multipageDocumentSeries.getObjectID() != multipageDocumentSeries2.getObjectID() || multipageDocumentSeries.getImageID() != multipageDocumentSeries2.getImageID() || !CollectionKeyDistributor.keysAgree(multipageDocumentSeries, multipageDocumentSeries2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.mpdSerieses.setElementAt(multipageDocumentSeries, n);
        } else {
            this.mpdSerieses.addElement(multipageDocumentSeries);
        }
    }

    public boolean removeMultipageDocument(long l, long l2, CollectionKey collectionKey) {
        if (this.mpdSerieses != null) {
            for (int i = 0; i < this.mpdSerieses.size(); ++i) {
                MultipageDocumentSeries multipageDocumentSeries = (MultipageDocumentSeries)this.mpdSerieses.elementAt(i);
                if (multipageDocumentSeries.getObjectID() != l || multipageDocumentSeries.getImageID() != l2 || !CollectionKeyDistributor.keysAgree(multipageDocumentSeries, collectionKey)) continue;
                this.mpdSerieses.removeElementAt(i);
                return true;
            }
        }
        return false;
    }

    public List getLinks() {
        return this.links;
    }

    public void setLinks(List list) {
        this.links = list;
    }

    public void convertToDesktop(Dimension dimension) {
        if (this.imageSerieses.size() > 0) {
            ImageGroupFile.debugOut("Loaded ImageSeries to fit desktop - new: " + dimension + " iss_screensize: " + ((ImageSeries)this.imageSerieses.elementAt(0)).getScreenSize(), 3);
        }
    }

    private void adjustToDesktop(ImageSeries imageSeries, Dimension dimension) {
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        int n = dimension.width;
        int n2 = dimension.height;
        Dimension dimension2 = imageSeries.getScreenSize();
        f = new Double((double)n2 * 1.0 / (double)dimension2.height).floatValue();
        float f4 = f3 = f > (f2 = new Double((double)n * 1.0 / (double)dimension2.width).floatValue()) ? f : f2;
        if (0.98f < f && 0.98f < f2) {
            return;
        }
        imageSeries.setScreenSize(dimension);
        Vector vector = imageSeries.getSlides();
        block0: for (int i = 0; i < vector.size(); ++i) {
            ImageSeriesSlide imageSeriesSlide = (ImageSeriesSlide)vector.elementAt(i);
            Dimension dimension3 = imageSeriesSlide.getTotalSize();
            imageSeriesSlide.setTotalSize(new Dimension((int)((float)dimension3.width * f3), (int)((float)dimension3.height * f3)));
            float f5 = f < f2 ? 1.05f + f2 - f : 1.05f + f - f2;
            imageSeriesSlide.setViewportPosition(new Point((int)((float)imageSeriesSlide.getViewportPosition().x * f3), (int)((float)imageSeriesSlide.getViewportPosition().y * f3)));
            Rectangle rectangle = imageSeriesSlide.getWindowRectangle();
            rectangle = dimension3.width > dimension3.height ? new Rectangle((int)((float)rectangle.x * f3), (int)((float)rectangle.y * f3), (int)((float)rectangle.width * f5), (int)((float)rectangle.height * f5)) : new Rectangle((int)((float)rectangle.x * f3), (int)((float)rectangle.y * f3), (int)((float)rectangle.width * f3), (int)((float)rectangle.height * f3));
            imageSeriesSlide.setWindowRectangle(rectangle);
            for (int j = 0; j < s_dimensions.length; ++j) {
                if (ImageGroupFile.s_dimensions[j].width < dimension3.width || ImageGroupFile.s_dimensions[j].height < dimension3.height) continue;
                imageSeriesSlide.setResolution(j);
                continue block0;
            }
        }
    }

    public boolean isAbsoluteOrdered() {
        return this.isAbsoluteOrder;
    }

    public void setAbsoluteOrdered(boolean bl) {
        this.isAbsoluteOrder = bl;
        if (!bl) {
            Iterator iterator = this.getImagesInGroup().iterator();
            while (iterator.hasNext()) {
                ImageInGroup imageInGroup = (ImageInGroup)iterator.next();
                imageInGroup.setAbsoluteOrder(0);
            }
        }
    }
}

