/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.InsightUtilities;
import java.io.Serializable;
import java.util.Vector;

public class FieldMapping
implements Serializable,
Comparable {
    static final long serialVersionUID = -4837575077092659682L;
    public String fieldName;
    public String fieldDisplayName;
    public int fieldID = -1;
    public int fieldType = -1;
    public int fieldGroupID = 0;
    public boolean picked = false;
    public String fieldStandardName = null;
    public String fieldDescriptionURL = null;
    public int displayOrder = 0;
    public int longString = 0;
    public boolean dataFieldSearchable = true;
    public boolean displayedInThumbnail = true;
    public boolean sortable = true;
    public int referenceCount = 0;
    public int finalFieldCount = 0;
    public String hierarchyName = "";
    public int hierarchyMode = Field.HIERARCHY_MODE_NONE;
    protected boolean date = false;
    protected boolean fuzzyDateSearchable = false;
    public transient FieldStandard fieldStandard = null;
    public transient Vector fieldMappings = new Vector();
    protected transient Vector finalFields = new Vector();
    protected transient int stepCount = 0;
    public int listMode = Field.LIST_ALL;

    public static void debugOut(String string) {
        Debug.debugOut("FM: " + string, 3);
    }

    public FieldMapping(int n) {
        this("", "", n, -1);
    }

    public FieldMapping(String string, String string2, int n, int n2) {
        this.fieldName = string;
        this.fieldDisplayName = string2;
        this.fieldID = n;
        this.fieldType = n2;
    }

    public FieldMapping(String string, String string2, int n, int n2, boolean bl, FieldStandard fieldStandard, int n3, String string3, int n4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n5) {
        this.fieldName = string;
        this.fieldDisplayName = string2;
        this.fieldID = n;
        this.fieldType = n2;
        this.picked = bl;
        this.fieldStandard = fieldStandard;
        this.displayOrder = n3;
        this.fieldDescriptionURL = string3;
        this.longString = n4;
        this.dataFieldSearchable = bl3;
        this.displayedInThumbnail = bl4;
        this.sortable = bl5;
        this.listMode = n5;
        this.setDate(bl2);
        this.setFuzzyDateSearchable(bl2);
        this.fieldStandardName = this.fieldStandard.standardName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDisplayName() {
        return this.fieldDisplayName;
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public int getFieldGroupID() {
        return this.fieldGroupID;
    }

    public boolean isPicked() {
        return this.picked;
    }

    public String getFieldStandardName() {
        return this.fieldStandardName;
    }

    public String getFieldDescriptionURL() {
        return this.fieldDescriptionURL;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public int getStringType() {
        return this.longString;
    }

    public boolean isDataFieldSearchable() {
        return this.dataFieldSearchable;
    }

    public boolean isDisplayedInThumbnail() {
        return this.displayedInThumbnail;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isDate() {
        return this.date;
    }

    public boolean isFuzzyDateSearchable() {
        return this.fuzzyDateSearchable;
    }

    public int getListMode() {
        return this.listMode;
    }

    public FieldStandard getFieldStandard() {
        return this.fieldStandard;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    public int getHierarchyMode() {
        return this.hierarchyMode;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public void setDisplayName(String string) {
        this.fieldDisplayName = string;
    }

    public void setFieldID(int n) {
        this.fieldID = n;
    }

    public void setFieldType(int n) {
        this.fieldType = n;
    }

    public void setFieldGroupID(int n) {
        this.fieldGroupID = n;
    }

    public void setPicked(boolean bl) {
        this.picked = bl;
    }

    public void setFieldStandardName(String string) {
        this.fieldStandardName = string;
    }

    public void setFieldDescriptionURL(String string) {
        this.fieldDescriptionURL = string;
    }

    public void setDisplayOrder(int n) {
        this.displayOrder = n;
    }

    public void setStringType(int n) {
        this.longString = n;
    }

    public void setDataFieldSearchable(boolean bl) {
        this.dataFieldSearchable = bl;
    }

    public void setDisplayedInThumbnail(boolean bl) {
        this.displayedInThumbnail = bl;
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    public void setDate(boolean bl) {
        this.date = bl;
    }

    public void setFuzzyDateSearchable(boolean bl) {
        this.fuzzyDateSearchable = bl;
    }

    public void setListMode(int n) {
        this.listMode = n;
    }

    public void setFieldStandard(FieldStandard fieldStandard) {
        this.fieldStandard = fieldStandard;
    }

    public void setHierarchyName(String string) {
        this.hierarchyName = string;
    }

    public void setHierarchyMode(int n) {
        this.hierarchyMode = n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof FieldMapping) {
            FieldMapping fieldMapping = (FieldMapping)object;
            return this.fieldName != null && this.fieldDisplayName != null && this.fieldType == fieldMapping.fieldType && this.fieldID == fieldMapping.fieldID && (this.fieldStandard == null && fieldMapping.fieldStandard == null || this.fieldStandard != null && this.fieldStandard.equals(fieldMapping.fieldStandard));
        }
        return super.equals(object);
    }

    public void matchToDates() {
        if (!this.isDate() || !this.isFuzzyDateSearchable()) {
            Vector vector = this.getFinalFields();
            boolean bl = false;
            Field field = null;
            for (int i = 0; i < vector.size(); ++i) {
                field = (Field)vector.elementAt(i);
                if (i == 0) {
                    bl = field.isDate();
                    continue;
                }
                if (field.isDate()) continue;
                bl = false;
                break;
            }
            this.setDate(bl);
            this.setFuzzyDateSearchable(bl);
        }
    }

    public Vector getFinalFields() {
        if (this.finalFields == null) {
            this.finalFields = new Vector();
        }
        return this.finalFields;
    }

    public Field getFinalField() {
        this.getFinalFields();
        if (this.finalFields != null && this.finalFields.size() > 0) {
            return (Field)this.finalFields.firstElement();
        }
        return null;
    }

    public boolean hasFinalField(Field field) {
        this.getFinalFields();
        if (field != null) {
            Field field2 = null;
            for (int i = 0; i < this.finalFields.size(); ++i) {
                field2 = (Field)this.finalFields.elementAt(i);
                if (field2.fieldID != field.fieldID) continue;
                return true;
            }
        }
        return false;
    }

    public void addFinalField(Field field) {
        this.getFinalFields();
        if (!this.finalFields.contains(field)) {
            this.finalFields.addElement(field);
            field.addFieldMapping(this);
        }
        this.finalFieldCount = this.finalFields.size();
    }

    public void addFieldMapping(FieldMapping fieldMapping) {
        if (this.fieldMappings == null) {
            this.fieldMappings = new Vector();
        }
        if (!this.fieldMappings.contains(fieldMapping)) {
            this.fieldMappings.addElement(fieldMapping);
        }
    }

    public Vector getFieldMappings(FieldStandard fieldStandard) {
        int n;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.findFieldMappings(fieldStandard, vector2, vector, 0);
        FieldMapping.debugOut("*********************************");
        FieldMapping.debugOut("In getFieldMappings().");
        FieldMapping.debugOut("[" + this.fieldStandardName + ", " + this.fieldID + "]");
        FieldMapping.debugOut("Total mappings returned: " + vector.size());
        Object[] objectArray = new FieldMapping[vector.size()];
        vector.copyInto(objectArray);
        int n2 = -1;
        for (n = 0; n < objectArray.length; ++n) {
            if (n2 != -1 && ((FieldMapping)objectArray[n]).stepCount >= n2) continue;
            n2 = ((FieldMapping)objectArray[n]).stepCount;
        }
        FieldMapping.debugOut("Lowest count: " + n2);
        for (n = 0; n < objectArray.length; ++n) {
            FieldMapping.debugOut("\tMapping [" + ((FieldMapping)objectArray[n]).fieldStandardName + ", " + ((FieldMapping)objectArray[n]).fieldID + "] step count: " + ((FieldMapping)objectArray[n]).stepCount);
            if (((FieldMapping)objectArray[n]).stepCount <= n2) continue;
            FieldMapping.debugOut("\tRemoving mapping: [" + ((FieldMapping)objectArray[n]).fieldStandardName + ", " + ((FieldMapping)objectArray[n]).fieldID + "]");
            vector.removeElement(objectArray[n]);
        }
        return vector;
    }

    protected void findFieldMappings(FieldStandard fieldStandard, Vector vector, Vector vector2, int n) {
        int n2;
        vector.addElement(this);
        if (this.fieldStandard.equals(fieldStandard)) {
            if (vector2.contains(this)) {
                if (n < this.stepCount) {
                    this.stepCount = n;
                }
            } else {
                this.stepCount = n;
                vector2.addElement(this);
            }
        } else if (n == 0 || this.fieldStandard.isMappingStandard()) {
            FieldMapping fieldMapping = null;
            for (int i = 0; i < this.fieldMappings.size(); ++i) {
                fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
                if (vector.lastIndexOf(fieldMapping) >= 0) continue;
                fieldMapping.findFieldMappings(fieldStandard, vector, vector2, n + 1);
            }
        }
        if ((n2 = vector.lastIndexOf(this)) > -1) {
            vector.removeElementAt(n2);
        }
    }

    public FieldMapping getTranslatedFieldMapping(FieldStandard fieldStandard) {
        if (this.fieldStandard.equals(fieldStandard)) {
            return this;
        }
        FieldMapping fieldMapping = null;
        Vector vector = this.getFieldMappings(fieldStandard);
        if (vector.size() > 0) {
            fieldMapping = (FieldMapping)vector.firstElement();
        }
        return fieldMapping;
    }

    public void showData() {
        FieldMapping.debugOut("[" + this.fieldStandardName + ", " + this.fieldID + ", " + this.fieldDisplayName + "].");
        FieldMapping.debugOut("Has " + this.getFinalFields().size() + " final field(s).");
        Field field = null;
        for (int i = 0; i < this.getFinalFields().size(); ++i) {
            field = (Field)this.getFinalFields().elementAt(i);
            FieldMapping.debugOut("\tFinal field " + i + ": [" + field.fieldID + ", " + field.fieldName + "]");
        }
        FieldMapping.debugOut("References " + this.fieldMappings.size() + " ->");
        FieldMapping fieldMapping = null;
        for (int i = 0; i < this.fieldMappings.size(); ++i) {
            fieldMapping = (FieldMapping)this.fieldMappings.elementAt(i);
            FieldMapping.debugOut("\t" + i + ": [" + fieldMapping.fieldStandardName + ", " + fieldMapping.fieldID + ", " + fieldMapping + "]");
        }
    }

    public int compareTo(Object object) {
        FieldMapping fieldMapping = (FieldMapping)object;
        if (this.getDisplayOrder() == fieldMapping.getDisplayOrder()) {
            return InsightUtilities.compareStrings(this.getDisplayName(), fieldMapping.getDisplayName());
        }
        return this.getDisplayOrder() - fieldMapping.getDisplayOrder();
    }

    public String display() {
        return "[" + this.fieldStandardName + ", " + this.fieldID + ", " + this.fieldDisplayName + "]";
    }

    public String toString() {
        return this.fieldDisplayName;
    }
}

