/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.DynamicDistributionBucketInfo;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ObjectKeyWrapper;
import com.luna.insight.server.ThumbnailDistribution;
import com.luna.insight.server.ThumbnailTallyMark;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class DynamicThumbnailDistribution
implements Serializable {
    static final long serialVersionUID = -7379403204808265498L;
    public int totalCount = 0;
    public int maxThumbnailsPerBucket = 0;
    public DynamicDistributionBucketInfo[] tally = null;
    protected transient int[] tallyMarkIndexes = null;
    protected transient List tallyMarks = null;
    protected transient boolean calcBuckets = false;

    public static void debugOut(String string) {
        DynamicThumbnailDistribution.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("DynamicTD: " + string, n);
    }

    public static DynamicThumbnailDistribution getDynamicDistribution(ThumbnailDistribution thumbnailDistribution) {
        DynamicThumbnailDistribution.debugOut("in getDynamicDistribution().");
        if (thumbnailDistribution != null) {
            DynamicThumbnailDistribution dynamicThumbnailDistribution = new DynamicThumbnailDistribution();
            dynamicThumbnailDistribution.totalCount = thumbnailDistribution.totalCount;
            if (thumbnailDistribution.tallyMarks == null) {
                dynamicThumbnailDistribution.tallyMarks = null;
            } else {
                dynamicThumbnailDistribution.tallyMarks = new Vector(0);
                for (int i = 0; thumbnailDistribution.tallyMarks != null && i < thumbnailDistribution.tallyMarks.length; ++i) {
                    dynamicThumbnailDistribution.tallyMarks.addAll(thumbnailDistribution.tallyMarks[i]);
                }
            }
            DynamicThumbnailDistribution.debugOut("td.totalCount: " + thumbnailDistribution.totalCount + ", td.tallyMarks: " + thumbnailDistribution.tallyMarks);
            dynamicThumbnailDistribution.tally = new DynamicDistributionBucketInfo[thumbnailDistribution.tally != null ? thumbnailDistribution.tally.length : 0];
            for (int i = 0; thumbnailDistribution.tally != null && i < thumbnailDistribution.tally.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                ThumbnailDistribution.findStringRange(i, stringBuffer, stringBuffer2);
                dynamicThumbnailDistribution.tally[i] = new DynamicDistributionBucketInfo(stringBuffer.toString(), stringBuffer2.toString(), thumbnailDistribution.tally[i]);
                DynamicThumbnailDistribution.debugOut("TD tally [Index: " + i + ", Count: " + thumbnailDistribution.tally[i] + "] to " + "DDBI[" + dynamicThumbnailDistribution.tally[i].getStartString() + " | " + dynamicThumbnailDistribution.tally[i].getEndString() + " | " + dynamicThumbnailDistribution.tally[i].getCount() + "]");
            }
            return dynamicThumbnailDistribution;
        }
        return null;
    }

    public DynamicThumbnailDistribution() {
    }

    public DynamicThumbnailDistribution(int n) {
        this.maxThumbnailsPerBucket = n;
    }

    public void addTally(ThumbnailTallyMark thumbnailTallyMark) {
        if (this.tallyMarks == null) {
            this.tallyMarks = new Vector(1);
        }
        InsightUtilities.addToSortedList(this.tallyMarks, thumbnailTallyMark);
        this.calcBuckets = true;
    }

    public void removeTally(long l) {
        int n = 0;
        while (this.tallyMarks != null && n < this.tallyMarks.size()) {
            ThumbnailTallyMark thumbnailTallyMark = (ThumbnailTallyMark)this.tallyMarks.get(n);
            if (thumbnailTallyMark.getObjectID() == l) {
                this.tallyMarks.remove(n);
                this.calcBuckets = true;
                continue;
            }
            ++n;
        }
    }

    public void removeTally(ObjectKeyWrapper objectKeyWrapper) {
        int n;
        if (this.tallyMarks != null && (n = this.tallyMarks.indexOf(objectKeyWrapper)) > -1) {
            this.tallyMarks.remove(n);
            this.calcBuckets = true;
        }
    }

    public Vector getTallyMarks(int n, int n2) {
        DynamicThumbnailDistribution.debugOut("in getTallyMarks(tallyIndex: " + n + ", length: " + n2 + ").");
        this.calculateBuckets();
        Vector vector = new Vector(n2);
        if (this.tallyMarks != null && this.tally != null && this.tallyMarkIndexes != null && n >= 0 && n < this.tally.length && n < this.tallyMarkIndexes.length) {
            int n3;
            DynamicDistributionBucketInfo dynamicDistributionBucketInfo = this.tally[n];
            for (n3 = this.tallyMarkIndexes[n]; n3 < this.tallyMarks.size() && vector.size() < dynamicDistributionBucketInfo.getCount(); ++n3) {
                vector.add(this.tallyMarks.get(n3));
            }
            for (int i = 0; n3 < this.tallyMarks.size() && i < n2; ++n3, ++i) {
                vector.add(this.tallyMarks.get(n3));
            }
        }
        return vector;
    }

    public void calculateBuckets() {
        if (this.calcBuckets || this.tally == null) {
            if (this.tallyMarks == null) {
                this.tallyMarks = new Vector(0);
            }
            this.totalCount = this.tallyMarks.size();
            int n = this.totalCount / this.maxThumbnailsPerBucket;
            if (this.totalCount % this.maxThumbnailsPerBucket > 0) {
                ++n;
            }
            this.tally = new DynamicDistributionBucketInfo[n];
            this.tallyMarkIndexes = new int[n];
            for (int i = 0; i < this.tally.length; ++i) {
                ThumbnailTallyMark thumbnailTallyMark;
                int n2 = i * this.maxThumbnailsPerBucket;
                ThumbnailTallyMark thumbnailTallyMark2 = (ThumbnailTallyMark)this.tallyMarks.get(n2);
                int n3 = 0;
                if (n2 + this.maxThumbnailsPerBucket - 1 < this.totalCount) {
                    thumbnailTallyMark = (ThumbnailTallyMark)this.tallyMarks.get(n2 + this.maxThumbnailsPerBucket - 1);
                    n3 = this.maxThumbnailsPerBucket;
                } else {
                    thumbnailTallyMark = (ThumbnailTallyMark)this.tallyMarks.get(this.totalCount - 1);
                    n3 = this.totalCount - n2;
                }
                this.tally[i] = new DynamicDistributionBucketInfo(thumbnailTallyMark2.sort, thumbnailTallyMark.sort, n3);
                this.tallyMarkIndexes[i] = n2;
            }
            this.calcBuckets = false;
        }
    }

    public String getContentsAsString() {
        this.calculateBuckets();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; this.tally != null && i < this.tally.length; ++i) {
            stringBuffer.append("\nBucket " + (i + 1) + ": " + this.tally[i].toString());
            Vector vector = this.getTallyMarks(i, 0);
            for (int j = 0; vector != null && j < vector.size(); ++j) {
                ThumbnailTallyMark thumbnailTallyMark = (ThumbnailTallyMark)vector.get(j);
                stringBuffer.append("\n  " + (j + 1) + "-> oid: " + thumbnailTallyMark.getObjectID() + ", iid: " + thumbnailTallyMark.getImageID() + ", sort: " + thumbnailTallyMark.sort);
            }
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.calculateBuckets();
        objectOutputStream.defaultWriteObject();
    }
}

