/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import com.luna.insight.core.util.CoreUtilities;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class XMLWriter {
    public static final String INDENTATION = "  ";
    public static final int ALL_ELEMENTS = -1;
    private StringBuffer responseBuffer;
    private Writer writer;
    private int indentLevel;
    private List openElementStack;
    private String systemID;
    private String doctype;
    private String xmlns;

    public XMLWriter(Writer writer, String string, String string2, String string3) {
        this.writer = writer;
        this.responseBuffer = new StringBuffer();
        this.openElementStack = new ArrayList();
        this.doctype = string;
        this.systemID = string2;
        this.xmlns = string3;
    }

    public void appendElement(String string, String[] stringArray, String[] stringArray2, String string2, boolean bl) {
        this.indent(this.indentLevel++);
        this.responseBuffer.append('<').append(string);
        if (this.indentLevel == 1 && this.xmlns != null && !this.xmlns.equals("")) {
            this.responseBuffer.append(" xmlns=\"" + this.xmlns + "\"");
        }
        if (stringArray != null) {
            this.responseBuffer.append(' ');
            for (int i = 0; i < stringArray.length; ++i) {
                this.responseBuffer.append(stringArray[i]).append("=\"").append(CoreUtilities.attValueEncode(stringArray2[i])).append("\"").append(" ");
            }
        }
        if (string2 == null && bl) {
            this.responseBuffer.append("/>\n");
            --this.indentLevel;
            return;
        }
        this.responseBuffer.append('>');
        if (string2 != null) {
            this.responseBuffer.append(CoreUtilities.pcDataEncode(string2));
        }
        if (!bl) {
            this.responseBuffer.append('\n');
            this.openElementStack.add(0, string);
        } else {
            --this.indentLevel;
            this.responseBuffer.append(this.end(string));
        }
    }

    public void appendElement(String string) {
        this.appendElement(string, null, null, null, false);
    }

    public void appendElement(String string, boolean bl) {
        this.appendElement(string, null, null, null, bl);
    }

    public void appendAndCloseElement(String string) {
        this.appendElement(string, true);
    }

    public void appendAndCloseElement(String string, String[] stringArray, String[] stringArray2, String string2) {
        this.appendElement(string, stringArray, stringArray2, string2, true);
    }

    public void appendAndCloseElement(String string, String[] stringArray, String[] stringArray2) {
        this.appendElement(string, stringArray, stringArray2, null, true);
    }

    public void appendAndCloseElement(String string, String string2) {
        this.appendElement(string, null, null, string2, true);
    }

    public void appendAndCloseElement(String string, int n) {
        this.appendElement(string, null, null, "" + n, true);
    }

    public void appendAndCloseElement(String string, boolean bl) {
        this.appendElement(string, null, null, bl ? "true" : "false", true);
    }

    public void appendHeader() {
        this.responseBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this.doctype != null) {
            if (this.systemID != null) {
                this.responseBuffer.append("<!DOCTYPE " + this.doctype + " SYSTEM \"" + this.systemID + "\" >\n");
            } else {
                this.responseBuffer.append("<!DOCTYPE " + this.doctype + " >\n");
            }
        }
    }

    public void appendComment(String string) {
        this.appendComment(new String[]{string});
    }

    public void appendComment(String[] stringArray) {
        this.indent(this.indentLevel);
        this.responseBuffer.append("<!--\n");
        for (int i = 0; i < stringArray.length; ++i) {
            this.indent(this.indentLevel);
            this.responseBuffer.append("  - " + stringArray[i] + "\n");
        }
        this.indent(this.indentLevel);
        this.responseBuffer.append("-->\n");
    }

    public void closeElements(String string, boolean bl) {
        if (this.openElementStack != null && this.openElementStack.size() > 0) {
            while (this.openElementStack.size() > 0) {
                String string2 = (String)this.openElementStack.get(0);
                if (!string2.equals(string)) {
                    this.closeElements(1);
                    continue;
                }
                if (!bl) break;
                this.closeElements(1);
                break;
            }
        }
    }

    public void closeElement(String string) {
        this.closeElements(string, true);
    }

    public void closeElements(int n) {
        int n2 = this.openElementStack.size();
        if (n == -1 || n > n2) {
            n = n2;
        }
        for (int i = 0; i < n; ++i) {
            this.indent(--this.indentLevel);
            String string = (String)this.openElementStack.remove(0);
            this.responseBuffer.append(this.end(string));
        }
    }

    private StringBuffer end(String string) {
        return new StringBuffer("</").append(string).append(">\n");
    }

    private void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.responseBuffer.append(INDENTATION);
        }
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.responseBuffer.toString());
            this.writer.flush();
            this.responseBuffer = new StringBuffer();
        }
    }
}

