/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class XMLHelper {
    static int[] specialChars;
    static int[] msSpecialChars;
    static String[] encodedChars;
    static String[] msEncodedChars;
    static Map encodedXmlCharMap;
    static Map msEncodedXmlCharMap;

    private static final boolean isValidXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return ' ' < c && c <= '\ud7ff' || '\ue000' < c && c <= '\ufffd' || '\u10000' < c && c <= '\u10ffff';
    }

    public static String lookupEncodedXmlChar(char c) {
        String string = null;
        Object v = encodedXmlCharMap.get(new Integer(c));
        if (v != null) {
            string = v.toString();
        } else if (!Character.isIdentifierIgnorable(c) && XMLHelper.isValidXMLChar(c)) {
            string = XMLHelper.lookupMsEncodedXmlChar(c);
            if (string == null) {
                string = String.valueOf(c);
            }
        } else {
            string = " ";
        }
        return string;
    }

    public static String lookupMsEncodedXmlChar(char c) {
        Object v = msEncodedXmlCharMap.get(new Integer(c));
        return v != null ? v.toString() : null;
    }

    public static final StringBuffer transformToXMLStringBuffer(String string) throws IOException {
        char[] cArray;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && (cArray = string.toCharArray()) != null) {
            for (int i = 0; i < cArray.length; ++i) {
                stringBuffer.append(XMLHelper.lookupEncodedXmlChar(cArray[i]));
            }
        }
        return stringBuffer;
    }

    public static final String transformToXMLString(String string) throws IOException {
        return XMLHelper.transformToXMLStringBuffer(string).toString();
    }

    static {
        int n;
        specialChars = new int[]{60, 38, 39, 34};
        msSpecialChars = new int[]{38, 133, 8226, 8216, 145, 8217, 146, 8220, 147, 8221, 148, 149, 8211, 150, 8212, 151, 8482, 153, 169, 174};
        encodedChars = new String[]{"&lt;", "&amp;", "&apos;", "&quot;"};
        msEncodedChars = new String[]{"&#38;", "&#133;", "&#8243;", "&#039;", "&#039;", "&#039;", "&#039;", "&#034;", "&#034;", "&#034;", "&#034;", "&#149;", "&#150;", "&#150;", "&#151;", "&#151;", "&#153;", "&#153;", "&#169;", "&#174;"};
        encodedXmlCharMap = new HashMap();
        msEncodedXmlCharMap = new HashMap();
        for (n = 0; n < specialChars.length; ++n) {
            encodedXmlCharMap.put(new Integer(specialChars[n]), encodedChars[n]);
        }
        for (n = 0; n < msSpecialChars.length; ++n) {
            msEncodedXmlCharMap.put(new Integer(msSpecialChars[n]), msEncodedChars[n]);
        }
    }
}

