/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import com.luna.insight.core.insightwizard.util.InsightWizardUtils;
import com.luna.insight.core.util.CoreException;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.FactoryConfigurationError;
import com.luna.insight.core.util.XMLDomConstants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDomBuilderFactory
implements XMLDomConstants {
    private static ThreadLocal domBuilderFactory = new ThreadLocal(){

        protected Object initialValue() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute("http://xml.org/sax/features/validation", Boolean.TRUE);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
            documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            try {
                documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema.dtd");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FactoryConfigurationError(illegalArgumentException);
            }
            return documentBuilderFactory;
        }
    };
    private static final ErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandler(){

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    };

    public static DocumentBuilder getDocumentBuilder() {
        return XMLDomBuilderFactory.getDocumentBuilder(null, null, null);
    }

    public static DocumentBuilder getDocumentBuilder(EntityResolver entityResolver) {
        return XMLDomBuilderFactory.getDocumentBuilder(null, null, entityResolver);
    }

    public static DocumentBuilder getDocumentBuilder(InputStream inputStream) {
        return XMLDomBuilderFactory.getDocumentBuilder(null, inputStream, null);
    }

    public static DocumentBuilder getDocumentBuilder(String string) throws CoreException {
        return XMLDomBuilderFactory.getDocumentBuilder(null, CoreUtilities.getResourceAsStream(string), null);
    }

    public static DocumentBuilder getDocumentBuilder(ErrorHandler errorHandler, InputStream inputStream, EntityResolver entityResolver) {
        try {
            DocumentBuilderFactory documentBuilderFactory = (DocumentBuilderFactory)domBuilderFactory.get();
            if (inputStream != null) {
                documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (errorHandler == null) {
                errorHandler = DEFAULT_ERROR_HANDLER;
            }
            documentBuilder.setErrorHandler(errorHandler);
            if (entityResolver == null) {
                entityResolver = new EntityResolver(){

                    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                        return InsightWizardUtils.resolveEntity(string, string2);
                    }
                };
            }
            documentBuilder.setEntityResolver(entityResolver);
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FactoryConfigurationError(parserConfigurationException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            long l = System.currentTimeMillis();
            DocumentBuilder documentBuilder = XMLDomBuilderFactory.getDocumentBuilder(null, null, null);
            Document document = documentBuilder.parse(new File(stringArray[0]));
            NodeList nodeList = document.getElementsByTagName("field");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                System.out.println();
                System.out.println("=================================================================");
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Object object;
                    Node node2 = nodeList2.item(j);
                    if (node2.hasChildNodes()) {
                        object = node2.getChildNodes();
                        Node node3 = object.item(0);
                        System.out.println(node2.getNodeName() + ": " + node3.getNodeValue() + "");
                        continue;
                    }
                    if (node2.getNodeName().equals("#text")) continue;
                    object = node2.getAttributes();
                    System.out.print(node2.getNodeName() + ":");
                    for (int k = 0; k < object.getLength(); ++k) {
                        Node node4 = object.item(k);
                        System.out.print((k > 0 ? ", " : " ") + node4.getNodeName() + " = " + node4.getNodeValue());
                    }
                    System.out.println();
                }
            }
            System.out.println("execution elapsed time: " + (System.currentTimeMillis() - l) + " ms.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        InsightWizardUtils.registerInputSourceMapping("http://www.lunaimaging.com/xsd/catalog-template-1.0.xsd", "xml/catalog-template-1.0.xsd");
    }
}

