/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import com.luna.insight.core.insightwizard.util.InsightWizardUtils;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.FloatingDecimal;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ObjectDimension
implements Serializable {
    static final long serialVersionUID = 1123574693295519930L;
    public static final int VIRTUAL_MAXIMUM = 10000;
    public static final String METRIC_FEET = "FEET";
    public static final String METRIC_INCHES = "INCHES";
    public static final String METRIC_METERS = "METERS";
    public static final String METRIC_CENTIMETERS = "CENTIMETERS";
    public static final int NO_METRIC = 0;
    public static final int FEET = 1;
    public static final int INCHES = 2;
    public static final int METERS = 3;
    public static final int CENTIMETERS = 4;
    public static final int DEFAULT_METRIC = 2;
    public static final float[] CONVERSION_FACTORS = new float[]{1.0f, 30.48f, 2.54f, 100.0f, 1.0f};
    protected static final Hashtable METRIC_NAME_MAP = new Hashtable();
    protected static final List WIDTH_QUALIFIERS = new Vector();
    protected static final List HEIGHT_QUALIFIERS = new Vector();
    public long objectID;
    public long imageID;
    public float width = -1.0f;
    public float height = -1.0f;
    public int metric = 2;
    protected boolean widthValid = false;
    protected boolean heightValid = false;
    protected Point vPoint = null;
    protected Point hPoint = null;
    protected int vLineLength = 0;
    protected int hLineLength = 0;
    protected boolean vLineDef = false;
    protected boolean hLineDef = false;

    public static void main(String[] stringArray) {
        InsightWizardUtils.setDebugLevel(5);
        String string = "feet,ft,f=1;inch,inches:1;meter,m,mtr=3;centimeters,cm,c=4";
        ObjectDimension.initMetricNameMap(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initMetricNameMap(String string) {
        if (CoreUtilities.isNonEmpty(string)) {
            Hashtable hashtable = METRIC_NAME_MAP;
            synchronized (hashtable) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";/\\", false);
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                Integer n = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=:", false);
                    string3 = null;
                    string5 = null;
                    if (stringTokenizer2.hasMoreTokens()) {
                        string3 = stringTokenizer2.nextToken();
                    }
                    if (stringTokenizer2.hasMoreTokens()) {
                        string5 = stringTokenizer2.nextToken();
                    }
                    if (!CoreUtilities.isNonEmpty(string3) || !CoreUtilities.isNonEmpty(string5)) continue;
                    try {
                        n = new Integer(Integer.parseInt(string5));
                        if (!ObjectDimension.isMetricValid(n)) continue;
                        StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ",", false);
                        while (stringTokenizer3.hasMoreTokens()) {
                            string4 = stringTokenizer3.nextToken();
                            string4 = string4.toLowerCase();
                            METRIC_NAME_MAP.put(string4, n);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    public static boolean isMetricValid(int n) {
        return n > 0 && n < CONVERSION_FACTORS.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMetric(String string, int n) {
        int n2 = n;
        if (string != null) {
            string = string.toLowerCase();
            Hashtable hashtable = METRIC_NAME_MAP;
            synchronized (hashtable) {
                Integer n3 = (Integer)METRIC_NAME_MAP.get(string);
                if (n3 != null && !ObjectDimension.isMetricValid(n2 = n3.intValue())) {
                    n2 = n;
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDimensionQualifiers(String string, String string2) {
        StringTokenizer stringTokenizer;
        List list;
        if (CoreUtilities.isNonEmpty(string)) {
            list = WIDTH_QUALIFIERS;
            synchronized (list) {
                WIDTH_QUALIFIERS.clear();
                string = string.toLowerCase();
                stringTokenizer = new StringTokenizer(string, ";,:", false);
                while (stringTokenizer.hasMoreTokens()) {
                    WIDTH_QUALIFIERS.add(stringTokenizer.nextToken());
                }
            }
        }
        if (CoreUtilities.isNonEmpty(string2)) {
            list = HEIGHT_QUALIFIERS;
            synchronized (list) {
                HEIGHT_QUALIFIERS.clear();
                string2 = string2.toLowerCase();
                stringTokenizer = new StringTokenizer(string2, ";,:", false);
                while (stringTokenizer.hasMoreTokens()) {
                    HEIGHT_QUALIFIERS.add(stringTokenizer.nextToken());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWidthDimension(String string) {
        if (CoreUtilities.isNonEmpty(string)) {
            List list = WIDTH_QUALIFIERS;
            synchronized (list) {
                string = string.toLowerCase();
                if (WIDTH_QUALIFIERS != null) {
                    return WIDTH_QUALIFIERS.contains(string);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHeightDimension(String string) {
        if (CoreUtilities.isNonEmpty(string)) {
            List list = HEIGHT_QUALIFIERS;
            synchronized (list) {
                string = string.toLowerCase();
                if (HEIGHT_QUALIFIERS != null) {
                    return HEIGHT_QUALIFIERS.contains(string);
                }
            }
        }
        return false;
    }

    public static float getConversionFactor(int n) {
        if (n >= 0 && n < CONVERSION_FACTORS.length) {
            return CONVERSION_FACTORS[n];
        }
        return CONVERSION_FACTORS[0];
    }

    public static float convertMetric(float f, int n, int n2) {
        float f2 = f;
        if (n != 0 && n2 != 0) {
            f2 *= CONVERSION_FACTORS[n];
            f2 /= CONVERSION_FACTORS[n2];
        }
        return f2;
    }

    public static float convertMetricArea(float f, int n, int n2) {
        float f2 = f;
        if (n != 0 && n2 != 0) {
            f2 = (float)((double)f2 * Math.pow(CONVERSION_FACTORS[n], 2.0));
            f2 = (float)((double)f2 / Math.pow(CONVERSION_FACTORS[n2], 2.0));
        }
        return f2;
    }

    public static int translateToVirtual(int n, int n2) {
        return Math.round((float)n * 10000.0f / (float)n2);
    }

    public static int translateToActual(int n, int n2) {
        return Math.round((float)n * (float)n2 / 10000.0f);
    }

    public static float parseFloat(String string) throws NumberFormatException {
        if (string == null) {
            string = "";
        }
        return FloatingDecimal.readJavaFormatString((String)string).floatValue();
    }

    public static double parseDouble(String string) throws NumberFormatException {
        if (string == null) {
            string = "";
        }
        return FloatingDecimal.readJavaFormatString((String)string).doubleValue();
    }

    public ObjectDimension() {
    }

    public ObjectDimension(long l) {
        this.imageID = l;
    }

    public ObjectDimension(long l, long l2, String string, String string2, int n) {
        this.objectID = l;
        this.imageID = l2;
        this.metric = n;
        this.convertDimension(string, string2);
    }

    public ObjectDimension(ObjectDimension objectDimension) {
        this.objectID = objectDimension.objectID;
        this.imageID = objectDimension.imageID;
        this.widthValid = objectDimension.widthValid;
        this.heightValid = objectDimension.heightValid;
        this.width = objectDimension.width;
        this.height = objectDimension.height;
        this.metric = objectDimension.metric;
        this.vPoint = new Point(objectDimension.vPoint);
        this.hPoint = new Point(objectDimension.hPoint);
        this.vLineLength = objectDimension.vLineLength;
        this.hLineLength = objectDimension.hLineLength;
        this.vLineDef = objectDimension.vLineDef;
        this.hLineDef = objectDimension.hLineDef;
    }

    public boolean isValid() {
        return this.widthValid && this.heightValid;
    }

    public boolean isWidthValid() {
        return this.widthValid;
    }

    public boolean isHeightValid() {
        return this.heightValid;
    }

    public boolean isVtLineDefined() {
        return this.vLineDef;
    }

    public boolean isHzLineDefined() {
        return this.hLineDef;
    }

    public void setHLineLength(int n) {
        this.hLineLength = n;
    }

    public void setVLineLength(int n) {
        this.vLineLength = n;
    }

    public void setHzLine(int n, Point point, Dimension dimension) {
        this.hLineLength = ObjectDimension.translateToVirtual(n, dimension.width);
        this.hPoint = new Point(ObjectDimension.translateToVirtual(point.x, dimension.width), ObjectDimension.translateToVirtual(point.y, dimension.height));
        this.hLineDef = this.hLineLength >= 0;
    }

    public void setVtLine(int n, Point point, Dimension dimension) {
        this.vLineLength = ObjectDimension.translateToVirtual(n, dimension.height);
        this.vPoint = new Point(ObjectDimension.translateToVirtual(point.x, dimension.width), ObjectDimension.translateToVirtual(point.y, dimension.height));
        this.vLineDef = this.vLineLength >= 0;
    }

    public int getHzLineLength(Dimension dimension) {
        if (this.hLineDef) {
            return ObjectDimension.translateToActual(this.hLineLength, dimension.width);
        }
        return dimension.width;
    }

    public int getVtLineLength(Dimension dimension) {
        if (this.vLineDef) {
            return ObjectDimension.translateToActual(this.vLineLength, dimension.height);
        }
        return dimension.height;
    }

    public Point getHzLinePoint(Dimension dimension) {
        if (this.hLineDef) {
            return new Point(ObjectDimension.translateToActual(this.hPoint.x, dimension.width), ObjectDimension.translateToActual(this.hPoint.y, dimension.height));
        }
        return new Point(0, 0);
    }

    public Point getVtLinePoint(Dimension dimension) {
        if (this.vLineDef) {
            return new Point(ObjectDimension.translateToActual(this.vPoint.x, dimension.width), ObjectDimension.translateToActual(this.vPoint.y, dimension.height));
        }
        return new Point(0, 0);
    }

    public String toString() {
        if (this.isValid()) {
            return "ObjectDimension [objectID=" + this.objectID + "; imageID=" + this.imageID + "; w=" + this.width + "; h=" + this.height + "; metric=" + this.metric + "]";
        }
        return "ObjectDimension [INVALID objectID=" + this.objectID + "; imageID=" + this.imageID + "; w=" + this.width + "; h=" + this.height + "; metric=" + this.metric + "]";
    }

    public void convertDimension(String string, String string2, String string3, String string4, int n) {
        if (!ObjectDimension.isMetricValid(n)) {
            n = 2;
        }
        this.convertDimension(string, string3);
        int n2 = ObjectDimension.getMetric(string2, n);
        int n3 = ObjectDimension.getMetric(string4, n);
        if (n2 != n3 && this.isWidthValid()) {
            this.width = ObjectDimension.convertMetric(this.width, n2, n3);
        }
        this.metric = n3;
    }

    public void convertDimension(String string, String string2) {
        this.convertWidth(string);
        this.convertHeight(string2);
    }

    public void convertWidth(String string) {
        this.widthValid = false;
        try {
            this.width = ObjectDimension.parseFloat(string);
            this.widthValid = this.width > 0.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void convertHeight(String string) {
        this.heightValid = false;
        try {
            this.height = ObjectDimension.parseFloat(string);
            this.heightValid = this.height > 0.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void convertMetric(int n) {
        if (this.metric != n && n != 0) {
            if (this.metric != 0) {
                if (this.isWidthValid()) {
                    this.width = ObjectDimension.convertMetric(this.width, this.metric, n);
                }
                if (this.isHeightValid()) {
                    this.height = ObjectDimension.convertMetric(this.height, this.metric, n);
                }
            }
            this.metric = n;
        }
    }

    public static int getMetricFromString(String string) {
        int n = 4;
        if (METRIC_FEET.equalsIgnoreCase(string)) {
            n = 1;
        } else if (METRIC_INCHES.equalsIgnoreCase(string)) {
            n = 2;
        } else if (METRIC_METERS.equalsIgnoreCase(string)) {
            n = 3;
        } else if (METRIC_CENTIMETERS.equalsIgnoreCase(string)) {
            n = 4;
        }
        return n;
    }
}

