/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.io.Serializable;
import javax.swing.JPanel;

public class FontDescriptor
implements Serializable {
    static final long serialVersionUID = 5394926733558382723L;
    protected FontMetrics metrics;
    protected Font font;

    public FontDescriptor(Font font) {
        this.font = font;
    }

    public FontDescriptor(String string, int n, int n2) {
        this(new Font(string, n, n2));
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.metrics == null ? (this.metrics = new JPanel().getFontMetrics(this.font)) : this.metrics;
    }

    public String getName() {
        return this.font.getName();
    }

    public int getStyle() {
        return this.font.getStyle();
    }

    public int getSize() {
        return this.font.getSize();
    }

    public String getFamily() {
        return this.font.getFamily();
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public String getPostScriptName() {
        return this.font.getPSName();
    }

    public int getGlyphCount() {
        return this.font.getNumGlyphs();
    }

    public int getMissingGlyphCode() {
        return this.font.getMissingGlyphCode();
    }

    public String toString() {
        return "FontDescriptor:: name: " + this.getName() + ", style: " + this.getStyle() + ", size: " + this.getSize();
    }

    public int getFontHeight() {
        FontMetrics fontMetrics = this.getFontMetrics();
        return fontMetrics.getHeight();
    }

    public int getDisplayWidth(String string) {
        FontMetrics fontMetrics = this.getFontMetrics();
        return fontMetrics.bytesWidth(string.getBytes(), 0, string.length());
    }
}

