/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import com.luna.insight.core.iface.CoreConsts;
import com.luna.insight.core.iface.Theme;
import com.luna.insight.core.insightwizard.gui.util.ColorPicker;
import com.luna.insight.core.theme.ThemeImageCreator;
import com.luna.insight.core.util.CoreUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;

public class DefaultTheme
implements Serializable,
Theme,
CoreConsts {
    public static final String CMM_THEME_SUFFIX = ".thm";
    public static final int PREVIEW_WIDTH = 803;
    public static final int PREVIEW_HEIGHT = 590;
    public static final transient String THEME_DIR = "Theme-Templates";
    public static final transient Hashtable themeTable = new Hashtable();
    public static boolean resampleDuringResize = true;
    static final long serialVersionUID = 4982336553720503637L;
    protected String name;
    protected String description;
    protected String bgSource;
    protected Color bgBlendColor = ColorPicker.getDEFAULT_COLOR();
    protected Color bgFillColor = null;
    protected long crcValue = 0L;
    protected transient ImageIcon preview;
    protected transient String collectionName;
    protected transient boolean custom;

    public static void setResampleDuringResize(boolean bl) {
        resampleDuringResize = bl;
    }

    public static long calculateThemeCRC(ImageIcon imageIcon) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static String[] getAvailableThemes(String string) {
        String string2;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
            return CoreConsts.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return file2.getName().endsWith(DefaultTheme.CMM_THEME_SUFFIX);
            }
        });
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n].substring(0, stringArray[n].length() - CMM_THEME_SUFFIX.length());
        }
        DefaultTheme.checkThemeCache(string, stringArray);
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n].substring(0, stringArray[n].length() - CMM_THEME_SUFFIX.length());
            arrayList.add(string2);
        }
        return arrayList.toArray(stringArray);
    }

    protected static void checkThemeCache(final String string, final String[] stringArray) {
        Thread thread = new Thread("Theme Loader"){

            public void run() {
                try {
                    2.sleep(100L);
                    for (int i = 0; i < stringArray.length; ++i) {
                        Theme theme = DefaultTheme.getTheme(string, stringArray[i]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    CoreUtilities.logException("themeloader", interruptedException);
                }
            }
        };
        thread.setPriority(5);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme getTheme(String string, String string2) {
        Theme theme;
        if (!themeTable.containsKey(string2) && (theme = DefaultTheme.loadTheme(string, string2)) != null) {
            Hashtable hashtable = themeTable;
            synchronized (hashtable) {
                themeTable.put(string2, theme);
            }
        }
        return (Theme)themeTable.get(string2);
    }

    public String createThemeImagesZip(Theme theme) {
        return this.createThemeImagesZip(THEME_DIR, theme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createThemeImagesZip(String string, Theme theme) {
        String string2;
        block17: {
            CoreUtilities.logInfo("Creating a theme images zip. Theme directory name = " + string + ", Theme name = " + theme.getName());
            string2 = null;
            String string3 = string;
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            File file = new File(this.getThemeImagesDir(string, theme, false));
            File[] fileArray = file.listFiles();
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            String string4 = string3 + URLEncoder.encode(theme.getName(), "UTF-8") + ".zip";
            fileOutputStream = new FileOutputStream(string4);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            byte[] byArray = new byte[1024];
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                fileInputStream = new FileInputStream(fileArray[i]);
                zipOutputStream.putNextEntry(new ZipEntry(fileArray[i].getName()));
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                fileInputStream.close();
            }
            zipOutputStream.close();
            string2 = string4;
            Object var15_15 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block17;
            }
            catch (Exception exception) {}
            break block17;
            {
                catch (Exception exception) {
                    CoreUtilities.logException(exception);
                    Object var15_16 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block17;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string2;
    }

    public String getThemeImagesDir(String string, Theme theme, boolean bl) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        try {
            string = string + URLEncoder.encode(theme.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        boolean bl2 = true;
        File file = new File(string);
        if (bl) {
            if (file.exists() && !file.isDirectory()) {
                bl2 = file.delete();
            } else if (!file.exists()) {
                bl2 = file.mkdirs();
            }
        }
        return bl2 ? string : null;
    }

    protected void generateThemePreview(Theme theme) {
        this.generateThemePreview(THEME_DIR, theme);
    }

    protected void generateThemePreview(String string, Theme theme) {
        String string2 = string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        ThemeImageCreator themeImageCreator = new ThemeImageCreator(resampleDuringResize);
        themeImageCreator.setDestinationDir(string2);
        themeImageCreator.setBgImage(theme.getBGImageSource());
        themeImageCreator.create(803, 590, false);
        ((DefaultTheme)theme).setBackgroundImage(((DefaultTheme)theme).getPreviewDiskImage());
    }

    protected void generateThemeImages(Theme theme) {
        this.generateThemeImages(THEME_DIR, theme);
    }

    protected void generateThemeImages(String string, Theme theme) {
        String string2 = this.getThemeImagesDir(string, theme, true);
        ThemeImageCreator themeImageCreator = new ThemeImageCreator(resampleDuringResize);
        themeImageCreator.setDestinationDir(string2);
        themeImageCreator.setBgImage(theme.getBGImageSource());
        themeImageCreator.create(803, 590);
        ((DefaultTheme)theme).setFillColor(themeImageCreator.getBlendColor());
        ((DefaultTheme)theme).setBackgroundImage(theme.getBackgroundImage());
    }

    public boolean saveTheme(String string, String string2, Theme theme) {
        return this.saveTheme(string, string2, theme, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean saveTheme(String string, String string2, Theme theme, boolean bl) {
        DefaultTheme.checkThemeDir(string);
        CoreUtilities.logInfo("saving a theme: theme directory name = " + string + ", theme name = " + theme.getName());
        if (theme != null) {
            this.generateThemeImages(theme);
            if (bl) {
                return true;
            }
            if (string2 == null) {
                string2 = theme.getName();
            }
            if (!string2.endsWith(CMM_THEME_SUFFIX)) {
                string2 = string2 + CMM_THEME_SUFFIX;
            }
            File file = new File(string);
            File file2 = new File(file, string2);
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(theme);
            objectOutputStream.close();
            fileOutputStream.close();
            DefaultTheme.getTheme(string, theme.getName());
            boolean bl2 = file2.exists();
            Object var11_11 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl2;
            catch (Exception exception) {
                try {
                    CoreUtilities.logInfo("ctm: " + exception);
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception3) {}
            }
        }
        return false;
    }

    public static Theme loadTheme(String string, String string2) {
        File file;
        File file2;
        CoreUtilities.logInfo("DefaultTheme: loadTheme(..): themeDirName = " + string);
        Theme theme = null;
        if (!DefaultTheme.checkThemeDir(string) || string2 == null) {
            return null;
        }
        if (!string2.endsWith(CMM_THEME_SUFFIX)) {
            string2 = string2 + CMM_THEME_SUFFIX;
        }
        if ((file2 = new File(file = new File(string), string2)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                theme = (Theme)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
                ((DefaultTheme)theme).setBackgroundImage(theme.getBackgroundImage());
            }
            catch (Exception exception) {
                CoreUtilities.logException("Exception in load(): ", exception);
            }
        } else {
            CoreUtilities.logInfo("File is missing: " + string2);
        }
        return theme;
    }

    private static boolean checkThemeDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
            return false;
        }
        return true;
    }

    public DefaultTheme(String string, String string2) {
        this.name = string;
        this.description = string2;
        this.custom = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getBGImageSource() {
        return this.bgSource;
    }

    public ImageIcon getPreviewDiskImage() {
        ImageIcon imageIcon = new ImageIcon(this.getPreviewImageFileName().replace(File.separatorChar, '/'));
        imageIcon.getImage().flush();
        return imageIcon;
    }

    public ImageIcon getBackgroundImage() {
        return this.getBackgroundImage(THEME_DIR);
    }

    public ImageIcon getBackgroundImage(String string) {
        if (this.preview == null) {
            ImageIcon imageIcon = new ImageIcon(this.getBackgroundImageFileName(string).replace(File.separatorChar, '/'));
            imageIcon.getImage().flush();
            this.setPreviewImage(imageIcon);
        }
        return this.preview;
    }

    public String getBackgroundImageFileName(String string) {
        return this.getThemeImagesDir(string, this, false) + File.separator + "insightbackground.jpg";
    }

    public String getPreviewImageFileName() {
        return this.getPreviewImageFileName(THEME_DIR);
    }

    public String getPreviewImageFileName(String string) {
        String string2 = string;
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            string2 = string2 + "insightbackground.jpg";
        }
        return string2;
    }

    public void setBackgroundImage(ImageIcon imageIcon) {
        this.setCRC(imageIcon);
        this.setPreviewImage(imageIcon);
    }

    public void setCRC(ImageIcon imageIcon) {
        this.crcValue = DefaultTheme.calculateThemeCRC(imageIcon);
    }

    public void setPreviewImage(ImageIcon imageIcon) {
        this.setPreviewImage(imageIcon, 803, 590);
    }

    public void setPreviewImage(ImageIcon imageIcon, int n, int n2) {
        this.preview = new ImageIcon(imageIcon.getImage().getScaledInstance(n, n2, 2));
        while (this.preview.getImageLoadStatus() != 8 && this.preview.getImageLoadStatus() != 4) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ImageIcon getPreviewImage() {
        return this.preview != null ? this.preview : null;
    }

    public void setBackgroundImage(String string) {
        this.bgSource = string;
        this.generateThemePreview(this);
    }

    public Dimension getBackgroundDimension() {
        return this.getBackgroundDimension(THEME_DIR);
    }

    public Dimension getBackgroundDimension(String string) {
        ImageIcon imageIcon = this.getBackgroundImage(string);
        return imageIcon != null ? new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()) : new Dimension(0, 0);
    }

    public boolean isCustom() {
        return this.isCustom();
    }

    public Color getBlendColor() {
        return this.bgBlendColor;
    }

    public void setBlendColor(Color color) {
        this.bgBlendColor = color;
        this.generateThemePreview(this);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String string) {
        this.collectionName = string;
    }

    public long getCRCValue() {
        return this.crcValue;
    }

    public void setCRCValue(long l) {
        this.crcValue = l;
    }

    public void setFillColor(Color color) {
        this.bgFillColor = color;
    }

    public Color getFillColor() {
        return this.bgFillColor;
    }
}

