/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import com.luna.insight.core.iface.UIResourceBundle;
import com.luna.insight.core.util.CoreException;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.FontDescriptor;
import com.luna.insight.core.util.ObjectDimension;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class BaseResourceBundle
extends ResourceBundle
implements Serializable,
UIResourceBundle {
    static final long serialVersionUID = -2904220918587373795L;
    protected static boolean SHOW_ALL_DEBUG = false;
    public static final String PROPERTY_PREFIX = "P_";
    public static final String DISPLAY_PREFIX = "D_";
    public static final String TEXT_PREFIX = "T_";
    public static final String TOOLTIP_PREFIX = "TT_";
    public static final String VERSION = "P_VERSION";
    public static final String LANGUAGE_CODE = "P_LANGUAGE_CODE";
    public static final String COUNTRY_CODE = "P_COUNTRY_CODE";
    public static final String BUNDLE_PREFIX = "P_BUNDLE_PREFIX";
    public static final String FONT_URL = "P_FONT_URL";
    public static final String USE_IME = "P_USE_IME";
    public static final String MENU_HEIGHT = "D_MENU_HEIGHT";
    public static final String GW_BOTTOM_OFFSET = "D_GW_BOTTOM_OFFSET";
    public static final String BOLD_ALLOWED = "D_BOLD_ALLOWED";
    public static final String CHAR_ENCODING = "D_CHAR_ENCODING";
    public static final String MIN_HTML_FONT_SIZE = "D_MIN_HTML_FONT_SIZE";
    public static final String METRIC_FEET = "FEET";
    public static final String METRIC_INCHES = "INCHES";
    public static final String METRIC_METERS = "METERS";
    public static final String METRIC_CENTIMETERS = "CENTIMETERS";
    public static final String DEFAULT_METRIC = "D_DEFAULT_METRIC";
    public static final String TITLE_FONT = "D_TITLE_FONT";
    public static final String ALT_TITLE_FONT = "D_ALT_TITLE_FONT";
    public static final String BUTTON_FONT = "D_BUTTON_FONT";
    public static final String TEXT_FONT = "D_TEXT_FONT";
    public static final String ALT_TEXT_FONT = "D_ALT_TEXT_FONT";
    public static final String SMALL_FONT = "D_SMALL_FONT";
    public static final String STORY_FONT = "D_STORY_FONT";
    public static final String PRINT_FONT = "D_PRINT_FONT";
    public static final String PRINT_HEADLINE_FONT = "D_PRINT_HEADLINE_FONT";
    public static final String FONT_NAME = "_NAME";
    public static final String FONT_STYLE = "_STYLE";
    public static final String FONT_SIZE = "_SIZE";
    protected static final String FONT_STYLE_PLAIN = "FONT_STYLE_PLAIN";
    protected static final String FONT_STYLE_BOLD = "FONT_STYLE_BOLD";
    protected static final String FONT_STYLE_ITALIC = "FONT_STYLE_ITALIC";
    public static final String BLUE = "T_BLUE";
    public static final String ORANGE = "T_ORANGE";
    public static final String YELLOW = "T_YELLOW";
    public static final String LIME_GREEN = "T_LIME_GREEN";
    public static final String TURQUOISE = "T_TURQUOISE";
    public static final String RED = "T_RED";
    public static final String MAGENTA = "T_MAGENTA";
    public static final String LIGHT_BLUE = "T_LIGHT_BLUE";
    public static final String MAUVE = "T_MAUVE";
    public static final String TAN = "T_TAN";
    public static final String OLIVE = "T_OLIVE";
    public static final String ANCILLARY_DATA_NOT_FOUND = "T_T_ANCILLARY_DATA_NOT_FOUND";
    public static final String CANCEL = "T_CANCEL";
    public static final String CONFIRM_NEW_FONT_TITLE_BAR = "T_CONFIRM_NEW_FONT_TITLE_BAR";
    public static final String FONT_DOWNLOAD_INSTRUCTIONS = "T_FONT_DOWNLOAD_INSTRUCTIONS";
    public static final String FONT_DOWNLOAD_INSTRUCTIONS_TITLE_BAR = "T_FONT_DOWNLOAD_INSTRUCTIONS_TITLE_BAR";
    public static final String IS_TEXT_LEGIBLE = "T_IS_TEXT_LEGIBLE";
    public static final String NO = "T_NO";
    public static final String OK = "T_OK";
    public static final String OK_LC = "T_OK_LC";
    public static final String SPACE_CHAR = "T_SPACE_CHAR";
    public static final String YES = "T_YES";
    public static final String VERIFICATION_TEST_STRING = "T_VERIFICATION_TEST_STRING";
    public int version;
    public String bundlePrefix;
    public String languageCode;
    public String countryCode;
    public String fontUrl;
    protected int menuHeight;
    protected int gwBottomOffset;
    protected boolean boldAllowed;
    protected String charEncoding;
    protected int minHtmlFontSize;
    protected int defaultMetric;
    protected FontDescriptor titleFont;
    protected FontDescriptor altTitleFont;
    protected FontDescriptor buttonFont;
    protected FontDescriptor textFont;
    protected FontDescriptor altTextFont;
    protected FontDescriptor smallFont;
    protected FontDescriptor storyFont;
    protected FontDescriptor printFont;
    protected FontDescriptor printHeadlineFont;
    protected Hashtable cachedProps = null;
    protected transient Properties loadingProps = null;
    protected boolean propertiesLoaded = false;
    protected boolean cached = false;

    public static void doMain(String[] stringArray) {
        CoreUtilities.setDebugLevel(5);
        String string = "";
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-showAll")) {
                ++i;
                SHOW_ALL_DEBUG = true;
                continue;
            }
            if (stringArray[i].equals("-file")) {
                if (stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                string = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-h") && !stringArray[i].equals("-help") && !stringArray[i].equals("/help") && !stringArray[i].equals("-?") && !stringArray[i].equals("/?") && !stringArray[i].equals("/h")) continue;
            bl = true;
            BaseResourceBundle.showHelp();
        }
        if (string != null && string.length() > 0) {
            BaseResourceBundle.verifyAgainstPropsFile(string);
        } else if (!bl) {
            CoreUtilities.logWarning("No properties file specified.");
            BaseResourceBundle.showHelp();
        }
        System.exit(0);
    }

    public static BaseResourceBundle getInstance(String string) throws CoreException {
        return BaseResourceBundle.getInstance(string, null);
    }

    public static BaseResourceBundle getInstance(String string, Locale locale) throws CoreException {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            String string2 = string + "_" + locale.getLanguage();
            return new BaseResourceBundle(CoreUtilities.readToBytes(string2));
        }
        catch (IOException iOException) {
            throw new CoreException(iOException);
        }
    }

    public static int getFontStyleFromString(String string) {
        int n = 0;
        if (FONT_STYLE_PLAIN.equals(string)) {
            n = 0;
        } else if (FONT_STYLE_BOLD.equals(string)) {
            n = 1;
        } else if (FONT_STYLE_ITALIC.equals(string)) {
            n = 2;
        }
        return n;
    }

    public static void showHelp() {
        System.out.println("\nUsage: ResourceBundle -file <properties file name> [-showAll] \n\n         -file     The path to the properties file to check against.\n         -showAll  Show keys that were found correctly, in ition to\n                   problems found.");
    }

    protected static void verifyAgainstPropsFile(String string) {
        try {
            Enumeration<Object> enumeration;
            BaseResourceBundle baseResourceBundle = new BaseResourceBundle(string);
            Class<?> clazz = baseResourceBundle.getClass();
            Properties properties = new Properties();
            properties.load(new FileInputStream(string));
            Vector<String> vector = new Vector<String>();
            Enumeration<Object> enumeration2 = properties.propertyNames();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                string2 = string2.substring(2);
                string2 = BaseResourceBundle.trimFontSuffix(string2);
                enumeration = null;
                try {
                    enumeration = clazz.getField(string2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    enumeration = null;
                }
                if (enumeration == null) {
                    vector.addElement(new String("NOT DEFINED: Key: " + string2));
                    continue;
                }
                if (!SHOW_ALL_DEBUG) continue;
                vector.addElement(new String("DEFINED:     Key: " + string2));
            }
            CoreUtilities.logInfo("");
            CoreUtilities.logInfo("Keys present in the properties file, but that are not defined strings:");
            if (vector.isEmpty()) {
                CoreUtilities.logInfo("  No spurious keys found.");
            } else {
                enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    CoreUtilities.logInfo((String)enumeration2.nextElement());
                }
            }
            vector = new Vector();
            enumeration2 = clazz.getFields();
            for (int i = 0; i < ((Enumeration<Object>)enumeration2).length; ++i) {
                String string3;
                int n;
                enumeration = enumeration2[i];
                if (!((Field)((Object)enumeration)).getType().equals(Class.forName("java.lang.String")) || !Modifier.isPublic(n = ((Field)((Object)enumeration)).getModifiers()) || !Modifier.isStatic(n) || !Modifier.isFinal(n)) continue;
                String string4 = (String)((Field)((Object)enumeration)).get(baseResourceBundle);
                if (string4.startsWith(DISPLAY_PREFIX) && string4.endsWith("_FONT")) {
                    string3 = string4;
                    string3 = string4 + FONT_NAME;
                    String string5 = properties.getProperty(string3, null);
                    while (string3.length() < 30) {
                        string3 = string3 + " ";
                    }
                    if (string5 == null || string5.length() == 0) {
                        vector.addElement(new String("NOT FOUND:   Key: " + string3 + " Value: " + string5));
                    } else if (SHOW_ALL_DEBUG) {
                        vector.addElement(new String("FOUND:       Key: " + string3 + " Value: " + string5));
                    }
                    string3 = string4 + FONT_SIZE;
                    string5 = properties.getProperty(string3, null);
                    while (string3.length() < 30) {
                        string3 = string3 + " ";
                    }
                    if (string5 == null || string5.length() == 0) {
                        vector.addElement(new String("NOT FOUND:   Key: " + string3 + " Value: " + string5));
                    } else if (SHOW_ALL_DEBUG) {
                        vector.addElement(new String("FOUND:       Key: " + string3 + " Value: " + string5));
                    }
                    string3 = string4 + FONT_STYLE;
                    string5 = properties.getProperty(string3, null);
                    while (string3.length() < 30) {
                        string3 = string3 + " ";
                    }
                    if (string5 == null || string5.length() == 0) {
                        vector.addElement(new String("NOT FOUND:   Key: " + string3 + " Value: " + string5));
                        continue;
                    }
                    if (!SHOW_ALL_DEBUG) continue;
                    vector.addElement(new String("FOUND:       Key: " + string3 + " Value: " + string5));
                    continue;
                }
                string3 = properties.getProperty(string4, null);
                while (string4.length() < 30) {
                    string4 = string4 + " ";
                }
                if (string3 == null || string3.length() == 0) {
                    vector.addElement(new String("NOT FOUND:   Key: " + string4 + " Value: " + string3));
                    continue;
                }
                if (!SHOW_ALL_DEBUG) continue;
                vector.addElement(new String("FOUND:       Key: " + string4 + " Value: " + string3));
            }
            CoreUtilities.logInfo("");
            CoreUtilities.logInfo("Defined key strings not found in the properties file:");
            CoreUtilities.logInfo("  (NOTE: Keys beginning with \"D_\" are optional)");
            if (vector.isEmpty()) {
                CoreUtilities.logInfo("  No missing keys found.");
            } else {
                Enumeration enumeration3 = vector.elements();
                while (enumeration3.hasMoreElements()) {
                    CoreUtilities.logInfo((String)enumeration3.nextElement());
                }
            }
        }
        catch (Exception exception) {
            CoreUtilities.logException("Exception in verifyAgainstPropsFile(): ", exception);
        }
    }

    protected static String trimFontSuffix(String string) {
        if (string.equals("MIN_HTML_FONT_SIZE")) {
            return string;
        }
        if (string.endsWith("_FONT_NAME")) {
            return string.substring(0, string.length() - FONT_NAME.length());
        }
        if (string.endsWith("_FONT_STYLE")) {
            return string.substring(0, string.length() - FONT_STYLE.length());
        }
        if (string.endsWith("_FONT_SIZE")) {
            return string.substring(0, string.length() - FONT_SIZE.length());
        }
        return string;
    }

    public BaseResourceBundle(String string) throws IOException {
        this(new File(string));
    }

    public BaseResourceBundle(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public BaseResourceBundle(InputStream inputStream) throws IOException {
        this.loadProperties(inputStream);
    }

    public BaseResourceBundle() {
        this.cacheProperties();
        this.propertiesLoaded = true;
    }

    public BaseResourceBundle(boolean bl) {
        this();
        this.setCached(bl);
    }

    public void setCached(boolean bl) {
        this.cached = bl;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void terminate() {
        if (this.cached) {
            return;
        }
        this.charEncoding = null;
        this.titleFont = null;
        this.altTitleFont = null;
        this.buttonFont = null;
        this.textFont = null;
        this.altTextFont = null;
        this.smallFont = null;
        this.storyFont = null;
        this.printFont = null;
        this.printHeadlineFont = null;
        this.cachedProps.clear();
        this.cachedProps = null;
    }

    protected void loadProperties(InputStream inputStream) throws IOException {
        this.loadingProps = new Properties();
        this.loadingProps.load(inputStream);
        inputStream.close();
        this.loadProperties();
        this.cacheProperties();
        this.propertiesLoaded = true;
        this.loadingProps = null;
    }

    protected void loadProperties() {
        this.bundlePrefix = this.readProperty(BUNDLE_PREFIX);
        this.languageCode = this.readProperty(LANGUAGE_CODE);
        this.countryCode = this.readProperty(COUNTRY_CODE);
        this.fontUrl = this.readProperty(FONT_URL);
        try {
            this.version = Integer.parseInt(this.readProperty(VERSION));
        }
        catch (Exception exception) {
            this.version = 0;
        }
        try {
            this.menuHeight = Integer.parseInt(this.readProperty(MENU_HEIGHT, "18"));
        }
        catch (Exception exception) {
            this.menuHeight = 18;
        }
        try {
            this.gwBottomOffset = Integer.parseInt(this.readProperty(GW_BOTTOM_OFFSET, "0"));
        }
        catch (Exception exception) {
            this.gwBottomOffset = 0;
        }
        try {
            this.boldAllowed = Integer.parseInt(this.readProperty(BOLD_ALLOWED, "0")) == 1;
        }
        catch (Exception exception) {
            this.boldAllowed = true;
        }
        try {
            this.minHtmlFontSize = Integer.parseInt(this.readProperty(MIN_HTML_FONT_SIZE, "1"));
        }
        catch (Exception exception) {
            this.minHtmlFontSize = 1;
        }
        try {
            this.defaultMetric = ObjectDimension.getMetricFromString(this.readProperty(DEFAULT_METRIC, METRIC_CENTIMETERS));
        }
        catch (Exception exception) {
            this.defaultMetric = 4;
        }
        this.charEncoding = this.readProperty(CHAR_ENCODING, "8859_1");
        this.titleFont = this.readFont(TITLE_FONT, new Font("Sansserif", 1, 12));
        this.altTitleFont = this.readFont(ALT_TITLE_FONT, new Font("Sansserif", 1, 12));
        this.buttonFont = this.readFont(BUTTON_FONT, new Font("Dialog", 1, 12));
        this.textFont = this.readFont(TEXT_FONT, new Font("Sansserif", 1, 11));
        this.altTextFont = this.readFont(ALT_TEXT_FONT, new Font("Sansserif", 1, 11));
        this.smallFont = this.readFont(SMALL_FONT, new Font("Dialog", 1, 10));
        this.storyFont = this.readFont(STORY_FONT, new Font("Dialog", 1, 12));
        this.printFont = this.readFont(PRINT_FONT, new Font("Serif", 0, 10));
        this.printHeadlineFont = this.readFont(PRINT_HEADLINE_FONT, new Font("Sansserif", 1, 13));
    }

    protected void cacheProperties() {
        this.cachedProps = new Hashtable();
        if (this.loadingProps == null) {
            return;
        }
        Enumeration<Object> enumeration = this.loadingProps.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.loadingProps.get(string);
            this.cachedProps.put(string, string2);
        }
    }

    public String readProperty(String string) {
        return this.readProperty(string, null);
    }

    public String readProperty(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string3 = string2;
        }
        return string3;
    }

    public Object handleGetObject(String string) throws MissingResourceException {
        if (!this.propertiesLoaded) {
            if (this.loadingProps != null) {
                return this.loadingProps.get(string);
            }
        } else if (this.cachedProps != null) {
            return this.cachedProps.get(string);
        }
        return null;
    }

    public Enumeration getKeys() {
        if (!this.propertiesLoaded) {
            return this.loadingProps.propertyNames();
        }
        return this.cachedProps.keys();
    }

    public FontDescriptor readFont(String string) {
        return this.readFont(string, null);
    }

    public FontDescriptor readFont(String string, Font font) {
        FontDescriptor fontDescriptor;
        block3: {
            fontDescriptor = null;
            try {
                String string2 = this.getString(string + FONT_NAME);
                int n = BaseResourceBundle.getFontStyleFromString(this.getString(string + FONT_STYLE));
                int n2 = Integer.parseInt(this.getString(string + FONT_SIZE).trim());
                if (string2 != null) {
                    fontDescriptor = new FontDescriptor(string2, n, n2);
                }
            }
            catch (Exception exception) {
                if (font == null) break block3;
                fontDescriptor = new FontDescriptor(font);
            }
        }
        return fontDescriptor;
    }

    public String get(String string) {
        try {
            return (String)this.handleGetObject(string);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getInteger(String string) {
        return this.getInteger(string, 0);
    }

    public int getInteger(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt((String)this.handleGetObject(string));
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    public int getHeightValue(String string) {
        if (string != null) {
            if (string.equals(MENU_HEIGHT)) {
                return this.menuHeight;
            }
            if (string.equals(GW_BOTTOM_OFFSET)) {
                return this.gwBottomOffset;
            }
        }
        return 0;
    }

    public boolean isBoldAllowed() {
        return this.boldAllowed;
    }

    public int getDefaultMetric() {
        return this.defaultMetric;
    }

    public Font getFont(String string) {
        try {
            if (string != null) {
                if (string.equals(TITLE_FONT)) {
                    return this.titleFont.getFont();
                }
                if (string.equals(ALT_TITLE_FONT)) {
                    return this.altTitleFont.getFont();
                }
                if (string.equals(BUTTON_FONT)) {
                    return this.buttonFont.getFont();
                }
                if (string.equals(TEXT_FONT)) {
                    return this.textFont.getFont();
                }
                if (string.equals(ALT_TEXT_FONT)) {
                    return this.altTextFont.getFont();
                }
                if (string.equals(SMALL_FONT)) {
                    return this.smallFont.getFont();
                }
                if (string.equals(STORY_FONT)) {
                    return this.storyFont.getFont();
                }
                if (string.equals(PRINT_FONT)) {
                    return this.printFont.getFont();
                }
                if (string.equals(PRINT_HEADLINE_FONT)) {
                    return this.printHeadlineFont.getFont();
                }
            }
            return this.buttonFont.getFont();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FontDescriptor getFontDescriptor(String string) {
        if (string != null) {
            if (string.equals(TITLE_FONT)) {
                return this.titleFont;
            }
            if (string.equals(ALT_TITLE_FONT)) {
                return this.altTitleFont;
            }
            if (string.equals(BUTTON_FONT)) {
                return this.buttonFont;
            }
            if (string.equals(TEXT_FONT)) {
                return this.textFont;
            }
            if (string.equals(ALT_TEXT_FONT)) {
                return this.altTextFont;
            }
            if (string.equals(SMALL_FONT)) {
                return this.smallFont;
            }
            if (string.equals(STORY_FONT)) {
                return this.storyFont;
            }
            if (string.equals(PRINT_FONT)) {
                return this.printFont;
            }
            if (string.equals(PRINT_HEADLINE_FONT)) {
                return this.printHeadlineFont;
            }
        }
        return this.buttonFont;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public int getMinHtmlFontSize() {
        return this.minHtmlFontSize;
    }

    public boolean equals(BaseResourceBundle baseResourceBundle) {
        boolean bl = false;
        try {
            if (baseResourceBundle == null) {
                bl = false;
            } else if (this.bundlePrefix == baseResourceBundle.bundlePrefix && this.version == baseResourceBundle.version && this.languageCode.equals(baseResourceBundle.languageCode) && this.countryCode.equals(baseResourceBundle.countryCode)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            CoreUtilities.logException("Exception in equals(): ", exception);
            bl = false;
        }
        return bl;
    }
}

