/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.theme;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFrame;

public class ThemeImageTransparentBlend
extends JFrame {
    BufferedImage bi1;
    BufferedImage bi2;
    BufferedImage bImg;

    public ThemeImageTransparentBlend(Image image, Image image2, int n, int n2) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        mediaTracker.addImage(image2, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.bi1 = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = this.bi1.createGraphics();
        graphics2D.drawImage(image, null, null);
        this.bi2 = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 2);
        graphics2D = this.bi2.createGraphics();
        graphics2D.drawImage(image2, null, null);
        this.bImg = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D2 = this.bImg.createGraphics();
        graphics2D2.drawImage(image, 0, 0, null);
        graphics2D2.drawImage(image2, 0, 0, null);
    }

    public void writeJPEG(String string) {
        if (this.bImg != null) {
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                int n = 15;
                if (n < 0) {
                    n = 0;
                } else if (n > 100) {
                    n = 100;
                }
                float f = 1.0f - (float)n / 100.0f;
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(this.bImg);
                jPEGEncodeParam.setQuality(f, true);
                jPEGImageEncoder.encode(this.bImg, jPEGEncodeParam);
                this.bImg.flush();
                this.bImg = null;
                bufferedOutputStream.close();
                System.exit(0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (ImageFormatException imageFormatException) {
                imageFormatException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Float float_ = new Point2D.Float(this.getHeight() / 2, this.getWidth() / 2);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(((Point2D)float_).getX() - (double)(this.bi2.getWidth() / 2), ((Point2D)float_).getY() - (double)(this.bi2.getHeight() / 2));
        graphics2D.transform(affineTransform);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage((Image)this.bi2, 0, 0, null);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.35f);
        graphics2D.setComposite(alphaComposite);
        affineTransform = AffineTransform.getTranslateInstance(((Point2D)float_).getX() - (double)(this.bi1.getWidth() / 2), ((Point2D)float_).getY() - (double)(this.bi1.getHeight() / 2));
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.bi1, 0, 0, null);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null) {
            System.out.println("Usage: com.luna.insight.core.theme.ThemeImageTransparentBlend image1Path image2Path outputname");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        Image image2 = Toolkit.getDefaultToolkit().getImage(string2);
        ThemeImageTransparentBlend themeImageTransparentBlend = new ThemeImageTransparentBlend(image, image2, 803, 590);
        themeImageTransparentBlend.writeJPEG(string3);
        themeImageTransparentBlend.setSize(803, 590);
        themeImageTransparentBlend.setVisible(true);
    }
}

