/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.theme;

import com.luna.insight.core.theme.ThemeImageLayer;
import ij.ImagePlus;
import ij.gui.NewImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;

public class ThemeImageLayerManager
implements ImageObserver {
    private ImagePlus mImage;
    private BufferedImage mBuffer;
    private Hashtable mColorMappers = new Hashtable();

    ThemeImageLayerManager(ThemeImageLayer themeImageLayer) {
        System.out.println("ThemeImageManager constructed");
        this.initNewDisplayImage("ThemeImageLayered Image", themeImageLayer.getWidth(), themeImageLayer.getHeight());
        this.mBuffer = new BufferedImage(themeImageLayer.getWidth(), themeImageLayer.getHeight(), 1);
    }

    public void updateThemeImageLayers(SortedSet sortedSet) {
        try {
            this.drawAllThemeImageLayersToBuffer(sortedSet);
            this.displayBuffer();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            System.out.println("ThemeImageManager caught a ConcurrentModException,\n trying to continue");
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    private void drawAllThemeImageLayersToBuffer(SortedSet sortedSet) {
        this.wipeBuffer();
        int n = 0;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            ++n;
            this.addThemeImageLayerToBuffer((ThemeImageLayer)iterator.next());
        }
    }

    private void initNewDisplayImage(String string, int n, int n2) {
        this.mImage = NewImage.createRGBImage((String)string, (int)n, (int)n2, (int)1, (int)4);
    }

    private void wipeBuffer() {
        Graphics2D graphics2D = (Graphics2D)this.mBuffer.getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.mBuffer.getWidth(), this.mBuffer.getHeight());
    }

    private BufferedImage performImageColorConversion(Image image, ILTColorMapper iLTColorMapper, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[n * i + j] = iLTColorMapper.getColorForRGB(nArray[n * i + j]).getRGB();
            }
        }
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage;
    }

    private void addBufferToBufferWithAlphaAndEffect(BufferedImage bufferedImage, int n, int n2, float f, int n3) {
        Color color = null;
        float f2 = 0.0f;
        int n4 = 0;
        float[] fArray = new float[3];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[4];
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                if (i + n >= this.mBuffer.getWidth() || i + n <= 0 || j + n2 >= this.mBuffer.getHeight() || j + n2 <= 0) continue;
                Color color2 = new Color(bufferedImage.getRGB(i, j));
                Color color3 = new Color(this.mBuffer.getRGB(i + n, j + n2));
                int n5 = (int)((float)color3.getRed() * (1.0f - f * (255.0f - (float)color2.getRed()) / 255.0f));
                int n6 = (int)((float)color3.getGreen() * (1.0f - f * (255.0f - (float)color2.getGreen()) / 255.0f));
                n4 = (int)((float)color3.getBlue() * (1.0f - f * (255.0f - (float)color2.getBlue()) / 255.0f));
                color = new Color(n5, n6, n4);
                this.mBuffer.setRGB(i + n, j + n2, color.getRGB());
            }
        }
    }

    public ImagePlus getIP() {
        return this.mImage;
    }

    private ILTColorMapper getColorMapper(ThemeImageLayer themeImageLayer) {
        ILTColorMapper iLTColorMapper = (ILTColorMapper)this.mColorMappers.get(themeImageLayer);
        if (iLTColorMapper == null) {
            iLTColorMapper = new ILTColorMapper(themeImageLayer);
            this.mColorMappers.put(themeImageLayer, iLTColorMapper);
        } else {
            iLTColorMapper.checkForUpdates(themeImageLayer);
        }
        return iLTColorMapper;
    }

    private void addThemeImageLayerToBuffer(ThemeImageLayer themeImageLayer) {
        ILTColorMapper iLTColorMapper = this.getColorMapper(themeImageLayer);
        BufferedImage bufferedImage = null;
        if (themeImageLayer.getOverlayMode() == 1) {
            bufferedImage = this.performImageColorConversion(themeImageLayer.getImagePlus().getImage(), iLTColorMapper, themeImageLayer.getWidth(), themeImageLayer.getHeight());
            this.addBufferToBufferWithAlphaAndEffect(bufferedImage, themeImageLayer.getXOffset(), themeImageLayer.getYOffset(), themeImageLayer.getAlpha(), themeImageLayer.getOverlayMode());
        }
    }

    private void displayBuffer() {
        int[] nArray = new int[this.mBuffer.getHeight() * this.mBuffer.getWidth()];
        int n = 0;
        int n2 = this.mBuffer.getHeight();
        int n3 = this.mBuffer.getWidth();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray[n] = this.mBuffer.getRGB(j, i);
                ++n;
            }
        }
        this.mImage.getProcessor().setPixels((Object)nArray);
        this.mImage.updateAndDraw();
    }

    class ILTColorMapper {
        public static final int SPECTRUM_256 = 0;
        public static final int CONTINUOUS_2COLOR = 1;
        public static final int ORIGINAL = 2;
        Color[] mLUT;
        float mMin;
        float mMax;
        int mMode;
        Color mC1;
        Color mC2;
        float mMaxPos = (float)Math.sqrt(3.0 * Math.pow(255.0, 2.0));
        int[] mCDiff;
        int mAlphaThreshold = 2;

        public ILTColorMapper(ThemeImageLayer themeImageLayer) {
            if (!themeImageLayer.getUseCustomColors()) {
                this.mMode = 2;
            } else if (themeImageLayer.getOverlayMode() == 1) {
                this.init(themeImageLayer.getColor1(), themeImageLayer.getColor2());
            } else if (themeImageLayer.getOverlayMode() == 2) {
                this.init(themeImageLayer.getContourPlotMinVal(), themeImageLayer.getContourPlotMaxVal(), 0);
            }
        }

        private void init(Color color, Color color2) {
            this.mMode = 1;
            this.mCDiff = new int[3];
            this.mC1 = color;
            this.mC2 = color2;
            this.mCDiff[0] = color2.getRed() - color.getRed();
            this.mCDiff[1] = color2.getGreen() - color.getGreen();
            this.mCDiff[2] = color2.getBlue() - color.getBlue();
            this.initContinuousLut();
        }

        private void init(float f, float f2, int n) {
            this.mMin = f;
            this.mMax = f2;
            float f3 = 0.7f;
            float f4 = 0.0f;
            int n2 = 256;
            this.mMode = n;
            if (n != 0) {
                System.out.println("ILTColorMapper error: unknown mode: " + n);
            } else if (n == 0) {
                this.mLUT = new Color[n2];
                Color color = null;
                for (int i = 1; i <= n2; ++i) {
                    color = Color.getHSBColor(f3 - (f3 - f4) * ((float)i / (float)n2), 1.0f, 1.0f);
                    this.mLUT[i - 1] = i < this.mAlphaThreshold ? new Color(0, 0, 0) : new Color(color.getRed(), color.getGreen(), color.getBlue());
                }
            }
        }

        private void initContinuousLut() {
            this.mLUT = new Color[256];
            Color color = null;
            for (int i = 0; i < 256; ++i) {
                color = new Color(i, i, i);
                double d = Math.sqrt(Math.pow(color.getRed(), 2.0) + Math.pow(color.getGreen(), 2.0) + Math.pow(color.getBlue(), 2.0)) / (double)this.mMaxPos;
                this.mLUT[i] = new Color((int)((double)this.mC1.getRed() + d * (double)this.mCDiff[0]), (int)((double)this.mC1.getGreen() + d * (double)this.mCDiff[1]), (int)((double)this.mC1.getBlue() + d * (double)this.mCDiff[2]));
            }
        }

        public Color getColorForRGB(int n) {
            if (this.mMode == 2) {
                return new Color(n);
            }
            Color color = new Color(n);
            double d = Math.sqrt(color.getRed() * color.getRed() + color.getGreen() * color.getGreen() + color.getBlue() * color.getBlue()) / (double)this.mMaxPos;
            return this.mLUT[(int)(d * 255.0)];
        }

        public Color getColorForFloat(float f) {
            int n = 0;
            f = f > this.mMax ? this.mMax : f;
            n = (int)(((f = f < this.mMin ? this.mMin : f) - this.mMin) / (this.mMax - this.mMin) * (float)this.mLUT.length);
            if (n >= this.mLUT.length || n < 0) {
                n = this.mLUT.length - 1;
            }
            return this.mLUT[n];
        }

        public void checkForUpdates(ThemeImageLayer themeImageLayer) {
            if (!themeImageLayer.getUseCustomColors()) {
                this.mMode = 2;
            } else if (themeImageLayer.getOverlayMode() == 1 && this.mMode != 1) {
                this.init(themeImageLayer.getColor1(), themeImageLayer.getColor2());
            } else if (themeImageLayer.getOverlayMode() == 2 && this.mMode != 0) {
                this.init(themeImageLayer.getContourPlotMinVal(), themeImageLayer.getContourPlotMaxVal(), 0);
            } else if (this.mMode == 1) {
                if (!this.mC1.equals(themeImageLayer.getColor1()) || !this.mC2.equals(themeImageLayer.getColor2())) {
                    this.init(themeImageLayer.getColor1(), themeImageLayer.getColor2());
                }
            } else if (this.mMode == 0 && (this.mMin != themeImageLayer.getContourPlotMinVal() || this.mMax != themeImageLayer.getContourPlotMaxVal())) {
                this.init(themeImageLayer.getContourPlotMinVal(), themeImageLayer.getContourPlotMaxVal(), 0);
            }
        }
    }
}

