/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.theme;

import com.luna.insight.core.theme.ThemeImageConstants;
import com.luna.insight.core.theme.ThemeImageLayer;
import com.luna.insight.core.theme.ThemeImageLayerManager;
import com.luna.insight.core.theme.ThemeImageTransparentBlend;
import com.luna.insight.core.theme.ThemeImageUtilities;
import com.luna.insight.core.util.CoreUtilities;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JFrame;

public class ThemeImageCreator
implements ThemeImageConstants {
    protected static float defaultAlpha = 0.95f;
    private boolean mPerformUpdateAtNextPass = false;
    private ImagePlus bgImage = null;
    private boolean bgImgTrueColor = false;
    private Color bkgdColor = null;
    private String cnString = null;
    private ImagePlus gradiantBlend = null;
    private ImagePlus gradiantFill = null;
    private ImagePlus insightLNF = null;
    private Image insightLNFImage = null;
    private ThemeImageLayerManager mIM = null;
    private SortedSet mThemeImageLayers = null;
    private Color blendColor = null;
    private String destinationDir = "";
    private boolean resampleDuringResize = true;

    public ThemeImageCreator(boolean bl) {
        this.resampleDuringResize = bl;
        try {
            Image image = CoreUtilities.getIcon("images/theme-insight-icon.gif").getImage();
            this.insightLNFImage = CoreUtilities.getIcon("images/theme-insight-icon.gif").getImage();
            this.setInsightLNF(new ImagePlus("", this.insightLNFImage));
        }
        catch (Exception exception) {
            CoreUtilities.logError("Exception occured: " + exception);
        }
    }

    public ThemeImageCreator() {
        this(true);
    }

    private void addThemeImageLayer(ImagePlus imagePlus) {
        this.addThemeImageLayer(imagePlus, this.bkgdColor, defaultAlpha);
    }

    private void addThemeImageLayer(ImagePlus imagePlus, float f) {
        this.addThemeImageLayer(imagePlus, null, f);
    }

    private void addThemeImageLayer(ImagePlus imagePlus, Color color) {
        this.addThemeImageLayer(imagePlus, color, defaultAlpha);
    }

    private void addThemeImageLayer(ImagePlus imagePlus, Color color, float f) {
        ThemeImageLayer themeImageLayer = new ThemeImageLayer(imagePlus);
        if (color == null) {
            themeImageLayer.setAlpha(f);
        }
        if (color != null) {
            themeImageLayer.setUseCustomColors(true);
            themeImageLayer.setColor1(color);
            themeImageLayer.setColor2(new Color(210, 210, 210));
            themeImageLayer.setAlpha(f);
        }
        TreeSet<ThemeImageLayer> treeSet = new TreeSet<ThemeImageLayer>();
        Iterator iterator = null;
        if (this.mThemeImageLayers == null) {
            this.mThemeImageLayers = treeSet;
        } else {
            iterator = this.mThemeImageLayers.iterator();
            while (iterator.hasNext()) {
                treeSet.add(((ThemeImageLayer)iterator.next()).incrementOrder());
            }
            this.mThemeImageLayers = treeSet;
        }
        this.mThemeImageLayers.add(themeImageLayer);
        if (this.mIM == null) {
            this.mIM = new ThemeImageLayerManager(themeImageLayer);
        }
        this.mPerformUpdateAtNextPass = true;
    }

    private void makeBrowserBackground(ImagePlus imagePlus, Color color) {
        ImagePlus imagePlus2 = new ImagePlus("", CoreUtilities.getIcon("images/theme-browser-horz.gif").getImage());
        ImageProcessor imageProcessor = ThemeImageUtilities.crop(imagePlus, 0, 0, 2048, 135, color);
        imageProcessor.insert(imagePlus2.getProcessor(), 0, 120);
        try {
            ThemeImageUtilities.writeImage(imageProcessor, this.getDestinationDir() + "gwtop_bg.jpg");
            ThemeImageUtilities.writeImage(ThemeImageUtilities.crop(imagePlus, 0, 135, 75, 2048, color), this.getDestinationDir() + "menu_bg.jpg");
            ImagePlus imagePlus3 = new ImagePlus("", CoreUtilities.getIcon("images/theme-browser-vert.gif").getImage());
            imageProcessor = ThemeImageUtilities.crop(imagePlus, 281, 135, 241, 2048, color);
            imageProcessor.insert(imagePlus3.getProcessor(), 33, 0);
            ThemeImageUtilities.writeImage(imageProcessor, this.getDestinationDir() + "groupleft_bg_ns.jpg");
            imageProcessor = ThemeImageUtilities.crop(imagePlus, 300, 135, 245, 2048, color);
            imageProcessor.insert(imagePlus3.getProcessor(), 14, 0);
            ThemeImageUtilities.writeImage(imageProcessor, this.getDestinationDir() + "groupleft_bg.jpg");
            ThemeImageUtilities.writeImage(ThemeImageUtilities.crop(imagePlus, 0, 800, 2048, 135, color), this.getDestinationDir() + "gwbottom_bg.jpg");
            ThemeImageUtilities.writeImage(ThemeImageUtilities.crop(imagePlus, 0, 800, 135, 2048, color), this.getDestinationDir() + "groupright_bg.jpg");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean create(int n, int n2) {
        boolean bl = this.create(n, n2, true);
        return bl;
    }

    public boolean create(int n, int n2, boolean bl) {
        return this.create(n, n2, "insightbackground.jpg", bl);
    }

    public boolean create(int n, int n2, String string, boolean bl) {
        ImagePlus imagePlus;
        if (this.getGradiantFill() != null || this.getGradiantBlend() != null) {
            this.addThemeImageLayer(this.getGradiantFill());
            if (this.getBgImage() != null) {
                if (this.isBgImgTrueColor()) {
                    this.addThemeImageLayer(this.getBgImage(), 0.3f);
                } else {
                    this.addThemeImageLayer(this.getBgImage(), this.bkgdColor, 0.6f);
                }
            }
            if (this.getGradiantFill() != null) {
                this.addThemeImageLayer(this.getGradiantFill(), this.bkgdColor, 0.95f);
            }
            if (this.getGradiantBlend() != null) {
                this.addThemeImageLayer(this.getGradiantBlend(), this.bkgdColor, 0.95f);
            }
            this.updateImage();
            imagePlus = this.getMIM().getIP();
        } else {
            imagePlus = this.getBgImage();
        }
        ThemeImageTransparentBlend themeImageTransparentBlend = new ThemeImageTransparentBlend(imagePlus.getImage(), this.insightLNFImage, n, n2);
        BufferedImage bufferedImage = themeImageTransparentBlend.bImg;
        int n3 = bufferedImage.getRGB(bufferedImage.getWidth() - 10, bufferedImage.getHeight() - 10);
        CoreUtilities.logInfo("Blend Pixel Value = " + n3);
        this.blendColor = new Color(n3);
        imagePlus = new ImagePlus("BrowserBackground", (Image)bufferedImage);
        if (this.cnString != null) {
            imagePlus.setColor(Color.WHITE);
            imagePlus.getProcessor().setFont(new Font("Arial", 1, 20));
            imagePlus.getProcessor().setAntialiasedText(true);
            imagePlus.getProcessor().drawString(this.cnString, 400, 100);
        }
        imagePlus.getProcessor().setColor(this.blendColor);
        imagePlus.getProcessor().drawLine(0, 0, 0, 803);
        imagePlus.getProcessor().drawLine(0, 0, 803, 0);
        imagePlus.getProcessor().setColor(new Color(134, 134, 134));
        imagePlus.getProcessor().drawLine(314, 0, 314, 308);
        imagePlus.getProcessor().drawLine(0, 120, 803, 120);
        if (bl) {
            this.makeBrowserBackground(imagePlus, this.blendColor);
        }
        if (bufferedImage != null) {
            try {
                int n4 = 15;
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > 100) {
                    n4 = 100;
                }
                float f = 1.0f - (float)n4 / 100.0f;
                CoreUtilities.logInfo("ThemeImageCreator(..): ip width = " + imagePlus.getWidth() + ", height = " + imagePlus.getHeight());
                ThemeImageUtilities.writeImage(imagePlus.getProcessor(), this.getDestinationDir() + string, f);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return true;
    }

    public ImagePlus getBgImage() {
        return this.bgImage;
    }

    public Color getBkgdColor() {
        return this.bkgdColor;
    }

    public String getCnString() {
        return this.cnString;
    }

    public ImagePlus getGradiantBlend() {
        return this.gradiantBlend;
    }

    public ImagePlus getGradiantFill() {
        return this.gradiantFill;
    }

    public ImagePlus getInsightLNF() {
        return this.insightLNF;
    }

    public ThemeImageLayerManager getMIM() {
        return this.mIM;
    }

    public SortedSet getMThemeImageLayers() {
        return this.mThemeImageLayers;
    }

    public Color getBlendColor() {
        return this.blendColor;
    }

    public String getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.destinationDir = string;
    }

    public boolean isBgImgTrueColor() {
        return this.bgImgTrueColor;
    }

    public void setBgImage(String string) {
        ImagePlus imagePlus = ThemeImageUtilities.openImageResized(string, this.resampleDuringResize);
        ImageProcessor imageProcessor = ThemeImageUtilities.crop(imagePlus, 0, 0, 803, 590);
        this.bgImage = new ImagePlus(null, imageProcessor);
    }

    public void setBgImage(ImagePlus imagePlus) {
        this.bgImage = imagePlus;
    }

    public void setBgImgTrueColor(boolean bl) {
        this.bgImgTrueColor = bl;
    }

    public void setBkgdColor(Color color) {
        this.bkgdColor = color;
    }

    public void setCnString(String string) {
        this.cnString = string;
    }

    public void setGradiantBlend(ImagePlus imagePlus) {
        this.gradiantBlend = imagePlus;
    }

    public void setGradiantFill(ImagePlus imagePlus) {
        this.gradiantFill = imagePlus;
    }

    public void setInsightLNF(ImagePlus imagePlus) {
        this.insightLNF = imagePlus;
    }

    public void setBlendColor(Color color) {
        this.blendColor = color;
    }

    public void setMIM(ThemeImageLayerManager themeImageLayerManager) {
        this.mIM = themeImageLayerManager;
    }

    public void setMThemeImageLayers(SortedSet sortedSet) {
        this.mThemeImageLayers = sortedSet;
    }

    private void updateImage() {
        if (this.mIM != null) {
            this.mIM.updateThemeImageLayers(this.mThemeImageLayers);
            this.mPerformUpdateAtNextPass = false;
        }
    }

    public static void main(String[] stringArray) {
        String string = "bkimg2.jpg";
        Color color = new Color(100, 136, 206);
        String string2 = "Johnson Museum of Art";
        if (stringArray.length == 0) {
            JFrame jFrame = new JFrame();
            FileDialog fileDialog = new FileDialog((Frame)jFrame, "Select an image..");
            fileDialog.setMode(0);
            fileDialog.show();
            string = fileDialog.getDirectory() + fileDialog.getFile();
        }
        try {
            long l = System.currentTimeMillis();
            ThemeImageCreator themeImageCreator = new ThemeImageCreator();
            themeImageCreator.setDestinationDir("./output/");
            themeImageCreator.setBgImage(string);
            themeImageCreator.create(803, 590);
            int n = themeImageCreator.getBlendColor().getRed();
            int n2 = themeImageCreator.getBlendColor().getGreen();
            int n3 = themeImageCreator.getBlendColor().getBlue();
            long l2 = System.currentTimeMillis();
            CoreUtilities.logInfo("Processing Time:" + (double)(l2 - l) / 1000.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

