/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.license;

import com.luna.insight.core.license.InsightLicenseConstants;
import com.luna.insight.core.util.CoreUtilities;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class InsightLicenseNamedUsers
implements InsightLicenseConstants {
    private Properties properties;
    private int licensedNamedPCUserCount = 5;
    private int licensedNamedInscribeUserCount = 5;
    private Set licensedNamedPCUsers;
    private Set licensedNamedInscribeUsers;

    public InsightLicenseNamedUsers(int n, int n2) {
        this.loadProperties();
        this.licensedNamedPCUserCount = n;
        this.licensedNamedInscribeUserCount = n2;
        this.registerNamedPersonalInsightUsers();
        this.registerNamedInscribeUsers();
        CoreUtilities.logInfo("Registed PC User Count: " + this.licensedNamedPCUsers.size());
        CoreUtilities.logInfo("Registed Inscribe User Count: " + this.licensedNamedInscribeUsers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void loadProperties() {
        block11: {
            String string = "InsightLicenseNamedUsers.dat";
            this.properties = new Properties();
            FileInputStream fileInputStream = null;
            CoreUtilities.logInfo("Licensed User Property file is " + string + ".");
            fileInputStream = new FileInputStream(string);
            this.properties.load(fileInputStream);
            Object var5_3 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    CoreUtilities.logInfo("Unable to locate Licensed User Property File");
                    Object var5_4 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void registerNamedPersonalInsightUsers() {
        CoreUtilities.logInfo("Registering Licensed Personal Insight Users");
        this.licensedNamedPCUsers = new HashSet();
        String string = null;
        for (int i = 0; i <= this.licensedNamedPCUserCount; ++i) {
            string = this.properties.getProperty("NamedUser." + (i + 1) + ".personalInsight", "");
            if (string == null || string.equals("")) continue;
            this.licensedNamedPCUsers.add(string);
        }
    }

    protected void registerNamedInscribeUsers() {
        CoreUtilities.logInfo("Registering Licensed Inscribe Users");
        this.licensedNamedInscribeUsers = new HashSet();
        String string = null;
        for (int i = 1; i <= this.licensedNamedInscribeUserCount; ++i) {
            string = this.properties.getProperty("NamedUser." + (i + 1) + ".inscribe", "");
            if (string == null || string.equals("")) continue;
            this.licensedNamedInscribeUsers.add(string);
        }
    }

    public boolean isLicensedPCNamedUser(String string) {
        return this.licensedNamedPCUsers.contains(string);
    }

    public void setLicensedPCNamedUser(String string) {
        if (string != null && !string.equals("")) {
            this.licensedNamedPCUsers.add(string);
        }
    }

    public boolean isLicensedInscribeNamedUser(String string) {
        return this.licensedNamedInscribeUsers.contains(string);
    }

    public void setLicensedInscribeNamedUser(String string) {
        if (string != null && !string.equals("")) {
            this.licensedNamedInscribeUsers.add(string);
        }
    }

    public Set getLicensedNamedInscribeUsers() {
        return Collections.unmodifiableSet(this.licensedNamedInscribeUsers);
    }

    public Set getLicensedNamedPCUsers() {
        return Collections.unmodifiableSet(this.licensedNamedPCUsers);
    }

    public int getLicensedNamedInscribeUserCount() {
        return this.licensedNamedInscribeUserCount;
    }

    protected void setLicensedNamedInscribeUserCount(int n) {
        this.licensedNamedInscribeUserCount = n;
    }

    public int getLicensedNamedPCUserCount() {
        return this.licensedNamedPCUserCount;
    }

    protected void setLicensedNamedPCUserCount(int n) {
        this.licensedNamedPCUserCount = n;
    }
}

