/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageEncoder;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.core.jpeg2000.JPEG2KException;
import com.luna.insight.core.util.CoreUtilities;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.Opener;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sf.ij.jaiio.JAIReader;
import net.sf.ij.jaiio.JAIWriter;

public class JPegConverter {
    private static boolean isJpeg2000Enabled;
    private static IJPEG2KEncodeParam params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Dimension getImageDimension(File file) {
        ImagePlus[] imagePlusArray;
        Dimension dimension;
        block19: {
            dimension = null;
            ImageInputStream imageInputStream = null;
            imageInputStream = ImageIO.createImageInputStream(file);
            imagePlusArray = ImageIO.getImageReaders(imageInputStream);
            if (imagePlusArray.hasNext()) {
                ImageReader imageReader = imagePlusArray.next();
                try {
                    imageReader.setInput(imageInputStream);
                    dimension = new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
                    System.out.println("w=" + dimension.width + ", h=" + dimension.height);
                }
                finally {
                    imageReader.dispose();
                }
            }
            Object var7_8 = null;
            try {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                break block19;
            }
            catch (Exception exception) {}
            break block19;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(exception.toString());
                    Object var7_9 = null;
                    try {
                        if (imageInputStream != null) {
                            imageInputStream.close();
                        }
                        break block19;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (imageInputStream != null) {
                        imageInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (dimension == null) {
            try {
                imagePlusArray = JAIReader.read((File)file);
                dimension = new Dimension(imagePlusArray[0].getWidth(), imagePlusArray[0].getHeight());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(exception.toString());
            }
        }
        return dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Dimension convertToJpeg(String string, String string2, String string3) throws Exception {
        String string4 = string2;
        int n = 0;
        int n2 = 0;
        Dimension dimension = null;
        if (!string4.toLowerCase().endsWith(".jpg")) {
            string4 = string4.substring(0, string4.lastIndexOf(".")) + ".jpg";
            File file = new File(string, string2);
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                System.err.println(new Date().getTime() + " - image read");
                File file2 = new File(string3, string4);
                if (bufferedImage != null) {
                    ImageIO.write((RenderedImage)bufferedImage, "jpg", file2);
                    System.err.println(new Date().getTime() + " - image written");
                    n = bufferedImage.getWidth();
                    n2 = bufferedImage.getHeight();
                } else {
                    JAIWriter jAIWriter = new JAIWriter();
                    ImagePlus[] imagePlusArray = JAIReader.read((File)file);
                    n2 = imagePlusArray[0].getHeight();
                    n = imagePlusArray[0].getWidth();
                    jAIWriter.setFormatName("jpg");
                    jAIWriter.write(file2.getPath(), imagePlusArray[0]);
                }
                if (n2 <= 0) return dimension;
                if (n <= 0) return dimension;
                return new Dimension(n, n2);
            }
            catch (Exception exception) {
                CoreUtilities.logException("exception generating bitmap input file for kdu_compress", exception);
                throw new JPEG2KException(exception);
            }
        }
        try {
            int n3;
            File file = new File(string, string2);
            File file3 = new File(string3, string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            byte[] byArray = new byte[1024];
            while ((n3 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n3);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            System.out.println("File copied.");
            return JPegConverter.getImageDimension(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage() + " in the specified directory.");
            System.exit(0);
            return dimension;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return dimension;
    }

    public static void convertToJpeg2000(String string, String string2, String string3, Dimension dimension) throws Exception {
        String string4 = null;
        String string5 = string3 + File.separator + string2.substring(0, string2.lastIndexOf(".")) + ".jp2";
        System.err.println(new Date().getTime());
        try {
            System.out.println(new Date().getTime());
            IJPEG2KImageEncoder iJPEG2KImageEncoder = JPEG2KCodec.createJPEG2KEncoder(string5);
            System.err.println(new Date().getTime());
            params.setLevels(0);
            iJPEG2KImageEncoder.encode(new File(string + File.separator + string2), params, dimension);
        }
        catch (IOException iOException) {
            string4 = "PROCESSED_FAIL_OTHER";
            System.out.println("JP2 creation failed: " + iOException);
            throw iOException;
        }
        catch (Exception exception) {
            string4 = "PROCESSED_FAIL_NODECODER";
            System.out.println("JP2 creation failed: " + exception);
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            string4 = "PROCESSED_FAIL_OUTOFMEMORY";
            System.out.println("JP2 creation failed due to memory limitation: " + outOfMemoryError);
            throw outOfMemoryError;
        }
    }

    public static void convertToJpeg2000Insight(String string) throws Exception {
        Object object;
        Object object2;
        ImagePlus imagePlus = new Opener().openImage(string);
        String string2 = null;
        if (imagePlus == null) {
            try {
                object2 = new File(string);
                object = JAIReader.read((File)object2);
                imagePlus = object[0];
                if (imagePlus.getOriginalFileInfo() == null) {
                    FileInfo fileInfo = imagePlus.getFileInfo();
                    fileInfo.directory = ((File)object2).getParent();
                    fileInfo.fileName = ((File)object2).getName();
                    imagePlus.setFileInfo(fileInfo);
                }
            }
            catch (Throwable throwable) {
                string2 = "PROCESSED_FAIL_OTHER";
                System.err.println("JAI Failed too...\n" + throwable.getStackTrace());
                System.runFinalization();
                System.gc();
            }
        }
        object2 = string.substring(0, string.lastIndexOf(".")) + "1.jp2";
        JPEG2KCodec.configure();
        try {
            object = JPEG2KCodec.createJPEG2KEncoder((String)object2);
            object.encode(imagePlus, params);
            System.out.println("JP2 creation done");
        }
        catch (IOException iOException) {
            string2 = "PROCESSED_FAIL_OTHER";
            System.out.println("JP2 creation failed: " + iOException);
            throw iOException;
        }
        catch (Exception exception) {
            string2 = "PROCESSED_FAIL_NODECODER";
            System.out.println("JP2 creation failed: " + exception);
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            string2 = "PROCESSED_FAIL_OUTOFMEMORY";
            System.out.println("JP2 creation failed due to memory limitation: " + outOfMemoryError);
            throw outOfMemoryError;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "C:\\Documents and Settings\\Rathi\\workspace\\RathiTest\\bookSrcFolder";
            String string2 = "0001.tif";
            ImagePlus imagePlus = IJ.openImage((String)(string + File.separator + string2));
            Date date = new Date();
            JPegConverter.convertToJpeg2000(string, string2, string, null);
            Date date2 = new Date();
            System.err.println("Total time for conversion " + (date2.getTime() - date.getTime()));
            date = new Date();
            JPegConverter.convertToJpeg2000Insight(string2);
            date2 = new Date();
            System.err.println("Total time for conversion (traditional way) " + (date2.getTime() - date.getTime()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.out.println("Error:" + fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("Error:" + iOException.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.toString());
        }
    }

    public static boolean isJpeg2000Enabled() {
        return isJpeg2000Enabled;
    }

    public static void setJpeg2000Enabled(boolean bl) {
        isJpeg2000Enabled = bl;
    }

    static {
        try {
            JPEG2KCodec.configure();
            params = JPEG2KCodec.getDefaultJPEG2KEncodeParam();
            isJpeg2000Enabled = true;
        }
        catch (Exception exception) {
            System.out.println("Jpeg2000 is not available");
        }
    }
}

