/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.insightwizard.util;

import com.luna.insight.core.insightwizard.InsightWizardException;
import com.luna.insight.core.insightwizard.gui.iface.UINode;
import com.luna.insight.core.insightwizard.iface.InsightWizardConsts;
import com.luna.insight.core.util.CoreException;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.FontDescriptor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InsightWizardUtils
extends CoreUtilities
implements InsightWizardConsts {
    public static Hashtable listenerClassTable = new Hashtable();
    public static Hashtable inputSourceTable = new Hashtable();
    public static HashMap sourceMap = new HashMap();
    public static final boolean REUSE_RESOURCES = !InsightWizardUtils.checkCompile();
    private static String[][] layoutPositions = new String[][]{{"top", "North"}, {"north", "North"}, {"bottom", "South"}, {"south", "South"}, {"right", "East"}, {"east", "East"}, {"left", "West"}, {"west", "West"}, {"center", "Center"}};
    private static Hashtable insetsTable = new Hashtable();
    protected static final Hashtable colorTable = new Hashtable();

    public static boolean checkCompile() {
        try {
            Class<?> clazz = Class.forName("com.luna.insight.core.insightwizard.parser.DynamicCompile");
            clazz.getConstructor(new Class[0]).newInstance(new Class[0]);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void registerInputSourceMapping(String string, String string2) {
        if (string != null) {
            sourceMap.put(string, string2);
        }
    }

    public static String convertURIToFSPath(String string) throws InsightWizardException {
        try {
            return new File("" + string).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new InsightWizardException(iOException);
        }
    }

    public static void searchClassForInterface(String string, String string2) throws InsightWizardException {
        try {
            Class<?> clazz = Class.forName(string);
            InsightWizardUtils.searchClassForInterface(clazz, clazz, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InsightWizardException(classNotFoundException);
        }
    }

    public static void searchClassForInterface(Class clazz, String string) throws InsightWizardException {
        InsightWizardUtils.searchClassForInterface(clazz, clazz, string);
    }

    private static void searchClassForInterface(Class clazz, Class clazz2, String string) throws InsightWizardException {
        String string2 = clazz.getName() + "#" + string;
        if (listenerClassTable.get(string2) != null) {
            return;
        }
        Class<?>[] classArray = clazz2.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals(string)) continue;
            listenerClassTable.put(string2, clazz);
            return;
        }
        Class clazz3 = clazz2.getSuperclass();
        if (clazz3 == null) {
            throw new InsightWizardException("Node controller class does not implement proper interface: " + clazz.getName());
        }
        InsightWizardUtils.searchClassForInterface(clazz, clazz3, string);
    }

    public static InputSource translateInputSource(String string, String string2) throws InsightWizardException {
        String[] stringArray = new String[1];
        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputSourceTable.get(string);
        if (byteArrayInputStream == null) {
            try {
                byteArrayInputStream = InsightWizardUtils.readToBytes(string);
            }
            catch (CoreException coreException) {
                System.out.println("read exception: " + string);
                throw new InsightWizardException(coreException);
            }
            if (REUSE_RESOURCES) {
                inputSourceTable.put(string, byteArrayInputStream);
            }
        }
        byteArrayInputStream.reset();
        InputSource inputSource = new InputSource(byteArrayInputStream);
        inputSource.setPublicId(stringArray[0]);
        inputSource.setEncoding("UTF-8");
        inputSource.setSystemId(string2);
        return inputSource;
    }

    public static InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return InsightWizardUtils.resolveEntity(string, string2, null, -1, -1);
    }

    public static InputSource resolveEntity(String string, String string2, String string3, int n, int n2) throws SAXException, IOException {
        try {
            if (sourceMap.get(string2) != null) {
                string2 = (String)sourceMap.get(string2);
            }
            return InsightWizardUtils.translateInputSource(string2, string2);
        }
        catch (InsightWizardException insightWizardException) {
            throw new SAXException(string3 + "@" + n + ":" + n2 + " - " + insightWizardException);
        }
    }

    public static int interpretSizeBoundary(String string) {
        if (string.equals("fill") || string.indexOf("%") > -1 || string.indexOf("c") > -1) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    public static int calculateSizeBoundary(int n, String string) {
        if (string.equals("fill")) {
            return Integer.MIN_VALUE;
        }
        if (string.indexOf("%") > -1) {
            String string2 = string.substring(0, string.indexOf("%"));
            int n2 = Integer.parseInt(string2);
            float f = n2 >= 100 ? 1.0f : (float)n2 / 100.0f;
            return Math.round((float)n * f);
        }
        if (string.indexOf("c") > -1) {
            String string3 = string.substring(0, string.indexOf("c"));
            int n3 = Integer.parseInt(string3);
            FontDescriptor fontDescriptor = new FontDescriptor(new JLabel().getFont());
            return Math.round((float)(fontDescriptor.getDisplayWidth("A") * n3) * 1.1f);
        }
        return Integer.parseInt(string);
    }

    public static String getBorderLayoutPosition(String string) {
        if (string == null) {
            return "Center";
        }
        for (int i = 0; i < layoutPositions.length; ++i) {
            if (!string.equals(layoutPositions[i][0])) continue;
            return layoutPositions[i][1];
        }
        return "Center";
    }

    public static Border getBorderStyle(String string, Color color) {
        return InsightWizardUtils.getBorderStyle(string, color, null);
    }

    public static Border getBorderStyle(String string, Color color, Object object) {
        if (string.equals("etched")) {
            return BorderFactory.createEtchedBorder();
        }
        if (string.equals("lined")) {
            return BorderFactory.createLineBorder(color);
        }
        if (string.equals("titled")) {
            return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), (String)object);
        }
        if (string.equals("raised")) {
            return BorderFactory.createBevelBorder(0);
        }
        if (string.equals("lowered")) {
            return BorderFactory.createBevelBorder(1);
        }
        if (string.equals("matte")) {
            return object instanceof Insets ? BorderFactory.createMatteBorder(((Insets)object).top, ((Insets)object).left, ((Insets)object).bottom, ((Insets)object).right, color) : BorderFactory.createMatteBorder(6, 6, 6, 6, color);
        }
        return BorderFactory.createEmptyBorder();
    }

    public static Border getBorderStyle(String string) {
        return InsightWizardUtils.getBorderStyle(string, Color.GRAY);
    }

    public static Border getTitledBorder(String string) {
        return InsightWizardUtils.getBorderStyle("titled", Color.GRAY, string);
    }

    public static Border getTitledBorder(String string, Color color) {
        return InsightWizardUtils.getBorderStyle("titled", color, string);
    }

    public static Border getBorderStyle(String string, String string2) {
        Border border = InsightWizardUtils.getBorderStyle(string, Color.GRAY);
        if (string2 == null || string2.equals("0,0,0,0")) {
            return border;
        }
        Insets insets = InsightWizardUtils.parseInsets(string2);
        return BorderFactory.createCompoundBorder(border, InsightWizardUtils.getInsetBorder(insets.left, insets.right, insets.top, insets.bottom));
    }

    public static Border getCompoundBorder(Border border, Border border2) {
        return BorderFactory.createCompoundBorder(border, border2);
    }

    public static Insets parseInsets(String string) {
        Insets insets = (Insets)insetsTable.get(string);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.hasMoreTokens()) {
                insets.left = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                insets.right = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                insets.top = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                insets.bottom = Integer.parseInt(stringTokenizer.nextToken());
            }
            insetsTable.put(string, insets);
        }
        return insets;
    }

    public static Border getInsetBorder(int n) {
        return InsightWizardUtils.getInsetBorder(n, n, n, n);
    }

    public static Border getInsetBorder(int n, int n2, int n3, int n4) {
        return BorderFactory.createEmptyBorder(n3, n, n4, n2);
    }

    public static Border getInsetBorder(Insets insets) {
        return InsightWizardUtils.getInsetBorder(insets.left, insets.right, insets.top, insets.bottom);
    }

    public static Color decodeColor(String string) {
        Color color;
        if (string == null || string.trim().equals("")) {
            string = "000000";
        }
        if ((color = (Color)colorTable.get(string)) != null) {
            return color;
        }
        color = Color.decode("0x" + string);
        colorTable.put(string, color);
        return color;
    }

    public static Font createFont(String string, Color color, Color color2, Float f, Float f2, Float f3, Boolean bl, Integer n, Boolean bl2, Float f4, Float f5) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, string);
        hashMap.put(TextAttribute.JUSTIFICATION, f);
        hashMap.put(TextAttribute.POSTURE, f2);
        hashMap.put(TextAttribute.SIZE, f3);
        hashMap.put(TextAttribute.STRIKETHROUGH, bl);
        hashMap.put(TextAttribute.SUPERSCRIPT, n);
        hashMap.put(TextAttribute.UNDERLINE, bl2);
        hashMap.put(TextAttribute.WEIGHT, f5);
        return new Font(hashMap);
    }

    public static int createAndShowDialog(UINode uINode, String string, String string2, boolean bl, boolean bl2, int n, int n2) throws InsightWizardException {
        return uINode.getUIManager().createAndShowDialog(uINode, string, string2, bl, bl2, n, n2);
    }

    public static int parseAlignmentString(String string) {
        if (string != null) {
            if (string.equals("left")) {
                return 2;
            }
            if (string.equals("right")) {
                return 4;
            }
            if (string.equals("center")) {
                return 0;
            }
            if (string.equals("leading")) {
                return 10;
            }
            if (string.equals("trailing")) {
                return 11;
            }
        }
        return 10;
    }

    static {
        colorTable.put("white", Color.white);
        colorTable.put("lightgray", Color.lightGray);
        colorTable.put("gray", Color.gray);
        colorTable.put("darkgray", Color.darkGray);
        colorTable.put("black", Color.black);
        colorTable.put("red", Color.red);
        colorTable.put("pink", Color.pink);
        colorTable.put("orange", Color.orange);
        colorTable.put("yellow", Color.yellow);
        colorTable.put("green", Color.green);
        colorTable.put("magenta", Color.magenta);
        colorTable.put("cyan", Color.cyan);
        colorTable.put("blue", Color.blue);
    }
}

