/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.dataimport;

import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseEntityType;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IEntityType;
import com.luna.insight.core.catalog.iface.ITemplate;
import com.luna.insight.core.dataimport.DataImportEntityFieldMapping;
import com.luna.insight.core.dataimport.DataImportFactory;
import com.luna.insight.core.dataimport.DataImportMappingException;
import com.luna.insight.core.dataimport.DataImportParams;
import com.luna.insight.core.dataimport.DataImportSourceException;
import com.luna.insight.core.dataimport.SourceImportEntity;
import com.luna.insight.core.dataimport.SourceImportEntityBuilder;
import com.luna.insight.core.dataimport.UnexpectedErrorException;
import com.luna.insight.core.dataimport.model.Field;
import com.luna.insight.core.dataimport.model.FieldGroup;
import com.luna.insight.core.dataimport.model.Record;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.IntegerRange;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataImportModule {
    protected DocumentBuilderFactory domFactory = null;
    protected DocumentBuilder domBuilder = null;
    private DataImportParams params;
    private String xmlFileName = null;
    private String jdbcDriverName = null;
    private String jdbcURL = null;
    private Properties props = null;
    private String sqlQuery = null;
    private Connection conn = null;
    private Statement stmt = null;
    private ResultSet results = null;
    private ResultSetMetaData info = null;
    private int colCount = 0;
    private int entityID = 0;
    private SourceImportEntityBuilder entityBuilder = new SourceImportEntityBuilder();
    private Pattern mappingPattern = Pattern.compile("(\\D+)\\d+$");
    private static final int NON_NUMERIC_GROUP = 1;
    private CanonicalStringCache canonicalStrings = new CanonicalStringCache();
    private BaseTemplate catalogTemplate;

    public DataImportModule(BaseTemplate baseTemplate) throws ParserConfigurationException {
        try {
            this.domFactory = DocumentBuilderFactory.newInstance();
            this.domBuilder = this.domFactory.newDocumentBuilder();
            this.catalogTemplate = baseTemplate;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            CoreUtilities.logError(factoryConfigurationError.toString());
            throw factoryConfigurationError;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            CoreUtilities.logError(parserConfigurationException.toString());
            throw parserConfigurationException;
        }
    }

    public DataImportModule(BaseTemplate baseTemplate, DataImportParams dataImportParams) throws ParserConfigurationException, ClassNotFoundException, SQLException {
        try {
            this.params = dataImportParams;
            this.domFactory = DocumentBuilderFactory.newInstance();
            this.domBuilder = this.domFactory.newDocumentBuilder();
            this.catalogTemplate = baseTemplate;
            this.initialize();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            CoreUtilities.logError(factoryConfigurationError.getMessage());
            throw factoryConfigurationError;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            CoreUtilities.logException(parserConfigurationException);
            throw parserConfigurationException;
        }
    }

    public void initialize() throws ClassNotFoundException, SQLException {
        try {
            this.jdbcDriverName = this.params.getJdbcDriverName();
            Class.forName(this.jdbcDriverName);
            this.jdbcURL = this.params.getJdbcUrl();
            this.props = this.params.getProps();
            this.conn = DriverManager.getConnection(this.jdbcURL, this.props);
            this.sqlQuery = this.params.getSqlStatement();
            this.getResultSet();
        }
        catch (ClassNotFoundException classNotFoundException) {
            CoreUtilities.logException(classNotFoundException);
            throw classNotFoundException;
        }
        catch (SQLException sQLException) {
            CoreUtilities.logException(sQLException);
            throw sQLException;
        }
    }

    public List getFieldMappings() throws SQLException {
        Object object;
        ArrayList<DataImportEntityFieldMapping> arrayList = new ArrayList<DataImportEntityFieldMapping>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.catalogTemplate.getLinkedFields().iterator();
        while (iterator.hasNext()) {
            object = (BaseEntityField)iterator.next();
            hashMap.put(((BaseTemplateElement)object).getDisplayName(), object);
            hashMap.put(((BaseTemplateElement)object).getDisplayName().toLowerCase(), object);
            hashMap.put(((BaseTemplateElement)object).getName(), object);
            hashMap.put(((BaseTemplateElement)object).getName().toLowerCase(), object);
        }
        for (int i = 0; i < this.colCount; ++i) {
            String string;
            Matcher matcher;
            object = this.info.getColumnName(i + 1).trim();
            if (i == 0 && Character.isIdentifierIgnorable(((String)object).charAt(0))) {
                object = ((String)object).substring(1);
            }
            DataImportEntityFieldMapping dataImportEntityFieldMapping = new DataImportEntityFieldMapping(i, (String)object);
            arrayList.add(dataImportEntityFieldMapping);
            BaseEntityField baseEntityField = (BaseEntityField)hashMap.get(object);
            if (baseEntityField == null) {
                baseEntityField = (BaseEntityField)hashMap.get(((String)object).toLowerCase());
            }
            if (baseEntityField == null && (matcher = this.mappingPattern.matcher((CharSequence)object)).matches() && (string = matcher.group(1)) != null && !string.equals("") && (baseEntityField = (BaseEntityField)hashMap.get(string)) == null) {
                baseEntityField = (BaseEntityField)hashMap.get(string.toLowerCase());
            }
            if (baseEntityField == null) continue;
            dataImportEntityFieldMapping.setEntityField(baseEntityField);
        }
        return arrayList;
    }

    public void setXmlFileOut() {
        this.xmlFileName = this.params.getXmlFileName();
        if (this.xmlFileName == null) {
            this.xmlFileName = "sample.xml";
        }
    }

    private boolean getResultSet() throws SQLException {
        try {
            this.stmt = this.conn.createStatement();
            this.results = this.stmt.executeQuery(this.sqlQuery);
            this.info = this.results.getMetaData();
            this.colCount = this.info.getColumnCount();
        }
        catch (SQLException sQLException) {
            CoreUtilities.logException(sQLException);
            throw sQLException;
        }
        return true;
    }

    private boolean createFieldGroup(ITemplate iTemplate, DataImportEntityFieldMapping dataImportEntityFieldMapping, List list, Map map) {
        if (list.size() == 0) {
            return false;
        }
        boolean bl = false;
        Record record = null;
        BaseEntityType baseEntityType = dataImportEntityFieldMapping.getEntityType();
        if (baseEntityType.isPrimaryType()) {
            record = new Record(iTemplate);
        } else {
            FieldGroup fieldGroup = (FieldGroup)map.get(new Integer(dataImportEntityFieldMapping.getParentEntityGroup()));
            if (fieldGroup == null) {
                bl = true;
            }
            record = new FieldGroup(iTemplate, (IEntityType)dataImportEntityFieldMapping.getEntityType(), fieldGroup);
        }
        this.createFields(iTemplate, (FieldGroup)record, list);
        map.put(new Integer(dataImportEntityFieldMapping.getEntityGroup()), record);
        return bl;
    }

    private List createFields(ITemplate iTemplate, FieldGroup fieldGroup, List list) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            IEntityField iEntityField = (IEntityField)objectArray[0];
            String string = (String)objectArray[1];
            arrayList.add(new Field(iTemplate, fieldGroup, iEntityField, string));
        }
        return arrayList;
    }

    public List processImport(String string, String string2, String string3) throws DataImportMappingException, DataImportSourceException, SQLException {
        return this.processImport(this.getFieldMappings(), false, string, string2, string3);
    }

    public List processImport(List list, boolean bl, String string, String string2, String string3) throws DataImportMappingException, SQLException, DataImportSourceException {
        List list2;
        int n = 0;
        try {
            if (!bl) {
                DataImportEntityFieldMapping.isMappingSetUseable(list);
            }
            BaseEntityType baseEntityType = this.catalogTemplate.getPrimaryEntityType();
            DataImportSourceException dataImportSourceException = new DataImportSourceException(this.params.getSeparator());
            while (this.results.next()) {
                ++n;
                boolean bl2 = false;
                boolean bl3 = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = 0;
                ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
                HashMap hashMap = new HashMap();
                boolean bl4 = false;
                DataImportEntityFieldMapping dataImportEntityFieldMapping = null;
                DataImportEntityFieldMapping dataImportEntityFieldMapping2 = null;
                for (int i = 1; i <= this.colCount; ++i) {
                    Object object;
                    DataImportEntityFieldMapping dataImportEntityFieldMapping3 = (DataImportEntityFieldMapping)list.get(i - 1);
                    if (!dataImportEntityFieldMapping3.isSkip()) {
                        object = dataImportEntityFieldMapping3.getEntityField();
                        if (dataImportEntityFieldMapping3.getEntityGroup() != n2) {
                            if (this.createFieldGroup(this.catalogTemplate, dataImportEntityFieldMapping2, arrayList2, hashMap)) {
                                bl3 = true;
                            }
                            n2 = dataImportEntityFieldMapping3.getEntityGroup();
                            arrayList2 = new ArrayList();
                            dataImportEntityFieldMapping = dataImportEntityFieldMapping2;
                        }
                        dataImportEntityFieldMapping2 = dataImportEntityFieldMapping3;
                        String string4 = this.canonicalStrings.getString(this.results.getString(i));
                        arrayList.add(string4);
                        if (string4 != null && !string4.equals("")) {
                            boolean bl5 = false;
                            if (string4.length() > 3900) {
                                dataImportSourceException.addLine(n, 2, arrayList);
                                bl5 = true;
                            } else if (object.getFieldType() == 2) {
                                try {
                                    int n3 = new Integer(string4);
                                    IntegerRange integerRange = object.getIntegerRange();
                                    if (integerRange != null && (n3 < integerRange.getMinValue() || n3 > integerRange.getMaxValue())) {
                                        dataImportSourceException.addLine(n, 4, arrayList);
                                        bl5 = true;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    dataImportSourceException.addLine(n, 3, arrayList);
                                    bl5 = true;
                                }
                            }
                            if (!bl5) {
                                if (object.getParentEntityType().isPrimaryType()) {
                                    bl2 = true;
                                }
                                arrayList2.add(new Object[]{object, string4});
                            }
                        }
                    }
                    if (i != this.colCount) continue;
                    object = dataImportEntityFieldMapping3;
                    if (((DataImportEntityFieldMapping)object).isSkip()) {
                        for (int j = i - 1; j > 0 && ((DataImportEntityFieldMapping)(object = (DataImportEntityFieldMapping)list.get(j - 1))).isSkip() && object != dataImportEntityFieldMapping; --j) {
                        }
                    }
                    if (((DataImportEntityFieldMapping)object).isSkip() || object == dataImportEntityFieldMapping || !this.createFieldGroup(this.catalogTemplate, (DataImportEntityFieldMapping)object, arrayList2, hashMap)) continue;
                    bl3 = true;
                }
                if (!bl2) {
                    dataImportSourceException.addLine(n, 0, arrayList);
                    continue;
                }
                if (bl3) {
                    dataImportSourceException.addLine(n, 1, arrayList);
                    continue;
                }
                this.entityBuilder.addRecord((Record)hashMap.get(new Integer(0)));
            }
            if (dataImportSourceException.getLines().size() > 0) {
                throw dataImportSourceException;
            }
            list2 = this.entityBuilder.getSourceImportEntities(null);
            Object var26_29 = null;
        }
        catch (Exception exception) {
            try {
                if (!(exception instanceof DataImportSourceException)) {
                    throw new UnexpectedErrorException(n, exception);
                }
                throw (DataImportSourceException)exception;
            }
            catch (Throwable throwable) {
                Object var26_30 = null;
                this.results.close();
                this.stmt.close();
                this.entityBuilder = new SourceImportEntityBuilder();
                this.canonicalStrings = new CanonicalStringCache();
                throw throwable;
            }
        }
        this.results.close();
        this.stmt.close();
        this.entityBuilder = new SourceImportEntityBuilder();
        this.canonicalStrings = new CanonicalStringCache();
        return list2;
    }

    private void updateDocument(Document document, List list, String string, String string2, String string3) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element;
            Element element2;
            Object object;
            Object object2;
            Object object3;
            SourceImportEntity sourceImportEntity = (SourceImportEntity)iterator.next();
            Element element3 = document.createElement("entity");
            document.getDocumentElement().appendChild(element3);
            Element element4 = document.createElement("entityTypeName");
            element4.appendChild(document.createTextNode(sourceImportEntity.getEntityType().getName()));
            element3.appendChild(element4);
            Element element5 = document.createElement("entityTypeID");
            element5.appendChild(document.createTextNode("" + sourceImportEntity.getEntityType().getID()));
            element3.appendChild(element5);
            Element element6 = document.createElement("entityID");
            element6.appendChild(document.createTextNode("" + sourceImportEntity.getEntityID()));
            element3.appendChild(element6);
            Element element7 = document.createElement("institutionID");
            element7.appendChild(document.createTextNode(string));
            element3.appendChild(element7);
            Element element8 = document.createElement("collectionID");
            element8.appendChild(document.createTextNode(string2));
            element3.appendChild(element8);
            Element element9 = document.createElement("vcID");
            element9.appendChild(document.createTextNode(string3));
            element3.appendChild(element9);
            Element element10 = document.createElement("entityFieldValues");
            element3.appendChild(element10);
            HashMap<Object, Element> hashMap = new HashMap<Object, Element>();
            Object object4 = sourceImportEntity.getEntityFieldValues().iterator();
            while (object4.hasNext()) {
                object3 = (Object[])object4.next();
                object2 = (IEntityField)object3[0];
                object = (String)object3[1];
                element2 = (Element)hashMap.get(object2);
                if (element2 == null) {
                    element = document.createElement("entityFieldValue");
                    element10.appendChild(element);
                    Element element11 = document.createElement("fieldName");
                    element11.appendChild(document.createTextNode(object2.getName()));
                    element.appendChild(element11);
                    element2 = document.createElement("values");
                    element.appendChild(element2);
                    hashMap.put(object2, element2);
                }
                element = document.createElement("value");
                element.appendChild(document.createTextNode((String)object));
                element2.appendChild(element);
            }
            if (sourceImportEntity.getRelatedSourceEntities().size() <= 0) continue;
            object4 = document.createElement("relEntities");
            element3.appendChild((Node)object4);
            object3 = sourceImportEntity.getRelatedSourceEntities().iterator();
            while (object3.hasNext()) {
                object2 = (SourceImportEntity)object3.next();
                object = document.createElement("relatedEntity");
                object4.appendChild((Node)object);
                element2 = document.createElement("relatedEntityTypeID");
                element2.appendChild(document.createTextNode(((SourceImportEntity)object2).getEntityType().getID() + ""));
                object.appendChild(element2);
                element = document.createElement("relatedEntityID");
                element.appendChild(document.createTextNode(((SourceImportEntity)object2).getEntityID() + ""));
                object.appendChild(element);
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            if (stringArray.length == 2) {
                CoreUtilities.logAlways("Usage: java DataImportModule <inputFile> <delimiterType>");
                string = stringArray[0];
                string2 = stringArray[1];
            }
        }
        catch (Exception exception) {
            CoreUtilities.logError(exception.toString());
        }
        if (stringArray.length == 0) {
            JFrame jFrame = new JFrame();
            FileDialog fileDialog = new FileDialog((Frame)jFrame, "Select a file to convert to XML");
            fileDialog.setMode(0);
            fileDialog.show();
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            try {
                long l = System.currentTimeMillis();
                if (fileDialog.getFile() == null && bl) {
                    CoreUtilities.logError("You must select a file...");
                } else {
                    DataImportParams dataImportParams = DataImportFactory.getDataImportParams();
                    dataImportParams.setFileDriverProfile(file, "\t");
                    DataImportModule dataImportModule = new DataImportModule(null, dataImportParams);
                    long l2 = System.currentTimeMillis();
                    CoreUtilities.logInfo("TIme to convert to XML: " + (double)(l2 - l) / 1000.0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
    }

    public DataImportParams getParams() {
        return this.params;
    }

    public void setParams(DataImportParams dataImportParams) {
        this.params = dataImportParams;
    }

    class CanonicalStringCache {
        Map stringPool = new HashMap();

        public String getString(String string) {
            String string2 = (String)this.stringPool.get(string);
            if (string2 == null) {
                this.stringPool.put(string, string);
                return string;
            }
            return string2;
        }
    }
}

