/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.dataimport;

import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.dataimport.DataImportModule;
import com.luna.insight.core.dataimport.DataImportParams;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.EnhancedProperties;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;

public class DataImportFactory {
    private static EnhancedProperties properties = null;

    public static void configure() {
        DataImportFactory.configure("InsightDataImport.dat");
    }

    public static void configure(String string) {
        properties = DataImportFactory.loadProperties(string);
    }

    protected static EnhancedProperties loadProperties(String string) {
        EnhancedProperties enhancedProperties = new EnhancedProperties();
        try {
            CoreUtilities.logInfo("propsfile: " + string);
            FileInputStream fileInputStream = new FileInputStream(string);
            enhancedProperties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            CoreUtilities.logInfo("Cannot read configuration file: " + string + " Using defaults");
        }
        return enhancedProperties;
    }

    public static DataImportModule getImportModule(BaseTemplate baseTemplate) throws ParserConfigurationException {
        return new DataImportModule(baseTemplate);
    }

    public static DataImportParams getDataImportParams() {
        return new DataImportParams(properties);
    }
}

