/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog.utils;

import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IEntityType;
import com.luna.insight.core.catalog.iface.ITemplate;
import com.luna.insight.core.catalog.iface.ITemplateElement;
import com.luna.insight.core.catalog.utils.RecordListConstants;
import com.luna.insight.core.util.CSVLogger;
import com.luna.insight.core.util.XMLWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class CatalogTemplateWriter
implements RecordListConstants {
    public static final int WRITE_CSV = 0;
    public static final int WRITE_XML_INSTANCE = 1;
    public static final String CSV_SEPARATOR = "csv_sep";
    public static final String XML_DOCTYPE = "doctype";
    public static final String XML_SYSTEM = "SYSTEM";
    public static final String XML_XMLNS = "xmlns";
    protected static final String EOL = System.getProperty("line.separator");
    protected static final String DEFAULT_CSV_SEPARATOR = "\t";
    protected int writeMode;
    protected String csvSeparator;
    protected boolean firstField;
    protected String doctype;
    protected String system;
    protected String xmlns;

    public static CatalogTemplateWriter getInstance(int n, Map map) {
        return new CatalogTemplateWriter(n, map);
    }

    protected CatalogTemplateWriter(int n, Map map) {
        this.writeMode = n;
        switch (this.writeMode) {
            case 0: {
                this.csvSeparator = map.get(CSV_SEPARATOR) == null ? DEFAULT_CSV_SEPARATOR : (String)map.get(CSV_SEPARATOR);
                break;
            }
            case 1: {
                this.doctype = (String)map.get(XML_DOCTYPE);
                this.system = (String)map.get(XML_SYSTEM);
                this.xmlns = (String)map.get(XML_XMLNS);
            }
        }
    }

    public void write(Writer writer, ITemplate iTemplate) throws IOException {
        switch (this.writeMode) {
            case 0: {
                this.writeCSV(writer, iTemplate);
                break;
            }
            case 1: {
                this.writeXmlInstance(writer, iTemplate);
            }
        }
    }

    protected void writeXmlInstance(Writer writer, ITemplate iTemplate) throws IOException {
        XMLWriter xMLWriter = new XMLWriter(writer, this.doctype, this.system, this.xmlns);
        int n = 1900 + new Date().getYear();
        xMLWriter.appendHeader();
        xMLWriter.appendComment(new String[]{"XML File generated by Insight Studio", "Copyright (C) " + n + " Luna Imaging"});
        xMLWriter.appendElement("recordList");
        this.writeXmlInstanceEntityType(xMLWriter, iTemplate.getPrimaryEntityType());
        xMLWriter.closeElements(-1);
        xMLWriter.flush();
    }

    protected void writeXmlInstanceEntityType(XMLWriter xMLWriter, IEntityType iEntityType) throws IOException {
        if (iEntityType == null) {
            return;
        }
        String string = iEntityType.isPrimaryType() ? "record" : "fieldGroup";
        xMLWriter.appendElement(string, new String[]{"type"}, new String[]{iEntityType.getDisplayName()}, null, false);
        Iterator iterator = iEntityType.getElements().iterator();
        while (iterator.hasNext()) {
            ITemplateElement iTemplateElement = (ITemplateElement)iterator.next();
            if (iTemplateElement instanceof IEntityType) {
                this.writeXmlInstanceEntityType(xMLWriter, (IEntityType)iTemplateElement);
                continue;
            }
            if (!(iTemplateElement instanceof IEntityField)) continue;
            xMLWriter.appendAndCloseElement("field", new String[]{"type"}, new String[]{((IEntityField)iTemplateElement).getDisplayName()}, "");
        }
        xMLWriter.closeElements(1);
        xMLWriter.flush();
    }

    protected void writeCSV(Writer writer, ITemplate iTemplate) throws IOException {
        CSVLogger.setSeparator(this.csvSeparator);
        this.firstField = true;
        this.writeCSVEntityType(writer, iTemplate.getPrimaryEntityType());
        CSVLogger.writeEndOfRecord(writer, EOL);
    }

    protected void writeCSVEntityType(Writer writer, IEntityType iEntityType) throws IOException {
        if (iEntityType == null) {
            return;
        }
        Iterator iterator = iEntityType.getEntityFields().iterator();
        while (iterator.hasNext()) {
            String string;
            IEntityField iEntityField = (IEntityField)iterator.next();
            if (iEntityField == null || (string = iEntityField.getDisplayName()) == null || string.equals("")) continue;
            if (this.firstField) {
                CSVLogger.writeFirstRecord(writer, string);
                this.firstField = false;
                continue;
            }
            CSVLogger.write(writer, string);
        }
        iterator = iEntityType.getRelatedEntityTypes().iterator();
        while (iterator.hasNext()) {
            this.writeCSVEntityType(writer, (IEntityType)iterator.next());
        }
    }
}

