/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog;

import com.luna.insight.core.catalog.CatalogTemplate;
import com.luna.insight.core.catalog.TemplateEntityField;
import com.luna.insight.core.catalog.TemplateEntityType;
import com.luna.insight.core.catalog.TemplateManager;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.ITemplateElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersistentCatalogTemplate
extends CatalogTemplate {
    protected int baseTemplateID;
    protected boolean isOwnedTemplate = true;
    protected transient String fileName = null;

    public static PersistentCatalogTemplate createPersistentCatalogTemplate(String string) {
        return new PersistentCatalogTemplate(string, -1);
    }

    public static PersistentCatalogTemplate createPersistentCatalogTemplate(Document document, Map map) {
        return new PersistentCatalogTemplate(document, map);
    }

    public static PersistentCatalogTemplate createPersistentCatalogTemplate(BaseTemplate baseTemplate, String string, boolean bl) {
        int n = baseTemplate instanceof PersistentCatalogTemplate ? ((PersistentCatalogTemplate)baseTemplate).getBaseTemplateID() : baseTemplate.getTemplateID();
        PersistentCatalogTemplate persistentCatalogTemplate = new PersistentCatalogTemplate(string, n);
        return PersistentCatalogTemplate.updateTemplateProperties(persistentCatalogTemplate, baseTemplate, bl) ? persistentCatalogTemplate : null;
    }

    public PersistentCatalogTemplate(String string, int n) {
        super(string);
        this.baseTemplateID = n;
        this.fileName = string + TemplateManager.TEMPLATE_SUFFIX;
    }

    public PersistentCatalogTemplate(Document document, Map map) {
        super("");
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("entities");
        HashMap hashMap = this.setTemplateProperties(element);
        HashMap hashMap2 = this.getEntityElements((Element)nodeList.item(0), map);
        String[][] stringArray = (String[][])hashMap.get("primary");
        if (stringArray != null) {
            String string = stringArray[0][1];
            TemplateEntityType templateEntityType = (TemplateEntityType)hashMap2.remove(string);
            this.setPrimaryEntityType(templateEntityType);
            this.linkImportedElements(templateEntityType, string, hashMap2);
        }
    }

    protected void linkImportedElements(TemplateEntityType templateEntityType, String string, HashMap hashMap) {
        List list = (List)hashMap.remove("refList:" + string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BaseTemplateElement baseTemplateElement;
                Object[] objectArray = (Object[])iterator.next();
                String string2 = ((String[][])objectArray[1])[0][1];
                if (objectArray[0].equals("field")) {
                    baseTemplateElement = (TemplateEntityField)hashMap.remove(string2);
                    baseTemplateElement.setParentEntityType(templateEntityType);
                    continue;
                }
                baseTemplateElement = (TemplateEntityType)hashMap.remove(string2);
                baseTemplateElement.setParentEntityType(templateEntityType);
                this.linkImportedElements((TemplateEntityType)baseTemplateElement, string2, hashMap);
            }
        }
    }

    protected HashMap getEntityElements(Element element, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ITemplateElement iTemplateElement;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            String string = ((Element)node).getAttribute("id");
            HashMap hashMap2 = this.parseElementProperties((Element)node);
            if (node.getNodeName().equals("entity")) {
                iTemplateElement = TemplateEntityType.createInstance(this, hashMap2);
                NodeList nodeList2 = ((Element)node).getElementsByTagName("elements");
                List list = this.parseElementList((Element)nodeList2.item(0));
                if (list.size() != 0) {
                    hashMap.put("refList:" + string, list);
                }
            } else if (node.getNodeName().equals("field")) {
                iTemplateElement = TemplateEntityField.createInstance(this, hashMap2, map);
            } else {
                System.out.println("logic error");
                continue;
            }
            hashMap.put(string, iTemplateElement);
        }
        return hashMap;
    }

    protected HashMap setTemplateProperties(Element element) {
        HashMap hashMap = this.parseElementProperties(element);
        String string = (String)hashMap.get("name");
        this.setTemplateName(string);
        string = (String)hashMap.get("version");
        if (string != null) {
            this.setVersion(string);
        }
        if ((string = (String)hashMap.get("version_info")) != null) {
            this.setVersionInfo(string);
        }
        if ((string = (String)hashMap.get("description_url")) != null) {
            this.setDescriptionURL(string);
        }
        this.setPersonalCollectionTemplate(new Boolean((String)hashMap.get("is_pccollections")));
        this.setPublished(new Boolean((String)hashMap.get("is_published")));
        return hashMap;
    }

    protected HashMap parseElementProperties(Element element) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = element.getAttribute("id");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            String string2 = node.getNodeName();
            if (string2.equals("#text")) continue;
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                if (object.getLength() == 1) {
                    String string3 = object.item(0).getNodeValue();
                    hashMap.put(string2, string3);
                }
                for (int j = 0; j < object.getLength(); ++j) {
                    List<String> list;
                    NodeList nodeList2;
                    Node node2 = object.item(j);
                    String string4 = node2.getNodeName();
                    if (!node2.hasChildNodes() || (nodeList2 = node2.getChildNodes()).getLength() != 1) continue;
                    String string5 = nodeList2.item(0).getNodeValue();
                    if (!hashMap.containsKey(string4)) {
                        list = new ArrayList<String>();
                        list.add(string5);
                        hashMap.put(string4, list);
                        continue;
                    }
                    list = (List)hashMap.get(string4);
                    list.add(string5);
                    hashMap.put(string4, list);
                }
                continue;
            }
            object = node.getAttributes();
            String[][] stringArray = new String[object.getLength()][2];
            for (int j = 0; j < object.getLength(); ++j) {
                node = object.item(j);
                stringArray[j][0] = node.getNodeName();
                stringArray[j][1] = node.getNodeValue();
            }
            if (stringArray.length <= 0) continue;
            hashMap.put(string2, stringArray);
        }
        return hashMap;
    }

    protected List parseElementList(Element element) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = element.getAttribute("id");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String[][] stringArray;
            Object object;
            Node node = nodeList.item(i);
            String string2 = node.getNodeName();
            if (string2.equals("#text")) continue;
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                if (object.getLength() != 1) continue;
                stringArray = new Object[]{string2, object.item(0).getNodeValue()};
                arrayList.add(stringArray);
                continue;
            }
            object = node.getAttributes();
            stringArray = new String[object.getLength()][2];
            for (int j = 0; j < object.getLength(); ++j) {
                node = object.item(j);
                stringArray[j][0] = node.getNodeName();
                stringArray[j][1] = node.getNodeValue();
            }
            if (stringArray.length <= 0) continue;
            Object[] objectArray = new Object[]{string2, stringArray};
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    public int getBaseTemplateID() {
        return this.baseTemplateID;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Boolean isOwnedTemplate() {
        return new Boolean(this.isOwnedTemplate);
    }

    public void setOwnedTemplate(Boolean bl) {
        this.isOwnedTemplate = bl;
    }

    public boolean equals(Object object) {
        return object != null && object == this || object instanceof CatalogTemplate && ((CatalogTemplate)object).getTemplateName().equals(this.getTemplateName());
    }
}

