/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.util;

import com.luna.insight.core.util.CoreUtilities;
import java.io.Serializable;

public class URLResponseResult
implements Serializable {
    static final long serialVersionUID = -7528168543768356819L;
    public static final int HTTP_OK = 200;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    private String responseString = null;
    private String urlData = null;
    private long lastModifiedDate;
    private int responseCode;
    private Throwable exception = null;

    URLResponseResult(int n, long l, String string, String string2) {
        this.responseCode = n;
        this.lastModifiedDate = l;
        this.responseString = string;
        this.urlData = string2;
    }

    URLResponseResult(Throwable throwable) {
        this.exception = throwable;
    }

    public boolean isValidResponse() {
        return this.exception == null;
    }

    public boolean isModifiedResponse() {
        return this.responseCode != 304;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long l) {
        this.lastModifiedDate = l;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseString() {
        return this.responseString;
    }

    public String getUrlData() {
        return this.urlData;
    }

    public void clearUrlData() {
        this.urlData = null;
    }

    public String toString() {
        if (this.exception == null) {
            return "code: " + this.responseCode + " message: " + this.responseString + " modified: " + CoreUtilities.formatUTCDateZ((long)this.lastModifiedDate) + " length: " + this.urlData.length();
        }
        return this.exception.getLocalizedMessage();
    }
}

