/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.util;

import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IRegistry;
import com.luna.insight.oai.util.Assert;
import com.luna.insight.oai.util.StaticRepository;
import com.luna.insight.oai.util.URLResponseResult;
import com.luna.insight.oai.util.URLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class URLRegistry
implements IRegistry,
IOAIConstants,
Runnable {
    protected HashMap registryMap;
    protected HashMap repositoryMap;
    protected File registryFile;
    protected DocumentBuilder builder;
    protected String gatewayURL;
    protected IMessageWriter logger = IMessageWriter.NULL_MESSAGE_WRITER;
    protected static File repositoryParent = null;

    public static File getRepositoryParent() {
        return repositoryParent;
    }

    public URLRegistry(IMessageWriter iMessageWriter, String string, String string2, DocumentBuilder documentBuilder) throws IOException {
        Assert.notNull(string);
        Assert.notNull(documentBuilder);
        Assert.notNull(string2);
        if (iMessageWriter != null) {
            this.logger = iMessageWriter;
        }
        this.builder = documentBuilder;
        this.gatewayURL = string2;
        if (!this.gatewayURL.endsWith("/")) {
            this.gatewayURL = this.gatewayURL + "/";
        }
        this.restoreRegistry(string);
        Thread thread = new Thread((Runnable)this, "URLRegistry");
        thread.setDaemon(true);
        thread.start();
    }

    protected void restoreRegistry(String string) throws IOException {
        this.registryFile = new File(string);
        repositoryParent = this.registryFile.getParentFile();
        if (!repositoryParent.exists()) {
            if (repositoryParent.mkdirs()) {
                this.logger.writeInfo("soai.registry.path.create", new Object[]{this.registryFile.getParent()});
            } else {
                this.logger.writeWarning("soai.registry.path.badcreate", new Object[]{this.registryFile.getParent()});
            }
        } else if (!repositoryParent.canRead() || !repositoryParent.canWrite()) {
            this.logger.writeWarning("soai.registry.path.perms", new Object[]{this.registryFile.getParent()});
        }
        this.repositoryMap = new HashMap();
        if (this.registryFile.exists()) {
            Object object;
            String string2;
            this.registryMap = (HashMap)this.loadSerializeableObjectFromFS(repositoryParent, this.registryFile.getName());
            this.logger.writeInfo("soai.registry.restore");
            Iterator<Object> iterator = this.registryMap.keySet().iterator();
            Vector<Object> vector = new Vector<Object>();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                object = "http://" + string2;
                vector.add(object);
            }
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                object = this.refreshRegistryUrl(string2);
                ((StaticRepository)object).setLogger(this.logger);
                if (((StaticRepository)object).getRepositoryDocument() == null) {
                    this.loadDocument((StaticRepository)object, string2);
                    continue;
                }
                this.repositoryMap.put(((StaticRepository)object).getRepositoryUrl(), object);
            }
        } else {
            this.registryMap = new HashMap();
            this.logger.writeInfo("soai.registry.create");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticRepository refreshRegistryUrl(String string) throws IOException {
        if (string != null) {
            StaticRepository staticRepository;
            boolean bl = false;
            String string2 = string.substring(7);
            Object object = this;
            synchronized (object) {
                staticRepository = (StaticRepository)this.get(string2);
                if (staticRepository == null) {
                    staticRepository = new StaticRepository(string2);
                    bl = true;
                }
                staticRepository.setLogger(this.logger);
            }
            if (!bl && staticRepository.getStatus() == -1) {
                return staticRepository;
            }
            object = staticRepository.getResponseResult();
            long l = object != null ? ((URLResponseResult)object).getLastModifiedDate() : Long.MIN_VALUE;
            this.logger.writeInfo("soai.registry.read", new Object[]{string});
            long l2 = System.currentTimeMillis();
            object = URLUtils.readURL(string, l);
            staticRepository.setResponseResult((URLResponseResult)object);
            if (((URLResponseResult)object).isValidResponse()) {
                switch (((URLResponseResult)object).getResponseCode()) {
                    case 304: {
                        this.logger.writeInfo("soai.registry.unchanged", new Object[]{string});
                        return staticRepository;
                    }
                    case 403: 
                    case 404: {
                        this.remove(string2);
                        this.logger.writeInfo("soai.registry.unavailable", new Object[]{string});
                        return staticRepository;
                    }
                    case 200: {
                        this.logger.writeInfo("soai.registry.readcomplete", new Object[]{string, "" + (System.currentTimeMillis() - l2)});
                        ((URLResponseResult)object).setLastModifiedDate(System.currentTimeMillis());
                        this.put(string2, staticRepository);
                        return staticRepository;
                    }
                }
            } else {
                return staticRepository;
            }
        }
        return null;
    }

    public Serializable loadSerializeableObjectFromFS(File file, String string) {
        if (file == null || string == null || string.trim().equals("")) {
            return null;
        }
        File file2 = new File(file, string);
        if (file2.isDirectory() || !file2.exists() || !file2.canRead()) {
            return null;
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file2), 4096));
            Serializable serializable = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
            return serializable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean writeSerializeableObjectToFS(File file, String string, Serializable serializable, boolean bl) {
        if (file == null || serializable == null) {
            return false;
        }
        File file2 = new File(file, string);
        if (file2.isDirectory() || file2.exists() && !bl || !file2.canRead() && file2.canWrite()) {
            return false;
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2), 4096));
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int size() {
        return this.registryMap.size();
    }

    public boolean isEmpty() {
        return this.registryMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.registryMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.registryMap.containsValue(object);
    }

    public Object get(Object object) {
        return this.registryMap.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        StaticRepository staticRepository;
        block15: {
            if (object == null) {
                return null;
            }
            staticRepository = (StaticRepository)this.registryMap.put(object, object2);
            StaticRepository staticRepository2 = (StaticRepository)object2;
            URLResponseResult uRLResponseResult = staticRepository2.getResponseResult();
            try {
                if (uRLResponseResult.getUrlData() != null) {
                    String string = uRLResponseResult.getUrlData();
                    uRLResponseResult.clearUrlData();
                    if (staticRepository2.getFileData() == null) {
                        staticRepository2.setFileData(new File(repositoryParent, new UID().toString().replace(':', '_')));
                    }
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(staticRepository2.getFileData()), "UTF8"));
                    HashMap hashMap = this.registryMap;
                    synchronized (hashMap) {
                        this.registryMap.notify();
                    }
                    bufferedWriter.write(string);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    this.processDocument(staticRepository2);
                    if (staticRepository2.getStatus() == 0) {
                        this.logger.writeInfo("soai.registry.file.saved", new Object[]{staticRepository2.getFileData().getCanonicalPath()});
                        this.logger.writeInfo("soai.registry.register", new Object[]{object});
                        break block15;
                    }
                    this.registryMap.remove(object);
                    staticRepository2.getFileData().delete();
                    hashMap = this.registryMap;
                    synchronized (hashMap) {
                        this.registryMap.notify();
                    }
                    this.logger.writeInfo("soai.registry.file.deregistered", new Object[]{staticRepository2.getFileData().getCanonicalPath()});
                    break block15;
                }
                HashMap hashMap = this.registryMap;
                synchronized (hashMap) {
                    this.registryMap.notify();
                }
            }
            catch (IOException iOException) {
                this.logger.writeError("soai.registry.file.error", iOException);
            }
        }
        return staticRepository;
    }

    protected void loadDocument(final StaticRepository staticRepository, final String string) {
        new Thread("Repository Loader"){

            public void run() {
                if (staticRepository.getStatus() != 1) {
                    URLRegistry.this.processDocument(staticRepository);
                    URLRegistry.this.logger.writeInfo("soai.registry.restore.url", new Object[]{string});
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDocument(StaticRepository staticRepository) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DocumentBuilder documentBuilder2 = this.builder;
            synchronized (documentBuilder2) {
                long l = System.currentTimeMillis();
                staticRepository.setInitializing();
                this.logger.writeInfo("soai.registry.parsing", new Object[]{"http://" + staticRepository.getBaseUrl()});
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(staticRepository.getFileData()), 4096);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "UTF8");
                document = documentBuilder.parse(new InputSource(inputStreamReader));
                staticRepository.setRepositoryDocument(this.gatewayURL, document);
                if (staticRepository.getRepositoryDocument() != null) {
                    this.logger.writeInfo("soai.registry.parsing.complete", new Object[]{"http://" + staticRepository.getBaseUrl(), "" + (System.currentTimeMillis() - l)});
                }
            }
        }
        catch (Exception exception) {
            staticRepository.setRepositoryDocument(this.gatewayURL, null);
            this.logger.writeInfo("soai.registry.parsing.exception", new Object[]{"http://" + staticRepository.getBaseUrl(), exception.getLocalizedMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        HashMap hashMap = this.registryMap;
        synchronized (hashMap) {
            Object v = this.registryMap.remove(object);
            if (v != null) {
                StaticRepository staticRepository = (StaticRepository)v;
                staticRepository.cleanup();
                this.logger.writeInfo("soai.registry.deregister", new Object[]{object});
                this.registryMap.notify();
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            HashMap hashMap = this.registryMap;
            synchronized (hashMap) {
                try {
                    this.registryMap.wait();
                    this.writeSerializeableObjectToFS(repositoryParent, this.registryFile.getName(), this.registryMap, true);
                    this.logger.writeInfo("soai.registry.rewrite");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

