/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.util;

import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.util.URLResponseResult;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaticRepository
implements Serializable,
IOAIConstants {
    static final long serialVersionUID = -7372711284009263051L;
    public static final int RP_INITIALIZE = -1;
    public static final int RP_DOCUMENT_VALID = 0;
    public static final int RP_DOCUMENT_ERROR = 1;
    private String baseUrl;
    private String repositoryURL;
    private File fileData = null;
    private URLResponseResult result = null;
    private int status = -1;
    private int recordCount = 0;
    private transient Map docNodeMap;
    private transient Document document;
    private transient IMessageWriter logger = IMessageWriter.NULL_MESSAGE_WRITER;

    public StaticRepository(String string) {
        this.baseUrl = string;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getRepositoryUrl() {
        return this.repositoryURL;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public File getFileData() {
        return this.fileData;
    }

    public void cleanup() {
        if (this.fileData != null && this.fileData.exists()) {
            this.fileData.delete();
            this.fileData = null;
        }
    }

    public void setFileData(File file) {
        this.fileData = file;
    }

    public void setLogger(IMessageWriter iMessageWriter) {
        this.logger = iMessageWriter != null ? iMessageWriter : IMessageWriter.NULL_MESSAGE_WRITER;
    }

    public URLResponseResult getResponseResult() {
        return this.result;
    }

    public void setResponseResult(URLResponseResult uRLResponseResult) {
        this.result = uRLResponseResult;
    }

    public synchronized void setRepositoryDocument(String string, Document document) {
        this.document = document;
        if (document != null) {
            this.status = 0;
            this.docNodeMap = new HashMap();
            if (!this.performDocumentIndexing(string)) {
                this.document = null;
                this.docNodeMap = null;
                this.status = 1;
            }
        } else {
            this.status = 1;
            this.docNodeMap = null;
        }
    }

    protected boolean performDocumentIndexing(String string) {
        this.logger.writeInfo("soai.registry.indexing.start", new Object[]{this.baseUrl});
        long l = System.currentTimeMillis();
        Element element = this.document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("Identify");
        Node node = nodeList.item(0);
        this.docNodeMap.put("Identify", node);
        nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (!string2.endsWith(":baseURL") && !string2.equals("baseURL")) continue;
            nodeList = node2.getChildNodes();
            String string3 = nodeList.item(0).getNodeValue();
            this.repositoryURL = string + this.baseUrl;
            if (string3.equals(this.repositoryURL)) break;
            this.logger.writeWarning("soai.registry.parsing.spec.exception", new Object[]{string3, this.repositoryURL});
            return false;
        }
        nodeList = element.getElementsByTagName("ListMetadataFormats");
        node = nodeList.item(0);
        this.docNodeMap.put("ListMetadataFormats", node);
        if (!this.indexRecords(element.getElementsByTagName("ListRecords"))) {
            this.logger.writeInfo("soai.registry.indexing.counterror", new Object[]{this.baseUrl});
            return false;
        }
        this.logger.writeInfo("soai.registry.indexing.complete", new Object[]{this.baseUrl, "" + (System.currentTimeMillis() - l)});
        return true;
    }

    protected boolean indexRecords(NodeList nodeList) {
        boolean bl = false;
        boolean bl2 = false;
        int n = nodeList.getLength();
        for (int i = 0; i < n && !bl2; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = node.getChildNodes();
            if (!bl) {
                this.recordCount = nodeList2.getLength();
                continue;
            }
            bl2 = this.recordCount != nodeList2.getLength();
        }
        return !bl2;
    }

    public Document getRepositoryDocument() {
        return this.document;
    }

    public int getStatus() {
        return this.status;
    }

    public void setInitializing() {
        this.status = -1;
    }
}

