/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.util;

import java.util.Collection;
import java.util.Map;

public class Assert {
    public static void isTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void isTrue(boolean bl) {
        Assert.isTrue(bl, "[Assertion failed] - this expression must be true");
    }

    public static void notNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it cannot be null");
    }

    public static void doesNotContain(String string, String string2, String string3) {
        if (string.indexOf(string2) != -1) {
            throw new IllegalArgumentException(string3);
        }
    }

    public static void doesNotContain(String string, String string2) {
        Assert.doesNotContain(string, string2, "[Assertion failed] - this String argument must not contain the substring [" + string2 + "]");
    }

    public static void notEmpty(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(Object[] objectArray) {
        Assert.notEmpty(objectArray, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Collection collection, String string) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(Collection collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Map map, String string) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(Map map) {
        Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static void isInstanceOf(Class clazz, Object object) {
        Assert.isInstanceOf(clazz, object, "");
    }

    public static void isInstanceOf(Class clazz, Object object, String string) {
        Assert.notNull(clazz, "The clazz to perform the instanceof assertion cannot be null");
        Assert.isTrue(clazz.isInstance(object), string + "Object of class '" + (object != null ? object.getClass().getName() : "[null]") + "' must be an instance of '" + clazz.getName() + "'");
    }

    public static void state(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void state(boolean bl) {
        Assert.state(bl, "[Assertion failed] - this state invariant must be true");
    }
}

