/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.handlers.statik;

import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.oai.BasicResumptionToken;
import com.luna.insight.oai.handlers.BaseResumableVerb;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IPropertySource;
import com.luna.insight.oai.iface.IRegistry;
import com.luna.insight.oai.iface.IRequestHandler;
import com.luna.insight.oai.util.Assert;
import com.luna.insight.oai.util.InvalidTokenException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListRecords
extends BaseResumableVerb {
    protected IRegistry urlRegistry;
    protected static final String TOKEN_PREFIX = "resume";
    protected static final String TOKEN_SEPARATOR = "::";

    public ListRecords(IRegistry iRegistry) {
        super("ListRecords");
        Assert.notNull(iRegistry);
        this.urlRegistry = iRegistry;
    }

    protected ListRecords(String string) {
        super(string);
    }

    protected BasicResumptionToken createResumptionToken(IRequestHandler iRequestHandler, String string) throws InvalidTokenException {
        return new BasicResumptionToken(iRequestHandler, string);
    }

    protected boolean isValidRequest(IRequestHandler iRequestHandler, List list, Map map, IPropertySource iPropertySource) {
        boolean bl = this.checkMutallyExclusiveParameters(map, IOAIConstants.LISTRECORDS_REQUIRED_ARGS, IOAIConstants.LISTRECORDS_RESUMPTION_ARGS, IOAIConstants.LISTRECORDS_OPTIONAL_ARGS, list);
        boolean bl2 = this.checkResumptionToken(iRequestHandler, map, list);
        boolean bl3 = this.validateMetadataPrefix(iRequestHandler, map, list);
        if (iRequestHandler.getRequestObject("$$resumptionTokenKey$$") != null) {
            bl3 = true;
        }
        return bl && bl3;
    }

    protected boolean renderResponse(IRequestHandler iRequestHandler, List list, Map map, IPropertySource iPropertySource, PrintWriter printWriter) throws IOException {
        Object object;
        String string = (String)map.get("resumptionToken");
        BasicResumptionToken basicResumptionToken = this.checkResumptionToken(iRequestHandler, map, iPropertySource);
        boolean bl = true;
        printWriter.println("<ListRecords>");
        Document document = this.getDocument(iPropertySource, this.urlRegistry, basicResumptionToken);
        if (document != null) {
            int n;
            Element element = document.getDocumentElement();
            object = element.getElementsByTagName("ListRecords");
            Node node = object.item(0);
            object = node.getChildNodes();
            int n2 = (int)basicResumptionToken.getResumptionOffset();
            int n3 = n2 + (n = basicResumptionToken.getResumptionLimit());
            if (n3 > object.getLength()) {
                n3 = object.getLength();
                bl = false;
            }
            for (int i = n2; i < n3; ++i) {
                Node node2 = object.item(i);
                NodeList nodeList = node2.getChildNodes();
                if (node2.getChildNodes().getLength() <= 0) continue;
                printWriter.println("<record>");
                printWriter.println("<header>");
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (nodeList2.item(j).getChildNodes().getLength() <= 0) continue;
                    NodeList nodeList3 = nodeList2.item(j).getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        int n4;
                        Object object2;
                        if (nodeList3.item(k).getNodeName().equalsIgnoreCase("oai:identifier")) {
                            object2 = nodeList3.item(k).getChildNodes();
                            for (n4 = 0; n4 < object2.getLength(); ++n4) {
                                printWriter.println("<identifier>" + CoreUtilities.attValueEncode((String)object2.item(n4).getNodeValue()) + "</identifier>");
                            }
                        }
                        if (nodeList3.item(k).getNodeName().equalsIgnoreCase("oai:datestamp")) {
                            object2 = nodeList3.item(k).getChildNodes();
                            for (n4 = 0; n4 < object2.getLength(); ++n4) {
                                printWriter.println("<datestamp>" + CoreUtilities.attValueEncode((String)object2.item(n4).getNodeValue()) + "</datestamp>");
                            }
                        }
                        if (!nodeList3.item(k).getNodeName().equalsIgnoreCase("oai_dc:dc")) continue;
                        object2 = "";
                        printWriter.println("<setSpec>" + (String)object2 + "</setSpec>");
                        printWriter.println("</header>");
                        printWriter.println("<metadata>");
                        printWriter.println("<oai_dc:dc\n    xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"\n    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n    xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd\">");
                        NodeList nodeList4 = nodeList3.item(k).getChildNodes();
                        for (int i2 = 0; i2 < nodeList4.getLength(); ++i2) {
                            printWriter.print("<" + nodeList4.item(i2).getNodeName() + ">");
                            NodeList nodeList5 = nodeList4.item(i2).getChildNodes();
                            for (int i3 = 0; i3 < nodeList5.getLength(); ++i3) {
                                printWriter.print(CoreUtilities.attValueEncode((String)nodeList5.item(i3).getNodeValue()));
                            }
                            printWriter.println("</" + nodeList4.item(i2).getNodeName() + ">");
                        }
                        printWriter.println("</oai_dc:dc>");
                        printWriter.println("</metadata>");
                    }
                }
                printWriter.println("</record>");
            }
        } else {
            System.out.println("document does not exist");
            bl = false;
        }
        int n = basicResumptionToken.getResumptionLimit() + (int)basicResumptionToken.getResumptionOffset();
        object = "resume::" + n + TOKEN_SEPARATOR + basicResumptionToken.getResumptionLimit() + TOKEN_SEPARATOR + basicResumptionToken.getSetSize() + TOKEN_SEPARATOR + basicResumptionToken.getMetadataPrefix();
        if (bl) {
            printWriter.println("<resumptionToken completeListSize=\"" + basicResumptionToken.getSetSize() + "\" cursor=\"" + basicResumptionToken.getResumptionOffset() + "\">" + (String)object + "</resumptionToken>");
        }
        printWriter.println("</ListRecords>");
        return true;
    }

    protected BasicResumptionToken checkResumptionToken(IRequestHandler iRequestHandler, Map map, IPropertySource iPropertySource) {
        BasicResumptionToken basicResumptionToken = (BasicResumptionToken)iRequestHandler.getRequestObject("$$resumptionTokenKey$$");
        if (basicResumptionToken == null) {
            basicResumptionToken = new BasicResumptionToken(Integer.parseInt(iPropertySource.getProperty("fetch.pagesize")), (String)map.get("metadataPrefix"));
            iRequestHandler.setRequestObject("$$resumptionTokenKey$$", basicResumptionToken);
        }
        return basicResumptionToken;
    }
}

