/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.handlers.statik;

import com.luna.insight.oai.handlers.statik.BaseHTMLVerbHandler;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IPropertySource;
import com.luna.insight.oai.iface.IRegistry;
import com.luna.insight.oai.iface.IRequestHandler;
import com.luna.insight.oai.util.Assert;
import com.luna.insight.oai.util.StaticRepository;
import com.luna.insight.oai.util.URLResponseResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class Initiate
extends BaseHTMLVerbHandler {
    protected IRegistry urlRegistry;

    public Initiate(IRegistry iRegistry) {
        super("initiate");
        Assert.notNull(iRegistry);
        this.urlRegistry = iRegistry;
    }

    protected boolean isValidRequest(IRequestHandler iRequestHandler, List list, Map map, IPropertySource iPropertySource) {
        return this.checkValidParameters(map, IOAIConstants.INITIATE_REQUIRED_ARGS, IOAIConstants.INITIATE_OPTIONAL_ARGS, list) && map.get("initiate") != null;
    }

    protected boolean renderResponse(IRequestHandler iRequestHandler, List list, Map map, IPropertySource iPropertySource, PrintWriter printWriter) throws IOException {
        String string = (String)map.get("initiate");
        HttpServletResponse httpServletResponse = (HttpServletResponse)iPropertySource.getObject("$$response$$");
        StaticRepository staticRepository = this.urlRegistry.refreshRegistryUrl(string);
        if (staticRepository != null) {
            if (staticRepository.getStatus() == -1) {
                httpServletResponse.sendError(503, "Service unavailable");
                httpServletResponse.setIntHeader("Retry-After", 600);
                return true;
            }
            URLResponseResult uRLResponseResult = staticRepository.getResponseResult();
            if (uRLResponseResult.isValidResponse()) {
                switch (uRLResponseResult.getResponseCode()) {
                    case 403: 
                    case 404: {
                        httpServletResponse.sendError(502, "Bad Gateway");
                        return true;
                    }
                    case 304: {
                        printWriter.println("<p class='warning'>" + this.logger.getMessageSource().getMessage("oai.request.initiate.notchanged") + "</p>");
                        return true;
                    }
                    case 200: {
                        if (staticRepository.getStatus() == 1) {
                            printWriter.println("<p class='message'>" + this.logger.getMessageSource().getMessage("oai.request.initiate.error") + "</p>");
                        } else {
                            printWriter.println("<p class='message'>" + this.logger.getMessageSource().getMessage("oai.request.initiate.ok") + "</p>");
                        }
                        return true;
                    }
                }
            } else {
                httpServletResponse.sendError(502, "Bad Gateway");
            }
        } else {
            httpServletResponse.sendError(502, "Bad Gateway");
        }
        return true;
    }
}

