/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.handlers.dynamic;

import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.oai.BasicResumptionToken;
import com.luna.insight.oai.OAIResumptionToken;
import com.luna.insight.oai.handlers.BaseResumableVerb;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IOAIRequestHandler;
import com.luna.insight.oai.iface.IPropertySource;
import com.luna.insight.oai.iface.IRequestHandler;
import com.luna.insight.oai.util.InvalidTokenException;
import com.luna.insight.server.TrinityCollectionInfo;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ListSets
extends BaseResumableVerb {
    public ListSets() {
        super("ListSets");
    }

    public boolean isValidRequest(IRequestHandler iRequestHandler, List list, Map map, IPropertySource iPropertySource) {
        boolean bl = this.checkValidParameters(map, IOAIConstants.LISTSETS_REQUIRED_ARGS, IOAIConstants.LISTSETS_OPTIONAL_ARGS, list) || this.checkResumptionToken((IOAIRequestHandler)iRequestHandler, map, list);
        return bl && list.size() == 0;
    }

    protected BasicResumptionToken createResumptionToken(IRequestHandler iRequestHandler, String string) throws InvalidTokenException {
        return new OAIResumptionToken((IOAIRequestHandler)iRequestHandler, string);
    }

    protected boolean renderResponse(IRequestHandler iRequestHandler, List list, Map map, IPropertySource iPropertySource, PrintWriter printWriter) {
        printWriter.println("<ListSets>");
        Iterator iterator = ((IOAIRequestHandler)iRequestHandler).getCollectionList().iterator();
        while (iterator.hasNext()) {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)iterator.next();
            printWriter.println("<set>");
            printWriter.println("<setSpec>collection:" + ((IOAIRequestHandler)iRequestHandler).getUniqueCollectionKey(trinityCollectionInfo).replaceAll("::", ":") + "</setSpec>");
            printWriter.println("<setName>" + CoreUtilities.pcDataEncode((String)trinityCollectionInfo.getCollectionName()) + "</setName>");
            printWriter.println("<setDescription>");
            printWriter.println("<oai_dc:dc\n    xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"\n    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n    xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd\">");
            printWriter.println("<dc:title>" + CoreUtilities.pcDataEncode((String)trinityCollectionInfo.getCollectionName()) + "</dc:title>");
            if (trinityCollectionInfo.getCreatedTimestamp() != null) {
                printWriter.println("<dc:date>" + trinityCollectionInfo.getCreatedTimestamp().substring(0, 8) + "</dc:date>");
            }
            if (trinityCollectionInfo.getShortDescription() != null && !trinityCollectionInfo.getShortDescription().trim().equals("")) {
                printWriter.println("<dc:description>" + CoreUtilities.pcDataEncode((String)trinityCollectionInfo.getShortDescription()) + "</dc:description>");
            }
            if (trinityCollectionInfo.getLongDescriptionURL() != null && !trinityCollectionInfo.getLongDescriptionURL().trim().equals("")) {
                printWriter.println("<dc:publisher>" + CoreUtilities.pcDataEncode((String)trinityCollectionInfo.getLongDescriptionURL()) + "</dc:publisher>");
            }
            if (trinityCollectionInfo.getCopyrightStatement() != null && !trinityCollectionInfo.getCopyrightStatement().trim().equals("")) {
                printWriter.println("<dc:rights>" + CoreUtilities.pcDataEncode((String)trinityCollectionInfo.getCopyrightStatement()) + "</dc:rights>");
            }
            printWriter.println("</oai_dc:dc>");
            printWriter.println("</setDescription>");
            printWriter.println("</set>");
        }
        printWriter.println("</ListSets>");
        return true;
    }
}

