/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.handlers;

import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.oai.BasicResumptionToken;
import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IOAIError;
import com.luna.insight.oai.iface.IPropertySource;
import com.luna.insight.oai.iface.IRegistry;
import com.luna.insight.oai.iface.IRequestHandler;
import com.luna.insight.oai.iface.IVerbHandler;
import com.luna.insight.oai.util.StaticRepository;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;

public abstract class BaseVerbHandler
implements IVerbHandler,
IOAIConstants {
    protected String verbName;
    protected IPropertySource propSource;
    protected IMessageWriter logger = IMessageWriter.NULL_MESSAGE_WRITER;

    protected BaseVerbHandler(String string) {
        this.verbName = string;
    }

    protected BaseVerbHandler() {
        throw new RuntimeException("invalid bean instantiation");
    }

    public String getVerbName() {
        return this.verbName;
    }

    public boolean render(IRequestHandler iRequestHandler, List list, Map map, IPropertySource iPropertySource, PrintWriter printWriter) throws IOException {
        this.propSource = iPropertySource;
        this.insertRequestParameters(iPropertySource.getProperty("$$requesturl$$"), map, printWriter);
        return this.isValidRequest(iRequestHandler, list, map, iPropertySource) && this.renderResponse(iRequestHandler, list, map, iPropertySource, printWriter);
    }

    protected void insertRequestParameters(String string, Map map, PrintWriter printWriter) {
        int n = 0;
        printWriter.println("<request");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            printWriter.print((n++ > 0 ? " " : "") + string2 + "='" + string3 + "'");
        }
        printWriter.println(">" + string + "</request>");
    }

    protected abstract boolean isValidRequest(IRequestHandler var1, List var2, Map var3, IPropertySource var4);

    protected abstract boolean renderResponse(IRequestHandler var1, List var2, Map var3, IPropertySource var4, PrintWriter var5) throws IOException;

    protected boolean checkValidParameters(Map map, List list, List list2, List list3) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (list.contains(string) || list2.contains(string)) continue;
            String string2 = this.logger.getMessageSource().getMessage("oai.badarg", new Object[]{string}, string, Locale.getDefault());
            list3.add(new OAIError("badArgument", string2));
        }
        return list3.size() == 0;
    }

    protected boolean checkMutallyExclusiveParameters(Map map, List list, List list2, List list3, List list4) {
        String string;
        int n = 0;
        int n2 = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.equals("verb")) continue;
            if (!(list.contains(string) || list2.contains(string) || list3.contains(string))) {
                String string2 = this.logger.getMessageSource().getMessage("oai.badarg", new Object[]{string}, string, Locale.getDefault());
                list4.add(new OAIError("badArgument", string2));
            }
            if (list.contains(string)) {
                ++n;
            }
            if (list2.contains(string)) {
                ++n2;
            }
            if (n == 0 || n2 == 0) continue;
        }
        if (n != 0 && n2 != 0) {
            string = this.logger.getMessageSource().getMessage("oai.clashargs");
            list4.add(new OAIError("badArgument", string));
        }
        return list4.size() == 0;
    }

    protected Document getDocument(IPropertySource iPropertySource, IRegistry iRegistry, BasicResumptionToken basicResumptionToken) throws IOException {
        String string = iPropertySource.getProperty("$$requesturl$$");
        int n = string.indexOf("/harvester/soai/") + "/harvester/soai/".length();
        string = string.substring(n);
        StaticRepository staticRepository = iRegistry.refreshRegistryUrl(string);
        if (basicResumptionToken != null) {
            basicResumptionToken.setSetSize(staticRepository.getRecordCount());
        }
        return staticRepository.getRepositoryDocument();
    }

    public void setLogger(IMessageWriter iMessageWriter) {
        this.logger = iMessageWriter != null ? iMessageWriter : IMessageWriter.NULL_MESSAGE_WRITER;
    }

    public String getResponseContentType() {
        return "text/xml; charset=UTF-8";
    }

    public void renderResponseHeader(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("");
        printWriter.println("<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/         http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">");
        printWriter.println("<responseDate>" + CoreUtilities.formatUTCDateZ((long)System.currentTimeMillis()) + "</responseDate>");
    }

    public void renderResponseFooter(PrintWriter printWriter) {
        printWriter.println("</OAI-PMH>");
    }

    public void renderErrorList(PrintWriter printWriter, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IOAIError iOAIError = (IOAIError)iterator.next();
            printWriter.println("<error code=\"" + iOAIError.getErrorCode() + "\">");
            printWriter.println(iOAIError.getErrorMessage());
            printWriter.println("</error>");
        }
    }

    protected class OAIError
    implements IOAIError {
        private String errorCode;
        private String errorMessage;

        OAIError(String string, String string2) {
            this.errorCode = string;
            this.errorMessage = string2;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

