/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai.handlers;

import com.luna.insight.oai.BasicResumptionToken;
import com.luna.insight.oai.handlers.BaseVerbHandler;
import com.luna.insight.oai.iface.IOAIRequestHandler;
import com.luna.insight.oai.iface.IRequestHandler;
import com.luna.insight.oai.util.InvalidTokenException;
import java.util.List;
import java.util.Map;

public abstract class BaseResumableVerb
extends BaseVerbHandler {
    protected BaseResumableVerb(String string) {
        super(string);
    }

    protected boolean checkResumptionToken(IRequestHandler iRequestHandler, Map map, List list) {
        String string = (String)map.get("resumptionToken");
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            iRequestHandler.setRequestObject("$$resumptionTokenKey$$", this.createResumptionToken(iRequestHandler, string));
            return true;
        }
        catch (InvalidTokenException invalidTokenException) {
            list.add(new BaseVerbHandler.OAIError(this, "badResumptionToken", this.logger.getMessageSource().getMessage("oai.badtoken")));
            return false;
        }
    }

    protected abstract BasicResumptionToken createResumptionToken(IRequestHandler var1, String var2) throws InvalidTokenException;

    protected boolean validateSetName(IRequestHandler iRequestHandler, Map map, List list) {
        String string = (String)map.get("set");
        if (string == null || string.equals("")) {
            list.add(new BaseVerbHandler.OAIError(this, "badArgument", this.logger.getMessageSource().getMessage("oai.nullset")));
            return false;
        }
        if (string.equals("collection:-1:ALL:-1:-1")) {
            return true;
        }
        if (!((IOAIRequestHandler)iRequestHandler).isValidCollectionID(string)) {
            list.add(new BaseVerbHandler.OAIError(this, "badArgument", this.logger.getMessageSource().getMessage("oai.badset", new Object[]{string})));
            return false;
        }
        return true;
    }

    protected boolean validateMetadataPrefix(IRequestHandler iRequestHandler, Map map, List list) {
        boolean bl = true;
        String string = (String)map.get("metadataPrefix");
        if (string == null || string.equals("")) {
            list.add(new BaseVerbHandler.OAIError(this, "badArgument", this.logger.getMessageSource().getMessage("oai.nullmdp")));
            bl = false;
        } else if (!iRequestHandler.isValidMetadataPrefix(string)) {
            list.add(new BaseVerbHandler.OAIError(this, "cannotDisseminateFormat", this.logger.getMessageSource().getMessage("oai.badmdp", new Object[]{string})));
            bl = false;
        }
        return bl;
    }
}

