/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.BaseRequestHandler;
import com.luna.insight.oai.BaseViewFactory;
import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IVerbHandler;
import com.luna.insight.oai.iface.IView;
import com.luna.insight.oai.iface.IViewFactory;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class SOAIViewFactory
extends BaseViewFactory
implements IViewFactory,
IOAIConstants {
    public SOAIViewFactory(EntityResolver entityResolver) {
        super(entityResolver);
    }

    public IView getViewInstance(HttpServletRequest httpServletRequest, IVerbHandler iVerbHandler) throws Exception {
        SOAIViewWrapper sOAIViewWrapper = (SOAIViewWrapper)super.getObjectInstance();
        sOAIViewWrapper.setVerbHandler(iVerbHandler);
        return sOAIViewWrapper;
    }

    public boolean init() throws Exception {
        boolean bl = super.init();
        this.logger.writeInfo("soai.vf.started", new Object[]{new Boolean(!bl)});
        return bl;
    }

    protected Object allocateNewObject(IMessageWriter iMessageWriter) throws Exception {
        SOAIViewWrapper sOAIViewWrapper = new SOAIViewWrapper(iMessageWriter, this);
        ++this.currPoolAllocations;
        return sOAIViewWrapper;
    }

    private class SOAIViewWrapper
    extends BaseRequestHandler
    implements IView {
        SOAIViewFactory factory;

        SOAIViewWrapper(IMessageWriter iMessageWriter, SOAIViewFactory sOAIViewFactory2) throws SAXException {
            super(iMessageWriter, sOAIViewFactory2.configProps, sOAIViewFactory2.parserClassName, sOAIViewFactory2.resolver);
            this.factory = sOAIViewFactory2;
        }

        public void render(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
            super.render(map, httpServletRequest, httpServletResponse);
            this.factory.returnToPool(this);
        }
    }
}

