/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.BaseViewFactory;
import com.luna.insight.oai.OAIRequestHandler;
import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IVerbHandler;
import com.luna.insight.oai.iface.IView;
import com.luna.insight.oai.iface.IViewFactory;
import com.luna.insight.server.InsightUserClient;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class OAIViewFactory
extends BaseViewFactory
implements IViewFactory,
IOAIConstants {
    public static final Set STANDARDS_CACHE_OPTIONS = new HashSet();
    protected int maxClientProxies = 0;
    protected String userServerAddress;
    protected String username;
    protected String password;
    protected String standardsCache;
    protected InsightUserClient userClient;
    protected Vector collections = new Vector();

    public OAIViewFactory(EntityResolver entityResolver) {
        super(entityResolver);
    }

    public IView getViewInstance(HttpServletRequest httpServletRequest, IVerbHandler iVerbHandler) throws Exception {
        OAIViewWrapper oAIViewWrapper = (OAIViewWrapper)super.getObjectInstance();
        oAIViewWrapper.setVerbHandler(iVerbHandler);
        return oAIViewWrapper;
    }

    public boolean init() throws Exception {
        boolean bl = true;
        super.init();
        this.logger.writeInfo("oai.vf.started", new Object[]{new Boolean(!bl)});
        return bl;
    }

    protected Object allocateNewObject(IMessageWriter iMessageWriter) throws Exception {
        OAIViewWrapper oAIViewWrapper = new OAIViewWrapper(iMessageWriter, this);
        if (this.currPoolAllocations == 0 && this.standardsCache != null && this.standardsCache.equals("servlet-init")) {
            iMessageWriter.writeInfo("oai.config.init_fieldstandards");
            oAIViewWrapper.initializeFieldStandards();
            iMessageWriter.writeInfo("oai.config.init_fieldstandards_ret");
        }
        ++this.currPoolAllocations;
        return oAIViewWrapper;
    }

    static {
        STANDARDS_CACHE_OPTIONS.add("servlet-init");
        STANDARDS_CACHE_OPTIONS.add("collection-lazy");
    }

    private class OAIViewWrapper
    extends OAIRequestHandler
    implements IView {
        OAIViewFactory factory;

        OAIViewWrapper(IMessageWriter iMessageWriter, OAIViewFactory oAIViewFactory2) throws SAXException {
            super(iMessageWriter, oAIViewFactory2.configProps, oAIViewFactory2.collections, oAIViewFactory2.parserClassName, oAIViewFactory2.username, oAIViewFactory2.userServerAddress, oAIViewFactory2.resolver);
            this.factory = oAIViewFactory2;
            if (oAIViewFactory2.invalidXMLReplacement != null) {
                this.setInvalidXMLReplacement(oAIViewFactory2.invalidXMLReplacement);
            }
        }

        public void render(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
            super.render(map, httpServletRequest, httpServletResponse);
            this.factory.returnToPool(this);
        }
    }
}

