/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IOAIRequestHandler;
import com.luna.insight.oai.iface.IPropertySource;
import com.luna.insight.oai.iface.IVerbHandler;
import com.luna.insight.oai.iface.IViewRenderer;
import com.luna.insight.oai.util.Assert;
import com.luna.insight.server.TrinityCollectionInfo;
import com.luna.insight.server.xml.InsightRequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class OAIRequestHandler
extends InsightRequestHandler
implements IViewRenderer,
IPropertySource,
IOAIConstants,
IOAIRequestHandler {
    protected IVerbHandler verbHandler;
    protected HttpServletRequest activeRequest;
    protected Properties configProps;
    protected IMessageWriter logger = IMessageWriter.NULL_MESSAGE_WRITER;
    protected List collections;
    protected HashMap requestContextMap;

    OAIRequestHandler(IMessageWriter iMessageWriter, Properties properties, List list, String string, String string2, String string3, EntityResolver entityResolver) throws SAXException {
        super(list, string, null, string2, string3, true);
        this.nameSpace = "insight";
        this.logger = iMessageWriter;
        this.configProps = properties;
        this.collections = list;
        this.reader.setEntityResolver(entityResolver);
    }

    public void setVerbHandler(IVerbHandler iVerbHandler) {
        this.verbHandler = iVerbHandler;
        this.requestContextMap = new HashMap();
    }

    public void render(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Vector vector;
        long l = System.currentTimeMillis();
        this.activeRequest = httpServletRequest;
        httpServletResponse.setContentType(this.verbHandler.getResponseContentType());
        PrintWriter printWriter = httpServletResponse.getWriter();
        this.verbHandler.renderResponseHeader(printWriter);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        PrintWriter printWriter2 = new PrintWriter(byteArrayOutputStream);
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            vector = (String)enumeration.nextElement();
            String string = httpServletRequest.getParameter((String)((Object)vector));
            hashMap.put(vector, string);
        }
        vector = new Vector();
        if (this.verbHandler.render(this, vector, hashMap, this, printWriter2)) {
            printWriter2.flush();
            if (!printWriter2.checkError()) {
                printWriter.print(byteArrayOutputStream.toString());
                printWriter2.close();
            } else {
                this.verbHandler.renderErrorList(printWriter, vector);
            }
        } else {
            this.verbHandler.renderErrorList(printWriter, vector);
        }
        this.verbHandler.renderResponseFooter(printWriter);
        this.logger.writeInfo("oai.process.result.timing", new Object[]{"" + (System.currentTimeMillis() - l)});
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        if (string.equals("$$requesturl$$")) {
            return this.activeRequest.getRequestURL().toString();
        }
        String string3 = this.activeRequest.getParameter(string);
        if (string3 == null) {
            string3 = this.configProps.getProperty(string, string2);
        }
        return string3;
    }

    public Object getObject(String string) {
        if (string.equals("$$requesthandler$$")) {
            return this;
        }
        return null;
    }

    public Enumeration propertyNames() {
        return null;
    }

    public void setConfigurationProperties(Properties properties) {
        this.configProps = properties;
    }

    public Object getRequestObject(String string) {
        return this.requestContextMap.get(string);
    }

    public Object setRequestObject(String string, Object object) {
        return this.requestContextMap.put(string, object);
    }

    public List getCollectionList() {
        return this.collections;
    }

    public boolean isValidCollectionID(String string) {
        Assert.notNull(string);
        string = this.translateSetSpecToCID(string);
        Iterator iterator = this.collections.iterator();
        while (iterator.hasNext()) {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)iterator.next();
            String string2 = this.getUniqueCollectionKey(trinityCollectionInfo);
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidMetadataPrefix(String string) {
        return string != null && (string.equals("oai_dc") || string.equals("insight"));
    }

    public String getEarliestDatestamp() {
        String string = "99991231";
        int n = Integer.parseInt(string);
        for (int i = 0; i < this.collections.size(); ++i) {
            TrinityCollectionInfo trinityCollectionInfo = (TrinityCollectionInfo)this.collections.get(i);
            String string2 = trinityCollectionInfo.getCreatedTimestamp();
            if (string2 == null || Integer.parseInt(string2 = string2.substring(0, 8)) >= n) continue;
            string = string2;
            n = Integer.parseInt(string2);
        }
        return string.equals("99991231") ? "19700101" : string;
    }

    public String translateSetSpecToCID(String string) {
        Assert.notNull(string);
        if (string.startsWith("collection:")) {
            string = string.substring("collection:".length());
        }
        string = string.replaceAll(":", "::");
        return string;
    }

    public String generateSetSpec(TrinityCollectionInfo trinityCollectionInfo) {
        return "collection:" + this.getUniqueCollectionKey(trinityCollectionInfo).replaceAll("::", ":");
    }

    public String translateCIDToMapping(String string, String string2) {
        Assert.notNull(string);
        Assert.notNull(string2);
        return string2.equals("oai_dc") ? "DublinCore" : string2;
    }

    public TrinityCollectionInfo getTCIForCID(String string) {
        return (TrinityCollectionInfo)this.collectionMap.get(string);
    }

    public String getObjectDate(String string, String string2, String string3) {
        TrinityCollectionInfo trinityCollectionInfo = this.getTCIForCID(string);
        if (trinityCollectionInfo != null && trinityCollectionInfo.getCreatedTimestamp() != null) {
            return trinityCollectionInfo.getCreatedTimestamp();
        }
        return this.getEarliestDatestamp();
    }
}

