/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.iface.IRequestHandler;
import com.luna.insight.oai.iface.IResumptionToken;
import com.luna.insight.oai.util.InvalidTokenException;
import org.springframework.util.StringUtils;

public class BasicResumptionToken
implements IResumptionToken {
    protected static final String TOKEN_PREFIX = "resume";
    protected static final String TOKEN_SEPARATOR = "::";
    protected int resumptionLimit = -1;
    protected long resumptionOffset = 0L;
    protected long setSize = -1L;
    protected String metaPrefix = "";
    protected String[] tokenSegments = new String[0];

    public BasicResumptionToken(int n, String string) {
        this.resumptionLimit = n;
        this.metaPrefix = string;
        this.initializeTokenArray();
    }

    protected void initializeTokenArray() {
        if (this.tokenSegments.length == 0) {
            this.tokenSegments = new String[5];
        }
        this.tokenSegments[0] = TOKEN_PREFIX;
        this.tokenSegments[1] = "" + this.resumptionOffset;
        this.tokenSegments[2] = "" + this.resumptionLimit;
        this.tokenSegments[3] = "" + this.setSize;
        this.tokenSegments[4] = this.metaPrefix;
    }

    public BasicResumptionToken(IRequestHandler iRequestHandler, String string) throws InvalidTokenException {
        string = string.replaceAll("\\:\\:", "^");
        this.tokenSegments = StringUtils.tokenizeToStringArray((String)string, (String)"^");
        if (this.tokenSegments.length < 5) {
            throw new InvalidTokenException("Invalid token format");
        }
        try {
            if (!this.tokenSegments[0].equals(TOKEN_PREFIX)) {
                throw new InvalidTokenException("Invalid token format");
            }
            this.resumptionOffset = Long.parseLong(this.tokenSegments[1]);
            this.resumptionLimit = Integer.parseInt(this.tokenSegments[2]);
            this.setSize = Long.parseLong(this.tokenSegments[3]);
            this.metaPrefix = this.tokenSegments[4];
            if (!iRequestHandler.isValidMetadataPrefix(this.metaPrefix)) {
                throw new InvalidTokenException("Invalid metadata prefix");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidTokenException("Invalid token format", numberFormatException);
        }
    }

    public long getResumptionOffset() {
        return this.resumptionOffset;
    }

    public void incrementOffset() {
        this.resumptionOffset += (long)this.resumptionLimit;
        this.tokenSegments[1] = "" + this.resumptionOffset;
    }

    public int getResumptionLimit() {
        return this.resumptionLimit;
    }

    public String getMetadataPrefix() {
        return this.metaPrefix;
    }

    public long getSetSize() {
        return this.setSize;
    }

    public void setSetSize(long l) {
        this.setSize = l;
        this.tokenSegments[3] = "" + l;
    }

    public String getTokenKey() {
        return "resume::" + this.getResumptionOffset() + TOKEN_SEPARATOR + this.getResumptionLimit() + TOKEN_SEPARATOR + this.getSetSize() + TOKEN_SEPARATOR + this.getMetadataPrefix();
    }
}

