/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.BaseReusableObjectFactory;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IViewFactory;
import org.xml.sax.EntityResolver;

public abstract class BaseViewFactory
extends BaseReusableObjectFactory
implements IViewFactory,
IOAIConstants {
    protected String parserClassName;
    protected String wirelessCompatMode;
    protected String invalidXMLReplacement;
    protected EntityResolver resolver;

    public BaseViewFactory(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public boolean init() throws Exception {
        boolean bl = true;
        this.wirelessCompatMode = this.configProps.getProperty("wireless_compatibility_mode");
        this.parserClassName = this.configProps.getProperty("parser_classname");
        if (this.parserClassName != null && !this.parserClassName.equals("")) {
            try {
                Class.forName(this.parserClassName);
                this.logger.writeInfo("oai.config.param_valid", new Object[]{"parser_classname", this.parserClassName});
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                this.logger.writeWarning("oai.config.bad_class", new Object[]{this.parserClassName});
            }
        } else {
            bl = false;
            this.logger.writeWarning("oai.config.missing_parameter", new Object[]{"parser_classname"});
        }
        this.invalidXMLReplacement = this.configProps.getProperty("invalid_xml_replacement");
        if (this.invalidXMLReplacement != null && this.invalidXMLReplacement.equals("null")) {
            this.invalidXMLReplacement = null;
        }
        return super.init() && bl;
    }
}

