/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import java.util.Properties;
import java.util.Vector;

public abstract class BaseReusableObjectFactory
extends Vector
implements IOAIConstants {
    protected static final int STRATEGY_GROW = 0;
    protected static final int STRATEGY_WARN = 1;
    protected static final int STRATEGY_WAIT = 2;
    protected static final int STRATEGY_FAIL = 3;
    protected int minPoolSize = 1;
    protected int maxPoolSize = Integer.MAX_VALUE;
    protected int currPoolAllocations = 0;
    protected long waitTimeout = Long.MAX_VALUE;
    protected int poolStrategy = 0;
    protected Properties configProps = new Properties();
    protected IMessageWriter logger = IMessageWriter.NULL_MESSAGE_WRITER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance() throws Exception {
        Object object = null;
        if (this.isEmpty() && (this.poolStrategy == 0 || this.poolStrategy == 1) && this.currPoolAllocations < this.maxPoolSize) {
            object = this.allocateNewObject(this.logger);
        } else {
            while (object == null) {
                try {
                    BaseReusableObjectFactory baseReusableObjectFactory = this;
                    synchronized (baseReusableObjectFactory) {
                        if (this.isEmpty()) {
                            this.wait();
                        }
                        if (!this.isEmpty()) {
                            object = this.remove(0);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        return object;
    }

    protected abstract Object allocateNewObject(IMessageWriter var1) throws Exception;

    public void setConfigurationProperties(Properties properties) {
        this.configProps = properties;
    }

    public void setLogger(IMessageWriter iMessageWriter) {
        this.logger = iMessageWriter != null ? iMessageWriter : IMessageWriter.NULL_MESSAGE_WRITER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool(Object object) {
        BaseReusableObjectFactory baseReusableObjectFactory = this;
        synchronized (baseReusableObjectFactory) {
            this.add(object);
            this.notify();
        }
    }

    public boolean init() throws Exception {
        for (int i = 0; i < this.minPoolSize; ++i) {
            this.returnToPool(this.allocateNewObject(this.logger));
        }
        return true;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int n) {
        this.minPoolSize = Math.max(1, n);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(long l) {
        this.waitTimeout = l;
    }

    public void setPoolStrategy(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("grow")) {
                this.poolStrategy = 0;
                return;
            }
            if (string.equalsIgnoreCase("warn")) {
                this.poolStrategy = 1;
                return;
            }
            if (string.equalsIgnoreCase("wait")) {
                this.poolStrategy = 2;
                return;
            }
            if (string.equalsIgnoreCase("fail")) {
                this.poolStrategy = 3;
                return;
            }
        }
        throw new RuntimeException("invalid strategy specified: " + string);
    }
}

