/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IPropertySource;
import com.luna.insight.oai.iface.IRequestHandler;
import com.luna.insight.oai.iface.IVerbHandler;
import com.luna.insight.oai.iface.IViewRenderer;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class BaseRequestHandler
implements IViewRenderer,
IPropertySource,
IOAIConstants,
IRequestHandler {
    protected IVerbHandler verbHandler;
    protected HttpServletRequest activeRequest;
    protected HttpServletResponse activeResponse;
    protected Properties configProps;
    protected IMessageWriter logger = IMessageWriter.NULL_MESSAGE_WRITER;
    protected HashMap requestContextMap;
    protected String parserClassName;
    protected EntityResolver resolver;

    BaseRequestHandler(IMessageWriter iMessageWriter, Properties properties, String string, EntityResolver entityResolver) throws SAXException {
        this.logger = iMessageWriter;
        this.configProps = properties;
        this.parserClassName = string;
        this.resolver = entityResolver;
    }

    public void setVerbHandler(IVerbHandler iVerbHandler) {
        this.verbHandler = iVerbHandler;
        this.requestContextMap = new HashMap();
    }

    public void render(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Vector vector;
        long l = System.currentTimeMillis();
        this.activeRequest = httpServletRequest;
        this.activeResponse = httpServletResponse;
        httpServletResponse.setContentType(this.verbHandler.getResponseContentType());
        PrintWriter printWriter = httpServletResponse.getWriter();
        this.verbHandler.renderResponseHeader(printWriter);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        PrintWriter printWriter2 = new PrintWriter(byteArrayOutputStream);
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            vector = (String)enumeration.nextElement();
            String string = httpServletRequest.getParameter((String)((Object)vector));
            hashMap.put(vector, string);
        }
        vector = new Vector();
        if (this.verbHandler.render(this, vector, hashMap, this, printWriter2)) {
            printWriter2.flush();
            if (!printWriter2.checkError()) {
                printWriter.print(byteArrayOutputStream.toString());
                printWriter2.close();
            } else {
                this.verbHandler.renderErrorList(printWriter, vector);
            }
        } else {
            this.verbHandler.renderErrorList(printWriter, vector);
        }
        this.verbHandler.renderResponseFooter(printWriter);
        this.logger.writeInfo("oai.process.result.timing", new Object[]{"" + (System.currentTimeMillis() - l)});
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string.equals("$$requesturl$$")) {
            return this.activeRequest.getRequestURL().toString();
        }
        String string3 = this.activeRequest.getParameter(string);
        if (string3 == null) {
            string3 = this.configProps.getProperty(string, string2);
        }
        return string3;
    }

    public Object getObject(String string) {
        if (string.equals("$$requesthandler$$")) {
            return this;
        }
        if (string.equals("$$request$$")) {
            return this.activeRequest;
        }
        if (string.equals("$$response$$")) {
            return this.activeResponse;
        }
        return null;
    }

    public Enumeration propertyNames() {
        return null;
    }

    public void setConfigurationProperties(Properties properties) {
        this.configProps = properties;
    }

    public Object getRequestObject(String string) {
        return this.requestContextMap.get(string);
    }

    public Object setRequestObject(String string, Object object) {
        return this.requestContextMap.put(string, object);
    }

    public boolean isValidMetadataPrefix(String string) {
        return string != null && (string.equals("oai_dc") || string.equals("insight"));
    }

    public String getEarliestDatestamp() {
        String string = "99991231";
        int n = Integer.parseInt(string);
        return string.equals("99991231") ? "19700101" : string;
    }
}

