/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.oai;

import com.luna.insight.oai.OAIView;
import com.luna.insight.oai.iface.IMessageSource;
import com.luna.insight.oai.iface.IMessageWriter;
import com.luna.insight.oai.iface.IOAIConstants;
import com.luna.insight.oai.iface.IVerbHandler;
import com.luna.insight.oai.iface.IViewFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public abstract class BaseController
implements Controller,
IOAIConstants {
    protected Map verbMap = null;
    protected IMessageWriter logger = IMessageWriter.NULL_MESSAGE_WRITER;
    protected Properties configProps;
    protected IMessageSource messageSource;
    protected IViewFactory viewFactory;

    public void setVerbMapping(List list) {
        this.verbMap = new HashMap(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IVerbHandler iVerbHandler = (IVerbHandler)iterator.next();
            this.verbMap.put(iVerbHandler.getVerbName(), iVerbHandler);
        }
    }

    public void setLogger(IMessageWriter iMessageWriter) {
        this.logger = iMessageWriter != null ? iMessageWriter : IMessageWriter.NULL_MESSAGE_WRITER;
    }

    public void setConfigurationProperties(Properties properties) {
        this.configProps = properties;
    }

    public void setViewFactory(IViewFactory iViewFactory) {
        this.viewFactory = iViewFactory;
    }

    public void setMessageSource(IMessageSource iMessageSource) {
        this.messageSource = iMessageSource;
    }

    public ModelAndView handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return this.getView(httpServletRequest, httpServletResponse);
    }

    protected abstract OAIView getView(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

