/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.mip.FuzzyDateMachine;

import edu.berkeley.mip.FuzzyDateMachine.Filter;

class Yytoken {
    public int yySymbol;
    public String yyText;
    public int[][] dayMonthYear = new int[2][3];
    public int yyValue;

    public Yytoken(int n) {
        this(n, "X", -1);
    }

    public Yytoken(int n, int n2) {
        this(n, "X", n2);
    }

    public Yytoken(int n, String string) {
        this(n, string, -1);
    }

    public Yytoken(int n, String string, int n2) {
        this.yySymbol = n;
        this.yyValue = n2;
        if (string != null) {
            this.yyText = new String(string);
        }
        this.internalParse();
    }

    protected int getYear(String string) {
        return Integer.parseInt(string.substring(string.lastIndexOf(32) + 1));
    }

    private void internalParse() {
        switch (this.yySymbol) {
            case 42: {
                this.toYear();
                break;
            }
            case 27: {
                this.toStrDate();
                break;
            }
            case 25: {
                this.toNumDate();
                break;
            }
            case 40: {
                this.yySymbol = 39;
                try {
                    this.yyValue = Integer.parseInt(this.yyText.substring(0, this.yyText.length() - 2));
                }
                catch (Exception exception) {
                    this.yyValue = Integer.parseInt(this.yyText.substring(0, this.yyText.length() - 1));
                }
                break;
            }
            case 23: {
                this.toMonth();
                break;
            }
            case 24: {
                this.toMonthOnlyRange();
                break;
            }
            case 28: {
                this.toStrDateRange();
                break;
            }
            case 29: {
                this.toNumDateRange();
                break;
            }
            case 36: {
                System.err.println("decade/hundreds: " + this);
                this.toDecadeHundreds();
                System.err.println("internal parse decade/hundreds: " + this);
                break;
            }
        }
    }

    protected void set(int n, int n2, int n3) {
        this.dayMonthYear[0][0] = n;
        this.dayMonthYear[0][1] = n2;
        this.dayMonthYear[0][2] = n3;
    }

    protected void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.dayMonthYear[0][0] = n;
        this.dayMonthYear[0][1] = n2;
        this.dayMonthYear[0][2] = n3;
        this.dayMonthYear[1][0] = n4;
        this.dayMonthYear[1][1] = n5;
        this.dayMonthYear[1][2] = n6;
    }

    protected void toDecadeHundreds() {
        int n = Integer.parseInt(this.yyText.substring(0, this.yyText.length() - 1));
        if (n % 100 == 0) {
            this.set(1, 1, n, 31, 12, n + 99);
            this.yySymbol = 37;
        } else if (n % 10 == 0) {
            this.set(1, 1, n, 31, 12, n + 9);
            this.yySymbol = 43;
        }
    }

    protected void toMonth() {
        String string = this.yyText.substring(0, this.yyText.indexOf(32));
        int n = Filter.monthForString(string.substring(0, Math.min(3, string.length())));
        int n2 = this.getYear(this.yyText);
        this.set(1, n, n2, Filter.lengthOfMonth(n, n2), n, n2);
    }

    protected void toMonthOnlyRange() {
        int n = this.yyText.indexOf(45);
        String string = this.yyText.substring(0, n).trim();
        String string2 = this.yyText.substring(n + 1).trim();
        String string3 = string2.substring(0, string2.indexOf(32));
        int n2 = Filter.monthForString(string.substring(0, Math.min(3, string.length())));
        int n3 = Filter.monthForString(string3.substring(0, Math.min(3, string3.length())));
        int n4 = this.getYear(this.yyText);
        this.set(1, n2, n4, Filter.lengthOfMonth(n3, n4), n3, n4);
    }

    protected void toNumDate() {
        String string = this.yyText.substring(0, this.yyText.indexOf(47));
        String string2 = this.yyText.substring(this.yyText.indexOf(47) + 1, this.yyText.lastIndexOf(47));
        String string3 = this.yyText.substring(this.yyText.lastIndexOf(47) + 1);
        int n = Integer.parseInt(string2.trim());
        int n2 = Integer.parseInt(string);
        int n3 = Integer.parseInt(string3);
        this.set(n, n2, n3);
    }

    protected void toNumDateRange() {
        String string = this.yyText.substring(0, this.yyText.indexOf(47));
        String string2 = this.yyText.substring(this.yyText.indexOf(47) + 1, this.yyText.lastIndexOf(47));
        String string3 = this.yyText.substring(this.yyText.lastIndexOf(47) + 1);
        int n = string2.indexOf(45);
        int n2 = Integer.parseInt(string2.substring(0, n));
        int n3 = Integer.parseInt(string2.substring(n + 1));
        int n4 = Integer.parseInt(string);
        int n5 = Integer.parseInt(string3);
        this.set(n2, n4, n5, n3, n4, n5);
    }

    protected void toStrDate() {
        String string = this.yyText.substring(0, this.yyText.indexOf(32)).trim();
        int n = this.yyText.lastIndexOf(32);
        int n2 = this.yyText.indexOf(44);
        if (n2 != -1) {
            n = n2;
        }
        String string2 = this.yyText.substring(string.length(), n).trim();
        int n3 = Filter.monthForString(string.substring(0, Math.min(3, string.length())));
        int n4 = Integer.parseInt(string2);
        int n5 = Integer.parseInt(this.yyText.substring(n + 1).trim());
        this.set(n4, n3, n5);
    }

    protected void toStrDateRange() {
        String string = this.yyText.substring(0, this.yyText.indexOf(32)).trim();
        int n = this.yyText.lastIndexOf(32);
        int n2 = this.yyText.indexOf(44);
        if (n2 != -1) {
            n = n2;
        }
        String string2 = this.yyText.substring(string.length(), n).trim();
        int n3 = Filter.monthForString(string.substring(0, Math.min(3, string.length())));
        int n4 = string2.indexOf(45);
        int n5 = Integer.parseInt(string2.substring(0, n4));
        int n6 = Integer.parseInt(string2.substring(n4 + 1));
        int n7 = this.getYear(this.yyText);
        this.set(n5, n3, n7, n6, n3, n7);
    }

    public String toString() {
        return "Token #" + this.yySymbol + ": " + this.yyText + " val: " + this.yyValue + "\n" + this.dayMonthYear[0][0] + " " + this.dayMonthYear[0][1] + " " + this.dayMonthYear[0][2] + "\n" + this.dayMonthYear[1][0] + "  " + this.dayMonthYear[1][1] + "  " + this.dayMonthYear[1][2];
    }

    protected void toYear() {
        int n = Integer.parseInt(this.yyText);
        this.set(1, 1, n, 31, 12, n);
    }
}

