/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.util.metadata.exiv2;

import com.luna.insight.server.Debug;
import com.luna.insight.server.util.metadata.AbstractTag;
import com.luna.insight.server.util.metadata.Exif;
import com.luna.insight.server.util.metadata.Iptc;
import com.luna.insight.server.util.metadata.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

class Exiv2CommandOutputParser {
    public static final String CANNOT_FIND_TAG_NAME = "Cannot find tag name.";
    public static final String INVALID_INFORMATION_TYPE = "Invalid Information Type";
    public static final String ERROR_AT_PARSING_METADATA = "Error at parsing metadata:";
    protected Reader reader = null;

    Exiv2CommandOutputParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parse(String string, String string2) throws Exception {
        ArrayList<Tag> arrayList = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.startsWith("Warning:")) continue;
            try {
                this.reader = new StringReader(string3);
                Tag tag = this.line(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Tag>();
                }
                arrayList.add(tag);
            }
            catch (Exception exception) {
                this.debugOut("parse(String): Error at parsing metadata: " + exception.getMessage() + " " + string3);
            }
            finally {
                this.reader.close();
            }
        }
        return arrayList;
    }

    public Tag line(String string) throws Exception {
        AbstractTag abstractTag = null;
        String string2 = null;
        if ("Iptc".equals(string)) {
            this.parseTo('.');
            this.debugOut("line(): informationType: " + string);
            string2 = this.parseTo('.');
            this.debugOut("line(): groupName: " + string2);
        } else if ("Exif".equals(string)) {
            this.parseTo(' ');
            this.debugOut("line(): informationType: " + string);
            string2 = this.parseTo(' ');
            this.debugOut("line(): groupName: " + string2);
        } else {
            throw new Exception("Invalid Information Type " + string);
        }
        String string3 = this.tagName();
        this.debugOut("line(): tagName: " + string3);
        String string4 = string + "." + string2 + "." + string3;
        String string5 = this.type();
        this.debugOut("line(): type: " + string5);
        String string6 = this.count();
        this.debugOut("line(): count: " + string6);
        String string7 = this.value();
        this.debugOut("line(): value: " + string7);
        abstractTag = "Exif".equals(string) ? new Exif() : new Iptc();
        if (abstractTag != null) {
            abstractTag.setTagName(string3);
            abstractTag.setType(string5);
            abstractTag.setValue(string7);
            abstractTag.setKey(string4);
        }
        return abstractTag;
    }

    protected String tagName() throws IOException {
        return this.parseTo(' ');
    }

    protected String type() throws IOException {
        return this.parseTo(' ');
    }

    protected String count() throws IOException {
        return this.parseTo(' ');
    }

    public String parseTo(char c) throws IOException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = this.reader.read()) != -1 && (n != c || stringBuffer.length() == 0)) {
            if (n == 32) continue;
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    protected String value() throws IOException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = this.reader.read()) != -1) {
            stringBuffer.append((char)n);
        }
        string = stringBuffer.toString();
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    protected void debugOut(String string) {
        Debug.debugOut("Exiv2CommandOutputParser: " + string);
    }
}

