/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.usergroup;

import com.luna.insight.server.Debug;
import java.net.MalformedURLException;
import java.util.StringTokenizer;

public class IPAddressRangeElement {
    public static int DEFAULT_DEBUG_LEVEL = 2;
    public int[] startIPAddress = null;
    public int[] endIPAddress = null;

    public IPAddressRangeElement(String string, String string2) throws MalformedURLException {
        if (string != null && string.length() > 0) {
            this.setRangeStart(string);
        }
        if (string2 != null && string2.length() > 0) {
            this.setRangeEnd(string2);
        }
    }

    public void setRangeStart(String string) throws MalformedURLException {
        this.startIPAddress = IPAddressRangeElement.divideIPAddress(string);
    }

    public void setRangeEnd(String string) throws MalformedURLException {
        this.endIPAddress = IPAddressRangeElement.divideIPAddress(string);
    }

    public static int[] divideIPAddress(String string) throws MalformedURLException {
        int[] nArray = new int[]{};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        nArray = new int[stringTokenizer.countTokens()];
        if (nArray.length != 4) {
            throw new MalformedURLException("IP address must have 4 elements, not " + nArray.length + ".");
        }
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 < 0 || n2 > 255) {
                throw new MalformedURLException("Invalid IP address element: " + n2);
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public boolean isIPAddressInRange(String string) {
        try {
            int[] nArray = IPAddressRangeElement.divideIPAddress(string);
            if (this.endIPAddress != null) {
                return this.isGreaterOrEqual(nArray, this.startIPAddress) && this.isLessOrEqual(nArray, this.endIPAddress);
            }
            if (this.startIPAddress != null && this.startIPAddress.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == this.startIPAddress[i]) continue;
                    return false;
                }
                return true;
            }
            IPAddressRangeElement.debugOut("in isIPAddressInRange, this range element's range is invalid.");
            return false;
        }
        catch (Exception exception) {
            IPAddressRangeElement.debugOut("Exception in divideIPAddress(): " + exception);
            return false;
        }
    }

    public boolean isGreaterOrEqual(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isLessOrEqual(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(IPAddressRangeElement iPAddressRangeElement) {
        int n;
        boolean bl = false;
        if (iPAddressRangeElement == null) {
            return false;
        }
        if (iPAddressRangeElement.startIPAddress == null && this.startIPAddress != null) {
            return false;
        }
        if (iPAddressRangeElement.startIPAddress == null && this.startIPAddress == null) {
            return true;
        }
        if (iPAddressRangeElement.startIPAddress.length != this.startIPAddress.length) {
            return false;
        }
        for (n = 0; n < this.startIPAddress.length; ++n) {
            if (this.startIPAddress[n] == iPAddressRangeElement.startIPAddress[n]) continue;
            return false;
        }
        if (iPAddressRangeElement.endIPAddress == null && this.endIPAddress != null) {
            return false;
        }
        if (iPAddressRangeElement.endIPAddress == null && this.endIPAddress == null) {
            return true;
        }
        if (iPAddressRangeElement.endIPAddress.length != this.endIPAddress.length) {
            return false;
        }
        for (n = 0; n < this.endIPAddress.length; ++n) {
            if (this.endIPAddress[n] == iPAddressRangeElement.endIPAddress[n]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        StringBuffer stringBuffer2 = new StringBuffer(20);
        StringBuffer stringBuffer3 = new StringBuffer(20);
        try {
            int n;
            if (this.startIPAddress != null) {
                for (n = 0; n < this.startIPAddress.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(".");
                    }
                    stringBuffer.append(this.startIPAddress[n]);
                }
            }
            if (this.endIPAddress != null) {
                for (n = 0; n < this.endIPAddress.length; ++n) {
                    if (n > 0) {
                        stringBuffer2.append(".");
                    }
                    stringBuffer2.append(this.endIPAddress[n]);
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer3.append(stringBuffer);
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer3.append('-');
                stringBuffer3.append(stringBuffer2);
            }
        }
        catch (Exception exception) {
            IPAddressRangeElement.debugOut("Exception in toString(): " + exception);
        }
        return stringBuffer3.toString();
    }

    protected static void debugOut(String string) {
        Debug.debugOut("IPAddressRangeElement: " + string);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IPAddressRangeElement: " + string, n);
    }
}

